/*
 * Decompiled with CFR 0.152.
 */
package org.enhydra.jawe.actions;

import java.awt.event.ActionEvent;
import java.util.Set;
import javax.swing.undo.CannotUndoException;
import org.enhydra.jawe.AbstractEditor;
import org.enhydra.jawe.JaWEGraphModel;
import org.enhydra.jawe.ResourceManager;
import org.enhydra.jawe.actions.ActionBase;

public class Undo
extends ActionBase {
    public Undo(AbstractEditor editor) {
        super(editor);
        this.setEnabled(false);
    }

    public void actionPerformed(ActionEvent e) {
        try {
            Set s1 = JaWEGraphModel.getAllCellsInModel(this.editor.getGraph().getModel());
            this.editor.getUndoManager().undo((Object)this.editor.getGraph().getGraphLayoutCache());
            Set s2 = JaWEGraphModel.getAllCellsInModel(this.editor.getGraph().getModel());
            this.editor.refreshCollections(s1, s2);
        }
        catch (CannotUndoException ex) {
            System.err.println("Unable to undo: " + ex);
            ex.printStackTrace();
        }
        this.editor.update();
        this.editor.getRedo().update();
        this.editor.getGraph().repaint();
    }

    public void update() {
        if (this.editor.getUndoManager().canUndo((Object)this.editor.getGraph().getGraphLayoutCache())) {
            this.setEnabled(true);
            this.putValue("Name", this.editor.getUndoManager().getUndoPresentationName());
            this.editor.getToolbarComponent("Undo").setToolTipText(this.editor.getUndoManager().getUndoPresentationName());
        } else {
            this.setEnabled(false);
            this.putValue("Name", ResourceManager.getLanguageDependentString("UndoLabel"));
        }
    }
}

