/*
 * Decompiled with CFR 0.152.
 */
package org.enhydra.jawe.actions;

import java.awt.BorderLayout;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Rectangle;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.util.MissingResourceException;
import javax.swing.JDialog;
import javax.swing.JFrame;
import org.enhydra.jawe.AbstractGraph;
import org.enhydra.jawe.JaWEOverviewPanel;
import org.enhydra.jawe.ProcessEditor;
import org.enhydra.jawe.ResourceManager;
import org.enhydra.jawe.actions.ActionBase;

public class ShowOverview
extends ActionBase {
    private JDialog overviewDlg;
    private JaWEOverviewPanel overviewPanel;

    public ShowOverview(ProcessEditor pe) {
        super(pe);
    }

    public void actionPerformed(ActionEvent e) {
        if (this.overviewDlg == null) {
            String title;
            try {
                title = ResourceManager.getLanguageDependentString("OverviewKey");
            }
            catch (MissingResourceException mre) {
                title = "Overview";
            }
            Window w = this.editor.getWindow();
            this.overviewDlg = w instanceof JFrame ? new JDialog((JFrame)w, title, false) : new JDialog((JDialog)w, title, false);
            Container fContentPane = this.overviewDlg.getContentPane();
            fContentPane.setLayout(new BorderLayout());
            this.overviewPanel = new JaWEOverviewPanel(this.editor.getGraph());
            fContentPane.add(this.overviewPanel);
            this.overviewDlg.setSize(new Dimension(180, 180));
            this.overviewDlg.setLocationRelativeTo(w);
            this.overviewDlg.addComponentListener(new ComponentListener(){

                public void componentShown(ComponentEvent evt) {
                }

                public void componentHidden(ComponentEvent evt) {
                }

                public void componentMoved(ComponentEvent evt) {
                }

                public void componentResized(ComponentEvent evt) {
                    ShowOverview.this.overviewPanel.componentResized(null);
                }
            });
            this.overviewPanel.getGraph().addMouseListener((MouseListener)new OverviewMouseListener());
        }
        this.overviewDlg.show();
        this.overviewPanel.componentResized(null);
    }

    class OverviewMouseListener
    extends MouseAdapter {
        OverviewMouseListener() {
        }

        public void mouseClicked(MouseEvent evt) {
            AbstractGraph origGraph = ShowOverview.this.editor.getGraph();
            Rectangle origVis = origGraph.getVisibleRect();
            Dimension ovDdim = ShowOverview.this.overviewPanel.getGraph().getPreferredSize();
            double mul = (double)origGraph.getWidth() / ovDdim.getWidth();
            int x = evt.getX();
            int y = evt.getY();
            double halfH = origVis.getHeight() / 2.0;
            double halfW = origVis.getWidth() / 2.0;
            double oldMiddleX = origVis.getX() + halfW;
            double oldMiddleY = origVis.getY() + halfH;
            double newMiddleX = (double)x * mul;
            double newMiddleY = (double)y * mul;
            origVis.translate((int)(newMiddleX - oldMiddleX), (int)(newMiddleY - oldMiddleY));
            origGraph.scrollRectToVisible(origVis);
        }
    }
}

