/*
 * Decompiled with CFR 0.152.
 */
package org.enhydra.jawe.actions;

import java.awt.Graphics;
import java.awt.event.ActionEvent;
import java.io.File;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import org.apache.batik.dom.GenericDOMImplementation;
import org.apache.batik.svggen.SVGGraphics2D;
import org.enhydra.jawe.AbstractEditor;
import org.enhydra.jawe.AbstractGraph;
import org.enhydra.jawe.JaWE;
import org.enhydra.jawe.JaWEConfig;
import org.enhydra.jawe.ResourceManager;
import org.enhydra.jawe.actions.ActionBase;
import org.w3c.dom.DOMImplementation;
import org.w3c.dom.Document;

public class SaveAsSVG
extends ActionBase {
    public SaveAsSVG(AbstractEditor editor) {
        super(editor);
    }

    public void actionPerformed(ActionEvent e) {
        try {
            String file = JaWE.getInstance().saveDialog(ResourceManager.getLanguageDependentString("SaveAsSVGLabel"), 2, this.editor.getGraph().get("Id").toString());
            if (file != null && file.length() > 0) {
                SaveAsSVG.saveGraphAsSVG(file, this.editor.getGraph());
            }
        }
        catch (Exception ex) {
            String msg = ResourceManager.getLanguageDependentString("ErrorSVGSavingFailed");
            JaWE.getInstance().message(msg, 2);
        }
    }

    public static void saveGraphAsSVG(String file, AbstractGraph graph) throws Exception {
        FileOutputStream fos = new FileOutputStream(new File(file));
        OutputStreamWriter out = new OutputStreamWriter((OutputStream)fos, JaWEConfig.getInstance().getEncoding());
        DOMImplementation domImpl = GenericDOMImplementation.getDOMImplementation();
        Document document = domImpl.createDocument(null, "svg", null);
        SVGGraphics2D svgGenerator = new SVGGraphics2D(document);
        graph.paint((Graphics)svgGenerator);
        boolean useCSS = true;
        svgGenerator.stream((Writer)out, useCSS);
        fos.flush();
        fos.close();
    }
}

