/*
 * Decompiled with CFR 0.152.
 */
package org.enhydra.jawe.actions;

import com.sun.image.codec.jpeg.JPEGCodec;
import com.sun.image.codec.jpeg.JPEGImageEncoder;
import java.awt.Dimension;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.image.BufferedImage;
import java.io.FileOutputStream;
import java.io.OutputStream;
import org.enhydra.jawe.AbstractEditor;
import org.enhydra.jawe.AbstractGraph;
import org.enhydra.jawe.JaWE;
import org.enhydra.jawe.ResourceManager;
import org.enhydra.jawe.actions.ActionBase;

public class SaveAsJPG
extends ActionBase {
    public SaveAsJPG(AbstractEditor editor) {
        super(editor);
    }

    public void actionPerformed(ActionEvent e) {
        try {
            String file = JaWE.getInstance().saveDialog(ResourceManager.getLanguageDependentString("SaveAsJPGLabel"), 1, this.editor.getGraph().get("Id").toString());
            if (file != null && file.length() > 0) {
                SaveAsJPG.saveGraphAsJPG(file, this.editor.getGraph());
            }
        }
        catch (Exception ex) {
            String msg = ResourceManager.getLanguageDependentString("ErrorJPGSavingFailed");
            JaWE.getInstance().message(msg, 2);
        }
    }

    public static void saveGraphAsJPG(String file, AbstractGraph graph) throws Exception {
        BufferedImage img = null;
        Object[] cells = graph.getRoots();
        if (cells.length > 0) {
            Rectangle bounds = graph.getCellBounds(cells).getBounds();
            graph.toScreen(bounds);
            Dimension d = bounds.getSize();
            img = new BufferedImage(d.width, d.height, 1);
            Graphics2D graphics = img.createGraphics();
            graph.paint(graphics);
        }
        FileOutputStream fos = new FileOutputStream(file);
        JPEGImageEncoder encoder = JPEGCodec.createJPEGEncoder((OutputStream)fos);
        encoder.encode(img);
        fos.flush();
        fos.close();
    }
}

