/*
 * Decompiled with CFR 0.152.
 */
package org.enhydra.jawe.actions;

import java.awt.Point;
import java.awt.event.ActionEvent;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.RandomAccessFile;
import java.nio.channels.FileLock;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.swing.JFrame;
import javax.swing.JOptionPane;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.enhydra.jawe.JaWE;
import org.enhydra.jawe.JaWEConfig;
import org.enhydra.jawe.JaWEGraphModel;
import org.enhydra.jawe.PackageEditor;
import org.enhydra.jawe.ProcessEditor;
import org.enhydra.jawe.ResourceManager;
import org.enhydra.jawe.Utils;
import org.enhydra.jawe.WorkflowManager;
import org.enhydra.jawe.actions.ActionBase;
import org.enhydra.jawe.graph.Activity;
import org.enhydra.jawe.graph.BlockActivity;
import org.enhydra.jawe.graph.End;
import org.enhydra.jawe.graph.Process;
import org.enhydra.jawe.graph.Start;
import org.enhydra.jawe.graph.TransitionView;
import org.enhydra.jawe.misc.ValidationErrorDisplay;
import org.enhydra.jawe.xml.Path;
import org.enhydra.jawe.xml.XML;
import org.enhydra.jawe.xml.XMLCollection;
import org.enhydra.jawe.xml.XMLElement;
import org.enhydra.jawe.xml.elements.ExternalPackage;
import org.enhydra.jawe.xml.elements.Package;
import org.enhydra.jawe.xml.elements.PackageHeader;
import org.enhydra.jawe.xml.elements.Participant;
import org.enhydra.jawe.xml.elements.Transition;
import org.enhydra.jawe.xml.elements.WorkflowProcess;
import org.enhydra.jawe.xml.elements.WorkflowProcesses;
import org.w3c.dom.Document;
import org.w3c.dom.Node;

public class Save
extends ActionBase {
    public Save(PackageEditor editor) {
        super(editor);
    }

    public Save(PackageEditor editor, String name) {
        super(editor, name);
    }

    public void actionPerformed(ActionEvent e) {
        this.saveDocumentIfPossible();
    }

    private void saveDocumentIfPossible() {
        boolean isModelOK;
        PackageEditor packageEditor = JaWE.getInstance().getPackageEditor();
        if (!packageEditor.isInitialized()) {
            packageEditor.enterPackageID();
        }
        packageEditor.displayPackage(packageEditor.getRealXMLPackage());
        boolean val = JaWEConfig.getInstance().getValidationStatus();
        JaWE.getInstance();
        JaWE.getXMLInterface().setValidation(true);
        boolean isXPDLSchemaValidationError = !packageEditor.getGraph().validateAgainsXPDLSchema();
        JaWE.getInstance();
        JaWE.getXMLInterface().setValidation(val);
        boolean isConnectionError = !packageEditor.getGraph().checkConnections(true);
        boolean isGraphConformanceError = !packageEditor.getGraph().checkGraphConformance(true);
        boolean isLogicError = !packageEditor.getGraph().checkLogic(true);
        boolean bl = isModelOK = !isXPDLSchemaValidationError && !isConnectionError && !isGraphConformanceError && !isLogicError;
        if (!isModelOK) {
            Map connectionErrors = this.editor.getGraph().getConnectionErrorMessages();
            List basicGraphConformanceErrors = this.editor.getGraph().getBasicGraphConformanceErrorMessages();
            Map graphConformanceErrors = this.editor.getGraph().getGraphConformanceErrorMessages();
            Map logicErrors = this.editor.getGraph().getLogicErrorMessages();
            String title = ResourceManager.getLanguageDependentString("DialogValidationReport");
            ValidationErrorDisplay ved = new ValidationErrorDisplay(null, connectionErrors, basicGraphConformanceErrors, graphConformanceErrors, logicErrors, (JFrame)packageEditor.getWindow(), title, true);
            if (ved.hasBeenStoped()) {
                return;
            }
        }
        if (packageEditor.allowInvalidPackageSaving() || isModelOK) {
            String oldFilename = JaWE.getInstance().getFilename();
            if (oldFilename == null) {
                JaWE.getInstance().setFilename(JaWE.getInstance().saveDialog(ResourceManager.getLanguageDependentString("SaveAsLabel"), 0, packageEditor.getGraph().get("Id").toString()));
                packageEditor.update();
            }
            if (JaWE.getInstance().getFilename() != null) {
                String filename = JaWE.getInstance().getFilename();
                try {
                    OutputStream os;
                    Package pkg = packageEditor.getRealXMLPackage();
                    if (oldFilename == null) {
                        JaWE.getInstance();
                        if (JaWE.getXMLInterface().getAbsoluteFilePath(pkg) != null) {
                            boolean crossRefs = this.doesCrossreferenceExist(pkg);
                            int r = 0;
                            if (crossRefs) {
                                r = JOptionPane.showConfirmDialog(packageEditor.getWindow(), ResourceManager.getLanguageDependentString("MessageCrossReferenceExistDoYouWantToProceed"), JaWE.getAppTitle(), 0);
                            }
                            if (r == 0) {
                                this.updateExternalPackagesRelativePaths(pkg, filename);
                            } else {
                                JaWE.getInstance().setFilename(null);
                                return;
                            }
                        }
                    }
                    Save.updateExtendedAttributesForWorkflowProcesses();
                    PackageHeader ph = (PackageHeader)pkg.get("PackageHeader");
                    ph.set("XPDLVersion", (Object)"1.0");
                    Document document = null;
                    DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
                    DocumentBuilder dbuilder = dbf.newDocumentBuilder();
                    document = dbuilder.newDocument();
                    RandomAccessFile raf = null;
                    JaWE.getInstance();
                    if (JaWE.getXMLInterface() instanceof XML) {
                        JaWE.getInstance();
                        raf = ((XML)JaWE.getXMLInterface()).getRaf(pkg);
                    }
                    if (oldFilename == null) {
                        JaWE.getInstance();
                        if (JaWE.getXMLInterface() instanceof XML) {
                            try {
                                File f = new File(filename);
                                RandomAccessFile r = new RandomAccessFile(f, "rw");
                                FileLock flck = r.getChannel().tryLock();
                                flck.release();
                                r.close();
                            }
                            catch (IOException ioe) {
                            }
                            catch (NullPointerException npe) {
                                JaWE.getInstance().setFilename(null);
                                throw new Exception();
                            }
                            os = new FileOutputStream(filename);
                        } else {
                            os = new FileOutputStream(filename);
                        }
                    } else {
                        JaWE.getInstance();
                        os = JaWE.getXMLInterface() instanceof XML ? new ByteArrayOutputStream() : new FileOutputStream(filename);
                    }
                    pkg.toXML((Node)document);
                    TransformerFactory tFactory = TransformerFactory.newInstance();
                    Transformer transformer = tFactory.newTransformer();
                    transformer.setOutputProperty("indent", "yes");
                    transformer.setOutputProperty("{http://xml.apache.org/xslt}indent-amount", "4");
                    transformer.setOutputProperty("encoding", JaWEConfig.getInstance().getEncoding());
                    DOMSource source = new DOMSource(document);
                    StreamResult result = new StreamResult(os);
                    transformer.transform(source, result);
                    if (oldFilename != null && raf != null && os instanceof ByteArrayOutputStream && raf != null) {
                        raf.seek(0L);
                        raf.getChannel().truncate(0L);
                        raf.write(((ByteArrayOutputStream)os).toByteArray());
                    }
                    os.close();
                    JaWE.getInstance().setModified(false);
                    if (oldFilename == null) {
                        JaWE.getInstance();
                        JaWE.getXMLInterface().registerPackageFilename(filename, pkg);
                    }
                    try {
                        JaWE.getInstance();
                        System.setProperty("user.dir", JaWE.getXMLInterface().getParentDirectory(pkg));
                    }
                    catch (Exception ex) {
                        // empty catch block
                    }
                    try {
                        JaWE.getInstance().addToRecentFiles(filename);
                    }
                    catch (Exception ex) {}
                }
                catch (Exception ex) {
                    JaWE.getInstance().message(ResourceManager.getLanguageDependentString("ErrorCannotSaveDocument"), 0);
                }
            }
            packageEditor.update();
            packageEditor.invalidate();
        } else {
            String msg = ResourceManager.getLanguageDependentString("ErrorCannotSaveIncorrectPackage");
            JaWE.getInstance().message(msg, 0);
        }
    }

    public static void updateExtendedAttributesForWorkflowProcesses() {
        PackageEditor pkgEd = JaWE.getInstance().getPackageEditor();
        Package pkg = pkgEd.getRealXMLPackage();
        Iterator wps = ((WorkflowProcesses)pkg.get("WorkflowProcesses")).toCollection().iterator();
        while (wps.hasNext()) {
            WorkflowProcess wp = (WorkflowProcess)wps.next();
            Process pr = pkgEd.getProcessObject(wp);
            ProcessEditor pe = pr.getImplementationEditor();
            Save.updateExtendedAttributesForWorkflowProcess(wp, pe);
        }
    }

    public static void updateExtendedAttributesForWorkflowProcess(WorkflowProcess wp, ProcessEditor pe) {
        Save.updateActivitySets(pe);
        Save.updateActivitiesExtendedAttributes(pe);
        Save.updateTransitionsExtendedAttributes(pe);
        wp.setVisuallySortedParticipantIDs(Save.getParticipantsVisualOrder(pe));
        wp.setStartDescriptions(Utils.getStartDescriptions(pe));
        wp.setEndDescriptions(Utils.getEndDescriptions(pe));
    }

    private static void updateActivitySets(ProcessEditor pe) {
        if (pe != null) {
            WorkflowManager wm = pe.getGraph().getWorkflowManager();
            Set blockActs = wm.getBlockActivities(true);
            Iterator it = blockActs.iterator();
            while (it.hasNext()) {
                BlockActivity ba = (BlockActivity)it.next();
                ProcessEditor bwe = ba.getImplementationEditor();
                Save.updateActivitiesExtendedAttributes(bwe);
                Save.updateTransitionsExtendedAttributes(bwe);
                org.enhydra.jawe.xml.elements.Activity bap = (org.enhydra.jawe.xml.elements.Activity)ba.getUserObject();
                bap.setVisuallySortedParticipantIDs(Save.getParticipantsVisualOrder(bwe));
                bap.setStartDescriptions(Utils.getStartDescriptions(bwe));
                bap.setEndDescriptions(Utils.getEndDescriptions(bwe));
            }
        }
    }

    private static void updateActivitiesExtendedAttributes(ProcessEditor pe) {
        WorkflowManager wm;
        Set allActs;
        if (pe != null && (allActs = JaWEGraphModel.getAllActivitiesInModel((wm = pe.getGraph().getWorkflowManager()).graphModel())) != null) {
            Iterator it = allActs.iterator();
            while (it.hasNext()) {
                Activity a = (Activity)it.next();
                a.recreatePropertyObjectTransitions();
                if (a instanceof Start || a instanceof End) continue;
                org.enhydra.jawe.xml.elements.Activity ap = (org.enhydra.jawe.xml.elements.Activity)a.getUserObject();
                Point pOffset = wm.getOffset(a);
                ap.setXOffset(pOffset.x);
                ap.setYOffset(pOffset.y);
                String Id = ((Participant)((org.enhydra.jawe.graph.Participant)((Object)a.getParent())).getUserObject()).getID();
                ap.setParticipantID(Id);
            }
        }
    }

    private static void updateTransitionsExtendedAttributes(ProcessEditor pe) {
        WorkflowManager wm;
        Set allTransitions;
        if (pe != null && (allTransitions = JaWEGraphModel.getAllTransitionsInModel((wm = pe.getGraph().getWorkflowManager()).graphModel())) != null) {
            Iterator it = allTransitions.iterator();
            while (it.hasNext()) {
                org.enhydra.jawe.graph.Transition tr = (org.enhydra.jawe.graph.Transition)it.next();
                Transition xmlT = (Transition)tr.getUserObject();
                Activity s = tr.getSourceActivity();
                Activity t = tr.getTargetActivity();
                if (!(s.getUserObject() instanceof XMLElement) || !(t.getUserObject() instanceof XMLElement)) continue;
                boolean isRouting = Utils.isRoutingTransition(tr.getAttributes());
                if (isRouting) {
                    xmlT.setRoutingType("SIMPLEROUTING");
                    continue;
                }
                xmlT.setRoutingType("NOROUTING");
                TransitionView tv = (TransitionView)wm.getView(tr);
                int noOfPoints = tv.getPointCount();
                Hashtable<Integer, Point> pnts = new Hashtable<Integer, Point>();
                for (int j = 1; j < noOfPoints - 1; ++j) {
                    pnts.put(new Integer(j), new Point((int)tv.getPoint(j).getX(), (int)tv.getPoint(j).getY()));
                }
                xmlT.setBreakPoints(pnts);
            }
        }
    }

    private static String getParticipantsVisualOrder(ProcessEditor pe) {
        String visuallySortedParticipantIDs = "";
        if (pe != null) {
            WorkflowManager wm = pe.getGraph().getWorkflowManager();
            ParticipantComparator pc = new ParticipantComparator(wm);
            Set allDeps = JaWEGraphModel.getAllParticipantsInModel(pe.getGraph().getModel());
            if (allDeps != null) {
                ArrayList gparts = new ArrayList();
                gparts.addAll(allDeps);
                Collections.sort(gparts, pc);
                Iterator it = gparts.iterator();
                while (it.hasNext()) {
                    String participantID = ((org.enhydra.jawe.graph.Participant)it.next()).get("Id").toString();
                    visuallySortedParticipantIDs = visuallySortedParticipantIDs + participantID + ";";
                }
            }
        }
        return visuallySortedParticipantIDs;
    }

    private void updateExternalPackagesRelativePaths(Package pkg, String newFilename) {
        File f = new File(newFilename);
        String parentF = f.getParent();
        Path newPath = new Path(parentF);
        Iterator eps = ((XMLCollection)pkg.get("ExternalPackages")).toCollection().iterator();
        while (eps.hasNext()) {
            ExternalPackage ep = (ExternalPackage)eps.next();
            String oldRelativePath = ep.toString();
            try {
                JaWE.getInstance();
                Package extP = JaWE.getXMLInterface().getExternalPackageByRelativeFilePath(oldRelativePath, pkg);
                JaWE.getInstance();
                String oldFullPath = JaWE.getXMLInterface().getAbsoluteFilePath(extP);
                String relativePath = Path.getRelativePath((Path)new Path(oldFullPath), (Path)newPath);
                ExternalPackage.AttrHref href = (ExternalPackage.AttrHref)ep.get("href");
                href.setPathDirectly(relativePath);
            }
            catch (Exception ex) {}
        }
    }

    private boolean doesCrossreferenceExist(Package pkg) {
        boolean crossRefs = false;
        Iterator eps = ((XMLCollection)pkg.get("ExternalPackages")).toCollection().iterator();
        while (eps.hasNext()) {
            ExternalPackage ep = (ExternalPackage)eps.next();
            String relativePath = ep.toString();
            try {
                JaWE.getInstance();
                Package extP = JaWE.getXMLInterface().getExternalPackageByRelativeFilePath(relativePath, pkg);
                if (!extP.getAllExternalPackages().contains(pkg)) continue;
                crossRefs = true;
                break;
            }
            catch (Exception ex) {
            }
        }
        return crossRefs;
    }

    private static class ParticipantComparator
    implements Comparator {
        WorkflowManager workflowManager;

        public ParticipantComparator(WorkflowManager workflowManager) {
            this.workflowManager = workflowManager;
        }

        public int compare(Object o1, Object o2) {
            org.enhydra.jawe.graph.Participant p1 = (org.enhydra.jawe.graph.Participant)o1;
            org.enhydra.jawe.graph.Participant p2 = (org.enhydra.jawe.graph.Participant)o2;
            int y1 = this.workflowManager.getBounds((Object)p1, null).getBounds().y;
            int y2 = this.workflowManager.getBounds((Object)p2, null).getBounds().y;
            return y1 < y2 ? -1 : (y1 == y2 ? 0 : 1);
        }
    }
}

