/*
 * Decompiled with CFR 0.152.
 */
package org.enhydra.jawe.actions;

import java.awt.event.ActionEvent;
import java.io.File;
import javax.swing.JOptionPane;
import org.enhydra.jawe.AbstractEditor;
import org.enhydra.jawe.JaWE;
import org.enhydra.jawe.PackageEditor;
import org.enhydra.jawe.ProcessEditor;
import org.enhydra.jawe.ResourceManager;
import org.enhydra.jawe.actions.ActionBase;
import org.enhydra.jawe.graph.Activity;
import org.enhydra.jawe.xml.elements.PackageHeader;

public class ReferredDocument
extends ActionBase {
    public ReferredDocument(AbstractEditor editor) {
        super(editor);
    }

    public void actionPerformed(ActionEvent e) {
        if (this.editor instanceof ProcessEditor) {
            Activity selected = (Activity)this.editor.getGraph().getSelectionCell();
            String doc = selected.get("Documentation").toString();
            this.showExternalDocument(doc);
        } else {
            String doc = ((PackageHeader)((PackageEditor)this.editor).getXMLPackage().get("PackageHeader")).get("Documentation").toString();
            this.showExternalDocument(doc);
        }
    }

    private void showExternalDocument(String document) {
        if (!new File(document).canRead()) {
            JOptionPane.showMessageDialog(this.editor.getWindow(), document + ": " + ResourceManager.getLanguageDependentString("InformationFileNotReadable"), JaWE.getAppTitle(), 1);
            return;
        }
        String startCommand = System.getProperty("path.to.start");
        if (null != startCommand) {
            if (!new File(startCommand).canRead()) {
                JOptionPane.showMessageDialog(this.editor.getWindow(), startCommand + ": " + ResourceManager.getLanguageDependentString("InformationFileNotReadable"), JaWE.getAppTitle(), 1);
                return;
            }
            if (System.getProperty("path.separator").equals(";")) {
                document = "\"" + document + "\"";
            }
        } else if (System.getProperty("path.separator").equals(":")) {
            startCommand = "kfmclient exec";
        } else {
            startCommand = "cmd /c start";
            document = "\"" + document + "\"" + " \"" + document + "\"";
        }
        try {
            Runtime.getRuntime().exec(startCommand + " " + document);
        }
        catch (Throwable t) {
            t.printStackTrace();
        }
    }
}

