/*
 * Decompiled with CFR 0.152.
 */
package org.enhydra.jawe.actions;

import java.awt.event.ActionEvent;
import java.util.Set;
import javax.swing.undo.CannotRedoException;
import org.enhydra.jawe.AbstractEditor;
import org.enhydra.jawe.JaWEGraphModel;
import org.enhydra.jawe.ResourceManager;
import org.enhydra.jawe.actions.ActionBase;

public class Redo
extends ActionBase {
    public Redo(AbstractEditor editor) {
        super(editor);
        this.setEnabled(false);
    }

    public void actionPerformed(ActionEvent e) {
        try {
            Set s1 = JaWEGraphModel.getAllCellsInModel(this.editor.getGraph().getModel());
            this.editor.getUndoManager().redo((Object)this.editor.getGraph().getGraphLayoutCache());
            Set s2 = JaWEGraphModel.getAllCellsInModel(this.editor.getGraph().getModel());
            this.editor.refreshCollections(s1, s2);
        }
        catch (CannotRedoException ex) {
            System.err.println("Unable to redo: " + ex);
            ex.printStackTrace();
        }
        this.update();
        this.editor.getUndo().update();
        this.editor.getGraph().repaint();
    }

    public void update() {
        if (this.editor.getUndoManager().canRedo((Object)this.editor.getGraph().getGraphLayoutCache())) {
            this.setEnabled(true);
            this.putValue("Name", this.editor.getUndoManager().getRedoPresentationName());
            this.editor.getToolbarComponent("Redo").setToolTipText(this.editor.getUndoManager().getRedoPresentationName());
        } else {
            this.setEnabled(false);
            this.putValue("Name", ResourceManager.getLanguageDependentString("RedoLabel"));
        }
    }
}

