/*
 * Decompiled with CFR 0.152.
 */
package org.enhydra.jawe.actions;

import java.awt.event.ActionEvent;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import org.enhydra.jawe.AbstractEditor;
import org.enhydra.jawe.ProcessEditor;
import org.enhydra.jawe.WorkflowManager;
import org.enhydra.jawe.actions.ActionBase;
import org.enhydra.jawe.graph.Participant;

public class MoveDownParticipant
extends ActionBase {
    public MoveDownParticipant(AbstractEditor editor) {
        super(editor);
    }

    public void actionPerformed(ActionEvent e) {
        if (this.editor instanceof ProcessEditor) {
            Object[] cells = this.editor.getGraph().getSelectionCells();
            ArrayList<Object> gparts = new ArrayList<Object>();
            for (int i = 0; i < cells.length; ++i) {
                gparts.add(cells[i]);
            }
            WorkflowManager dm = this.editor.getGraph().getWorkflowManager();
            ParticipantComparator pc = new ParticipantComparator(dm);
            Collections.sort(gparts, pc);
            dm.moveParticipants(gparts.toArray(), false);
        }
    }

    private static class ParticipantComparator
    implements Comparator {
        WorkflowManager workflowManager;

        public ParticipantComparator(WorkflowManager workflowManager) {
            this.workflowManager = workflowManager;
        }

        public int compare(Object o1, Object o2) {
            Participant p1 = (Participant)o1;
            Participant p2 = (Participant)o2;
            int y1 = this.workflowManager.getBounds((Object)p1, null).getBounds().y;
            int y2 = this.workflowManager.getBounds((Object)p2, null).getBounds().y;
            return y1 > y2 ? -1 : (y1 == y2 ? 0 : 1);
        }
    }
}

