/*
 * Decompiled with CFR 0.152.
 */
package org.enhydra.jawe.actions;

import java.awt.event.ActionEvent;
import java.net.URL;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.swing.ImageIcon;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JOptionPane;
import org.enhydra.jawe.AbstractEditor;
import org.enhydra.jawe.PackageEditor;
import org.enhydra.jawe.ResourceManager;
import org.enhydra.jawe.WorkflowElement;
import org.enhydra.jawe.WorkflowManager;
import org.enhydra.jawe.actions.ActionBase;
import org.enhydra.jawe.graph.BlockActivityEditor;
import org.enhydra.jawe.graph.End;
import org.enhydra.jawe.graph.Participant;
import org.enhydra.jawe.graph.Start;
import org.enhydra.jawe.graph.Transition;
import org.enhydra.jawe.misc.ValidationErrorDisplay;
import org.enhydra.jawe.xml.elements.Activity;

public class CheckValidity
extends ActionBase {
    private static ImageIcon checkOKIcon;

    public CheckValidity(AbstractEditor editor) {
        super(editor);
    }

    public void actionPerformed(ActionEvent e) {
        if (this.editor instanceof PackageEditor && !((PackageEditor)this.editor).isInitialized()) {
            ((PackageEditor)this.editor).enterPackageID();
        }
        boolean isSchemaValidationError = !this.editor.getGraph().validateAgainsXPDLSchema();
        boolean isConnectionError = !this.editor.getGraph().checkConnections(true);
        boolean isGraphConformanceError = !this.editor.getGraph().checkGraphConformance(true);
        boolean isLogicError = !this.editor.getGraph().checkLogic(true);
        boolean isModelOK = !isSchemaValidationError && !isConnectionError && !isGraphConformanceError && !isLogicError;
        Map xpdlSchemaValidationErrors = this.editor.getGraph().getXPDLSchemaValidationErrorMessages();
        Map connectionErrors = this.editor.getGraph().getConnectionErrorMessages();
        List basicGraphConformanceErrors = this.editor.getGraph().getBasicGraphConformanceErrorMessages();
        Map graphConformanceErrors = this.editor.getGraph().getGraphConformanceErrorMessages();
        Map logicErrors = this.editor.getGraph().getLogicErrorMessages();
        String title = ResourceManager.getLanguageDependentString("DialogValidationReport");
        URL iconURL = ResourceManager.getResource("CheckOKImage");
        if (iconURL != null) {
            checkOKIcon = new ImageIcon(iconURL);
        }
        if (this.editor.getWindow() instanceof JFrame) {
            if (isModelOK) {
                JOptionPane.showMessageDialog((JFrame)this.editor.getWindow(), ResourceManager.getLanguageDependentString("InformationPackageIsValid"), title, 1, checkOKIcon);
            } else {
                new ValidationErrorDisplay(xpdlSchemaValidationErrors, connectionErrors, basicGraphConformanceErrors, graphConformanceErrors, logicErrors, (JFrame)this.editor.getWindow(), title, false);
            }
        } else if (isModelOK) {
            String OKMessage = this.editor instanceof BlockActivityEditor ? ResourceManager.getLanguageDependentString("InformationBlockIsValid") : ResourceManager.getLanguageDependentString("InformationProcessIsValid");
            JOptionPane.showMessageDialog((JDialog)this.editor.getWindow(), OKMessage, title, 1, checkOKIcon);
        } else {
            new ValidationErrorDisplay(xpdlSchemaValidationErrors, connectionErrors, basicGraphConformanceErrors, graphConformanceErrors, logicErrors, (JDialog)this.editor.getWindow(), title, false);
        }
        if (isModelOK) {
            return;
        }
        this.editor.getGraph().clearSelection();
        HashSet wc = new HashSet(connectionErrors.keySet());
        wc.addAll(graphConformanceErrors.keySet());
        wc.addAll(logicErrors.keySet());
        WorkflowManager wm = this.editor.getGraph().getWorkflowManager();
        HashSet<WorkflowElement> graphObjects = new HashSet<WorkflowElement>();
        Iterator it = wc.iterator();
        while (it.hasNext()) {
            Participant gPart;
            Object obj = it.next();
            if (obj instanceof Activity) {
                org.enhydra.jawe.graph.Activity gAct = wm.getActivity(((Activity)obj).getID());
                if (gAct == null) continue;
                graphObjects.add(gAct);
                continue;
            }
            if (obj instanceof Start || obj instanceof End) {
                graphObjects.add((WorkflowElement)obj);
                continue;
            }
            if (obj instanceof org.enhydra.jawe.xml.elements.Transition) {
                Transition gTrans = wm.getTransition(((org.enhydra.jawe.xml.elements.Transition)obj).getID());
                if (gTrans == null) continue;
                graphObjects.add(gTrans);
                continue;
            }
            if (!(obj instanceof org.enhydra.jawe.xml.elements.Participant) || (gPart = wm.getParticipant(((org.enhydra.jawe.xml.elements.Participant)obj).getID())) == null) continue;
            graphObjects.add(gPart);
        }
        this.editor.getGraph().setSelectionCells(graphObjects.toArray());
        this.editor.valueChanged(null);
    }
}

