/*
 * Decompiled with CFR 0.152.
 */
package org.enhydra.jawe.actions;

import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.MissingResourceException;
import java.util.Set;
import javax.swing.AbstractAction;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.KeyStroke;
import javax.swing.MenuElement;
import org.enhydra.jawe.AbstractEditor;
import org.enhydra.jawe.BarFactory;
import org.enhydra.jawe.JaWE;
import org.enhydra.jawe.JaWEGraphModel;
import org.enhydra.jawe.PackageEditor;
import org.enhydra.jawe.PackageGraph;
import org.enhydra.jawe.ProcessEditor;
import org.enhydra.jawe.ProcessGraph;
import org.enhydra.jawe.ResourceManager;
import org.enhydra.jawe.Utils;
import org.enhydra.jawe.WorkflowManager;
import org.enhydra.jawe.actions.ActionBase;
import org.enhydra.jawe.actions.HelpManual;
import org.enhydra.jawe.actions.HelpTutorial;
import org.enhydra.jawe.config.ConfigDialog;
import org.enhydra.jawe.graph.BlockActivity;
import org.enhydra.jawe.graph.Process;
import org.enhydra.jawe.ldap.ImportExternalParticipants;
import org.enhydra.jawe.misc.PFLocale;
import org.enhydra.jawe.xml.elements.Package;
import org.enhydra.jawe.xml.elements.Participant;

public class ChangeLanguage
extends ActionBase {
    static /* synthetic */ Class class$org$enhydra$jawe$ldap$ImportExternalParticipants;

    public ChangeLanguage(PackageEditor editor) {
        super(editor);
    }

    public void actionPerformed(ActionEvent e) {
        this.makeChangeLangDialog();
    }

    public void makeChangeLangDialog() {
        JFrame frame = (JFrame)this.editor.getWindow();
        String title = ResourceManager.getLanguageDependentString("DialogChangeLanguage");
        final JDialog changeLangDlg = new JDialog(frame, title, true);
        changeLangDlg.setSize(new Dimension(430, 280));
        changeLangDlg.setLocationRelativeTo(frame);
        JButton cancelButton = new JButton(ResourceManager.getLanguageDependentString("CancelKey"));
        final JButton setButton = new JButton(ResourceManager.getLanguageDependentString("SetKey"));
        changeLangDlg.getRootPane().setDefaultButton(setButton);
        JPanel buttonPane = new JPanel();
        buttonPane.setLayout(new BoxLayout(buttonPane, 0));
        buttonPane.setBorder(BorderFactory.createEmptyBorder(0, 10, 10, 10));
        buttonPane.add(Box.createHorizontalGlue());
        buttonPane.add(cancelButton);
        buttonPane.add(Box.createRigidArea(new Dimension(10, 0)));
        buttonPane.add(setButton);
        List pfLocales = Utils.findPropertyFiles();
        if (pfLocales.size() == 0) {
            System.err.println("Can't find the property files - you have probably started JaWE from wrong location");
            return;
        }
        final JList<Object> list = new JList<Object>(pfLocales.toArray());
        JScrollPane scroll = new JScrollPane(list);
        scroll.setPreferredSize(new Dimension(350, 150));
        scroll.setMinimumSize(new Dimension(350, 150));
        scroll.setAlignmentX(0.0f);
        JLabel lab = new JLabel(ResourceManager.getLanguageDependentString("AvailableLocales"));
        lab.setLabelFor(list);
        JPanel listPane = new JPanel();
        listPane.setLayout(new BoxLayout(listPane, 1));
        listPane.add(lab);
        listPane.add(Box.createRigidArea(new Dimension(0, 5)));
        listPane.add(scroll);
        listPane.setBorder(BorderFactory.createEmptyBorder(10, 10, 10, 10));
        Container contentPane = changeLangDlg.getContentPane();
        contentPane.add((Component)listPane, "Center");
        contentPane.add((Component)buttonPane, "South");
        changeLangDlg.setResizable(true);
        cancelButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                changeLangDlg.dispose();
            }
        });
        setButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                Object temp = list.getSelectedValue();
                if (temp != null) {
                    PFLocale pfloc = (PFLocale)temp;
                    try {
                        ResourceManager.setChoosen(pfloc.getLocale());
                        try {
                            ChangeLanguage.this.editor.setTitle(ChangeLanguage.this.editor.getWindow(), ChangeLanguage.this.editor.getTitle());
                        }
                        catch (Exception ex) {
                            // empty catch block
                        }
                        ChangeLanguage.this.editor.getStatusBar().updateMessage();
                        ConfigDialog.getInstance().refreshLanguageDependentStrings();
                        ChangeLanguage.this.changeLanguage(ChangeLanguage.this.editor);
                        ChangeLanguage.this.changePackageSpecific((PackageEditor)ChangeLanguage.this.editor);
                        ChangeLanguage.this.changeLanguageForAllEditors();
                        JaWE.getInstance();
                        Iterator it = JaWE.getXMLInterface().getAllPackages().iterator();
                        while (it.hasNext()) {
                            ((Package)it.next()).refreshLabelName();
                        }
                    }
                    catch (MissingResourceException mre) {
                        String message = ResourceManager.getLanguageDependentString("NotFoundKey");
                        message = message + ": " + "org.enhydra.jawe.resources.JaWE";
                        message = message + pfloc.getLocaleString();
                        message = message + ".properties";
                        JOptionPane.showMessageDialog(ChangeLanguage.this.editor.getWindow(), message, JaWE.getAppTitle(), 0);
                    }
                    changeLangDlg.dispose();
                } else {
                    JOptionPane.showMessageDialog(ChangeLanguage.this.editor.getWindow(), ResourceManager.getLanguageDependentString("WarningEmptySelectionToEditOrDelete"), JaWE.getAppTitle(), 2);
                }
            }
        });
        list.setSelectionMode(1);
        list.addMouseListener(new MouseAdapter(){

            public void mouseClicked(MouseEvent e) {
                if (e.getClickCount() == 2) {
                    setButton.doClick();
                }
            }
        });
        changeLangDlg.getRootPane().getInputMap(2).put(KeyStroke.getKeyStroke(27, 0, false), "Cancel");
        changeLangDlg.getRootPane().getActionMap().put("Cancel", new AbstractAction(){

            public void actionPerformed(ActionEvent e) {
                changeLangDlg.dispose();
            }
        });
        Utils.center(changeLangDlg, 100, 100);
        changeLangDlg.show();
    }

    private void changeLanguageForAllEditors() {
        Iterator pkgGraphs = ((PackageEditor)this.editor).getPkgIdToGraphMap().values().iterator();
        HashSet wObjects = new HashSet();
        while (pkgGraphs.hasNext()) {
            PackageGraph peg = (PackageGraph)pkgGraphs.next();
            Set ws = JaWEGraphModel.getAllActivitiesInModel(peg.getModel());
            if (ws == null) continue;
            wObjects.addAll(ws);
        }
        Iterator wObjs = wObjects.iterator();
        HashSet baObjects = new HashSet();
        while (wObjs.hasNext()) {
            Process pr = (Process)wObjs.next();
            ProcessEditor pe = pr.getImplementationEditor();
            if (pe == null) continue;
            WorkflowManager wm = ((ProcessGraph)pe.getGraph()).getWorkflowManager();
            Set bas = wm.getBlockActivities(true);
            baObjects.addAll(bas);
            this.changeLanguage(pe);
        }
        Iterator baObjs = baObjects.iterator();
        while (baObjs.hasNext()) {
            BlockActivity ba = (BlockActivity)baObjs.next();
            ProcessEditor bae = ba.getImplementationEditor();
            if (bae == null) continue;
            this.changeLanguage(bae);
        }
    }

    private void changeMenuItems(AbstractEditor ed) {
        Iterator iter = ed.getMenuItems().values().iterator();
        while (iter.hasNext()) {
            JMenuItem jmi = (JMenuItem)iter.next();
            jmi.setLocale(ResourceManager.getChoosenLocale());
            jmi.setText(ResourceManager.getLanguageDependentString(jmi.getActionCommand() + "Label"));
            ed.getBarFactory();
            BarFactory.setMnemonic(jmi, ResourceManager.getLanguageDependentString(jmi.getActionCommand() + "Mnemonic"));
            ed.getBarFactory();
            BarFactory.setAccelerator(jmi, ResourceManager.getLanguageDependentString(jmi.getActionCommand() + "Accel"));
        }
    }

    private void changeMenuBar(AbstractEditor ed) {
        MenuElement[] me = ed.getMenubar().getSubElements();
        for (int i = 0; i < me.length; ++i) {
            JMenu jm = (JMenu)me[i].getComponent();
            jm.setLocale(ResourceManager.getChoosenLocale());
            jm.setText(ResourceManager.getLanguageDependentString(jm.getActionCommand() + "Label"));
            ed.getBarFactory();
            BarFactory.setMnemonic(jm, ResourceManager.getLanguageDependentString(jm.getActionCommand() + "Mnemonic"));
        }
        JMenuBar textViewMenuBar = ed.getTextPreview().getMenuBar();
        me = textViewMenuBar.getSubElements();
        for (int i = 0; i < me.length; ++i) {
            JMenu jm = (JMenu)me[i].getComponent();
            for (int j = 0; j < jm.getItemCount(); ++j) {
                JMenuItem jmi = jm.getItem(j);
                jmi.setLocale(ResourceManager.getChoosenLocale());
                jmi.setText(ResourceManager.getLanguageDependentString(jmi.getActionCommand() + "Label"));
                ed.getBarFactory();
                BarFactory.setMnemonic(jmi, ResourceManager.getLanguageDependentString(jmi.getActionCommand() + "Mnemonic"));
                ed.getBarFactory();
                BarFactory.setAccelerator(jmi, ResourceManager.getLanguageDependentString(jmi.getActionCommand() + "Accel"));
            }
            jm.setLocale(ResourceManager.getChoosenLocale());
            jm.setText(ResourceManager.getLanguageDependentString(jm.getActionCommand() + "Label"));
            ed.getBarFactory();
            BarFactory.setMnemonic(jm, ResourceManager.getLanguageDependentString(jm.getActionCommand() + "Mnemonic"));
        }
    }

    private void changeToolbarComponents(AbstractEditor ed) {
        AbstractButton ab = null;
        Iterator iter = ed.getToolbarComponents().values().iterator();
        while (iter.hasNext()) {
            ab = (AbstractButton)iter.next();
            ab.setLocale(ResourceManager.getChoosenLocale());
            ab.setToolTipText(ResourceManager.getLanguageDependentString(ab.getActionCommand() + "Tooltip"));
        }
    }

    private void changeTabbedPaneItems(AbstractEditor ed) {
        ed.getTabbedPane().setLocale(ResourceManager.getChoosenLocale());
        String[] toolBars = Utils.tokenize(ResourceManager.getResourceString(ed.toolbarToLoad()), " ");
        for (int i = 0; i < toolBars.length && !toolBars[i].equals("-"); ++i) {
            try {
                String nm = ResourceManager.getLanguageDependentString(toolBars[i] + "Label");
                ed.getTabbedPane().setTitleAt(i, nm);
                ed.getTabbedPane().setToolTipTextAt(i, nm);
                continue;
            }
            catch (Exception ex) {
                // empty catch block
            }
        }
    }

    private void changeSpecialButtons(AbstractEditor ed) {
        Object[] keys = ed.getSpecialButtons().keySet().toArray();
        for (int i = 0; i < keys.length; ++i) {
            JComponent c = (JComponent)ed.getSpecialButtons().get(keys[i]);
            c.setLocale(ResourceManager.getChoosenLocale());
            c.setToolTipText(ResourceManager.getLanguageDependentString((String)keys[i] + "Tooltip"));
        }
    }

    private void changeSpecialItems(AbstractEditor ed) {
        Object[] keys = ed.getSpecialItems().keySet().toArray();
        for (int i = 0; i < keys.length; ++i) {
            JMenuItem mi = (JMenuItem)ed.getSpecialItems().get(keys[i]);
            mi.setLocale(ResourceManager.getChoosenLocale());
            ed.getBarFactory();
            BarFactory.setAccelerator(mi, ResourceManager.getLanguageDependentString((String)keys[i] + "Accel"));
            ed.getBarFactory();
            BarFactory.setMnemonic(mi, ResourceManager.getLanguageDependentString((String)keys[i] + "Mnemonic"));
        }
    }

    private void changePackageSpecific(PackageEditor pe) {
        pe.getPackageTreePanel().setLocale(ResourceManager.getChoosenLocale());
        pe.getPackageTreePanel().setTitle(ResourceManager.getLanguageDependentString("PackageAndExternalPackagesKey"), false);
        try {
            ((ImportExternalParticipants)pe.getAction(Utils.getUnqualifiedClassName(class$org$enhydra$jawe$ldap$ImportExternalParticipants == null ? (class$org$enhydra$jawe$ldap$ImportExternalParticipants = ChangeLanguage.class$("org.enhydra.jawe.ldap.ImportExternalParticipants")) : class$org$enhydra$jawe$ldap$ImportExternalParticipants))).refreshLabels();
        }
        catch (Exception ex) {
            // empty catch block
        }
        Participant.getFreeTextExpressionParticipant().set("Name", (Object)ResourceManager.getLanguageDependentString("FreeTextExpressionParticipantKey"));
        try {
            ((HelpTutorial)pe.getAction("HelpTutorial")).createHelp();
        }
        catch (Exception ex) {
            // empty catch block
        }
        try {
            ((HelpManual)pe.getAction("HelpManual")).createHelp();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private void changeContentTab(AbstractEditor ed) {
        JTabbedPane ctp = ed.getContentTabbedPane();
        ctp.setTitleAt(0, ResourceManager.getLanguageDependentString("GraphViewKey"));
        ctp.setTitleAt(1, ResourceManager.getLanguageDependentString("TextViewKey"));
        ctp.setTitleAt(2, ResourceManager.getLanguageDependentString("XPDLViewKey"));
    }

    private void changeTextViewTab(AbstractEditor ed) {
        ed.getTextPreview().getTextTreePanel().setTitle(ResourceManager.getLanguageDependentString("PackageAndExternalPackagesXPDLKey"), false);
    }

    private void changeXPDLViewTab(AbstractEditor ed) {
        ed.getXPDLPreview().changeLanguage();
    }

    private void changeLanguage(AbstractEditor ed) {
        this.changeMenuItems(ed);
        this.changeToolbarComponents(ed);
        this.changeMenuBar(ed);
        this.changeTabbedPaneItems(ed);
        this.changeSpecialButtons(ed);
        this.changeSpecialItems(ed);
        this.changeContentTab(ed);
        this.changeTextViewTab(ed);
        this.changeXPDLViewTab(ed);
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

