/*
 * Decompiled with CFR 0.152.
 */
package org.enhydra.jawe;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.ByteArrayOutputStream;
import java.net.URL;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JViewport;
import javax.swing.border.Border;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.enhydra.jawe.AbstractEditor;
import org.enhydra.jawe.JaWE;
import org.enhydra.jawe.JaWEConfig;
import org.enhydra.jawe.ProcessEditor;
import org.enhydra.jawe.ResourceManager;
import org.enhydra.jawe.actions.Save;
import org.enhydra.jawe.xml.elements.Package;
import org.w3c.dom.Document;
import org.w3c.dom.Node;

public class XPDLPreview
extends JPanel {
    private AbstractEditor editor;
    private JScrollPane xpdlPreviewSP;
    private JTextArea xpdlPreviewTA;
    private JComboBox searchCB = new JComboBox();
    private Component searchPanel;

    public XPDLPreview(AbstractEditor editor) {
        super(true);
        this.editor = editor;
        this.setBorder(BorderFactory.createEtchedBorder());
        this.setLayout(new BorderLayout());
        this.add(this.createCenterComponent(), "Center");
        this.searchPanel = this.createSearchPanel();
        this.add(this.searchPanel, "North");
    }

    protected Component createCenterComponent() {
        this.xpdlPreviewTA = new JTextArea();
        this.xpdlPreviewTA.setLineWrap(false);
        this.xpdlPreviewTA.setWrapStyleWord(false);
        this.xpdlPreviewTA.setEditable(false);
        this.xpdlPreviewSP = new JScrollPane();
        this.xpdlPreviewSP.setViewportView(this.xpdlPreviewTA);
        JViewport port = this.xpdlPreviewSP.getViewport();
        port.setScrollMode(0);
        return this.xpdlPreviewSP;
    }

    protected Component createSearchPanel() {
        JPanel sp = new JPanel();
        sp.setLayout(new BoxLayout(sp, 0));
        Border emptyb = BorderFactory.createEmptyBorder(5, 5, 5, 5);
        sp.setBorder(emptyb);
        JLabel jl = new JLabel(ResourceManager.getLanguageDependentString("SearchForKey") + ": ");
        jl.setAlignmentX(0.0f);
        jl.setAlignmentY(1.0f);
        jl.setHorizontalAlignment(4);
        this.searchCB.setEditable(true);
        this.searchCB.setAlignmentX(0.0f);
        this.searchCB.setAlignmentY(1.0f);
        Dimension comboBoxDimension = new Dimension(200, 20);
        this.searchCB.setMinimumSize(new Dimension(comboBoxDimension));
        this.searchCB.setMaximumSize(new Dimension(comboBoxDimension));
        this.searchCB.setPreferredSize(new Dimension(comboBoxDimension));
        JButton jb = new JButton("");
        URL u = ResourceManager.getResource("FindNextImage");
        if (u != null) {
            jb.setIcon(new ImageIcon(u));
        }
        jb.setToolTipText(ResourceManager.getLanguageDependentString("FindNextStringOccuranceKey"));
        jb.setVerticalTextPosition(0);
        jb.setAlignmentX(0.0f);
        jb.setAlignmentY(1.0f);
        jb.setPreferredSize(new Dimension(25, 25));
        sp.add(jl);
        sp.add(this.searchCB);
        sp.add(Box.createHorizontalStrut(5));
        sp.add(jb);
        jb.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent ae) {
                XPDLPreview.this.findString();
            }
        });
        return sp;
    }

    public void refreshView() {
        try {
            Document document = null;
            DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
            DocumentBuilder dbuilder = dbf.newDocumentBuilder();
            document = dbuilder.newDocument();
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            Package pkg = JaWE.getInstance().getPackageEditor().getXMLPackage();
            if (pkg == JaWE.getInstance().getRealXMLPackage()) {
                Save.updateExtendedAttributesForWorkflowProcesses();
            }
            this.editor.getGraph().getXPDLObject().toXML((Node)document);
            TransformerFactory tFactory = TransformerFactory.newInstance();
            Transformer transformer = tFactory.newTransformer();
            transformer.setOutputProperty("indent", "yes");
            transformer.setOutputProperty("{http://xml.apache.org/xslt}indent-amount", "4");
            transformer.setOutputProperty("encoding", JaWEConfig.getInstance().getEncoding());
            if (this.editor instanceof ProcessEditor) {
                transformer.setOutputProperty("omit-xml-declaration", "yes");
            }
            DOMSource source = new DOMSource(document);
            StreamResult result = new StreamResult(baos);
            transformer.transform(source, result);
            this.xpdlPreviewTA.setText(baos.toString(JaWEConfig.getInstance().getEncoding()));
            this.xpdlPreviewTA.setCaretPosition(0);
            baos.close();
        }
        catch (Exception ex) {
            ex.printStackTrace();
            this.xpdlPreviewTA.setText("");
        }
    }

    private void findString() {
        if (this.searchCB.getSelectedItem() == null) {
            return;
        }
        String searchingTxt = this.searchCB.getSelectedItem().toString();
        this.addItemToCombo(searchingTxt);
        String txt = this.xpdlPreviewTA.getText();
        try {
            int foundPos;
            for (int i = foundPos = this.xpdlPreviewTA.getCaretPosition(); i <= txt.length() - searchingTxt.length(); ++i) {
                if (!txt.substring(i, i + searchingTxt.length()).equalsIgnoreCase(searchingTxt)) continue;
                this.xpdlPreviewTA.setCaretPosition(i);
                this.xpdlPreviewTA.getCaret().setSelectionVisible(true);
                this.xpdlPreviewTA.select(i, i + searchingTxt.length());
                foundPos = i + searchingTxt.length();
                return;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        JOptionPane.showMessageDialog(this.editor.getWindow(), ResourceManager.getLanguageDependentString("MessageJaWEHasFinishedSearchingXPDL"), JaWE.getAppTitle(), 1);
        this.xpdlPreviewTA.setCaretPosition(0);
    }

    private void addItemToCombo(String searchingTxt) {
        if (searchingTxt == null || searchingTxt.trim().length() == 0) {
            return;
        }
        for (int i = 0; i < this.searchCB.getItemCount(); ++i) {
            if (!this.searchCB.getItemAt(i).toString().equals(searchingTxt)) continue;
            return;
        }
        this.searchCB.addItem(searchingTxt);
    }

    public void changeLanguage() {
        JLabel l = (JLabel)((JPanel)this.searchPanel).getComponent(0);
        JButton b = (JButton)((JPanel)this.searchPanel).getComponent(3);
        l.setText(ResourceManager.getLanguageDependentString("SearchForKey") + ": ");
        b.setToolTipText(ResourceManager.getLanguageDependentString("FindNextStringOccuranceKey"));
    }
}

