/*
 * Decompiled with CFR 0.152.
 */
package org.enhydra.jawe;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Window;
import java.awt.geom.Rectangle2D;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.swing.JDialog;
import javax.swing.JOptionPane;
import javax.swing.SwingUtilities;
import javax.swing.ToolTipManager;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.TreeNode;
import org.enhydra.jawe.AbstractGraph;
import org.enhydra.jawe.JaWE;
import org.enhydra.jawe.JaWEConfig;
import org.enhydra.jawe.JaWEGraphModel;
import org.enhydra.jawe.JaWEParentMap;
import org.enhydra.jawe.PackageEditor;
import org.enhydra.jawe.ProcessEditor;
import org.enhydra.jawe.ProcessGraph;
import org.enhydra.jawe.ResourceManager;
import org.enhydra.jawe.Utils;
import org.enhydra.jawe.graph.Activity;
import org.enhydra.jawe.graph.BlockActivity;
import org.enhydra.jawe.graph.BlockActivityGraph;
import org.enhydra.jawe.graph.End;
import org.enhydra.jawe.graph.Process;
import org.enhydra.jawe.graph.Route;
import org.enhydra.jawe.graph.Start;
import org.enhydra.jawe.graph.Subflow;
import org.enhydra.jawe.graph.TransitionView;
import org.enhydra.jawe.xml.XMLComplexElement;
import org.enhydra.jawe.xml.XMLElement;
import org.enhydra.jawe.xml.XMLElementDialog;
import org.enhydra.jawe.xml.elements.Activities;
import org.enhydra.jawe.xml.elements.ActivitySet;
import org.enhydra.jawe.xml.elements.ActivitySets;
import org.enhydra.jawe.xml.elements.Package;
import org.enhydra.jawe.xml.elements.Participant;
import org.enhydra.jawe.xml.elements.Participants;
import org.enhydra.jawe.xml.elements.Transition;
import org.enhydra.jawe.xml.elements.Transitions;
import org.enhydra.jawe.xml.elements.WorkflowProcess;
import org.enhydra.jawe.xml.elements.WorkflowProcesses;
import org.jgraph.graph.CellView;
import org.jgraph.graph.ConnectionSet;
import org.jgraph.graph.DefaultGraphCell;
import org.jgraph.graph.Edge;
import org.jgraph.graph.GraphConstants;
import org.jgraph.graph.ParentMap;
import org.jgraph.graph.Port;
import org.jgraph.graph.PortView;

public class WorkflowManager
implements Serializable {
    private transient AbstractGraph graph;
    private int horizontalOffset = 0;
    private static final int defProcessWidth = JaWEConfig.getInstance().getProcessWidth();
    private static final int defProcessHeight = JaWEConfig.getInstance().getProcessHeight();
    private static final int minParWidth = JaWEConfig.getInstance().getMinParticipantWidth();
    private static final int minParHeight = JaWEConfig.getInstance().getMinParticipantHeight();
    private static final int defParNameWidth = JaWEConfig.getInstance().getParticipantNameWidth();
    private static final int defActivityWidth = JaWEConfig.getInstance().getActivityWidth();
    private static final int defActivityHeight = JaWEConfig.getInstance().getActivityHeight();
    private boolean creatingGraph = false;

    public WorkflowManager(AbstractGraph g) {
        this.graph = g;
    }

    public AbstractGraph getGraph() {
        return this.graph;
    }

    public Package getXMLPackage() {
        return this.graph.getXMLPackage();
    }

    public JaWEGraphModel graphModel() {
        return (JaWEGraphModel)this.graph.getModel();
    }

    public void createWorkflowGraph(WorkflowProcess wp) {
        this.creatingGraph = true;
        boolean isMine = true;
        if (!this.getXMLPackage().isMadeByJaWE()) {
            isMine = false;
        }
        List entitiesToInsert = wp.getEntitiesToInsert((Object)this.getVisualOwner());
        this.createGraphParticipants(wp, entitiesToInsert);
        this.createGraphActivitiesAndBlockActivities(wp, entitiesToInsert, isMine);
        this.createGraphTransitions(wp, entitiesToInsert, isMine);
        if (JaWEConfig.getInstance().getUseBubblesStatus()) {
            this.createGraphStarts(wp, isMine, false);
            this.createGraphEnds(wp, isMine, false);
        }
        if (!isMine) {
            this.layoutActivities();
            ProcessEditor pe = (ProcessEditor)this.graph.getEditor();
            Set startDescs = Utils.getStartDescriptions(pe);
            Set endDescs = Utils.getEndDescriptions(pe);
            XMLComplexElement vo = this.getVisualOwner();
            if (vo instanceof WorkflowProcess) {
                ((WorkflowProcess)vo).setStartDescriptions(startDescs);
                ((WorkflowProcess)vo).setEndDescriptions(endDescs);
            } else {
                ((org.enhydra.jawe.xml.elements.Activity)vo).setStartDescriptions(startDescs);
                ((org.enhydra.jawe.xml.elements.Activity)vo).setEndDescriptions(endDescs);
            }
        }
        this.creatingGraph = false;
        try {
            Dimension prefSize = new Dimension(this.getRootParticipantWidth(null, null) + 50, this.getNewRootParYPos(null, null) + 50);
            this.graph.setPreferredSize(prefSize);
        }
        catch (Exception ex) {
            // empty catch block
        }
    }

    public XMLComplexElement getVisualOwner() {
        if (this.graph instanceof BlockActivityGraph) {
            return (org.enhydra.jawe.xml.elements.Activity)((BlockActivityGraph)this.graph).getMyBlockActivity().getUserObject();
        }
        if (this.graph instanceof ProcessGraph) {
            return (WorkflowProcess)this.graph.getPropertyObject();
        }
        return (Package)this.graph.getPropertyObject();
    }

    private Activities getActivitiesCollection() {
        Activities acts;
        XMLComplexElement myOwner = this.getVisualOwner();
        if (myOwner instanceof WorkflowProcess) {
            acts = (Activities)myOwner.get("Activities");
        } else {
            BlockActivity ba = ((BlockActivityGraph)this.graph).getMyBlockActivity();
            ActivitySet as = this.getBlockActivitySet(ba);
            acts = (Activities)as.get("Activities");
        }
        return acts;
    }

    public Transitions getTransitionsCollection() {
        Transitions trans;
        XMLComplexElement myOwner = this.getVisualOwner();
        if (myOwner instanceof WorkflowProcess) {
            trans = (Transitions)myOwner.get("Transitions");
        } else {
            BlockActivity ba = ((BlockActivityGraph)this.graph).getMyBlockActivity();
            ActivitySet as = this.getBlockActivitySet(ba);
            trans = (Transitions)as.get("Transitions");
        }
        return trans;
    }

    private ActivitySet getBlockActivitySet(BlockActivity ba) {
        try {
            String ID = ba.getBlockID();
            ActivitySet as = ((ActivitySets)this.getWorkflowProcess().get("ActivitySets")).getActivitySet(ID);
            return as;
        }
        catch (Exception ex) {
            return null;
        }
    }

    private WorkflowProcess getWorkflowProcess() {
        if (this.graph.getPropertyObject() instanceof WorkflowProcess) {
            return (WorkflowProcess)this.graph.getPropertyObject();
        }
        return null;
    }

    public Process insertProcess(Point p, boolean updateCollection) {
        Point realP = (Point)this.graph.fromScreen(new Point(p));
        int ulx = realP.x;
        int uly = realP.y;
        Rectangle bounds = new Rectangle(ulx, uly, defProcessWidth, defProcessHeight);
        Hashtable<Process, Map> viewMap = new Hashtable<Process, Map>();
        Map map = GraphConstants.createMap();
        Process pr = new Process((PackageEditor)this.getGraph().getEditor());
        WorkflowProcess wp = new WorkflowProcess((WorkflowProcesses)this.getXMLPackage().get("WorkflowProcesses"), this.getXMLPackage());
        wp.get("Name").setValue((Object)ResourceManager.getLanguageDependentString("ProcessKey"));
        pr.setUserObject(wp);
        GraphConstants.setBounds((Map)map, (Rectangle2D)bounds);
        GraphConstants.setOpaque((Map)map, (boolean)true);
        GraphConstants.setBorderColor((Map)map, (Color)Color.darkGray);
        GraphConstants.setFont((Map)map, (Font)GraphConstants.defaultFont.deriveFont(JaWEConfig.getInstance().getFontSize()));
        viewMap.put(pr, map);
        Object[] insert = new Object[]{pr};
        String actionName = ResourceManager.getLanguageDependentString("MessageInsertingProcessIntoPackage");
        this.graphModel().insertAndEdit(insert, viewMap, null, null, null, actionName);
        if (updateCollection) {
            this.refreshCollections(insert, true);
        }
        return pr;
    }

    public void insertCellsAndArrangeParticipants(Object[] insert, Map viewMap, ConnectionSet cs) {
        if (JaWEGraphModel.getRootParticipants(this.graphModel()) != null) {
            this.updateModelAndArrangeParticipants(insert, null, null, viewMap, ResourceManager.getLanguageDependentString("MessageDuplicatingObject"), true, cs);
        } else {
            JOptionPane.showMessageDialog(this.graph.getEditor().getWindow(), ResourceManager.getLanguageDependentString("WarningCannotInsertObjectsOutsideParticipant"), JaWE.getAppTitle(), 2);
        }
    }

    public void moveCellsAndArrangeParticipants(Map propertyMap) {
        this.updateModelAndArrangeParticipants(null, propertyMap, null, null, ResourceManager.getLanguageDependentString("MessageMovingObjects"), false, null);
    }

    public void insertSubflowAndArrangeParticipants(Point p) {
        Set rootParticipants = JaWEGraphModel.getRootParticipants(this.graphModel());
        if (rootParticipants != null && rootParticipants.size() > 0) {
            Hashtable viewMap = new Hashtable();
            Subflow sbf = this.createSubflow(p, viewMap);
            this.updateModelAndArrangeParticipants(new Object[]{sbf}, null, null, viewMap, ResourceManager.getLanguageDependentString("MessageInsertingSubflowActivity"), true, null);
        } else {
            JOptionPane.showMessageDialog(this.graph.getEditor().getWindow(), ResourceManager.getLanguageDependentString("WarningCannotInsertSubflowActivityOutsideParticipant"), JaWE.getAppTitle(), 2);
        }
    }

    public void insertBlockActivityAndArrangeParticipants(Point p) {
        Set rootParticipants = JaWEGraphModel.getRootParticipants(this.graphModel());
        if (rootParticipants != null && rootParticipants.size() > 0) {
            Hashtable viewMap = new Hashtable();
            BlockActivity bla = this.createBlockActivity(p, viewMap);
            this.updateModelAndArrangeParticipants(new Object[]{bla}, null, null, viewMap, ResourceManager.getLanguageDependentString("MessageInsertingBlockActivity"), true, null);
        } else {
            JOptionPane.showMessageDialog(this.graph.getEditor().getWindow(), ResourceManager.getLanguageDependentString("WarningCannotInsertBlockActivityOutsideParticipant"), JaWE.getAppTitle(), 2);
        }
    }

    public void insertStartAndArrangeParticipants(Point p) {
        Set rootParticipants = JaWEGraphModel.getRootParticipants(this.graphModel());
        if (rootParticipants != null && rootParticipants.size() > 0) {
            Hashtable viewMap = new Hashtable();
            Start s = this.createStart(p, viewMap);
            this.updateModelAndArrangeParticipants(new Object[]{s}, null, null, viewMap, ResourceManager.getLanguageDependentString("MessageInsertingStart"), true, null);
        } else {
            String msg = ResourceManager.getLanguageDependentString("WarningCannotInsertStartOutsideParticipant");
            JOptionPane.showMessageDialog(this.graph.getEditor().getWindow(), msg, JaWE.getAppTitle(), 2);
        }
    }

    public void insertEndAndArrangeParticipants(Point p) {
        Set rootParticipants = JaWEGraphModel.getRootParticipants(this.graphModel());
        if (rootParticipants != null && rootParticipants.size() > 0) {
            Hashtable viewMap = new Hashtable();
            End e = this.createEnd(p, viewMap);
            this.updateModelAndArrangeParticipants(new Object[]{e}, null, null, viewMap, ResourceManager.getLanguageDependentString("MessageInsertingEnd"), true, null);
        } else {
            JOptionPane.showMessageDialog(this.graph.getEditor().getWindow(), ResourceManager.getLanguageDependentString("WarningCannotInsertEndOutsideParticipant"), JaWE.getAppTitle(), 2);
        }
    }

    public void insertActivityAndArrangeParticipants(Point p) {
        Set rootParticipants = JaWEGraphModel.getRootParticipants(this.graphModel());
        if (rootParticipants != null && rootParticipants.size() > 0) {
            Hashtable viewMap = new Hashtable();
            Activity act = this.createActivity(p, viewMap);
            this.updateModelAndArrangeParticipants(new Object[]{act}, null, null, viewMap, ResourceManager.getLanguageDependentString("MessageInsertingGenericActivity"), true, null);
        } else {
            JOptionPane.showMessageDialog(this.graph.getEditor().getWindow(), ResourceManager.getLanguageDependentString("WarningCannotInsertGenericActivityOutsideParticipant"), JaWE.getAppTitle(), 2);
        }
    }

    public void insertRouteAndArrangeParticipants(Point p) {
        Set rootParticipants = JaWEGraphModel.getRootParticipants(this.graphModel());
        if (rootParticipants != null && rootParticipants.size() > 0) {
            Hashtable viewMap = new Hashtable();
            Route r = this.createRoute(p, viewMap);
            this.updateModelAndArrangeParticipants(new Object[]{r}, null, null, viewMap, ResourceManager.getLanguageDependentString("MessageInsertingRouteActivity"), true, null);
        } else {
            JOptionPane.showMessageDialog(this.graph.getEditor().getWindow(), ResourceManager.getLanguageDependentString("WarningCannotInsertRouteActivityOutsideParticipant"), JaWE.getAppTitle(), 2);
        }
    }

    public org.enhydra.jawe.graph.Participant insertParticipantAndArrangeParticipants(Point p, Participant parUO) {
        ToolTipManager.sharedInstance().setEnabled(false);
        org.enhydra.jawe.graph.Participant par = null;
        HashMap viewMap = new HashMap();
        ParentMap parentMap = null;
        HashMap propertyMap = null;
        Object cell = ((ProcessGraph)this.graph).getFirstParticipantForLocation(p.x, p.y);
        if (cell != null) {
            JOptionPane.showMessageDialog(this.graph.getEditor().getWindow(), ResourceManager.getLanguageDependentString("WarningParticipantCannotHaveParticipants"), JaWE.getAppTitle(), 2);
            return null;
        }
        par = this.createParticipant(new Rectangle(this.horizontalOffset, this.getNewRootParYPos(null, null), this.getRootParticipantWidth(null, null), minParHeight), viewMap);
        propertyMap = new HashMap(viewMap);
        Participants wfp = (Participants)this.getWorkflowProcess().get("Participants");
        if (parUO != null) {
            Object[] insert = new Object[]{par};
            this.graphModel().insertAndEdit(insert, propertyMap, null, parentMap, null, ResourceManager.getLanguageDependentString("MessageInsertingParticipant"));
            par.setUserObject(parUO);
            if (!this.getXMLPackage().isReadOnly()) {
                parUO.graphReferenceAdded();
            }
        } else {
            parUO = (Participant)wfp.generateNewElement();
            Window w = this.graph.getEditor().getWindow();
            XMLElementDialog de = new XMLElementDialog((JDialog)w, ResourceManager.getLanguageDependentString("DialogNewParticipant"));
            de.editXMLElement(parUO.getPanel(), true, false);
            if (!de.isCanceled()) {
                Object[] insert = new Object[]{par};
                this.graphModel().insertAndEdit(insert, propertyMap, null, parentMap, null, ResourceManager.getLanguageDependentString("MessageInsertingParticipant"));
                par.setUserObject(parUO);
                if (!this.getXMLPackage().isReadOnly()) {
                    parUO.graphReferenceAdded();
                }
                wfp.add((XMLElement)parUO);
            }
        }
        if (JaWEConfig.getInstance().getTooltipStatus()) {
            ToolTipManager.sharedInstance().setEnabled(true);
        }
        if (!this.creatingGraph) {
            try {
                Dimension prefSize = new Dimension(this.getRootParticipantWidth(propertyMap, parentMap) + 50, this.getNewRootParYPos(propertyMap, parentMap) + 50);
                this.graph.setPreferredSize(prefSize);
            }
            catch (Exception ex) {
                // empty catch block
            }
        }
        return par;
    }

    public boolean showNode(Participant parUO) {
        if (parUO == null) {
            return false;
        }
        Point ofInsert = new Point(10, Integer.MAX_VALUE);
        org.enhydra.jawe.graph.Participant graphObj = this.getGraphObjectForXMLParticipant(parUO);
        if (null != graphObj) {
            return true;
        }
        org.enhydra.jawe.graph.Participant ins = this.insertParticipantAndArrangeParticipants(ofInsert, parUO);
        return ins != null;
    }

    public void hideNode(Participant parUO) {
        org.enhydra.jawe.graph.Participant p = this.getGraphObjectForXMLParticipant(parUO);
        if (p != null && !p.hasAnyActivity()) {
            this.removeCellsAndArrangeParticipants(new Object[]{p});
        }
    }

    private org.enhydra.jawe.graph.Participant getGraphObjectForXMLParticipant(Participant source) {
        Set graphParts = JaWEGraphModel.getAllParticipantsInModel(this.graphModel());
        if (graphParts != null) {
            Iterator it = graphParts.iterator();
            while (it.hasNext()) {
                org.enhydra.jawe.graph.Participant graphPart = (org.enhydra.jawe.graph.Participant)it.next();
                if (graphPart.getUserObject() != source) continue;
                return graphPart;
            }
        }
        return null;
    }

    public org.enhydra.jawe.graph.Transition insertTransition(Point start, Point end, PortView source, PortView target, boolean isRouting, boolean updateCollection) {
        Point p = (Point)this.graph.fromScreen(new Point(start));
        Point p2 = (Point)this.graph.fromScreen(new Point(end));
        ArrayList<Point> list = new ArrayList<Point>();
        Map map = GraphConstants.createMap();
        if (source.equals(target)) {
            GraphConstants.setLineStyle((Map)map, (int)12);
            list.add(p);
            if (updateCollection) {
                list.add(new Point(p.x - 50, p.y - 75));
                list.add(new Point(p.x + 50, p.y - 75));
            }
            list.add(p2);
        } else {
            list.add(p);
            list.add(p2);
        }
        GraphConstants.setPoints((Map)map, list);
        if (isRouting) {
            GraphConstants.setRouting((Map)map, (Edge.Routing)GraphConstants.ROUTING_SIMPLE);
        }
        GraphConstants.setLineEnd((Map)map, (int)2);
        GraphConstants.setEndFill((Map)map, (boolean)true);
        GraphConstants.setEndSize((Map)map, (int)10);
        GraphConstants.setFont((Map)map, (Font)GraphConstants.defaultFont.deriveFont(JaWEConfig.getInstance().getFontSize()));
        Hashtable<org.enhydra.jawe.graph.Transition, Map> viewMap = new Hashtable<org.enhydra.jawe.graph.Transition, Map>();
        org.enhydra.jawe.graph.Transition transition = new org.enhydra.jawe.graph.Transition();
        viewMap.put(transition, map);
        Object[] insert = new Object[]{transition};
        ConnectionSet cs = new ConnectionSet();
        cs.connect((Object)transition, source.getCell(), target.getCell());
        Transition uo = null;
        Transitions ts = this.getTransitionsCollection();
        uo = new Transition(ts);
        transition.setUserObject(uo);
        String undoMsg = ResourceManager.getLanguageDependentString("MessageInsertingTransition");
        this.graphModel().insertAndEdit(insert, viewMap, cs, null, null, undoMsg);
        Activity s = null;
        Activity t = null;
        try {
            s = transition.getSourceActivity();
        }
        catch (Exception ex) {
            // empty catch block
        }
        try {
            t = transition.getTargetActivity();
        }
        catch (Exception ex) {
            // empty catch block
        }
        org.enhydra.jawe.xml.elements.Activity sourceAct = null;
        if (s != null && t != null && !(s instanceof Start) && !(t instanceof End)) {
            try {
                sourceAct = (org.enhydra.jawe.xml.elements.Activity)s.getPropertyObject();
                uo.setFrom((XMLElement)sourceAct);
            }
            catch (Exception e) {
                // empty catch block
            }
            try {
                uo.setTo(t.getPropertyObject());
            }
            catch (Exception e) {
                // empty catch block
            }
        }
        if (updateCollection) {
            this.refreshCollections(insert, true);
        }
        return transition;
    }

    public void removeCellsAndArrangeParticipants(Object[] cellsToDelete) {
        HashSet<TreeNode> participantsToArrange = new HashSet<TreeNode>();
        HashMap propertyMap = new HashMap();
        JaWEParentMap parentMap = new JaWEParentMap();
        HashSet<Object> ports = new HashSet<Object>();
        if (cellsToDelete != null && cellsToDelete.length > 0) {
            for (int i = 0; i < cellsToDelete.length; ++i) {
                if (cellsToDelete[i] instanceof org.enhydra.jawe.graph.Participant) {
                    org.enhydra.jawe.graph.Participant par = (org.enhydra.jawe.graph.Participant)cellsToDelete[i];
                    Rectangle2D r = this.getBounds(par, propertyMap);
                    int yPos = r.getBounds().y + r.getBounds().height - 1;
                    org.enhydra.jawe.graph.Participant ppar = (org.enhydra.jawe.graph.Participant)((Object)par.getParent());
                    if (ppar != null) {
                        if (ppar.getChildCount() <= 1 && this.getParticipantHeight(ppar, propertyMap) <= minParHeight) continue;
                        Object[] allParents = ppar.getPath();
                        int resizeValue = r.getBounds().height;
                        int pHeight = this.getParticipantHeight(ppar, propertyMap);
                        if (pHeight - r.getBounds().height < minParHeight) {
                            resizeValue = pHeight - minParHeight;
                        }
                        this.resize(allParents, propertyMap, 0, -resizeValue);
                        this.translateVertically(propertyMap, null, yPos, -resizeValue);
                        continue;
                    }
                    this.translateVertically(propertyMap, null, yPos, -r.getBounds().height);
                    continue;
                }
                if (!(cellsToDelete[i] instanceof Port)) continue;
                ports.add(cellsToDelete[i]);
            }
            HashSet<Object> ctd = new HashSet<Object>(Arrays.asList(cellsToDelete));
            ctd.removeAll(ports);
            if (ctd.size() == 0) {
                return;
            }
            cellsToDelete = ctd.toArray();
            Set cellsToDel = JaWEGraphModel.getDescendants(this.graphModel(), cellsToDelete);
            this.graphModel();
            Set edges = JaWEGraphModel.getEdges(this.graphModel(), cellsToDel.toArray());
            cellsToDel.addAll(edges);
            HashSet allEdgesToDelete = new HashSet();
            HashSet allCellsToDelete = new HashSet();
            Iterator it = cellsToDel.iterator();
            while (it.hasNext()) {
                Object cell = it.next();
                if (cell instanceof Edge) {
                    allEdgesToDelete.add(cell);
                    continue;
                }
                if (cell instanceof Port) continue;
                allCellsToDelete.add(cell);
            }
            cellsToDelete = allCellsToDelete.toArray();
            for (int i = 0; i < cellsToDelete.length; ++i) {
                TreeNode parent = ((DefaultMutableTreeNode)cellsToDelete[i]).getParent();
                if (parent != null && parent instanceof org.enhydra.jawe.graph.Participant && cellsToDelete[i] instanceof Activity) {
                    participantsToArrange.add(parent);
                }
                parentMap.addEntry(cellsToDelete[i], null);
            }
            this.resizeAllParticipantsHorizontally(propertyMap, parentMap);
            this.arrangeParticipantsVertically(participantsToArrange.toArray(), propertyMap, parentMap);
            if (cellsToDelete != null && cellsToDelete.length == 1 && cellsToDelete[0] instanceof Process) {
                Process pr = (Process)cellsToDelete[0];
                this.arrangeProcesses(propertyMap, GraphConstants.getBounds((Map)pr.getAttributes()).getBounds());
            }
            this.graphModel().removeAndEdit(cellsToDel.toArray(), propertyMap, ResourceManager.getLanguageDependentString("MessageRemovingObjects"));
            this.refreshCollections(cellsToDel.toArray(), false);
        }
        try {
            Dimension prefSize = new Dimension(this.getRootParticipantWidth(propertyMap, parentMap) + 50, this.getNewRootParYPos(propertyMap, parentMap) + 50);
            this.graph.setPreferredSize(prefSize);
        }
        catch (Exception ex) {
            // empty catch block
        }
    }

    public int getHorizontalOffset() {
        return this.horizontalOffset;
    }

    public String getParticipantID(Activity a) {
        org.enhydra.jawe.graph.Participant par;
        if (a != null && (par = (org.enhydra.jawe.graph.Participant)((Object)a.getParent())) != null) {
            return par.get("Id").toString();
        }
        return "";
    }

    public Point getOffset(Activity a) {
        org.enhydra.jawe.graph.Participant par;
        if (a != null && a instanceof Activity && (par = (org.enhydra.jawe.graph.Participant)((Object)a.getParent())) != null) {
            Rectangle2D rpar = this.getBounds(par, null);
            Rectangle2D ract = this.getBounds(a, null);
            int yOff = ract.getBounds().y - rpar.getBounds().y;
            int xOff = ract.getBounds().x - rpar.getBounds().x;
            return new Point(xOff, yOff);
        }
        return new Point(0, 0);
    }

    public Set getBlockActivities(boolean recursivly) {
        Set allActs = JaWEGraphModel.getAllActivitiesInModel(this.graphModel());
        HashSet bas = new HashSet();
        if (allActs != null) {
            Iterator it = allActs.iterator();
            while (it.hasNext()) {
                WorkflowManager wm;
                Object act = it.next();
                if (!(act instanceof BlockActivity)) continue;
                bas.add(act);
                if (!recursivly || (wm = ((BlockActivity)act).getWorkflowManager()) == null) continue;
                bas.addAll(wm.getBlockActivities(true));
            }
        }
        return bas;
    }

    protected org.enhydra.jawe.graph.Participant createParticipant(Rectangle bounds, Map viewMap) {
        org.enhydra.jawe.graph.Participant par = new org.enhydra.jawe.graph.Participant();
        Map map = GraphConstants.createMap();
        GraphConstants.setBounds((Map)map, (Rectangle2D)bounds);
        GraphConstants.setOpaque((Map)map, (boolean)false);
        GraphConstants.setBorderColor((Map)map, (Color)Color.black);
        GraphConstants.setMoveable((Map)map, (boolean)false);
        GraphConstants.setFont((Map)map, (Font)GraphConstants.defaultFont.deriveFont(JaWEConfig.getInstance().getFontSize()));
        viewMap.put(par, map);
        return par;
    }

    protected Subflow createSubflow(Point p, Map viewMap) {
        Point realP = (Point)this.graph.fromScreen(new Point(p));
        int ulx = realP.x;
        int uly = realP.y;
        Rectangle bounds = new Rectangle(ulx, uly, defActivityWidth, defActivityHeight);
        Subflow sbf = new Subflow();
        WorkflowProcess wp = this.getWorkflowProcess();
        Activities acts = this.getActivitiesCollection();
        org.enhydra.jawe.xml.elements.Activity ap = new org.enhydra.jawe.xml.elements.Activity(acts, wp, 3);
        ap.set("Name", (Object)ResourceManager.getLanguageDependentString("SubFlowKey"));
        sbf.setUserObject(ap);
        Map map = GraphConstants.createMap();
        GraphConstants.setBounds((Map)map, (Rectangle2D)bounds);
        GraphConstants.setOpaque((Map)map, (boolean)true);
        GraphConstants.setBorderColor((Map)map, (Color)new Color(15, 0, 115));
        GraphConstants.setFont((Map)map, (Font)GraphConstants.defaultFont.deriveFont(JaWEConfig.getInstance().getFontSize()));
        viewMap.put(sbf, map);
        return sbf;
    }

    protected BlockActivity createBlockActivity(Point p, Map viewMap) {
        Point realP = (Point)this.graph.fromScreen(new Point(p));
        int ulx = realP.x;
        int uly = realP.y;
        Rectangle bounds = new Rectangle(ulx, uly, defActivityWidth, defActivityHeight);
        BlockActivity bla = new BlockActivity((ProcessEditor)this.getGraph().getEditor());
        org.enhydra.jawe.xml.elements.Activity ap = new org.enhydra.jawe.xml.elements.Activity(this.getActivitiesCollection(), this.getWorkflowProcess(), 4);
        ap.getBlockActivity().set("BlockId", (Object)((ActivitySets)this.getWorkflowProcess().get("ActivitySets")).generateID());
        ap.set("Name", (Object)ResourceManager.getLanguageDependentString("BlockActivityKey"));
        bla.setUserObject(ap);
        Map map = GraphConstants.createMap();
        GraphConstants.setBounds((Map)map, (Rectangle2D)bounds);
        GraphConstants.setOpaque((Map)map, (boolean)true);
        GraphConstants.setBorderColor((Map)map, (Color)new Color(15, 0, 115));
        GraphConstants.setFont((Map)map, (Font)GraphConstants.defaultFont.deriveFont(JaWEConfig.getInstance().getFontSize()));
        viewMap.put(bla, map);
        return bla;
    }

    protected Start createStart(Point p, Map viewMap) {
        Point realP = (Point)this.graph.fromScreen(new Point(p));
        int ulx = realP.x;
        int uly = realP.y;
        Rectangle bounds = new Rectangle(ulx, uly, defActivityHeight, defActivityHeight);
        Start s = new Start();
        Map map = GraphConstants.createMap();
        GraphConstants.setBounds((Map)map, (Rectangle2D)bounds);
        GraphConstants.setOpaque((Map)map, (boolean)true);
        GraphConstants.setBorderColor((Map)map, (Color)Color.darkGray);
        GraphConstants.setFont((Map)map, (Font)GraphConstants.defaultFont.deriveFont(JaWEConfig.getInstance().getFontSize()));
        viewMap.put(s, map);
        return s;
    }

    protected End createEnd(Point p, Map viewMap) {
        Point realP = (Point)this.graph.fromScreen(new Point(p));
        int ulx = realP.x;
        int uly = realP.y;
        Rectangle bounds = new Rectangle(ulx, uly, defActivityHeight, defActivityHeight);
        End e = new End();
        Map map = GraphConstants.createMap();
        GraphConstants.setBounds((Map)map, (Rectangle2D)bounds);
        GraphConstants.setOpaque((Map)map, (boolean)true);
        GraphConstants.setBorderColor((Map)map, (Color)Color.darkGray);
        GraphConstants.setFont((Map)map, (Font)GraphConstants.defaultFont.deriveFont(JaWEConfig.getInstance().getFontSize()));
        viewMap.put(e, map);
        return e;
    }

    protected Activity createActivity(Point p, Map viewMap) {
        Point realP = (Point)this.graph.fromScreen(new Point(p));
        int ulx = realP.x;
        int uly = realP.y;
        Rectangle bounds = new Rectangle(ulx, uly, defActivityWidth, defActivityHeight);
        Activity act = new Activity();
        WorkflowProcess wp = this.getWorkflowProcess();
        Activities acts = this.getActivitiesCollection();
        org.enhydra.jawe.xml.elements.Activity ap = new org.enhydra.jawe.xml.elements.Activity(acts, wp, 2);
        ap.set("Name", (Object)ResourceManager.getLanguageDependentString("GenericKey"));
        act.setUserObject(ap);
        Map map = GraphConstants.createMap();
        GraphConstants.setBounds((Map)map, (Rectangle2D)bounds);
        GraphConstants.setOpaque((Map)map, (boolean)true);
        GraphConstants.setBorderColor((Map)map, (Color)Color.darkGray);
        GraphConstants.setFont((Map)map, (Font)GraphConstants.defaultFont.deriveFont(JaWEConfig.getInstance().getFontSize()));
        viewMap.put(act, map);
        return act;
    }

    protected Route createRoute(Point p, Map viewMap) {
        Point realP = (Point)this.graph.fromScreen(new Point(p));
        int ulx = realP.x;
        int uly = realP.y;
        Rectangle bounds = new Rectangle(ulx, uly, defActivityWidth, defActivityHeight);
        Route r = new Route();
        WorkflowProcess wp = this.getWorkflowProcess();
        Activities acts = this.getActivitiesCollection();
        org.enhydra.jawe.xml.elements.Activity ap = new org.enhydra.jawe.xml.elements.Activity(acts, wp, 0);
        ap.set("Name", (Object)ResourceManager.getLanguageDependentString("RouteKey"));
        r.setUserObject(ap);
        Map map = GraphConstants.createMap();
        GraphConstants.setBounds((Map)map, (Rectangle2D)bounds);
        GraphConstants.setOpaque((Map)map, (boolean)true);
        GraphConstants.setBorderColor((Map)map, (Color)Color.darkGray);
        GraphConstants.setFont((Map)map, (Font)GraphConstants.defaultFont.deriveFont(JaWEConfig.getInstance().getFontSize()));
        viewMap.put(r, map);
        return r;
    }

    protected void updateModelAndArrangeParticipants(Object[] insert, Map propertyMap, ParentMap parentMap, Map viewMap, String actionName, boolean updateCollection, ConnectionSet cs) {
        if (propertyMap == null && viewMap == null) {
            return;
        }
        if (propertyMap == null) {
            propertyMap = new HashMap(viewMap);
        }
        if (parentMap == null) {
            parentMap = new JaWEParentMap();
        }
        this.arrangeParticipants(propertyMap, parentMap);
        if (insert == null || ((JaWEParentMap)parentMap).entryCount() != insert.length) {
            // empty if block
        }
        Dimension prefSize = null;
        if (!this.creatingGraph) {
            try {
                prefSize = new Dimension(this.getRootParticipantWidth(propertyMap, parentMap) + 50, this.getNewRootParYPos(propertyMap, parentMap) + 50);
            }
            catch (Exception ex) {
                // empty catch block
            }
        }
        this.graphModel().insertAndEdit(insert, propertyMap, cs, parentMap, null, actionName);
        if (updateCollection) {
            this.refreshCollections(insert, true);
        }
        if (!this.creatingGraph && prefSize != null) {
            try {
                this.graph.setPreferredSize(prefSize);
            }
            catch (Exception ex) {
                // empty catch block
            }
        }
    }

    protected void arrangeParticipants(Map propertyMap, ParentMap parentMap) {
        HashSet parsToArrangeVerticaly = new HashSet();
        Object[] cellsToManage = propertyMap.keySet().toArray();
        for (int i = 0; i < cellsToManage.length; ++i) {
            Object cell = cellsToManage[i];
            if (!(cell instanceof Activity)) continue;
            Set oldAndNewParentPar = this.updateActivityParent((Activity)cell, propertyMap, parentMap);
            parsToArrangeVerticaly.addAll(oldAndNewParentPar);
        }
        this.arrangeParticipantsVertically(parsToArrangeVerticaly.toArray(), propertyMap, parentMap);
        this.resizeAllParticipantsHorizontally(propertyMap, parentMap);
    }

    protected Set updateActivityParent(Activity ac, Map propertyMap, ParentMap parentMap) {
        HashSet<org.enhydra.jawe.graph.Participant> oldAndNewPar = new HashSet<org.enhydra.jawe.graph.Participant>();
        org.enhydra.jawe.graph.Participant oldPar = (org.enhydra.jawe.graph.Participant)((Object)ac.getParent());
        if (oldPar != null) {
            oldAndNewPar.add(oldPar);
        }
        org.enhydra.jawe.graph.Participant newPar = null;
        Rectangle2D acRect = this.getBounds(ac, propertyMap);
        Point acUpperLeft = acRect.getBounds().getLocation();
        Point newAcUpperLeft = new Point(acUpperLeft);
        newPar = this.findParentActivityParticipantForLocation(newAcUpperLeft, propertyMap, parentMap);
        if (!newAcUpperLeft.equals(acUpperLeft)) {
            Rectangle r = new Rectangle(acRect.getBounds());
            r.setLocation(newAcUpperLeft);
            this.changeBounds(ac, propertyMap, r);
        }
        if (newPar != null) {
            oldAndNewPar.add(newPar);
            if (!newPar.equals(oldPar)) {
                parentMap.addEntry((Object)ac, (Object)newPar);
            }
            Participant defaultP = Participant.getFreeTextExpressionParticipant();
            if (!(ac instanceof Route || ac instanceof Start || ac instanceof End || ac instanceof Subflow || ac instanceof BlockActivity || newPar.getUserObject() == defaultP)) {
                ac.set("Performer", newPar.getUserObject());
            }
            if (newPar != oldPar && newPar.getUserObject() == defaultP) {
                ac.set("Performer", "");
            }
        }
        return oldAndNewPar;
    }

    protected org.enhydra.jawe.graph.Participant findParentActivityParticipantForLocation(Point loc, Map propertyMap, ParentMap parentMap) {
        org.enhydra.jawe.graph.Participant newPar = null;
        if (loc.y <= 0) {
            loc.y = 1;
        }
        if (loc.x <= 0) {
            loc.x = 1;
        }
        if ((newPar = this.getLeafParticipantForYPos(loc.y, propertyMap, parentMap)) == null) {
            newPar = this.getLeafParticipantForYPos(this.getNewRootParYPos(propertyMap, null) - 10, propertyMap, parentMap);
        }
        if (newPar != null) {
            Rectangle newParRect = (Rectangle)this.getBounds(newPar, propertyMap);
            if (newParRect.x + defParNameWidth >= loc.x) {
                loc.x = newParRect.x + defParNameWidth + 1;
            }
        } else if (this.horizontalOffset >= loc.x) {
            loc.x = this.horizontalOffset;
        }
        return newPar;
    }

    protected void arrangeParticipantsVertically(Object[] pars, Map propertyMap, ParentMap parentMap) {
        if (pars == null || pars.length == 0) {
            return;
        }
        for (int i = 0; i < pars.length; ++i) {
            this.arrangeParticipantVertically(pars[i], propertyMap, parentMap);
        }
    }

    protected void arrangeParticipantVertically(Object par, Map propertyMap, ParentMap parentMap) {
        int curHeight;
        if (par == null) {
            return;
        }
        if (!(par instanceof org.enhydra.jawe.graph.Participant)) {
            return;
        }
        org.enhydra.jawe.graph.Participant p = (org.enhydra.jawe.graph.Participant)par;
        if (this.hasAnyParticipant(p, parentMap)) {
            return;
        }
        ArrayList removedPars = ((JaWEParentMap)parentMap).getRemovedNodes();
        if (removedPars.contains(p)) {
            return;
        }
        int optHeight = this.optimalParticipantHeight(p, propertyMap, parentMap);
        int dheight = optHeight - (curHeight = this.getParticipantHeight(p, propertyMap));
        if (dheight != 0) {
            this.translateVertically(propertyMap, parentMap, this.getBounds((Object)p, (Map)propertyMap).getBounds().y + curHeight - 1, dheight);
            Object[] allParentsAndPar = p.getPath();
            this.resize(allParentsAndPar, propertyMap, 0, dheight);
        }
    }

    protected void resizeAllParticipantsHorizontally(Map propertyMap, ParentMap parentMap) {
        int rootParWidth;
        int optimalRDW;
        Set participants = JaWEGraphModel.getAllParticipantsInModel(this.graphModel());
        if (parentMap != null && participants != null) {
            participants.removeAll(((JaWEParentMap)parentMap).getRemovedNodes());
        }
        if ((optimalRDW = this.optimalRootParticipantWidth(participants, propertyMap, parentMap)) != (rootParWidth = this.getRootParticipantWidth(propertyMap, parentMap))) {
            int dw = optimalRDW - rootParWidth;
            if (participants != null) {
                this.resize(participants.toArray(), propertyMap, dw, 0);
            }
        }
    }

    protected int optimalRootParticipantWidth(Set participants, Map propertyMap, ParentMap parentMap) {
        int minWidth = minParWidth;
        if (participants == null) {
            return minWidth;
        }
        HashSet<org.enhydra.jawe.graph.Participant> leafParticipants = new HashSet<org.enhydra.jawe.graph.Participant>();
        Iterator it = participants.iterator();
        while (it.hasNext()) {
            org.enhydra.jawe.graph.Participant par = (org.enhydra.jawe.graph.Participant)it.next();
            if (this.hasAnyParticipant(par, parentMap)) continue;
            leafParticipants.add(par);
        }
        it = leafParticipants.iterator();
        int maxRightEdgePosition = 0;
        while (it.hasNext()) {
            org.enhydra.jawe.graph.Participant lpar = (org.enhydra.jawe.graph.Participant)it.next();
            int minChildrenREdge = 0;
            int minParREdge = ((Rectangle)this.getBounds((Object)lpar, (Map)propertyMap)).x + minParWidth;
            Rectangle r = this.getBoundsOfParticipantFutureActivities(lpar, propertyMap, parentMap);
            if (r != null) {
                minChildrenREdge = r.x + r.width + defParNameWidth;
            }
            int minREdge = Math.max(minParREdge, minChildrenREdge);
            if (maxRightEdgePosition == 0) {
                maxRightEdgePosition = minREdge;
                continue;
            }
            if (minREdge <= maxRightEdgePosition) continue;
            maxRightEdgePosition = minREdge;
        }
        int minW = maxRightEdgePosition - this.horizontalOffset;
        if (minW > minParWidth) {
            minWidth = minW;
        }
        return minWidth;
    }

    protected int optimalParticipantHeight(org.enhydra.jawe.graph.Participant par, Map propertyMap, ParentMap parentMap) {
        int dBottom;
        int optH;
        int optHeight = minParHeight;
        if (!this.hasAnyActivity(par, parentMap)) {
            return optHeight;
        }
        Rectangle rCurrent = (Rectangle)this.getBounds(par, propertyMap);
        Rectangle rPreferred = this.getBoundsOfParticipantFutureActivities(par, propertyMap, parentMap);
        if (rPreferred != null && (optH = rCurrent.height + (dBottom = rPreferred.y + rPreferred.height - (rCurrent.y + rCurrent.height)) + 10) > optHeight) {
            optHeight = optH;
        }
        return optHeight;
    }

    protected void resize(Object[] cells, Map propertyMap, int dw, int dh) {
        if (cells != null && cells.length > 0) {
            for (int i = 0; i < cells.length; ++i) {
                Rectangle r = new Rectangle(this.getBounds(cells[i], propertyMap).getBounds());
                int newWidth = r.width + dw;
                int newHeight = r.height + dh;
                if (newWidth < minParWidth || newHeight < minParHeight) {
                    System.err.println("There was an error in calculating size of participant " + cells[i] + "!!!");
                    System.err.println("New width=" + newWidth + ", new height=" + newHeight);
                }
                r.setSize(newWidth, newHeight);
                this.changeBounds(cells[i], propertyMap, r);
            }
        }
    }

    protected void translateVertically(Map propertyMap, ParentMap parentMap, int yPos, int dv) {
        org.enhydra.jawe.graph.Participant[] pars = this.getParticipantsForYPos(yPos, 0, propertyMap, parentMap);
        this.translateParticipants(pars, propertyMap, parentMap, 0, dv);
    }

    protected void translateParticipants(org.enhydra.jawe.graph.Participant[] cells, Map propertyMap, ParentMap parentMap, int dx, int dy) {
        if (cells != null && cells.length > 0) {
            for (int i = 0; i < cells.length; ++i) {
                this.translateParticipant(cells[i], propertyMap, parentMap, dx, dy);
            }
        }
    }

    protected void translateParticipant(org.enhydra.jawe.graph.Participant par, Map propertyMap, ParentMap parentMap, int dx, int dy) {
        HashSet<org.enhydra.jawe.graph.Participant> participantAndItsFutureActivities = new HashSet<org.enhydra.jawe.graph.Participant>();
        participantAndItsFutureActivities.add(par);
        Set futureActivities = this.getParticipantFutureActivities(par, parentMap);
        participantAndItsFutureActivities.addAll(futureActivities);
        Iterator it = participantAndItsFutureActivities.iterator();
        while (it.hasNext()) {
            Object cell = it.next();
            Rectangle r = new Rectangle(this.getBounds(cell, propertyMap).getBounds());
            r.translate(dx, dy);
            this.changeBounds(cell, propertyMap, r);
        }
    }

    protected Rectangle getBoundsOfParticipantFutureActivities(org.enhydra.jawe.graph.Participant par, Map propertyMap, ParentMap parentMap) {
        Set futureActivities = this.getParticipantFutureActivities(par, parentMap);
        HashSet<Rectangle> futureActivityBounds = new HashSet<Rectangle>();
        Iterator it = futureActivities.iterator();
        while (it.hasNext()) {
            Rectangle actBnd = (Rectangle)this.getBounds(it.next(), propertyMap);
            futureActivityBounds.add(actBnd);
        }
        Rectangle[] fab = new Rectangle[futureActivityBounds.size()];
        futureActivityBounds.toArray(fab);
        Rectangle unionBounds = this.getUnionBounds(fab);
        return unionBounds;
    }

    protected Set getParticipantFutureActivities(org.enhydra.jawe.graph.Participant par, ParentMap parentMap) {
        if (parentMap == null) {
            return par.getChildActivities();
        }
        HashSet futureActivities = new HashSet();
        ArrayList emptyPars = ((JaWEParentMap)parentMap).emptyParentList();
        if (emptyPars.contains(par)) {
            return futureActivities;
        }
        Set changedNodes = parentMap.getChangedNodes();
        futureActivities = new HashSet(par.getChildActivities());
        Object[] previousActivities = futureActivities.toArray();
        for (int i = 0; i < previousActivities.length; ++i) {
            if (!changedNodes.contains(previousActivities[i])) continue;
            futureActivities.remove(previousActivities[i]);
        }
        ArrayList nc = ((JaWEParentMap)parentMap).getNewChildren(par);
        futureActivities.addAll(nc);
        return futureActivities;
    }

    protected org.enhydra.jawe.graph.Participant getLeafParticipantForYPos(int yPos, Map propertyMap, ParentMap parentMap) {
        org.enhydra.jawe.graph.Participant[] pars = this.getParticipantsForYPos(yPos, 2, propertyMap, parentMap);
        if (pars == null) {
            return null;
        }
        HashSet<org.enhydra.jawe.graph.Participant> leafPars = new HashSet<org.enhydra.jawe.graph.Participant>();
        for (int i = 0; i < pars.length; ++i) {
            if (this.hasAnyParticipant(pars[i], parentMap)) continue;
            leafPars.add(pars[i]);
        }
        if (leafPars.size() == 0) {
            return null;
        }
        Iterator it = leafPars.iterator();
        Object rightPar = it.next();
        if (leafPars.size() > 1) {
            int upperLeftY;
            Rectangle parRect = this.getBounds(rightPar, propertyMap).getBounds();
            int minUpperLeftY = upperLeftY = parRect.getLocation().y;
            while (it.hasNext()) {
                Object curPar = it.next();
                parRect = this.getBounds(curPar, propertyMap).getBounds();
                upperLeftY = parRect.getLocation().y;
                if (upperLeftY >= minUpperLeftY) continue;
                minUpperLeftY = upperLeftY;
                rightPar = curPar;
            }
        }
        return (org.enhydra.jawe.graph.Participant)rightPar;
    }

    protected org.enhydra.jawe.graph.Participant[] getParticipantsForYPos(int yPos, int direction, Map propertyMap, ParentMap parentMap) {
        Set participants = JaWEGraphModel.getAllParticipantsInModel(this.graphModel());
        if (participants == null) {
            return null;
        }
        if (parentMap != null) {
            participants.removeAll(((JaWEParentMap)parentMap).getRemovedNodes());
        }
        org.enhydra.jawe.graph.Participant[] pars = new org.enhydra.jawe.graph.Participant[participants.size()];
        participants.toArray(pars);
        HashSet<org.enhydra.jawe.graph.Participant> yPosPars = new HashSet<org.enhydra.jawe.graph.Participant>();
        block5: for (int i = 0; i < pars.length; ++i) {
            Rectangle r = (Rectangle)this.getBounds(pars[i], propertyMap);
            switch (direction) {
                case 0: {
                    if (r.y < yPos) continue block5;
                    yPosPars.add(pars[i]);
                    continue block5;
                }
                case 1: {
                    if (r.y >= yPos) continue block5;
                    yPosPars.add(pars[i]);
                    continue block5;
                }
                case 2: {
                    if (r.y > yPos || r.y + r.height < yPos) continue block5;
                    yPosPars.add(pars[i]);
                }
            }
        }
        if (yPosPars.size() > 0) {
            pars = new org.enhydra.jawe.graph.Participant[yPosPars.size()];
            yPosPars.toArray(pars);
            return pars;
        }
        return null;
    }

    protected int getNewRootParYPos(Map propertyMap, ParentMap parentMap) {
        Iterator<Object> it;
        int newRootParYPos = 0;
        Set rootPars = JaWEGraphModel.getRootParticipants(this.graphModel());
        if (propertyMap != null) {
            it = propertyMap.keySet().iterator();
            while (it.hasNext()) {
                Object rootPar = it.next();
                if (!(rootPar instanceof org.enhydra.jawe.graph.Participant) || ((DefaultGraphCell)rootPar).getParent() != null) continue;
                rootPars.add(rootPar);
            }
        }
        if (parentMap != null) {
            rootPars.removeAll(((JaWEParentMap)parentMap).getRemovedNodes());
        }
        if (rootPars == null || rootPars.size() == 0) {
            return newRootParYPos;
        }
        newRootParYPos = minParHeight;
        it = rootPars.iterator();
        while (it.hasNext()) {
            Rectangle bounds = (Rectangle)this.getBounds(it.next(), propertyMap);
            if (bounds.y + bounds.height <= newRootParYPos) continue;
            newRootParYPos = bounds.y + bounds.height;
        }
        return newRootParYPos;
    }

    protected int getRootParticipantWidth(Map propertyMap, ParentMap parentMap) {
        int rootParWidth = minParWidth;
        Set rootPars = JaWEGraphModel.getRootParticipants(this.graphModel());
        if (rootPars == null) {
            return rootParWidth;
        }
        if (parentMap != null) {
            rootPars.removeAll(((JaWEParentMap)parentMap).getRemovedNodes());
        }
        if (rootPars.size() == 0) {
            return rootParWidth;
        }
        Iterator it = rootPars.iterator();
        Object firstPar = it.next();
        rootParWidth = this.getParticipantWidth(firstPar, propertyMap);
        return rootParWidth;
    }

    protected boolean hasAnyParticipant(org.enhydra.jawe.graph.Participant par, ParentMap parentMap) {
        if (parentMap == null || !parentMap.getChangedNodes().contains(par)) {
            return par.hasAnyParticipant();
        }
        return ((JaWEParentMap)parentMap).hasAnyParticipant(par);
    }

    protected boolean hasAnyActivity(org.enhydra.jawe.graph.Participant par, ParentMap parentMap) {
        if (parentMap == null || !parentMap.getChangedNodes().contains(par)) {
            return par.hasAnyActivity();
        }
        ArrayList emptyPars = ((JaWEParentMap)parentMap).emptyParentList();
        return !emptyPars.contains(par);
    }

    protected Set getStarts() {
        HashSet starts = new HashSet();
        this.graphModel();
        Set allActivities = JaWEGraphModel.getAllActivitiesInModel(this.graphModel());
        if (allActivities != null) {
            Iterator it = allActivities.iterator();
            while (it.hasNext()) {
                Object act = it.next();
                if (!(act instanceof Start)) continue;
                starts.add(act);
            }
        }
        return starts;
    }

    protected Set getEnds() {
        HashSet ends = new HashSet();
        this.graphModel();
        Set allActivities = JaWEGraphModel.getAllActivitiesInModel(this.graphModel());
        if (allActivities != null) {
            Iterator it = allActivities.iterator();
            while (it.hasNext()) {
                Object act = it.next();
                if (!(act instanceof End)) continue;
                ends.add(act);
            }
        }
        return ends;
    }

    public CellView getView(Object cell) {
        return this.graph.getGraphLayoutCache().getMapping(cell, false);
    }

    protected int getParticipantWidth(Object par, Map propertyMap) {
        return this.getBounds((Object)par, (Map)propertyMap).getBounds().width;
    }

    protected int getParticipantHeight(Object par, Map propertyMap) {
        return this.getBounds((Object)par, (Map)propertyMap).getBounds().height;
    }

    protected void changeBounds(Object cell, Map propertyMap, Rectangle r) {
        if (propertyMap == null || !propertyMap.containsKey(cell)) {
            Map map = GraphConstants.createMap();
            GraphConstants.setBounds((Map)map, (Rectangle2D)r);
            propertyMap.put(cell, map);
        } else {
            Map map = (Map)propertyMap.get(cell);
            GraphConstants.setBounds((Map)map, (Rectangle2D)r);
        }
    }

    public Rectangle2D getBounds(Object cell, Map propertyMap) {
        if (propertyMap != null && propertyMap.containsKey(cell)) {
            Map map = (Map)propertyMap.get(cell);
            return GraphConstants.getBounds((Map)map);
        }
        CellView view = this.getView(cell);
        return view.getBounds();
    }

    protected Rectangle getUnionBounds(Rectangle[] rects) {
        if (rects != null && rects.length > 0) {
            Rectangle unionRect = null;
            for (int i = 0; i < rects.length; ++i) {
                if (unionRect == null) {
                    unionRect = new Rectangle(rects[i]);
                    continue;
                }
                SwingUtilities.computeUnion(rects[i].x, rects[i].y, rects[i].width, rects[i].height, unionRect);
            }
            return unionRect;
        }
        return null;
    }

    private void createGraphParticipants(WorkflowProcess wp, List entitiesToInsert) {
        boolean participantInserted = false;
        Iterator it = entitiesToInsert.iterator();
        while (it.hasNext()) {
            Object p = it.next();
            if (!(p instanceof Participant)) continue;
            this.showNode((Participant)p);
            participantInserted = true;
        }
        if (!participantInserted) {
            Participants pcs = (Participants)wp.get("Participants");
            Activities acts = null;
            if (this.graph instanceof BlockActivityGraph) {
                ActivitySet as = this.getBlockActivitySet(((BlockActivityGraph)this.graph).getMyBlockActivity());
                if (as != null) {
                    acts = (Activities)as.get("Activities");
                }
            } else {
                acts = (Activities)wp.get("Activities");
            }
            if (acts != null && acts.size() > 0) {
                this.showNode(Participant.getFreeTextExpressionParticipant());
            }
        }
    }

    private void createGraphActivitiesAndBlockActivities(WorkflowProcess wp, List entitiesToInsert, boolean isMine) {
        Iterator it = entitiesToInsert.iterator();
        while (it.hasNext()) {
            Object mayBeActivity = it.next();
            if (!(mayBeActivity instanceof org.enhydra.jawe.xml.elements.Activity)) continue;
            this.insertActivity((org.enhydra.jawe.xml.elements.Activity)mayBeActivity, wp, isMine);
        }
    }

    private void insertActivity(org.enhydra.jawe.xml.elements.Activity a, WorkflowProcess wp, boolean isMine) {
        Activity act;
        Rectangle rPar;
        org.enhydra.jawe.graph.Participant par;
        Participants pcs = (Participants)wp.get("Participants");
        Point p = null;
        Object performer = a.get("Performer").toValue();
        String participantID = "";
        if (isMine) {
            participantID = a.getParticipantID();
        }
        if (participantID.length() == 0) {
            participantID = performer != null && performer instanceof Participant ? ((Participant)performer).getID() : performer.toString();
        }
        if ((par = this.getGraphObjectForXMLParticipant(pcs.getParticipant(participantID))) == null) {
            par = this.getGraphObjectForXMLParticipant(Participant.getFreeTextExpressionParticipant());
        }
        if (par != null) {
            rPar = (Rectangle)this.getBounds(par, null);
            p = new Point(rPar.getLocation());
            p.x += 10;
            p.y += 10;
        } else {
            rPar = null;
            p = new Point(10, 10);
        }
        Hashtable viewMap = new Hashtable();
        int actType = a.getType();
        switch (actType) {
            case 0: {
                act = this.createRoute(p, viewMap);
                break;
            }
            case 3: {
                act = this.createSubflow(p, viewMap);
                break;
            }
            case 4: {
                act = this.createBlockActivity(p, viewMap);
                ((ActivitySets)wp.get("ActivitySets")).decrementID();
                break;
            }
            default: {
                act = this.createActivity(p, viewMap);
            }
        }
        this.getActivitiesCollection().decrementID();
        act.setUserObject(a);
        this.updateModelAndArrangeParticipants(new Object[]{act}, null, null, viewMap, "", false, null);
        int xOffset = 0;
        int yOffset = 0;
        if (isMine) {
            xOffset = a.getXOffset();
            yOffset = a.getYOffset();
        }
        this.adjustActivityPosition(act, xOffset, yOffset, rPar);
        a.set("Performer", performer);
        if (actType == 4) {
            ((BlockActivity)act).createBlockActivityGraph(this.graph.getEditor().getWindow());
        }
    }

    /*
     * Unable to fully structure code
     */
    private void createGraphTransitions(WorkflowProcess wp, List entitiesToInsert, boolean isMine) {
        it = entitiesToInsert.iterator();
        while (it.hasNext()) {
            tr = it.next();
            if (!(tr instanceof Transition)) continue;
            trans = (Transition)tr;
            IDFrom = trans.get("From").toValue().toString();
            IDTo = trans.get("To").toValue().toString();
            source = this.getActivity(IDFrom);
            target = this.getActivity(IDTo);
            rt = trans.getRoutingType();
            if (rt == null) ** GOTO lbl-1000
            if (!rt.equals("NOROUTING")) {
                v0 = true;
            } else lbl-1000:
            // 2 sources

            {
                v0 = false;
            }
            if ((t = this.connectActivities(source, target, isRouting = v0)) == null) continue;
            if (!isRouting) {
                tv = (TransitionView)this.getView(t);
                ordNoToPoint = trans.getBreakPoints();
                for (i = 1; i <= ordNoToPoint.size(); ++i) {
                    tv.addPointProgramatically((Point)ordNoToPoint.get(new Integer(i)), i);
                }
            }
            t.setUserObject(trans);
        }
    }

    protected void createGraphStarts(WorkflowProcess wp, boolean isMine, boolean automaticCreation) {
        block17: {
            Hashtable viewMap;
            Activity target;
            Start source;
            block16: {
                source = null;
                target = null;
                viewMap = new Hashtable();
                org.enhydra.jawe.xml.elements.Activity a = null;
                if (!isMine || automaticCreation) break block16;
                Set startDescriptions = new HashSet();
                if (this.graph instanceof BlockActivityGraph) {
                    a = (org.enhydra.jawe.xml.elements.Activity)this.getVisualOwner();
                    startDescriptions = a.getStartDescriptions();
                } else {
                    startDescriptions = wp.getStartDescriptions();
                }
                if (startDescriptions.size() == 0) {
                    return;
                }
                Participants pcs = (Participants)wp.get("Participants");
                Iterator it = startDescriptions.iterator();
                while (it.hasNext()) {
                    Point p;
                    Rectangle rPar;
                    String startDesc = (String)it.next();
                    String[] startD = Utils.tokenize(startDesc, ";");
                    String ID = "";
                    try {
                        ID = startD[0];
                    }
                    catch (Exception ex) {
                        // empty catch block
                    }
                    org.enhydra.jawe.graph.Participant par = this.getGraphObjectForXMLParticipant(pcs.getParticipant(ID));
                    if (par == null) {
                        par = this.getGraphObjectForXMLParticipant(Participant.getFreeTextExpressionParticipant());
                    }
                    if (par != null) {
                        rPar = (Rectangle)this.getBounds(par, null);
                        p = new Point(rPar.getLocation());
                        p.x += 10;
                        p.y += 10;
                    } else {
                        rPar = null;
                        p = new Point(10, 10);
                    }
                    viewMap = new Hashtable();
                    source = this.createStart(p, viewMap);
                    this.updateModelAndArrangeParticipants(new Object[]{source}, null, null, viewMap, "", false, null);
                    try {
                        this.adjustActivityPosition(source, Integer.parseInt(startD[2]), Integer.parseInt(startD[3]), rPar);
                    }
                    catch (Exception ex) {
                        // empty catch block
                    }
                    try {
                        target = this.getActivity(startD[1]);
                    }
                    catch (Exception ex) {
                        // empty catch block
                    }
                    boolean isTransitionRouted = false;
                    try {
                        String itr = startD[4];
                        isTransitionRouted = !itr.equals("NOROUTING");
                    }
                    catch (Exception ex) {
                        isTransitionRouted = false;
                    }
                    if (source == null || target == null) continue;
                    this.connectActivities(source, target, isTransitionRouted);
                }
                break block17;
            }
            Set acs = JaWEGraphModel.getAllActivitiesInModel(this.graphModel());
            if (acs == null) break block17;
            int translY = 10;
            Iterator it = acs.iterator();
            while (it.hasNext()) {
                Activity act = (Activity)it.next();
                if (act instanceof Start || act instanceof End || !Utils.isStartingActivity(act) || Utils.hasConnectedStartBubble(act)) continue;
                target = act;
                viewMap = new Hashtable();
                source = this.createStart(new Point(10, translY), viewMap);
                translY += 30;
                this.updateModelAndArrangeParticipants(new Object[]{source}, null, null, viewMap, "", false, null);
                if (source == null || target == null) continue;
                this.connectActivities(source, target, false);
            }
        }
    }

    protected void createGraphEnds(WorkflowProcess wp, boolean isMine, boolean automaticCreation) {
        block17: {
            End target;
            Activity source;
            block16: {
                source = null;
                target = null;
                org.enhydra.jawe.xml.elements.Activity a = null;
                if (!isMine || automaticCreation) break block16;
                Set endDescriptions = new HashSet();
                if (this.graph instanceof BlockActivityGraph) {
                    a = (org.enhydra.jawe.xml.elements.Activity)this.getVisualOwner();
                    endDescriptions = a.getEndDescriptions();
                } else {
                    endDescriptions = wp.getEndDescriptions();
                }
                if (endDescriptions.size() == 0) {
                    return;
                }
                Participants pcs = (Participants)wp.get("Participants");
                Iterator it = endDescriptions.iterator();
                while (it.hasNext()) {
                    Point p;
                    Rectangle rPar;
                    String endDesc = (String)it.next();
                    String[] endD = Utils.tokenize(endDesc, ";");
                    String ID = "";
                    try {
                        ID = endD[0];
                    }
                    catch (Exception ex) {
                        // empty catch block
                    }
                    org.enhydra.jawe.graph.Participant par = this.getGraphObjectForXMLParticipant(pcs.getParticipant(ID));
                    if (par == null) {
                        par = this.getGraphObjectForXMLParticipant(Participant.getFreeTextExpressionParticipant());
                    }
                    if (par != null) {
                        rPar = (Rectangle)this.getBounds(par, null);
                        p = new Point(rPar.getLocation());
                        p.x += 10;
                        p.y += 10;
                    } else {
                        rPar = null;
                        p = new Point(10, 10);
                    }
                    Hashtable viewMap = new Hashtable();
                    target = this.createEnd(p, viewMap);
                    this.updateModelAndArrangeParticipants(new Object[]{target}, null, null, viewMap, "", false, null);
                    try {
                        this.adjustActivityPosition(target, Integer.parseInt(endD[2]), Integer.parseInt(endD[3]), rPar);
                    }
                    catch (Exception ex) {
                        // empty catch block
                    }
                    try {
                        source = this.getActivity(endD[1]);
                    }
                    catch (Exception ex) {
                        // empty catch block
                    }
                    boolean isTransitionRouted = false;
                    try {
                        String itr = endD[4];
                        isTransitionRouted = !itr.equals("NOROUTING");
                    }
                    catch (Exception ex) {
                        isTransitionRouted = false;
                    }
                    if (source == null || target == null) continue;
                    this.connectActivities(source, target, isTransitionRouted);
                }
                break block17;
            }
            Set acs = JaWEGraphModel.getAllActivitiesInModel(this.graphModel());
            if (acs == null) break block17;
            int translY = 10;
            Iterator it = acs.iterator();
            while (it.hasNext()) {
                Activity act = (Activity)it.next();
                if (act instanceof Start || act instanceof End || !Utils.isEndingActivity(act) || Utils.hasConnectedEndBubble(act)) continue;
                source = act;
                Hashtable viewMap = new Hashtable();
                target = this.createEnd(new Point(600, translY), viewMap);
                translY += 10;
                this.updateModelAndArrangeParticipants(new Object[]{target}, null, null, viewMap, "", false, null);
                if (source == null || target == null) continue;
                this.connectActivities(source, target, false);
            }
        }
    }

    private void adjustActivityPosition(Activity act, int xOff, int yOff, Rectangle rPar) {
        int inc;
        if (rPar == null || xOff == 0 && yOff == 0) {
            return;
        }
        int yPar = rPar.y;
        int xPar = rPar.x;
        Map attrib = GraphConstants.cloneMap((Map)act.getAttributes());
        Hashtable<Activity, Map> propertyMap = new Hashtable<Activity, Map>();
        JaWEParentMap parentMap = new JaWEParentMap();
        propertyMap.put(act, attrib);
        Rectangle bounds = (Rectangle)GraphConstants.getBounds((Map)attrib);
        int nextYOff = inc = rPar.height - 5;
        if (yOff < inc) {
            inc = yOff;
            nextYOff = yOff;
        }
        bounds.setLocation(new Point(xPar + xOff, yPar + inc));
        this.arrangeParticipants(propertyMap, parentMap);
        if (yOff > nextYOff) {
            inc = defActivityHeight;
            do {
                if ((nextYOff += inc) > yOff) {
                    inc = yOff - (nextYOff -= inc);
                    nextYOff += inc;
                }
                bounds.translate(0, inc);
                this.arrangeParticipants(propertyMap, parentMap);
            } while (nextYOff < yOff);
        }
        this.graphModel().edit(propertyMap, null, parentMap, null);
        this.graph.paintImmediately(this.graph.getBounds());
    }

    private org.enhydra.jawe.graph.Transition connectActivities(Activity source, Activity target, boolean isRouting) {
        Point startP = this.getCenter(source);
        Point endP = this.getCenter(target);
        try {
            org.enhydra.jawe.graph.Transition t = this.insertTransition(startP, endP, (PortView)this.getView(source.getPort()), (PortView)this.getView(target.getPort()), isRouting, false);
            return t;
        }
        catch (Exception ex) {
            System.err.println("Error while connecting activities " + source + " and " + target + " !!!");
            return null;
        }
    }

    private void layoutActivities() {
        Set participants = JaWEGraphModel.getAllParticipantsInModel(this.graphModel());
        if (participants != null) {
            Iterator it = participants.iterator();
            while (it.hasNext()) {
                org.enhydra.jawe.graph.Participant par = (org.enhydra.jawe.graph.Participant)it.next();
                Set activities = par.getChildActivities();
                Iterator itAct = activities.iterator();
                int cnt = 0;
                double chngDir = (int)Math.sqrt(activities.size());
                int incX = 2 * defActivityWidth;
                int incY = defActivityHeight + 5;
                int translateX = 0;
                int translateY = 0;
                while (itAct.hasNext()) {
                    Activity act = (Activity)itAct.next();
                    if (act instanceof Start || act instanceof End) continue;
                    if ((double)(++cnt) / chngDir == (double)((int)((double)cnt / chngDir))) {
                        incX = -incX;
                        translateY += incY;
                    } else {
                        translateX += incX;
                    }
                    Map attrib = GraphConstants.cloneMap((Map)act.getAttributes());
                    Hashtable<Activity, Map> propertyMap = new Hashtable<Activity, Map>();
                    JaWEParentMap parentMap = new JaWEParentMap();
                    propertyMap.put(act, attrib);
                    Rectangle bounds = (Rectangle)GraphConstants.getBounds((Map)attrib);
                    if (act instanceof End) {
                        bounds.translate(0, translateY);
                    } else {
                        bounds.translate(translateX, translateY);
                    }
                    this.arrangeParticipants(propertyMap, parentMap);
                    this.graphModel().edit(propertyMap, null, parentMap, null);
                }
            }
        }
    }

    public Activity getActivity(String ID) {
        Set allActs = JaWEGraphModel.getAllActivitiesInModel(this.graphModel());
        if (allActs != null) {
            Iterator it = allActs.iterator();
            while (it.hasNext()) {
                String curID;
                Activity act = (Activity)it.next();
                if (act instanceof Start || act instanceof End || (curID = act.get("Id").toValue().toString()) == null || !curID.equals(ID)) continue;
                return act;
            }
        }
        return null;
    }

    public org.enhydra.jawe.graph.Transition getTransition(String ID) {
        Set allTrans = JaWEGraphModel.getAllTransitionsInModel(this.graphModel());
        if (allTrans != null) {
            Iterator it = allTrans.iterator();
            while (it.hasNext()) {
                String curID;
                org.enhydra.jawe.graph.Transition tr = (org.enhydra.jawe.graph.Transition)it.next();
                Transition xmlT = (Transition)tr.getUserObject();
                if (xmlT.getFrom() == null || xmlT.getTo() == null || (curID = tr.get("Id").toValue().toString()) == null || !curID.equals(ID)) continue;
                return tr;
            }
        }
        return null;
    }

    public org.enhydra.jawe.graph.Participant getParticipant(String ID) {
        Set allPartic = JaWEGraphModel.getAllParticipantsInModel(this.graphModel());
        if (allPartic != null) {
            Iterator it = allPartic.iterator();
            while (it.hasNext()) {
                org.enhydra.jawe.graph.Participant p = (org.enhydra.jawe.graph.Participant)it.next();
                if (!p.get("Id").toString().equals(ID)) continue;
                return p;
            }
        }
        return null;
    }

    private Point getCenter(Object go) {
        if (go == null) {
            return null;
        }
        Rectangle r = (Rectangle)this.getBounds(go, null);
        if (!(go instanceof org.enhydra.jawe.graph.Participant)) {
            return new Point(r.x + r.width / 2, r.y + r.height / 2);
        }
        return new Point(r.x + defParNameWidth / 2, r.y + r.height / 2);
    }

    protected void refreshCollections(Object[] cellsToAddOrRemove, boolean toAdd) {
        HashSet<Object> xmlaAR = new HashSet<Object>();
        HashSet<Object> xmltAR = new HashSet<Object>();
        HashSet<WorkflowProcess> xmlwAR = new HashSet<WorkflowProcess>();
        HashSet<Object> baAR = new HashSet<Object>();
        if (cellsToAddOrRemove != null && cellsToAddOrRemove.length > 0) {
            for (int i = 0; i < cellsToAddOrRemove.length; ++i) {
                Object cell = cellsToAddOrRemove[i];
                this.manageParticipantReferences(cell, toAdd);
                if (cell instanceof org.enhydra.jawe.graph.Transition) {
                    org.enhydra.jawe.graph.Transition tr = (org.enhydra.jawe.graph.Transition)cell;
                    boolean isValid = this.manageTransition(tr);
                    if (toAdd) {
                        if (!isValid) continue;
                        xmltAR.add(tr.getUserObject());
                        continue;
                    }
                    xmltAR.add(tr.getUserObject());
                    continue;
                }
                if (cell instanceof Process) {
                    Process proc = (Process)cell;
                    WorkflowProcess wp = (WorkflowProcess)proc.getUserObject();
                    xmlwAR.add(wp);
                    if (toAdd) {
                        JaWE.getInstance().getPackageEditor().putProcessObjectMapping(wp, proc);
                        continue;
                    }
                    JaWE.getInstance().getPackageEditor().removeProcessObjectMapping(wp);
                    continue;
                }
                if (cell instanceof BlockActivity) {
                    xmlaAR.add(((Activity)cell).getUserObject());
                    baAR.add(cell);
                    continue;
                }
                if (!(cell instanceof Activity) || cell instanceof Start || cell instanceof End) continue;
                xmlaAR.add(((Activity)cell).getUserObject());
            }
        }
        Package pkg = this.getXMLPackage();
        WorkflowProcesses wps = (WorkflowProcesses)pkg.get("WorkflowProcesses");
        wps.refreshCollection(xmlwAR, toAdd);
        XMLElement el = this.graph.getPropertyObject();
        if (el instanceof WorkflowProcess) {
            WorkflowProcess wp = (WorkflowProcess)el;
            ActivitySets xmlactsts = (ActivitySets)wp.get("ActivitySets");
            Activities xmlacts = this.getActivitiesCollection();
            Transitions xmltrans = this.getTransitionsCollection();
            xmlacts.refreshCollection(xmlaAR, toAdd);
            xmltrans.refreshCollection(xmltAR, toAdd);
            Iterator it = baAR.iterator();
            while (it.hasNext()) {
                BlockActivity ba = (BlockActivity)it.next();
                ActivitySet as = null;
                String ID = ba.getBlockID();
                if (toAdd) {
                    as = new ActivitySet(xmlactsts, wp);
                    as.set("Id", (Object)ID);
                    as.setIDPrefixForCollections();
                    xmlactsts.add((XMLElement)as);
                    continue;
                }
                as = xmlactsts.getActivitySet(ID);
                xmlactsts.remove((Object)as);
            }
        }
        if (cellsToAddOrRemove != null && cellsToAddOrRemove.length > 0) {
            this.getGraph().getEditor().getStatusBar().updateMessage();
        }
    }

    public boolean manageTransition(org.enhydra.jawe.graph.Transition tr) {
        Transition xmlT = (Transition)tr.getUserObject();
        Activity s = null;
        try {
            s = tr.getSourceActivity();
        }
        catch (Exception ex) {
            try {
                s = this.getActivity(xmlT.get("From").toString());
            }
            catch (Exception ex2) {
                // empty catch block
            }
        }
        Activity t = null;
        try {
            t = tr.getTargetActivity();
        }
        catch (Exception ex) {
            try {
                t = this.getActivity(xmlT.get("To").toString());
            }
            catch (Exception ex2) {
                // empty catch block
            }
        }
        if (s != null) {
            this.updateSplit(s);
        }
        if (t != null) {
            this.updateJoin(t);
        }
        return s != null && !(s instanceof Start) && s.getUserObject() instanceof XMLElement && t != null && !(s instanceof Start) && t.getUserObject() instanceof XMLElement;
    }

    public void correctXMLTransition(org.enhydra.jawe.graph.Transition tr) {
        Transition xmlT = (Transition)tr.getUserObject();
        Activity s = tr.getSourceActivity();
        Activity t = tr.getTargetActivity();
        if (s != null && s.getUserObject() instanceof XMLElement && t != null && t.getUserObject() instanceof XMLElement) {
            xmlT.setFrom(s.getPropertyObject());
            xmlT.setTo(t.getPropertyObject());
        }
    }

    public void updateSplit(Activity s) {
        if (s != null && s.getUserObject() instanceof XMLElement) {
            org.enhydra.jawe.xml.elements.Activity a = (org.enhydra.jawe.xml.elements.Activity)s.getUserObject();
            int noft = s.getOutgoingTransitions().size();
            String type = a.getSplit().get("Type").toString().trim();
            if (type.length() == 0) {
                if (noft > 1) {
                    a.setSplitType(ResourceManager.getLanguageDependentString("XORKey"));
                }
            } else if (noft <= 1) {
                a.setSplitType("");
            }
        }
    }

    public void updateJoin(Activity t) {
        if (t != null && t.getUserObject() instanceof XMLElement) {
            org.enhydra.jawe.xml.elements.Activity a = (org.enhydra.jawe.xml.elements.Activity)t.getUserObject();
            int noft = t.getIncomingTransitions().size();
            String type = a.getJoin().get("Type").toString().trim();
            if (type.length() == 0) {
                if (noft > 1) {
                    a.setJoinType(ResourceManager.getLanguageDependentString("XORKey"));
                }
            } else if (noft <= 1) {
                a.setJoinType("");
            }
        }
    }

    private void manageParticipantReferences(Set cellsToDelete, boolean toAdd) {
        Iterator it = cellsToDelete.iterator();
        while (it.hasNext()) {
            this.manageParticipantReferences(it.next(), toAdd);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void manageParticipantReferences(Object cellToDelete, boolean toAdd) {
        if (cellToDelete instanceof Process) {
            Process pr = (Process)cellToDelete;
            try {
                Set s = JaWEGraphModel.getAllParticipantsInModel(pr.getImplementationEditor().getGraph().getModel());
                if (s != null) {
                    Iterator iter = s.iterator();
                    while (iter.hasNext()) {
                        this.manageParticipantReferences(iter.next(), toAdd);
                    }
                }
                this.manageParticipantReferences(pr.getImplementationEditor().getGraph().getWorkflowManager().getBlockActivities(true), toAdd);
                return;
            }
            catch (Exception ex) {}
            return;
        }
        if (cellToDelete instanceof BlockActivity) {
            BlockActivity b = (BlockActivity)cellToDelete;
            try {
                Set s = JaWEGraphModel.getAllParticipantsInModel(b.getImplementationEditor().getGraph().getModel());
                if (s == null) return;
                Iterator iter = s.iterator();
                while (iter.hasNext()) {
                    this.manageParticipantReferences(iter.next(), toAdd);
                }
                return;
            }
            catch (Exception ex) {
                return;
            }
        }
        if (!(cellToDelete instanceof org.enhydra.jawe.graph.Participant)) return;
        org.enhydra.jawe.graph.Participant par = (org.enhydra.jawe.graph.Participant)cellToDelete;
        try {
            Participant puo = (Participant)par.getUserObject();
            if (toAdd) {
                puo.graphReferenceAdded();
                return;
            } else {
                puo.graphReferenceRemoved();
            }
            return;
        }
        catch (Exception ex) {
            // empty catch block
        }
    }

    public Object findNearestCell(Object selectedCell, int direction) {
        Set cellSet = JaWEGraphModel.getAllCellsInModel(this.graphModel());
        if (cellSet == null || cellSet.size() == 0) {
            return null;
        }
        Object[] cells = cellSet.toArray();
        if (selectedCell == null) {
            return cells[0];
        }
        Point centerOfSelectedCell = this.getCenter(selectedCell);
        if (centerOfSelectedCell == null) {
            return cells[0];
        }
        Object nearestCell = null;
        double minDistance = Double.MAX_VALUE;
        block5: for (int i = 0; i < cells.length; ++i) {
            if (cells[i] == selectedCell || cells[i] instanceof Port) continue;
            Point centerOfCell = this.getCenter(cells[i]);
            Point ref = new Point(centerOfCell.x, centerOfSelectedCell.y);
            double dist = centerOfSelectedCell.distance(centerOfCell);
            double absOfTan = centerOfCell.distance(ref) / ref.distance(centerOfSelectedCell);
            switch (direction) {
                case 1: {
                    if (centerOfCell.y < centerOfSelectedCell.y || !(dist < minDistance) || !(absOfTan >= 1.0)) continue block5;
                    minDistance = dist;
                    nearestCell = cells[i];
                    continue block5;
                }
                case 2: {
                    if (centerOfCell.x > centerOfSelectedCell.x || !(dist < minDistance) || !(absOfTan <= 1.0)) continue block5;
                    minDistance = dist;
                    nearestCell = cells[i];
                    continue block5;
                }
                case 3: {
                    if (centerOfCell.x < centerOfSelectedCell.x || !(dist < minDistance) || !(absOfTan <= 1.0)) continue block5;
                    minDistance = dist;
                    nearestCell = cells[i];
                    continue block5;
                }
                default: {
                    if (centerOfCell.y > centerOfSelectedCell.y || !(dist < minDistance) || !(absOfTan >= 1.0)) continue block5;
                    minDistance = dist;
                    nearestCell = cells[i];
                }
            }
        }
        return nearestCell;
    }

    public Object findCell(Point p, Map propertyMap) {
        Set cellSet = JaWEGraphModel.getAllCellsInModel(this.graphModel());
        if (cellSet == null || cellSet.size() == 0) {
            return null;
        }
        Object[] cells = cellSet.toArray();
        for (int i = 0; i < cells.length; ++i) {
            Rectangle r = this.getBounds(cells[i], propertyMap).getBounds();
            if (!r.contains(p) || cells[i] instanceof Port) continue;
            return cells[i];
        }
        return null;
    }

    private void arrangeProcesses(Map propertyMap, Rectangle deletedProcessBounds) {
        int deletedOrdNoY;
        int deletedOrdNoX;
        int deletedOrdNo;
        int nextHowMany = JaWEGraphModel.getAllActivitiesInModel(this.graphModel()).size() - 1;
        if (nextHowMany >= (deletedOrdNo = (deletedOrdNoX = (int)Math.round((double)(deletedProcessBounds.x - 50) / ((double)defProcessWidth * 1.5))) + 1 + (deletedOrdNoY = (int)Math.round((double)(deletedProcessBounds.y - 50) / ((double)defProcessHeight * 1.5))) * 3)) {
            for (int i = deletedOrdNo + 1; i <= nextHowMany + 1; ++i) {
                int xon = (i - 1) % 3;
                int yon = (i - 1) / 3;
                Point p = new Point((int)(50.0 + (double)xon * 1.5 * (double)defProcessWidth + (double)(defProcessWidth / 2)), (int)(50.0 + (double)yon * 1.5 * (double)defProcessHeight + (double)(defProcessHeight / 2)));
                Process pr = (Process)this.findCell(p, propertyMap);
                if (pr == null) continue;
                int xo = this.getBounds((Object)pr, (Map)propertyMap).getBounds().x;
                int yo = this.getBounds((Object)pr, (Map)propertyMap).getBounds().y;
                int xn = (int)(50.0 + (double)((i - 2) % 3) * 1.5 * (double)defProcessWidth);
                int yn = (int)(50.0 + (double)((i - 2) / 3) * 1.5 * (double)defProcessHeight);
                Map attrib = GraphConstants.cloneMap((Map)pr.getAttributes());
                Rectangle bounds = (Rectangle)GraphConstants.getBounds((Map)attrib);
                bounds.translate(xn - xo, yn - yo);
                propertyMap.put(pr, attrib);
            }
        }
    }

    public void moveParticipants(Object[] cellsToMove, boolean direction) {
        HashMap propertyMap = new HashMap();
        JaWEParentMap parentMap = new JaWEParentMap();
        if (cellsToMove != null && cellsToMove.length > 0) {
            boolean updated = false;
            for (int i = 0; i < cellsToMove.length; ++i) {
                Rectangle rTarget;
                org.enhydra.jawe.graph.Participant parTarget;
                org.enhydra.jawe.graph.Participant[] parts;
                int yPos;
                if (!(cellsToMove[i] instanceof org.enhydra.jawe.graph.Participant)) continue;
                org.enhydra.jawe.graph.Participant parSource = (org.enhydra.jawe.graph.Participant)cellsToMove[i];
                Rectangle rSource = (Rectangle)this.getBounds(parSource, propertyMap);
                Rectangle matching = new Rectangle(rSource);
                if (direction) {
                    yPos = rSource.y - 1;
                    parts = this.getParticipantsForYPos(yPos, 2, propertyMap, parentMap);
                    if (parts != null && parts.length > 0) {
                        parTarget = parts[0];
                        rTarget = (Rectangle)this.getBounds(parTarget, propertyMap);
                        this.translateParticipant(parSource, propertyMap, parentMap, 0, -rTarget.height);
                        this.translateParticipant(parTarget, propertyMap, parentMap, 0, rSource.height);
                    }
                } else {
                    yPos = rSource.y + rSource.height + 1;
                    parts = this.getParticipantsForYPos(yPos, 2, propertyMap, parentMap);
                    if (parts != null && parts.length > 0) {
                        parTarget = parts[0];
                        rTarget = (Rectangle)this.getBounds(parTarget, propertyMap);
                        this.translateParticipant(parSource, propertyMap, parentMap, 0, rTarget.height);
                        this.translateParticipant(parTarget, propertyMap, parentMap, 0, -rSource.height);
                    }
                }
                Rectangle toMatch = (Rectangle)this.getBounds(parSource, propertyMap);
                this.arrangeParticipants(propertyMap, parentMap);
                if (toMatch.equals(matching)) continue;
                updated = true;
            }
            if (updated) {
                this.graphModel().insertAndEdit(null, propertyMap, null, parentMap, null, "");
            }
        }
    }

    public Dimension getGraphsPreferredSize() {
        return new Dimension(this.getRootParticipantWidth(null, null) + 50, this.getNewRootParYPos(null, null) + 50);
    }
}

