/*
 * Decompiled with CFR 0.152.
 */
package org.enhydra.jawe;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.GraphicsEnvironment;
import java.awt.Point;
import java.awt.Window;
import java.io.File;
import java.lang.reflect.Field;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.Vector;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import java.util.zip.ZipEntry;
import javax.swing.tree.TreeNode;
import org.enhydra.jawe.JaWEConfig;
import org.enhydra.jawe.PFFilter;
import org.enhydra.jawe.ProcessEditor;
import org.enhydra.jawe.WorkflowManager;
import org.enhydra.jawe.graph.Activity;
import org.enhydra.jawe.graph.End;
import org.enhydra.jawe.graph.NoRouting;
import org.enhydra.jawe.graph.Start;
import org.enhydra.jawe.misc.PFLocale;
import org.enhydra.jawe.xml.elements.Activities;
import org.enhydra.jawe.xml.elements.ActivitySet;
import org.enhydra.jawe.xml.elements.ActivitySets;
import org.enhydra.jawe.xml.elements.Package;
import org.enhydra.jawe.xml.elements.Transition;
import org.enhydra.jawe.xml.elements.WorkflowProcess;
import org.enhydra.jawe.xml.elements.WorkflowProcesses;
import org.jgraph.graph.DefaultPort;
import org.jgraph.graph.Edge;
import org.jgraph.graph.GraphConstants;

public class Utils {
    static /* synthetic */ Class class$org$enhydra$jawe$JaWEConfig;
    static /* synthetic */ Class class$org$enhydra$jawe$Utils;

    public static String[] tokenize(String input, String boundary) {
        if (input == null) {
            input = "";
        }
        Vector<String> v = new Vector<String>();
        StringTokenizer t = new StringTokenizer(input, boundary);
        while (t.hasMoreTokens()) {
            v.addElement(t.nextToken());
        }
        String[] cmd = new String[v.size()];
        for (int i = 0; i < cmd.length; ++i) {
            cmd[i] = (String)v.elementAt(i);
        }
        return cmd;
    }

    public static String getUnqualifiedClassName(Class cls) {
        String name = cls.getName();
        int lastDot = name.lastIndexOf(".");
        if (lastDot >= 0) {
            name = name.substring(lastDot + 1, name.length());
        }
        return name;
    }

    public static Set getStartDescriptions(ProcessEditor pe) {
        WorkflowManager workflowManager;
        Set starts;
        HashSet<String> startDescriptions = new HashSet<String>();
        if (pe != null && JaWEConfig.getInstance().getUseBubblesStatus() && (starts = (workflowManager = pe.getGraph().getWorkflowManager()).getStarts()).size() > 0) {
            Iterator it = starts.iterator();
            while (it.hasNext()) {
                Start start = (Start)it.next();
                Set outTransitions = start.getOutgoingTransitions();
                String startDescription = workflowManager.getParticipantID(start) + ";";
                String ID = "-1";
                org.enhydra.jawe.graph.Transition t = null;
                if (outTransitions.size() > 0 && (t = (org.enhydra.jawe.graph.Transition)outTransitions.toArray()[0]) != null) {
                    ID = t.getTargetActivity().get("Id").toString();
                }
                startDescription = startDescription + ID + ";";
                Point pOffset = workflowManager.getOffset(start);
                startDescription = startDescription + String.valueOf(pOffset.x) + ";";
                startDescription = startDescription + String.valueOf(pOffset.y) + ";";
                if (t != null) {
                    boolean isRouted = Utils.isRoutingTransition(t.getAttributes());
                    startDescription = startDescription + (isRouted ? "SIMPLEROUTING" : "NOROUTING");
                }
                startDescriptions.add(startDescription);
            }
        }
        return startDescriptions;
    }

    public static Set getEndDescriptions(ProcessEditor pe) {
        WorkflowManager workflowManager;
        Set ends;
        HashSet<String> endDescriptions = new HashSet<String>();
        if (pe != null && JaWEConfig.getInstance().getUseBubblesStatus() && (ends = (workflowManager = pe.getGraph().getWorkflowManager()).getEnds()).size() > 0) {
            Iterator it = ends.iterator();
            while (it.hasNext()) {
                End end = (End)it.next();
                String endDescription = workflowManager.getParticipantID(end) + ";";
                Set inTransitions = end.getIncomingTransitions();
                String ID = "-1";
                org.enhydra.jawe.graph.Transition t = null;
                if (inTransitions.size() > 0 && (t = (org.enhydra.jawe.graph.Transition)inTransitions.toArray()[0]) != null) {
                    ID = t.getSourceActivity().get("Id").toString();
                }
                endDescription = endDescription + ID + ";";
                Point pOffset = workflowManager.getOffset(end);
                endDescription = endDescription + String.valueOf(pOffset.x) + ";";
                endDescription = endDescription + String.valueOf(pOffset.y) + ";";
                if (t != null) {
                    boolean isRouted = Utils.isRoutingTransition(t.getAttributes());
                    endDescription = endDescription + (isRouted ? "SIMPLEROUTING" : "NOROUTING");
                }
                endDescriptions.add(endDescription);
            }
        }
        return endDescriptions;
    }

    public static Color getColor(String col) {
        Color c = null;
        int dotInd = col.indexOf(".");
        if (col.indexOf("Color") != -1 && dotInd != -1) {
            try {
                ClassLoader cl = (class$org$enhydra$jawe$JaWEConfig == null ? (class$org$enhydra$jawe$JaWEConfig = Utils.class$("org.enhydra.jawe.JaWEConfig")) : class$org$enhydra$jawe$JaWEConfig).getClassLoader();
                Class<?> cls = cl.loadClass("java.awt." + col.substring(0, dotInd));
                Field f = cls.getField(col.substring(dotInd + 1));
                c = (Color)f.get(null);
                c = new Color(c.getRed(), c.getGreen(), c.getBlue());
            }
            catch (Exception ex) {}
        } else {
            try {
                int i1 = col.indexOf("R=");
                if (i1 == -1) {
                    i1 = col.indexOf("r=");
                }
                int i1c = col.indexOf(",", i1 + 2);
                int i2 = col.indexOf("G=");
                if (i2 == -1) {
                    i2 = col.indexOf("g=");
                }
                int i2c = col.indexOf(",", i2 + 2);
                int i3 = col.indexOf("B=");
                if (i3 == -1) {
                    i3 = col.indexOf("b=");
                }
                if (i1 != -1 && i1c != -1 && i2 != -1 && i2c != -1 && i3 != -1 && i1c < i2 && i2c < i3) {
                    int b;
                    int g;
                    int r = Integer.valueOf(col.substring(i1 + 2, i1c).trim());
                    if (r < 0) {
                        r = 0;
                    }
                    if (r > 255) {
                        r = 255;
                    }
                    if ((g = Integer.valueOf(col.substring(i2 + 2, i2c).trim()).intValue()) < 0) {
                        g = 0;
                    }
                    if (g > 255) {
                        g = 255;
                    }
                    if ((b = Integer.valueOf(col.substring(i3 + 2).trim()).intValue()) < 0) {
                        b = 0;
                    }
                    if (b > 255) {
                        b = 255;
                    }
                    c = new Color(r, g, b);
                }
            }
            catch (Exception ex) {
                // empty catch block
            }
        }
        return c;
    }

    public static Set getSplitOrJoinActivities(Set acts, int sOrJ) {
        HashSet<Activity> sOrJactivities = new HashSet<Activity>();
        if (acts == null) {
            return sOrJactivities;
        }
        Iterator it = acts.iterator();
        while (it.hasNext()) {
            Activity act = (Activity)it.next();
            if (act instanceof Start || act instanceof End) continue;
            Iterator iter = sOrJ == 0 ? act.getOutgoingTransitions().iterator() : act.getIncomingTransitions().iterator();
            int noOfTrans = 0;
            while (iter.hasNext()) {
                org.enhydra.jawe.graph.Transition tr = (org.enhydra.jawe.graph.Transition)iter.next();
                Transition t = (Transition)tr.getUserObject();
                if (t == null || t.getFrom() == null || t.getTo() == null) continue;
                ++noOfTrans;
            }
            if (noOfTrans <= true) continue;
            sOrJactivities.add(act);
        }
        return sOrJactivities;
    }

    public static void printStrings(String[] s) {
        if (s != null) {
            for (int i = 0; i < s.length; ++i) {
                System.out.println("String no " + i + " = " + s[i]);
            }
        } else {
            System.out.println("Passed string array is null !!!");
        }
    }

    public static boolean isRoutingTransition(Map attributes) {
        Edge.Routing routing = GraphConstants.getRouting((Map)attributes);
        return routing != null && !(routing instanceof NoRouting);
    }

    public static boolean isCircularTransition(Map attributes) {
        int style = GraphConstants.getLineStyle((Map)attributes);
        return style == 12;
    }

    public static void center(Window w, int minXDiffFromMax, int minYDiffFromMax) {
        w.pack();
        Dimension screenSize = GraphicsEnvironment.getLocalGraphicsEnvironment().getDefaultScreenDevice().getDefaultConfiguration().getBounds().getSize();
        Dimension windowSize = w.getPreferredSize();
        if (windowSize.width > screenSize.width - minXDiffFromMax) {
            windowSize.width = screenSize.width - minXDiffFromMax;
        }
        if (windowSize.height > screenSize.height - minYDiffFromMax) {
            windowSize.height = screenSize.height - minYDiffFromMax;
        }
        w.setSize(windowSize);
        w.setLocation(screenSize.width / 2 - windowSize.width / 2, screenSize.height / 2 - windowSize.height / 2);
    }

    public static List findPropertyFiles() {
        ArrayList<String> pfs = new ArrayList<String>();
        URL u = (class$org$enhydra$jawe$Utils == null ? (class$org$enhydra$jawe$Utils = Utils.class$("org.enhydra.jawe.Utils")) : class$org$enhydra$jawe$Utils).getClassLoader().getResource("org/enhydra/jawe/resources");
        File path = null;
        if (u != null) {
            path = new File(u.getFile());
        }
        if (path != null && path.exists() && path.isDirectory()) {
            pfs.addAll(Arrays.asList(path.list(new PFFilter())));
        } else {
            JarFile jfile = null;
            try {
                String jp = "org/enhydra/jawe/resources/JaWE.properties";
                u = (class$org$enhydra$jawe$Utils == null ? (class$org$enhydra$jawe$Utils = Utils.class$("org.enhydra.jawe.Utils")) : class$org$enhydra$jawe$Utils).getClassLoader().getResource(jp);
                String jarPath = u.getFile().substring(0, u.getFile().length() - jp.length() - 2);
                jarPath = jarPath.substring(5);
                jfile = new JarFile(jarPath, false);
                Enumeration<JarEntry> e = jfile.entries();
                while (e.hasMoreElements()) {
                    try {
                        ZipEntry entry = e.nextElement();
                        String entryname = entry.getName();
                        if (entryname.indexOf("JaWE") == -1 || !entryname.endsWith(".properties")) continue;
                        pfs.add(entryname);
                    }
                    catch (Exception ex) {}
                }
            }
            catch (Exception ex) {
                // empty catch block
            }
        }
        if (pfs.size() == 0) {
            u = (class$org$enhydra$jawe$Utils == null ? (class$org$enhydra$jawe$Utils = Utils.class$("org.enhydra.jawe.Utils")) : class$org$enhydra$jawe$Utils).getClassLoader().getResource("org/enhydra/jawe/resources/JaWE.properties");
            if (u != null) {
                pfs.add("JaWE.properties");
            }
            if ((u = (class$org$enhydra$jawe$Utils == null ? (class$org$enhydra$jawe$Utils = Utils.class$("org.enhydra.jawe.Utils")) : class$org$enhydra$jawe$Utils).getClassLoader().getResource("org/enhydra/jawe/resources/JaWE_de.properties")) != null) {
                pfs.add("JaWE_de.properties");
            }
            if ((u = (class$org$enhydra$jawe$Utils == null ? (class$org$enhydra$jawe$Utils = Utils.class$("org.enhydra.jawe.Utils")) : class$org$enhydra$jawe$Utils).getClassLoader().getResource("org/enhydra/jawe/resources/JaWE_fr.properties")) != null) {
                pfs.add("JaWE_fr.properties");
            }
            if ((u = (class$org$enhydra$jawe$Utils == null ? (class$org$enhydra$jawe$Utils = Utils.class$("org.enhydra.jawe.Utils")) : class$org$enhydra$jawe$Utils).getClassLoader().getResource("org/enhydra/jawe/resources/JaWE_sh.properties")) != null) {
                pfs.add("JaWE_sh.properties");
            }
        }
        ArrayList<PFLocale> pfLocales = new ArrayList<PFLocale>();
        if (pfs.size() > 0) {
            pfLocales.add(new PFLocale());
            for (int i = 0; i < pfs.size(); ++i) {
                PFLocale pfl;
                int p1;
                boolean isDefault;
                String propFile = (String)pfs.get(i);
                boolean bl = isDefault = !propFile.substring(p1 = propFile.indexOf("JaWE") + "JaWE".length(), p1 + 1).equals("_");
                if (isDefault || (pfl = PFLocale.createPFLocale(propFile.substring(p1 + 1, propFile.length() - ".properties".length()))) == null) continue;
                pfLocales.add(pfl);
            }
        }
        return pfLocales;
    }

    public static boolean hasCircularTransitions(Set transitions) {
        Iterator it = transitions.iterator();
        while (it.hasNext()) {
            TreeNode target;
            org.enhydra.jawe.graph.Transition t = (org.enhydra.jawe.graph.Transition)it.next();
            TreeNode source = ((DefaultPort)t.getSource()).getParent();
            if (!source.equals(target = ((DefaultPort)t.getTarget()).getParent())) continue;
            return true;
        }
        return false;
    }

    public static boolean isStartingActivity(Activity act) {
        Set trans = act.getIncomingTransitions();
        return trans.size() == 0 || trans.size() == 1 && Utils.hasCircularTransitions(trans);
    }

    public static boolean isEndingActivity(Activity act) {
        Set trans = act.getNonExceptionalOutgoingTransitions();
        return trans.size() == 0 || trans.size() == 1 && Utils.hasCircularTransitions(trans);
    }

    public static boolean hasConnectedStartBubble(Activity act) {
        Object[] trnsArr;
        Set trans = act.getIncomingTransitions();
        return (trans.size() == 1 || trans.size() == 2) && (((org.enhydra.jawe.graph.Transition)(trnsArr = trans.toArray())[0]).getSourceActivity() instanceof Start || trans.size() == 2 && ((org.enhydra.jawe.graph.Transition)trnsArr[1]).getSourceActivity() instanceof Start);
    }

    public static boolean hasConnectedEndBubble(Activity act) {
        Object[] trnsArr;
        Set trans = act.getNonExceptionalOutgoingTransitions();
        return (trans.size() == 1 || trans.size() == 2) && (((org.enhydra.jawe.graph.Transition)(trnsArr = trans.toArray())[0]).getTargetActivity() instanceof End || trans.size() == 2 && ((org.enhydra.jawe.graph.Transition)trnsArr[1]).getTargetActivity() instanceof End);
    }

    public static void removeBubblesExtAttribs(Package pkg) {
        WorkflowProcesses wprocs = (WorkflowProcesses)pkg.get("WorkflowProcesses");
        Iterator wps = wprocs.toCollection().iterator();
        while (wps.hasNext()) {
            WorkflowProcess wp = (WorkflowProcess)wps.next();
            wp.getEndDescriptions().clear();
            wp.getStartDescriptions().clear();
            Activities activities = (Activities)wp.get("Activities");
            Iterator acts = activities.toCollection().iterator();
            while (acts.hasNext()) {
                org.enhydra.jawe.xml.elements.Activity act = (org.enhydra.jawe.xml.elements.Activity)acts.next();
                act.getEndDescriptions().clear();
                act.getStartDescriptions().clear();
            }
            ActivitySets asets = (ActivitySets)wp.get("ActivitySets");
            Iterator ass = asets.toCollection().iterator();
            while (ass.hasNext()) {
                ActivitySet as = (ActivitySet)ass.next();
                activities = (Activities)wp.get("Activities");
                acts = activities.toCollection().iterator();
                while (acts.hasNext()) {
                    org.enhydra.jawe.xml.elements.Activity act = (org.enhydra.jawe.xml.elements.Activity)acts.next();
                    act.getEndDescriptions().clear();
                    act.getStartDescriptions().clear();
                }
            }
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

