/*
 * Decompiled with CFR 0.152.
 */
package org.enhydra.jawe;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import javax.swing.JMenuBar;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTextPane;
import javax.swing.JTree;
import javax.swing.text.StyledDocument;
import javax.swing.tree.TreePath;
import org.enhydra.jawe.AbstractEditor;
import org.enhydra.jawe.BarFactory;
import org.enhydra.jawe.ResourceManager;
import org.enhydra.jawe.TextTreeModel;
import org.enhydra.jawe.misc.TextTreePanel;
import org.enhydra.jawe.xml.ToNameMutableTreeNode;
import org.enhydra.jawe.xml.XMLElement;
import org.enhydra.jawe.xml.XMLUtil;
import org.enhydra.jawe.xml.panels.XMLPanel;

public class TextPreview
extends XMLPanel {
    private AbstractEditor editor;
    private Component currentPane;
    private JTextPane rightPaneCurrent;
    private JScrollPane scrollPane = new JScrollPane();
    private JMenuBar menuBar;
    TextTreePanel treePanel;

    public TextPreview(AbstractEditor editor) {
        super((XMLElement)editor.getGraph().getXMLPackage(), 2, "", XMLPanel.BOX_LAYOUT, true, false);
        this.rightPaneCurrent = new JTextPane();
        this.rightPaneCurrent.setBackground(Color.lightGray);
        this.rightPaneCurrent.setSize(500, 500);
        this.editor = editor;
        this.treePanel = new TextTreePanel(editor.getGraph().getXMLPackage(), this, ResourceManager.getLanguageDependentString("PackageAndExternalPackagesXPDLKey"));
        this.currentPane = this.createCenterComponent();
        this.add(this.currentPane);
    }

    protected Component createCenterComponent() {
        this.refreshView();
        BarFactory barFactory = new BarFactory(this.editor);
        barFactory.createViewActions(this.rightPaneCurrent);
        this.menuBar = barFactory.createTextViewMenubar("Text_menu");
        JPanel centerPane = new JPanel(new BorderLayout(5, 5));
        JSplitPane splitPane = new JSplitPane(1);
        splitPane.setLeftComponent((Component)((Object)this.treePanel));
        this.scrollPane.setViewportView(this.rightPaneCurrent);
        splitPane.setRightComponent(this.scrollPane);
        splitPane.setDividerLocation(0.3);
        centerPane.add((Component)this.menuBar, "North");
        centerPane.add((Component)splitPane, "Center");
        return centerPane;
    }

    public void refreshView() {
        try {
            ((TextTreeModel)this.treePanel.getTreeModel()).setRoot(this.editor.getGraph().getXMLPackage().getNode());
            XMLUtil.initExpand((JTree)this.treePanel.getTree(), (TreePath)this.treePanel.getTree().getPathForLocation(0, 0));
            XMLElement root = (XMLElement)((ToNameMutableTreeNode)this.treePanel.getTree().getPathForLocation(0, 0).getLastPathComponent()).getUserObject();
            root.setCollapsed(false);
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    public void display(XMLElement element) {
        try {
            this.rightPaneCurrent.setEditable(false);
            this.rightPaneCurrent.setFont(new Font("Verdana", 0, 12));
            StyledDocument doc = this.rightPaneCurrent.getStyledDocument();
            doc.remove(0, doc.getLength());
            this.rightPaneCurrent.setText(element.getPrintDescription(doc));
            this.rightPaneCurrent.setCaretPosition(0);
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    public TextTreePanel getTextTreePanel() {
        return this.treePanel;
    }

    public JMenuBar getMenuBar() {
        return this.menuBar;
    }
}

