/*
 * Decompiled with CFR 0.152.
 */
package org.enhydra.jawe;

import java.io.InputStream;
import java.net.URL;
import java.util.Locale;
import java.util.MissingResourceException;
import java.util.Properties;
import java.util.ResourceBundle;
import org.enhydra.jawe.JaWEConfig;
import org.enhydra.jawe.xml.XMLUtil;

public class ResourceManager {
    private static Locale defaultLocale;
    private static ResourceBundle defaultResourceBoundle;
    private static Locale choosenLocale;
    private static ResourceBundle choosenResourceBundle;
    private static Properties properties;
    static /* synthetic */ Class class$org$enhydra$jawe$ResourceManager;

    public static String getLanguageDependentString(String nm) {
        String str;
        try {
            str = choosenResourceBundle.getString(nm);
        }
        catch (MissingResourceException mre) {
            try {
                str = defaultResourceBoundle.getString(nm);
            }
            catch (MissingResourceException mre1) {
                str = null;
            }
        }
        return str;
    }

    public static String getResourceString(String nm) {
        String str = null;
        try {
            str = properties.getProperty(nm);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return str;
    }

    public static URL getResource(String key) {
        String name = properties.getProperty(key);
        if (name != null) {
            URL url = (class$org$enhydra$jawe$ResourceManager == null ? (class$org$enhydra$jawe$ResourceManager = ResourceManager.class$("org.enhydra.jawe.ResourceManager")) : class$org$enhydra$jawe$ResourceManager).getClassLoader().getResource(name);
            return url;
        }
        return null;
    }

    public static void setDefault() {
        choosenResourceBundle = defaultResourceBoundle;
        choosenLocale = defaultLocale;
        XMLUtil.setChoosenResources((ResourceBundle)choosenResourceBundle);
    }

    public static void setSystem() {
        choosenLocale = Locale.getDefault();
        choosenResourceBundle = ResourceBundle.getBundle("org.enhydra.jawe.resources.JaWE", choosenLocale);
        XMLUtil.setChoosenResources((ResourceBundle)choosenResourceBundle);
    }

    public static ResourceBundle getDefaultResourceBundle() {
        return defaultResourceBoundle;
    }

    public static ResourceBundle getChoosenResourceBundle() {
        return choosenResourceBundle;
    }

    public static Locale getDefaultLocale() {
        return defaultLocale;
    }

    public static Locale getChoosenLocale() {
        return choosenLocale;
    }

    public static void setChoosen(Locale loc) throws MissingResourceException {
        Locale previousLocale = choosenLocale;
        try {
            choosenLocale = loc;
            choosenResourceBundle = ResourceBundle.getBundle("org.enhydra.jawe.resources.JaWE", loc);
            XMLUtil.setChoosenResources((ResourceBundle)choosenResourceBundle);
        }
        catch (Exception ex) {
            choosenLocale = previousLocale;
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    static {
        properties = new Properties();
        try {
            defaultLocale = new Locale("");
            defaultResourceBoundle = ResourceBundle.getBundle("org.enhydra.jawe.resources.JaWE", defaultLocale);
            String startingLocale = JaWEConfig.getInstance().getStartingLocale();
            choosenLocale = startingLocale != null && startingLocale.length() > 0 ? (!startingLocale.equals("default") ? new Locale(startingLocale) : defaultLocale) : Locale.getDefault();
            choosenResourceBundle = !startingLocale.equals("default") ? ResourceBundle.getBundle("org.enhydra.jawe.resources.JaWE", choosenLocale) : defaultResourceBoundle;
        }
        catch (MissingResourceException mre) {
            System.err.println("org.enhydra.jawe.resources.JaWE.properties not found");
            System.exit(1);
        }
        try {
            URL u = (class$org$enhydra$jawe$ResourceManager == null ? (class$org$enhydra$jawe$ResourceManager = ResourceManager.class$("org.enhydra.jawe.ResourceManager")) : class$org$enhydra$jawe$ResourceManager).getClassLoader().getResource("org/enhydra/jawe/resources/JaWE.res");
            InputStream is = (InputStream)u.getContent();
            properties.load(is);
        }
        catch (Exception exception) {
            // empty catch block
        }
        XMLUtil.setDefaultResources((ResourceBundle)defaultResourceBoundle);
        XMLUtil.setChoosenResources((ResourceBundle)choosenResourceBundle);
        XMLUtil.setProperties((Properties)properties);
    }
}

