/*
 * Decompiled with CFR 0.152.
 */
package org.enhydra.jawe;

import java.awt.Rectangle;
import java.awt.Window;
import java.awt.event.MouseEvent;
import java.awt.geom.Rectangle2D;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import java.util.Stack;
import javax.swing.KeyStroke;
import javax.swing.tree.DefaultMutableTreeNode;
import org.enhydra.jawe.AbstractGraph;
import org.enhydra.jawe.JaWE;
import org.enhydra.jawe.JaWEConfig;
import org.enhydra.jawe.JaWEGraphModel;
import org.enhydra.jawe.JaWEMarqueeHandler;
import org.enhydra.jawe.JaWEPortView;
import org.enhydra.jawe.ProcessEditor;
import org.enhydra.jawe.ResourceManager;
import org.enhydra.jawe.Utils;
import org.enhydra.jawe.WorkflowElement;
import org.enhydra.jawe.graph.Activity;
import org.enhydra.jawe.graph.ActivityView;
import org.enhydra.jawe.graph.BlockActivity;
import org.enhydra.jawe.graph.BlockActivityView;
import org.enhydra.jawe.graph.End;
import org.enhydra.jawe.graph.EndView;
import org.enhydra.jawe.graph.Participant;
import org.enhydra.jawe.graph.ParticipantView;
import org.enhydra.jawe.graph.Route;
import org.enhydra.jawe.graph.RouteView;
import org.enhydra.jawe.graph.Start;
import org.enhydra.jawe.graph.StartView;
import org.enhydra.jawe.graph.Subflow;
import org.enhydra.jawe.graph.SubflowView;
import org.enhydra.jawe.graph.Transition;
import org.enhydra.jawe.graph.TransitionView;
import org.enhydra.jawe.xml.PackageValidator;
import org.enhydra.jawe.xml.XMLCollectionElement;
import org.enhydra.jawe.xml.XMLComplexElement;
import org.enhydra.jawe.xml.XMLElement;
import org.enhydra.jawe.xml.XMLUtil;
import org.enhydra.jawe.xml.elements.Package;
import org.enhydra.jawe.xml.elements.WorkflowProcess;
import org.jgraph.JGraph;
import org.jgraph.graph.CellMapper;
import org.jgraph.graph.CellView;
import org.jgraph.graph.DefaultPort;
import org.jgraph.graph.EdgeView;
import org.jgraph.graph.GraphLayoutCache;
import org.jgraph.graph.GraphModel;
import org.jgraph.graph.Port;
import org.jgraph.graph.PortView;
import org.jgraph.graph.VertexView;

public class ProcessGraph
extends AbstractGraph {
    static /* synthetic */ Class class$org$enhydra$jawe$actions$HideWindow;

    public ProcessGraph(GraphModel model, ProcessEditor pe) {
        super(model, pe);
    }

    public ProcessGraph(GraphModel model, GraphLayoutCache view) {
        super(model, view);
    }

    protected void initGraphBehavior() {
        super.initGraphBehavior();
        this.setMoveable(true);
        this.setDisconnectable(true);
        this.setDisconnectOnMove(false);
        this.selectionModel.setSelectionMode(4);
    }

    public Package getXMLPackage() {
        return ((WorkflowProcess)this.xmlObject).getPackage();
    }

    public void setPropertyObject(XMLComplexElement wp) {
        this.xmlObject = wp;
        Package myP = ((WorkflowProcess)this.xmlObject).getPackage();
        if (myP != JaWE.getInstance().getRealXMLPackage()) {
            super.initGraphBehavior();
        }
    }

    public void createWorkflowGraph(Window notInUse) {
        this.workflowManager.createWorkflowGraph((WorkflowProcess)this.xmlObject);
        this.editor.resetUndoManager();
    }

    public String convertValueToString(Object value) {
        if (value instanceof CellView) {
            value = ((CellView)value).getCell();
        }
        if (value instanceof DefaultMutableTreeNode && !(value instanceof Transition) && !(value instanceof Start) && !(value instanceof End) && ((DefaultMutableTreeNode)value).getUserObject() != null) {
            return ((DefaultMutableTreeNode)value).getUserObject().toString();
        }
        if (value != null) {
            return value.toString();
        }
        return null;
    }

    protected VertexView createVertexView(JGraph graph, CellMapper cm, Object cell) {
        if (cell instanceof Participant) {
            return new ParticipantView(cell, this, cm);
        }
        if (cell instanceof Subflow) {
            return new SubflowView(cell, this, cm);
        }
        if (cell instanceof BlockActivity) {
            return new BlockActivityView(cell, this, cm);
        }
        if (cell instanceof Start) {
            return new StartView(cell, this, cm);
        }
        if (cell instanceof End) {
            return new EndView(cell, this, cm);
        }
        if (cell instanceof Route) {
            return new RouteView(cell, this, cm);
        }
        if (cell instanceof Activity) {
            return new ActivityView(cell, this, cm);
        }
        return super.createVertexView(graph, cm, cell);
    }

    protected EdgeView createEdgeView(JGraph graph, CellMapper cm, Object e) {
        if (e instanceof Transition) {
            return new TransitionView(e, this, cm);
        }
        return super.createEdgeView(graph, cm, e);
    }

    protected PortView createPortView(JGraph graph, CellMapper cm, Object o) {
        return new JaWEPortView(o, this, cm);
    }

    public Object getFirstParticipantForLocation(int x, int y) {
        x = (int)((double)x / this.scale);
        y = (int)((double)y / this.scale);
        CellView[] cells = this.getOrderedAllSelectableCells();
        if (cells != null) {
            Rectangle r = new Rectangle(x - this.tolerance, y - this.tolerance, 2 * this.tolerance, 2 * this.tolerance);
            Object first = null;
            for (int i = 0; i < cells.length; ++i) {
                boolean intersects;
                if (!(cells[i] instanceof ParticipantView) || !(intersects = cells[i].getBounds().intersects(r))) continue;
                return cells[i].getCell();
            }
        }
        return null;
    }

    public CellView getNextViewAt(CellView current, double x, double y) {
        CellView[] sel = this.getOrderedAllSelectableCells();
        CellView cell = this.getNextViewAt(sel, current, x, y);
        return cell;
    }

    public CellView getNextViewAt(CellView[] cells, CellView c, double x, double y) {
        if (cells != null) {
            Rectangle r = new Rectangle((int)x - this.tolerance, (int)y - this.tolerance, 2 * this.tolerance, 2 * this.tolerance);
            CellView first = null;
            boolean active = c == null;
            for (int i = 0; i < cells.length; ++i) {
                boolean intersects = false;
                boolean wholeArea = true;
                if (((JaWEMarqueeHandler)this.marquee).getSelectButton().isSelected() || ((JaWEMarqueeHandler)this.marquee).getTransitionButton().isSelected() || ((JaWEMarqueeHandler)this.marquee).getSelfRoutedTransitionButton().isSelected() || ((JaWEMarqueeHandler)this.marquee).getCircularTransitionButton().isSelected()) {
                    wholeArea = false;
                }
                if (!(intersects = cells[i] instanceof ParticipantView && wholeArea ? cells[i].getBounds().intersects(r) : cells[i].intersects(this.getGraphics(), (Rectangle2D)r))) continue;
                if (active) {
                    return cells[i];
                }
                if (first == null) {
                    first = cells[i];
                }
                active |= cells[i] == c;
            }
            return first;
        }
        return null;
    }

    private CellView[] getOrderedAllSelectableCells() {
        CellView[] views = this.graphLayoutCache.getRoots();
        Stack<CellView> s = new Stack<CellView>();
        for (int i = 0; i < views.length; ++i) {
            s.add(views[i]);
        }
        ArrayList<CellView> result = new ArrayList<CellView>();
        while (!s.isEmpty()) {
            CellView view = (CellView)s.pop();
            Object cell = view.getCell();
            if (!(cell instanceof Port)) {
                result.add(view);
            }
            CellView[] children = view.getChildViews();
            for (int i = 0; i < children.length; ++i) {
                s.add(children[i]);
            }
        }
        ArrayList<CellView> activitiesAndEdges = new ArrayList<CellView>();
        ArrayList<CellView> participants = new ArrayList<CellView>();
        Iterator it = result.iterator();
        while (it.hasNext()) {
            CellView cv = (CellView)it.next();
            if (cv.getCell() instanceof Participant) {
                participants.add(cv);
                continue;
            }
            activitiesAndEdges.add(cv);
        }
        int i = -1;
        int j = participants.size() + activitiesAndEdges.size();
        CellView[] tmp = new CellView[j];
        it = activitiesAndEdges.iterator();
        while (it.hasNext()) {
            tmp[++i] = (CellView)it.next();
        }
        it = participants.iterator();
        while (it.hasNext()) {
            tmp[--j] = (CellView)it.next();
        }
        return tmp;
    }

    public void printOrderedAllSelectables() {
        CellView[] sel = this.getOrderedAllSelectableCells();
        for (int i = 0; i < sel.length; ++i) {
            System.out.println("view" + i + "=" + sel[i].getCell());
        }
    }

    public String getToolTipText(MouseEvent event) {
        Object cell;
        if (event != null && (cell = !((JaWEMarqueeHandler)this.marquee).getSelectButton().isSelected() && !((JaWEMarqueeHandler)this.marquee).getTransitionButton().isSelected() && !((JaWEMarqueeHandler)this.marquee).getSelfRoutedTransitionButton().isSelected() || ((JaWEMarqueeHandler)this.marquee).getCircularTransitionButton().isSelected() ? this.getFirstParticipantForLocation(event.getX(), event.getY()) : this.getFirstCellForLocation(event.getX(), event.getY())) != null) {
            String s = this.convertValueToString(cell);
            if (cell instanceof WorkflowElement) {
                s = ((WorkflowElement)cell).getTooltip();
            }
            return s;
        }
        return null;
    }

    public void setAdditionalKeyboardShortcuts() {
        super.setAdditionalKeyboardShortcuts();
        this.getInputMap(2).put(KeyStroke.getKeyStroke(8, 512, false), Utils.getUnqualifiedClassName(class$org$enhydra$jawe$actions$HideWindow == null ? (class$org$enhydra$jawe$actions$HideWindow = ProcessGraph.class$("org.enhydra.jawe.actions.HideWindow")) : class$org$enhydra$jawe$actions$HideWindow));
        this.getActionMap().put(Utils.getUnqualifiedClassName(class$org$enhydra$jawe$actions$HideWindow == null ? (class$org$enhydra$jawe$actions$HideWindow = ProcessGraph.class$("org.enhydra.jawe.actions.HideWindow")) : class$org$enhydra$jawe$actions$HideWindow), this.editor.getAction(Utils.getUnqualifiedClassName(class$org$enhydra$jawe$actions$HideWindow == null ? (class$org$enhydra$jawe$actions$HideWindow = ProcessGraph.class$("org.enhydra.jawe.actions.HideWindow")) : class$org$enhydra$jawe$actions$HideWindow)));
    }

    public boolean validateAgainsXPDLSchema() {
        return true;
    }

    public boolean checkConnections(boolean fullCheck) {
        this.updateXMLObjectsBeforeChecking();
        PackageValidator pv = new PackageValidator(this.getXMLPackage(), true, true, false, false, JaWEConfig.getInstance().getAllowUndefinedStartActivity(), JaWEConfig.getInstance().getAllowUndefinedEndActivity(), JaWEConfig.getInstance().getEncoding());
        XMLCollectionElement wpOrAs = (XMLCollectionElement)this.getXPDLObject();
        boolean isGraphWellConnected = pv.checkGraphConnections(wpOrAs, fullCheck);
        this.basicGraphConnectionError = pv.getBasicGraphConnectionError((XMLComplexElement)wpOrAs);
        this.graphConnectionErrors = pv.getGraphsConnectionErrors((XMLComplexElement)wpOrAs);
        if (JaWEConfig.getInstance().getUseBubblesStatus() && (fullCheck || isGraphWellConnected)) {
            isGraphWellConnected = this.checkStartAndEndsConnections(fullCheck) && isGraphWellConnected;
        }
        return isGraphWellConnected;
    }

    protected boolean checkStartAndEndsConnections(boolean fullCheck) {
        Set icEnds;
        Set icStarts;
        boolean wellConnected = true;
        WorkflowProcess wp = (WorkflowProcess)this.getPropertyObject();
        if (this.graphConformanceErrors == null) {
            this.graphConformanceErrors = new HashMap();
        }
        if ((icStarts = this.getImproperlyConnectedStarts(fullCheck)).size() > 0) {
            wellConnected = false;
            this.basicGraphConnectionError = ResourceManager.getLanguageDependentString("InformationOneOrMoreElementsAreNotProperlyConnected");
            if (fullCheck) {
                Iterator i = icStarts.iterator();
                while (i.hasNext()) {
                    Activity s = (Activity)i.next();
                    if (s instanceof Start) {
                        this.graphConnectionErrors.put(s, ResourceManager.getLanguageDependentString("ErrorConnectionToStartingActivityIsMissing") + "; ");
                        continue;
                    }
                    String msg = (String)this.graphConnectionErrors.get(s.getPropertyObject());
                    msg = PackageValidator.prepareMessageString((String)msg);
                    msg = msg + ResourceManager.getLanguageDependentString("ErrorIncomingTransitionOrConnectionFromStartBubbleIsMissing");
                    this.graphConnectionErrors.put(s.getPropertyObject(), msg);
                }
            }
        }
        if ((fullCheck || wellConnected) && (icEnds = this.getImproperlyConnectedEnds(fullCheck)).size() > 0) {
            wellConnected = false;
            this.basicGraphConnectionError = ResourceManager.getLanguageDependentString("InformationOneOrMoreElementsAreNotProperlyConnected");
            if (fullCheck) {
                Iterator i = icEnds.iterator();
                while (i.hasNext()) {
                    Activity e = (Activity)i.next();
                    if (e instanceof End) {
                        if (e.getIncomingTransitions().size() == 0) {
                            this.graphConnectionErrors.put(e, ResourceManager.getLanguageDependentString("ErrorConnectionFromEndingActivityIsMissing") + "; ");
                            continue;
                        }
                        this.graphConnectionErrors.put(e, ResourceManager.getLanguageDependentString("ErrorNotConnectedToEndingActivity") + "; ");
                        continue;
                    }
                    String msg = (String)this.graphConnectionErrors.get(e.getPropertyObject());
                    msg = PackageValidator.prepareMessageString((String)msg);
                    msg = msg + ResourceManager.getLanguageDependentString("ErrorOutgoingTransitionOrConnectionToEndBubbleIsMissing");
                    this.graphConnectionErrors.put(e.getPropertyObject(), msg);
                }
            }
        }
        if (fullCheck || wellConnected) {
            Set blockActs = this.workflowManager.getBlockActivities(true);
            Iterator itBas = blockActs.iterator();
            while (itBas.hasNext()) {
                ProcessGraph bag;
                BlockActivity ba = (BlockActivity)itBas.next();
                ProcessEditor bwe = ba.getImplementationEditor();
                if (bwe == null || (bag = (ProcessGraph)bwe.getGraph()).getImproperlyConnectedStarts(false).size() <= 0 && bag.getImproperlyConnectedEnds(false).size() <= 0) continue;
                wellConnected = false;
                this.basicGraphConnectionError = ResourceManager.getLanguageDependentString("InformationOneOrMoreElementsAreNotProperlyConnected");
                if (!fullCheck) break;
                String m = ResourceManager.getLanguageDependentString("ErrorInnerTransitionError");
                String msg = (String)this.graphConnectionErrors.get(ba.getUserObject());
                msg = PackageValidator.prepareMessageString((String)msg);
                msg = msg + m;
                this.graphConnectionErrors.put(ba.getUserObject(), msg);
            }
        }
        return wellConnected;
    }

    public Set getImproperlyConnectedStarts(boolean fullCheck) {
        HashSet<Activity> icStarts = new HashSet<Activity>();
        JaWEGraphModel cfr_ignored_0 = (JaWEGraphModel)this.graphModel;
        Set allActivities = JaWEGraphModel.getAllActivitiesInModel(this.graphModel);
        if (allActivities != null) {
            Iterator it = allActivities.iterator();
            while (it.hasNext()) {
                Activity act = (Activity)it.next();
                if (act instanceof Start) {
                    if (act.getOutgoingTransitions().size() != 0) continue;
                    icStarts.add(act);
                    if (fullCheck) continue;
                    break;
                }
                if (act instanceof End) continue;
                Set incomingTrans = act.getIncomingTransitions();
                if (incomingTrans.size() == 0) {
                    icStarts.add(act);
                    if (fullCheck) continue;
                    break;
                }
                if (incomingTrans.size() != 1 || !Utils.hasCircularTransitions(incomingTrans)) continue;
                icStarts.add(act);
                if (fullCheck) continue;
                break;
            }
        }
        return icStarts;
    }

    public Set getImproperlyConnectedEnds(boolean fullCheck) {
        HashSet<Activity> icEnds = new HashSet<Activity>();
        JaWEGraphModel cfr_ignored_0 = (JaWEGraphModel)this.graphModel;
        Set allActivities = JaWEGraphModel.getAllActivitiesInModel(this.graphModel);
        if (allActivities != null) {
            Iterator it = allActivities.iterator();
            while (it.hasNext()) {
                Activity act = (Activity)it.next();
                if (act instanceof End) {
                    Set incT = act.getIncomingTransitions();
                    if (incT.size() == 0) {
                        icEnds.add(act);
                        if (fullCheck) continue;
                        break;
                    }
                    if (incT.size() != 1) continue;
                    Transition t = (Transition)incT.toArray()[0];
                    Activity a = (Activity)((Object)((DefaultPort)t.getSource()).getParent());
                    Set eas = XMLUtil.getEndingActivities((XMLCollectionElement)((XMLCollectionElement)this.getXPDLObject()));
                    if (eas.contains(a.getPropertyObject())) continue;
                    icEnds.add(act);
                    if (fullCheck) continue;
                    break;
                }
                if (act instanceof Start) continue;
                Set outgoingTrans = act.getNonExceptionalOutgoingTransitions();
                if (outgoingTrans.size() == 0) {
                    icEnds.add(act);
                    if (!fullCheck) break;
                }
                if (outgoingTrans.size() != 1 || !Utils.hasCircularTransitions(outgoingTrans)) continue;
                icEnds.add(act);
                if (fullCheck) continue;
                break;
            }
        }
        return icEnds;
    }

    protected void updateXMLObjectsBeforeChecking() {
        WorkflowProcess wp = (WorkflowProcess)this.getPropertyObject();
        wp.setStartDescriptions(Utils.getStartDescriptions((ProcessEditor)this.editor));
        wp.setEndDescriptions(Utils.getEndDescriptions((ProcessEditor)this.editor));
        Set blockActs = this.workflowManager.getBlockActivities(true);
        Iterator itBas = blockActs.iterator();
        while (itBas.hasNext()) {
            BlockActivity ba = (BlockActivity)itBas.next();
            ProcessEditor bwe = ba.getImplementationEditor();
            org.enhydra.jawe.xml.elements.Activity bap = (org.enhydra.jawe.xml.elements.Activity)ba.getUserObject();
            bap.setStartDescriptions(Utils.getStartDescriptions(bwe));
            bap.setEndDescriptions(Utils.getEndDescriptions(bwe));
        }
    }

    public boolean checkGraphConformance(boolean fullCheck) {
        PackageValidator pv = new PackageValidator(this.getXMLPackage(), true, true, false, false, JaWEConfig.getInstance().getAllowUndefinedStartActivity(), JaWEConfig.getInstance().getAllowUndefinedEndActivity(), JaWEConfig.getInstance().getEncoding());
        XMLCollectionElement wpOrAs = (XMLCollectionElement)this.getXPDLObject();
        boolean areGraphsConformant = pv.checkGraphConformance(wpOrAs, fullCheck);
        this.basicGraphConformanceErrors = pv.getBasicGraphConformanceErrors((XMLComplexElement)wpOrAs);
        this.graphConformanceErrors = pv.getGraphConformanceErrors((XMLComplexElement)wpOrAs);
        return areGraphsConformant;
    }

    public boolean checkLogic(boolean fullCheck) {
        PackageValidator pv = new PackageValidator(this.getXMLPackage(), true, true, false, false, JaWEConfig.getInstance().getAllowUndefinedStartActivity(), JaWEConfig.getInstance().getAllowUndefinedEndActivity(), JaWEConfig.getInstance().getEncoding());
        boolean isLogical = pv.checkWorkflowProcess((WorkflowProcess)this.getXPDLObject(), fullCheck);
        this.basicLogicError = pv.getBasicLogicError((XMLComplexElement)((WorkflowProcess)this.getXPDLObject()));
        this.logicErrors = pv.getLogicErrors((XMLComplexElement)((WorkflowProcess)this.getXPDLObject()));
        return isLogical;
    }

    public void xmlElementChanged(XMLElement el) {
        if (el instanceof org.enhydra.jawe.xml.elements.Activity) {
            this.editor.getStatusBar().updateMessage();
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

