/*
 * Decompiled with CFR 0.152.
 */
package org.enhydra.jawe;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Frame;
import java.awt.Window;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.Iterator;
import javax.swing.Action;
import javax.swing.JDialog;
import javax.swing.JFrame;
import org.enhydra.jawe.AbstractEditor;
import org.enhydra.jawe.AbstractGraph;
import org.enhydra.jawe.JaWE;
import org.enhydra.jawe.JaWEGraphModel;
import org.enhydra.jawe.ProcessGraph;
import org.enhydra.jawe.ResourceManager;
import org.enhydra.jawe.Utils;
import org.enhydra.jawe.WorkflowElement;
import org.enhydra.jawe.actions.ActivitiesOverview;
import org.enhydra.jawe.actions.ActivitySetsOverview;
import org.enhydra.jawe.actions.ActualSize;
import org.enhydra.jawe.actions.AddPoint;
import org.enhydra.jawe.actions.Applications;
import org.enhydra.jawe.actions.CheckValidity;
import org.enhydra.jawe.actions.Copy;
import org.enhydra.jawe.actions.Cut;
import org.enhydra.jawe.actions.Delete;
import org.enhydra.jawe.actions.EditCell;
import org.enhydra.jawe.actions.EditProperties;
import org.enhydra.jawe.actions.FormalParameters;
import org.enhydra.jawe.actions.HideWindow;
import org.enhydra.jawe.actions.MoveDownParticipant;
import org.enhydra.jawe.actions.MoveUpParticipant;
import org.enhydra.jawe.actions.Participants;
import org.enhydra.jawe.actions.Paste;
import org.enhydra.jawe.actions.PasteAt;
import org.enhydra.jawe.actions.ProcessProperties;
import org.enhydra.jawe.actions.ReferredDocument;
import org.enhydra.jawe.actions.RemovePoint;
import org.enhydra.jawe.actions.SaveAsJPG;
import org.enhydra.jawe.actions.SaveAsSVG;
import org.enhydra.jawe.actions.SetNoRouting;
import org.enhydra.jawe.actions.SetSelfRouting;
import org.enhydra.jawe.actions.ShowOverview;
import org.enhydra.jawe.actions.TransitionsOverview;
import org.enhydra.jawe.actions.WorkflowRelevantData;
import org.enhydra.jawe.actions.ZoomIn;
import org.enhydra.jawe.actions.ZoomOut;
import org.enhydra.jawe.graph.Activity;
import org.enhydra.jawe.graph.BlockActivity;
import org.enhydra.jawe.graph.End;
import org.enhydra.jawe.graph.Start;
import org.enhydra.jawe.graph.Subflow;
import org.enhydra.jawe.xml.XMLComplexElement;
import org.enhydra.jawe.xml.XMLElementDialog;
import org.enhydra.jawe.xml.elements.WorkflowProcess;
import org.jgraph.event.GraphSelectionEvent;
import org.jgraph.graph.GraphModel;

public class ProcessEditor
extends AbstractEditor {
    protected XMLElementDialog elementEditingDialog = null;
    static /* synthetic */ Class class$org$enhydra$jawe$actions$EditCell;
    static /* synthetic */ Class class$org$enhydra$jawe$actions$EditProperties;
    static /* synthetic */ Class class$org$enhydra$jawe$actions$Cut;
    static /* synthetic */ Class class$org$enhydra$jawe$actions$Copy;
    static /* synthetic */ Class class$org$enhydra$jawe$actions$Delete;
    static /* synthetic */ Class class$org$enhydra$jawe$actions$Paste;
    static /* synthetic */ Class class$org$enhydra$jawe$actions$PasteAt;
    static /* synthetic */ Class class$org$enhydra$jawe$actions$AddPoint;
    static /* synthetic */ Class class$org$enhydra$jawe$actions$RemovePoint;
    static /* synthetic */ Class class$org$enhydra$jawe$actions$SetNoRouting;
    static /* synthetic */ Class class$org$enhydra$jawe$actions$SetSelfRouting;
    static /* synthetic */ Class class$org$enhydra$jawe$actions$HideWindow;

    public XMLElementDialog getElementEditingDialog() {
        if (this.elementEditingDialog == null || !this.elementEditingDialog.isShowing()) {
            this.elementEditingDialog = new XMLElementDialog((JDialog)this.getWindow(), "", false);
            this.setALTCursorKeyboardShortcuts(this.elementEditingDialog.getRootPane());
        }
        return this.elementEditingDialog;
    }

    public ProcessEditor(Window dialogOrFrame, WorkflowProcess wp, AbstractEditor parentEditor) {
        super((XMLComplexElement)wp);
        this.parentEditor = parentEditor;
        JDialog dialog = dialogOrFrame instanceof JDialog ? new JDialog((Dialog)((JDialog)dialogOrFrame), true) : new JDialog((Frame)((JFrame)dialogOrFrame), true);
        dialog.setDefaultCloseOperation(0);
        dialog.setBackground(Color.lightGray);
        dialog.getContentPane().setLayout(new BorderLayout());
        dialog.addWindowListener(this.createAppCloser());
        dialog.getContentPane().add("Center", this);
        dialog.pack();
        this.setBounds(dialog, dialogOrFrame);
    }

    protected AbstractGraph createGraph() {
        JaWEGraphModel model = new JaWEGraphModel();
        this.graph = new ProcessGraph((GraphModel)model, this);
        return this.graph;
    }

    protected void createActions() {
        this.defaultActions = new Action[]{new CheckValidity(this), new ProcessProperties(this), new Participants(this), new Applications(this), new WorkflowRelevantData(this), new FormalParameters(this), new ActivitySetsOverview(this), new ActivitiesOverview(this), new TransitionsOverview(this), new SaveAsJPG(this), new SaveAsSVG(this), this.undoAction, this.redoAction, new Cut(this), new Copy(this), new Paste(this), new PasteAt(this), new Delete(this), new EditCell(this), new EditProperties(this), new AddPoint(this), new RemovePoint(this), new SetSelfRouting(this), new SetNoRouting(this), new ActualSize(this), new ZoomIn(this), new ZoomOut(this), new ShowOverview(this), new MoveDownParticipant(this), new MoveUpParticipant(this), new HideWindow(this), new ReferredDocument(this)};
    }

    public void valueChanged(GraphSelectionEvent e) {
        boolean enabled = !this.graph.isSelectionEmpty();
        try {
            Subflow sbflw;
            WorkflowProcess wp;
            Object cell = this.graph.getSelectionCell();
            boolean enableEdit = true;
            if (cell instanceof Subflow && cell instanceof Subflow && (wp = (sbflw = (Subflow)cell).getReferencedWorkflowProcess(this.graph.getXMLPackage())) == null) {
                enableEdit = false;
            }
            this.getAction(Utils.getUnqualifiedClassName(class$org$enhydra$jawe$actions$EditCell == null ? (class$org$enhydra$jawe$actions$EditCell = ProcessEditor.class$("org.enhydra.jawe.actions.EditCell")) : class$org$enhydra$jawe$actions$EditCell)).setEnabled(enabled && (cell instanceof Subflow && enableEdit || cell instanceof BlockActivity));
            this.getAction(Utils.getUnqualifiedClassName(class$org$enhydra$jawe$actions$EditProperties == null ? (class$org$enhydra$jawe$actions$EditProperties = ProcessEditor.class$("org.enhydra.jawe.actions.EditProperties")) : class$org$enhydra$jawe$actions$EditProperties)).setEnabled(enabled);
            this.getAction("ReferredDocument").setEnabled(enabled && cell instanceof Activity && !(cell instanceof Start) && !(cell instanceof End));
            if (this.graph.getXMLPackage() == JaWE.getInstance().getRealXMLPackage() && !this.graph.getXMLPackage().isReadOnly()) {
                this.getAction(Utils.getUnqualifiedClassName(class$org$enhydra$jawe$actions$Cut == null ? (class$org$enhydra$jawe$actions$Cut = ProcessEditor.class$("org.enhydra.jawe.actions.Cut")) : class$org$enhydra$jawe$actions$Cut)).setEnabled(enabled);
                this.getAction(Utils.getUnqualifiedClassName(class$org$enhydra$jawe$actions$Copy == null ? (class$org$enhydra$jawe$actions$Copy = ProcessEditor.class$("org.enhydra.jawe.actions.Copy")) : class$org$enhydra$jawe$actions$Copy)).setEnabled(enabled);
                this.getAction(Utils.getUnqualifiedClassName(class$org$enhydra$jawe$actions$Delete == null ? (class$org$enhydra$jawe$actions$Delete = ProcessEditor.class$("org.enhydra.jawe.actions.Delete")) : class$org$enhydra$jawe$actions$Delete)).setEnabled(enabled);
            }
            if (enabled && cell != null && !(cell instanceof Start) && !(cell instanceof End) && this.elementEditingDialog != null && this.elementEditingDialog.isShowing() && this.elementEditingDialog.getEditingPanel().getOwner() != ((WorkflowElement)cell).getPropertyObject()) {
                this.getAction(Utils.getUnqualifiedClassName(class$org$enhydra$jawe$actions$EditProperties == null ? (class$org$enhydra$jawe$actions$EditProperties = ProcessEditor.class$("org.enhydra.jawe.actions.EditProperties")) : class$org$enhydra$jawe$actions$EditProperties)).actionPerformed(null);
            }
            if (this.elementEditingDialog != null && this.elementEditingDialog.isShowing()) {
                this.elementEditingDialog.requestFocus();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.update();
    }

    public void setButtonsEnabled(boolean enable) {
        try {
            Iterator iter = this.specialButtons.values().iterator();
            while (iter.hasNext()) {
                Object item = iter.next();
                ((Component)item).setEnabled(enable);
            }
            this.undoAction.setEnabled(enable);
            this.redoAction.setEnabled(enable);
            this.getAction(Utils.getUnqualifiedClassName(class$org$enhydra$jawe$actions$Cut == null ? (class$org$enhydra$jawe$actions$Cut = ProcessEditor.class$("org.enhydra.jawe.actions.Cut")) : class$org$enhydra$jawe$actions$Cut)).setEnabled(enable);
            this.getAction(Utils.getUnqualifiedClassName(class$org$enhydra$jawe$actions$Copy == null ? (class$org$enhydra$jawe$actions$Copy = ProcessEditor.class$("org.enhydra.jawe.actions.Copy")) : class$org$enhydra$jawe$actions$Copy)).setEnabled(enable);
            this.getAction(Utils.getUnqualifiedClassName(class$org$enhydra$jawe$actions$Paste == null ? (class$org$enhydra$jawe$actions$Paste = ProcessEditor.class$("org.enhydra.jawe.actions.Paste")) : class$org$enhydra$jawe$actions$Paste)).setEnabled(enable);
            this.getAction(Utils.getUnqualifiedClassName(class$org$enhydra$jawe$actions$PasteAt == null ? (class$org$enhydra$jawe$actions$PasteAt = ProcessEditor.class$("org.enhydra.jawe.actions.PasteAt")) : class$org$enhydra$jawe$actions$PasteAt)).setEnabled(enable);
            this.getAction(Utils.getUnqualifiedClassName(class$org$enhydra$jawe$actions$Delete == null ? (class$org$enhydra$jawe$actions$Delete = ProcessEditor.class$("org.enhydra.jawe.actions.Delete")) : class$org$enhydra$jawe$actions$Delete)).setEnabled(enable);
            this.getAction(Utils.getUnqualifiedClassName(class$org$enhydra$jawe$actions$AddPoint == null ? (class$org$enhydra$jawe$actions$AddPoint = ProcessEditor.class$("org.enhydra.jawe.actions.AddPoint")) : class$org$enhydra$jawe$actions$AddPoint)).setEnabled(enable);
            this.getAction(Utils.getUnqualifiedClassName(class$org$enhydra$jawe$actions$RemovePoint == null ? (class$org$enhydra$jawe$actions$RemovePoint = ProcessEditor.class$("org.enhydra.jawe.actions.RemovePoint")) : class$org$enhydra$jawe$actions$RemovePoint)).setEnabled(enable);
            this.getAction(Utils.getUnqualifiedClassName(class$org$enhydra$jawe$actions$SetNoRouting == null ? (class$org$enhydra$jawe$actions$SetNoRouting = ProcessEditor.class$("org.enhydra.jawe.actions.SetNoRouting")) : class$org$enhydra$jawe$actions$SetNoRouting)).setEnabled(enable);
            this.getAction(Utils.getUnqualifiedClassName(class$org$enhydra$jawe$actions$SetSelfRouting == null ? (class$org$enhydra$jawe$actions$SetSelfRouting = ProcessEditor.class$("org.enhydra.jawe.actions.SetSelfRouting")) : class$org$enhydra$jawe$actions$SetSelfRouting)).setEnabled(enable);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    protected WindowAdapter createAppCloser() {
        return new AppCloser();
    }

    public String getTitle() {
        String title = ResourceManager.getLanguageDependentString("ProcessKey") + " - '" + this.graph.getPropertyObject().toString() + "'";
        return title;
    }

    public String toolbarToLoad() {
        return "processToolbars";
    }

    public String menubarToLoad() {
        return "processMenubar";
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    protected final class AppCloser
    extends WindowAdapter {
        protected AppCloser() {
        }

        public void windowClosing(WindowEvent e) {
            ProcessEditor.this.getAction(Utils.getUnqualifiedClassName(class$org$enhydra$jawe$actions$HideWindow == null ? (class$org$enhydra$jawe$actions$HideWindow = ProcessEditor.class$("org.enhydra.jawe.actions.HideWindow")) : class$org$enhydra$jawe$actions$HideWindow)).actionPerformed(null);
        }
    }
}

