/*
 * Decompiled with CFR 0.152.
 */
package org.enhydra.jawe;

import java.awt.Point;
import java.awt.Window;
import java.awt.event.MouseEvent;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Set;
import javax.swing.tree.DefaultMutableTreeNode;
import org.enhydra.jawe.AbstractGraph;
import org.enhydra.jawe.JaWEConfig;
import org.enhydra.jawe.JaWEGraphModel;
import org.enhydra.jawe.PackageEditor;
import org.enhydra.jawe.ProcessEditor;
import org.enhydra.jawe.ProcessGraph;
import org.enhydra.jawe.ResourceManager;
import org.enhydra.jawe.Utils;
import org.enhydra.jawe.WorkflowElement;
import org.enhydra.jawe.actions.Save;
import org.enhydra.jawe.graph.BlockActivity;
import org.enhydra.jawe.graph.Process;
import org.enhydra.jawe.graph.ProcessView;
import org.enhydra.jawe.xml.PackageValidator;
import org.enhydra.jawe.xml.XMLComplexElement;
import org.enhydra.jawe.xml.XMLElement;
import org.enhydra.jawe.xml.elements.Activity;
import org.enhydra.jawe.xml.elements.Package;
import org.enhydra.jawe.xml.elements.WorkflowProcess;
import org.enhydra.jawe.xml.elements.WorkflowProcesses;
import org.jgraph.JGraph;
import org.jgraph.graph.CellMapper;
import org.jgraph.graph.CellView;
import org.jgraph.graph.GraphLayoutCache;
import org.jgraph.graph.GraphModel;
import org.jgraph.graph.VertexView;

public class PackageGraph
extends AbstractGraph {
    private static final int processWidth = JaWEConfig.getInstance().getProcessWidth();
    private static final int processHeight = JaWEConfig.getInstance().getProcessHeight();

    public PackageGraph(GraphModel model, PackageEditor pe) {
        super(model, pe);
    }

    public PackageGraph(GraphModel model, GraphLayoutCache view) {
        super(model, view);
    }

    public Package getXMLPackage() {
        return (Package)this.xmlObject;
    }

    public void setPropertyObject(XMLComplexElement ce) {
        this.xmlObject = ce;
    }

    public Point getNextInsertionPoint() {
        int hmp;
        try {
            hmp = JaWEGraphModel.getAllActivitiesInModel(this.graphModel).size();
        }
        catch (Exception ex) {
            hmp = 0;
        }
        return new Point((int)(50.0 + (double)processWidth * 1.5 * (double)(hmp % 3)), (int)(50.0 + (double)processHeight * 1.5 * (double)(hmp / 3)));
    }

    public void createWorkflowGraph(Window pFrame) {
        Package p = (Package)this.xmlObject;
        WorkflowProcesses wps = (WorkflowProcesses)p.get("WorkflowProcesses");
        Iterator it = wps.toCollection().iterator();
        while (it.hasNext()) {
            WorkflowProcess wp = (WorkflowProcess)it.next();
            this.createWorkflowObject(pFrame, wp);
            wps.decrementID();
        }
    }

    public void createWorkflowObject(Window pFrame, WorkflowProcess wp) {
        Process pr = this.workflowManager.insertProcess(this.getNextInsertionPoint(), false);
        pr.setUserObject(wp);
        pr.createWorkflowGraph(pFrame);
        this.paintImmediately(this.getBounds());
        ((PackageEditor)this.editor).putProcessObjectMapping(wp, pr);
    }

    public String getTooltip() {
        return "";
    }

    protected VertexView createVertexView(JGraph graph, CellMapper cm, Object cell) {
        if (cell instanceof Process) {
            return new ProcessView(cell, this, cm);
        }
        return super.createVertexView(graph, cm, cell);
    }

    public String convertValueToString(Object value) {
        if (value instanceof CellView) {
            value = ((CellView)value).getCell();
        }
        if (value instanceof Process && ((DefaultMutableTreeNode)value).getUserObject() != null) {
            return ((DefaultMutableTreeNode)value).getUserObject().toString();
        }
        if (value != null) {
            return value.toString();
        }
        return null;
    }

    public String getToolTipText(MouseEvent event) {
        Object cell;
        if (event != null && (cell = this.getFirstCellForLocation(event.getX(), event.getY())) != null) {
            String s = this.convertValueToString(cell);
            if (cell instanceof WorkflowElement) {
                s = ((WorkflowElement)cell).getTooltip();
            }
            return s;
        }
        return null;
    }

    public boolean validateAgainsXPDLSchema() {
        Save.updateExtendedAttributesForWorkflowProcesses();
        PackageValidator pv = new PackageValidator(this.getXMLPackage(), true, true, false, true, JaWEConfig.getInstance().getAllowUndefinedStartActivity(), JaWEConfig.getInstance().getAllowUndefinedEndActivity(), JaWEConfig.getInstance().getEncoding());
        boolean isValid = pv.validateAgainstXPDLSchema();
        this.xpdlSchemaValidationErrors = pv.getXPDLSchemaValidationErrors();
        this.basicXpdlSchemaValidationError = !isValid && this.xpdlSchemaValidationErrors.size() > 0 ? ResourceManager.getLanguageDependentString("MessageThereAreSomeSchemaValidationErrors") : null;
        return isValid;
    }

    public boolean checkConnections(boolean fullCheck) {
        this.updateXMLObjectsBeforeChecking();
        PackageValidator pv = new PackageValidator(this.getXMLPackage(), true, true, false, true, JaWEConfig.getInstance().getAllowUndefinedStartActivity(), JaWEConfig.getInstance().getAllowUndefinedEndActivity(), JaWEConfig.getInstance().getEncoding());
        boolean areGraphsWellConnected = pv.checkGraphConnections(fullCheck);
        this.basicGraphConnectionError = pv.getBasicGraphConnectionError((XMLComplexElement)this.getXMLPackage());
        this.graphConnectionErrors = pv.getGraphsConnectionErrors((XMLComplexElement)this.getXMLPackage());
        if (JaWEConfig.getInstance().getUseBubblesStatus() && (fullCheck || areGraphsWellConnected)) {
            areGraphsWellConnected = this.checkStartAndEndsConnections(fullCheck) && areGraphsWellConnected;
        }
        return areGraphsWellConnected;
    }

    protected boolean checkStartAndEndsConnections(boolean fullCheck) {
        boolean wellConnected = true;
        Set activities = JaWEGraphModel.getAllActivitiesInModel(this.graphModel);
        if (activities != null) {
            Iterator it = activities.iterator();
            block0: while (it.hasNext() && (fullCheck || wellConnected)) {
                org.enhydra.jawe.graph.Activity act = (org.enhydra.jawe.graph.Activity)it.next();
                ProcessEditor pe = act.getImplementationEditor();
                if (pe == null) continue;
                WorkflowProcess wp = (WorkflowProcess)act.getUserObject();
                ProcessGraph pg = (ProcessGraph)pe.getGraph();
                if (pg.getImproperlyConnectedStarts(false).size() > 0 || pg.getImproperlyConnectedEnds(false).size() > 0) {
                    wellConnected = false;
                    this.basicGraphConnectionError = ResourceManager.getLanguageDependentString("InformationOneOrMoreProcessesHaveImproperlyConnectedElements");
                    if (!fullCheck) break;
                    if (this.graphConnectionErrors == null) {
                        this.graphConnectionErrors = new HashMap();
                    }
                    this.graphConnectionErrors.put(wp, this.basicGraphConnectionError);
                }
                Set blockActs = this.workflowManager.getBlockActivities(true);
                Iterator itBas = blockActs.iterator();
                while (itBas.hasNext()) {
                    ProcessGraph bag;
                    BlockActivity ba = (BlockActivity)itBas.next();
                    ProcessEditor bwe = ba.getImplementationEditor();
                    if (bwe == null || (bag = (ProcessGraph)bwe.getGraph()).getImproperlyConnectedStarts(false).size() <= 0 && bag.getImproperlyConnectedEnds(false).size() <= 0) continue;
                    wellConnected = false;
                    this.basicGraphConnectionError = ResourceManager.getLanguageDependentString("InformationOneOrMoreProcessesHaveImproperlyConnectedElements");
                    if (!fullCheck) continue block0;
                    this.graphConnectionErrors.put(wp, this.basicGraphConnectionError);
                }
            }
        }
        return wellConnected;
    }

    protected void updateXMLObjectsBeforeChecking() {
        Set activities = JaWEGraphModel.getAllActivitiesInModel(this.graphModel);
        if (activities != null) {
            Iterator it = activities.iterator();
            while (it.hasNext()) {
                org.enhydra.jawe.graph.Activity act = (org.enhydra.jawe.graph.Activity)it.next();
                ProcessEditor pe = act.getImplementationEditor();
                if (pe == null) continue;
                WorkflowProcess wp = (WorkflowProcess)act.getUserObject();
                wp.setStartDescriptions(Utils.getStartDescriptions(pe));
                wp.setEndDescriptions(Utils.getEndDescriptions(pe));
                Set blockActs = this.workflowManager.getBlockActivities(true);
                Iterator itBas = blockActs.iterator();
                while (itBas.hasNext()) {
                    BlockActivity ba = (BlockActivity)itBas.next();
                    ProcessEditor bwe = ba.getImplementationEditor();
                    Activity bap = (Activity)ba.getUserObject();
                    bap.setStartDescriptions(Utils.getStartDescriptions(bwe));
                    bap.setEndDescriptions(Utils.getEndDescriptions(bwe));
                }
            }
        }
    }

    public boolean checkGraphConformance(boolean fullCheck) {
        PackageValidator pv = new PackageValidator(this.getXMLPackage(), true, true, false, true, JaWEConfig.getInstance().getAllowUndefinedStartActivity(), JaWEConfig.getInstance().getAllowUndefinedEndActivity(), JaWEConfig.getInstance().getEncoding());
        boolean areGraphsConformant = pv.checkGraphConformance(fullCheck);
        this.basicGraphConformanceErrors = pv.getBasicGraphConformanceErrors((XMLComplexElement)this.getXMLPackage());
        this.graphConformanceErrors = pv.getGraphConformanceErrors((XMLComplexElement)this.getXMLPackage());
        return areGraphsConformant;
    }

    public boolean checkLogic(boolean fullCheck) {
        PackageValidator pv = new PackageValidator(this.getXMLPackage(), true, true, false, true, JaWEConfig.getInstance().getAllowUndefinedStartActivity(), JaWEConfig.getInstance().getAllowUndefinedEndActivity(), JaWEConfig.getInstance().getEncoding());
        boolean isLogical = pv.checkPackage(fullCheck);
        this.basicLogicError = pv.getBasicLogicError((XMLComplexElement)this.getXMLPackage());
        this.logicErrors = pv.getLogicErrors((XMLComplexElement)this.getXMLPackage());
        return isLogical;
    }

    public void xmlElementChanged(XMLElement el) {
        if (el instanceof Activity) {
            this.editor.getStatusBar().updateMessage();
        }
    }
}

