/*
 * Decompiled with CFR 0.152.
 */
package org.enhydra.jawe;

import java.awt.Component;
import java.awt.Window;
import java.io.File;
import java.util.Collections;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import javax.swing.Action;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JSplitPane;
import javax.swing.ToolTipManager;
import javax.swing.event.UndoableEditListener;
import org.enhydra.jawe.AbstractEditor;
import org.enhydra.jawe.AbstractGraph;
import org.enhydra.jawe.JaWE;
import org.enhydra.jawe.JaWEConfig;
import org.enhydra.jawe.JaWEGraphModel;
import org.enhydra.jawe.PackageGraph;
import org.enhydra.jawe.ProcessEditor;
import org.enhydra.jawe.ResourceManager;
import org.enhydra.jawe.Utils;
import org.enhydra.jawe.actions.Applications;
import org.enhydra.jawe.actions.ChangeLanguage;
import org.enhydra.jawe.actions.CheckValidity;
import org.enhydra.jawe.actions.Config;
import org.enhydra.jawe.actions.Delete;
import org.enhydra.jawe.actions.EditCell;
import org.enhydra.jawe.actions.EditProperties;
import org.enhydra.jawe.actions.Exit;
import org.enhydra.jawe.actions.ExternalPackages;
import org.enhydra.jawe.actions.HelpAbout;
import org.enhydra.jawe.actions.HelpManual;
import org.enhydra.jawe.actions.HelpTutorial;
import org.enhydra.jawe.actions.ImportExternalProcess;
import org.enhydra.jawe.actions.MakeCopyOfProcess;
import org.enhydra.jawe.actions.Namespaces;
import org.enhydra.jawe.actions.New;
import org.enhydra.jawe.actions.Open;
import org.enhydra.jawe.actions.PackageProperties;
import org.enhydra.jawe.actions.Participants;
import org.enhydra.jawe.actions.Processes;
import org.enhydra.jawe.actions.ReferredDocument;
import org.enhydra.jawe.actions.Reopen;
import org.enhydra.jawe.actions.Save;
import org.enhydra.jawe.actions.SaveAs;
import org.enhydra.jawe.actions.TypeDeclarations;
import org.enhydra.jawe.actions.WfXML;
import org.enhydra.jawe.actions.WorkflowRelevantData;
import org.enhydra.jawe.graph.Process;
import org.enhydra.jawe.ldap.ImportExternalParticipants;
import org.enhydra.jawe.misc.PackageTreePanel;
import org.enhydra.jawe.misc.TextTreePanel;
import org.enhydra.jawe.xml.XMLComplexElement;
import org.enhydra.jawe.xml.XMLElement;
import org.enhydra.jawe.xml.XMLElementDialog;
import org.enhydra.jawe.xml.XMLUtil;
import org.enhydra.jawe.xml.elements.ConformanceClass;
import org.enhydra.jawe.xml.elements.Package;
import org.enhydra.jawe.xml.elements.RedefinableHeader;
import org.enhydra.jawe.xml.elements.WorkflowProcess;
import org.enhydra.jawe.xml.panels.XMLPanel;
import org.jgraph.event.GraphModelListener;
import org.jgraph.event.GraphSelectionEvent;
import org.jgraph.event.GraphSelectionListener;
import org.jgraph.graph.GraphModel;

public class PackageEditor
extends AbstractEditor {
    private Map pkgIdToGraph;
    private Map processToProcessObject;
    private Package realXMLPackage;
    private PackageGraph realGraph;
    private boolean isInitialized = false;
    private JSplitPane splitPane;
    private PackageTreePanel packageTreePanel;
    private TextTreePanel packagePrintTreePanel;
    static /* synthetic */ Class class$org$enhydra$jawe$actions$Delete;
    static /* synthetic */ Class class$org$enhydra$jawe$actions$EditCell;
    static /* synthetic */ Class class$org$enhydra$jawe$actions$EditProperties;
    static /* synthetic */ Class class$org$enhydra$jawe$actions$MakeCopyOfProcess;
    static /* synthetic */ Class class$org$enhydra$jawe$actions$ImportExternalProcess;
    static /* synthetic */ Class class$org$enhydra$jawe$ldap$ImportExternalParticipants;

    public PackageEditor(XMLComplexElement pkgOrProcess) {
        super(pkgOrProcess);
    }

    public PackageTreePanel getPackageTreePanel() {
        return this.packageTreePanel;
    }

    public TextTreePanel getPackagePrintTreePanel() {
        return this.packagePrintTreePanel;
    }

    public boolean isInitialized() {
        return this.isInitialized;
    }

    public boolean isPackageGraphCreated(String pkgId) {
        if (this.pkgIdToGraph == null) {
            this.pkgIdToGraph = new Hashtable();
        }
        return this.pkgIdToGraph.containsKey(pkgId);
    }

    public boolean isProcessObjectCreated(WorkflowProcess wp) {
        if (this.processToProcessObject == null) {
            this.processToProcessObject = new Hashtable();
        }
        return this.processToProcessObject.containsKey(wp);
    }

    public PackageGraph getPackageGraph(String pkgId) {
        if (this.pkgIdToGraph == null) {
            this.pkgIdToGraph = new Hashtable();
        }
        return (PackageGraph)this.pkgIdToGraph.get(pkgId);
    }

    public void putPackageGraphMapping(String pkgId, PackageGraph peg) {
        if (this.pkgIdToGraph == null) {
            this.pkgIdToGraph = new Hashtable();
        }
        this.pkgIdToGraph.put(pkgId, peg);
    }

    public Map getPkgIdToGraphMap() {
        if (this.pkgIdToGraph == null) {
            this.pkgIdToGraph = new Hashtable();
        }
        return Collections.unmodifiableMap(this.pkgIdToGraph);
    }

    public void removePackageGraphMapping(String pkgId) {
        if (this.pkgIdToGraph == null) {
            this.pkgIdToGraph = new Hashtable();
        }
        this.pkgIdToGraph.remove(pkgId);
    }

    public void clearPackageGraphMap() {
        if (this.pkgIdToGraph == null) {
            this.pkgIdToGraph = new Hashtable();
        }
        this.pkgIdToGraph.clear();
    }

    public Process getProcessObject(WorkflowProcess wp) {
        if (this.processToProcessObject == null) {
            this.processToProcessObject = new Hashtable();
        }
        return (Process)this.processToProcessObject.get(wp);
    }

    public void putProcessObjectMapping(WorkflowProcess wp, Process pr) {
        if (this.processToProcessObject == null) {
            this.processToProcessObject = new Hashtable();
        }
        this.processToProcessObject.put(wp, pr);
    }

    public void removeProcessObjectMapping(WorkflowProcess wp) {
        if (this.processToProcessObject == null) {
            this.processToProcessObject = new Hashtable();
        }
        this.processToProcessObject.remove(wp);
    }

    public void clearProcessObjectMap() {
        if (this.processToProcessObject == null) {
            this.processToProcessObject = new Hashtable();
        }
        this.processToProcessObject.clear();
    }

    protected Component createCenterComponent() {
        this.packageTreePanel = new PackageTreePanel(this.getXMLPackage(), this, ResourceManager.getLanguageDependentString("PackageAndExternalPackagesKey"), false);
        this.splitPane = new JSplitPane(1, (Component)((Object)this.packageTreePanel), super.createCenterComponent());
        return this.splitPane;
    }

    protected AbstractGraph createGraph() {
        this.realGraph = new PackageGraph((GraphModel)new JaWEGraphModel(), this);
        return this.realGraph;
    }

    protected void createActions() {
        this.defaultActions = new Action[]{new New(this), new Open(this), new Reopen(this), new Save(this), new SaveAs(this), new ChangeLanguage(this), new WfXML(this), new Exit(this), new Namespaces(this), new PackageProperties(this), new Processes(this), new ExternalPackages(this), new ImportExternalProcess(this), new ImportExternalParticipants(this), new TypeDeclarations(this), new Participants(this), new Applications(this), new WorkflowRelevantData(this), new ReferredDocument(this), new CheckValidity(this), this.undoAction, this.redoAction, new Delete(this), new EditCell(this), new EditProperties(this), new MakeCopyOfProcess(this), new HelpTutorial(this), new HelpManual(this), new HelpAbout(this), new Config(this)};
    }

    public void valueChanged(GraphSelectionEvent e) {
        boolean enabled;
        boolean bl = enabled = !this.graph.isSelectionEmpty();
        if (this.realGraph != this.graph) {
            this.getToolbarComponent("processActivityTool").setEnabled(false);
            this.getToolbarComponent("automaticStartEndTool").setEnabled(false);
            this.getAction(Utils.getUnqualifiedClassName(class$org$enhydra$jawe$actions$Delete == null ? (class$org$enhydra$jawe$actions$Delete = PackageEditor.class$("org.enhydra.jawe.actions.Delete")) : class$org$enhydra$jawe$actions$Delete)).setEnabled(false);
            this.undoAction.setEnabled(false);
            this.redoAction.setEnabled(false);
            this.getAction(Utils.getUnqualifiedClassName(class$org$enhydra$jawe$actions$EditCell == null ? (class$org$enhydra$jawe$actions$EditCell = PackageEditor.class$("org.enhydra.jawe.actions.EditCell")) : class$org$enhydra$jawe$actions$EditCell)).setEnabled(enabled);
            this.getAction(Utils.getUnqualifiedClassName(class$org$enhydra$jawe$actions$EditProperties == null ? (class$org$enhydra$jawe$actions$EditProperties = PackageEditor.class$("org.enhydra.jawe.actions.EditProperties")) : class$org$enhydra$jawe$actions$EditProperties)).setEnabled(enabled);
            this.getAction(Utils.getUnqualifiedClassName(class$org$enhydra$jawe$actions$MakeCopyOfProcess == null ? (class$org$enhydra$jawe$actions$MakeCopyOfProcess = PackageEditor.class$("org.enhydra.jawe.actions.MakeCopyOfProcess")) : class$org$enhydra$jawe$actions$MakeCopyOfProcess)).setEnabled(false);
            return;
        }
        this.getToolbarComponent("processActivityTool").setEnabled(true);
        if (JaWEConfig.getInstance().getUseBubblesStatus()) {
            this.getToolbarComponent("automaticStartEndTool").setEnabled(true);
        }
        try {
            this.getAction(Utils.getUnqualifiedClassName(class$org$enhydra$jawe$actions$Delete == null ? (class$org$enhydra$jawe$actions$Delete = PackageEditor.class$("org.enhydra.jawe.actions.Delete")) : class$org$enhydra$jawe$actions$Delete)).setEnabled(enabled);
            this.getAction(Utils.getUnqualifiedClassName(class$org$enhydra$jawe$actions$EditCell == null ? (class$org$enhydra$jawe$actions$EditCell = PackageEditor.class$("org.enhydra.jawe.actions.EditCell")) : class$org$enhydra$jawe$actions$EditCell)).setEnabled(enabled);
            this.getAction(Utils.getUnqualifiedClassName(class$org$enhydra$jawe$actions$EditProperties == null ? (class$org$enhydra$jawe$actions$EditProperties = PackageEditor.class$("org.enhydra.jawe.actions.EditProperties")) : class$org$enhydra$jawe$actions$EditProperties)).setEnabled(enabled);
            this.getAction(Utils.getUnqualifiedClassName(class$org$enhydra$jawe$actions$MakeCopyOfProcess == null ? (class$org$enhydra$jawe$actions$MakeCopyOfProcess = PackageEditor.class$("org.enhydra.jawe.actions.MakeCopyOfProcess")) : class$org$enhydra$jawe$actions$MakeCopyOfProcess)).setEnabled(enabled);
        }
        catch (Exception ex) {
            // empty catch block
        }
        try {
            this.update();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public Package getXMLPackage() {
        return this.graph.getXMLPackage();
    }

    public Package getRealXMLPackage() {
        return this.realXMLPackage;
    }

    public void enterPackageID() {
        String msg = ResourceManager.getLanguageDependentString("InformationNotAllowedToDoEnythingBeforeEnteringPackageID");
        JaWE.getInstance().message(msg, 1);
        XMLElement ID = this.realXMLPackage.get("Id");
        ID.setReadOnly(false);
        String mcl = JaWE.getInstance().getMandatoryConformanceClass();
        int mct = XMLUtil.getConformanceClassNo((String)mcl);
        if (mct > 0) {
            ConformanceClass cc = (ConformanceClass)this.getXMLPackage().get("ConformanceClass");
            cc.set("GraphConformance", (Object)ResourceManager.getLanguageDependentString(mcl + "Key"));
            cc.setReadOnly(true);
        }
        XMLPanel p = this.getXMLPackage().getPanel(1);
        XMLElementDialog d = new XMLElementDialog((JFrame)this.getWindow(), ResourceManager.getLanguageDependentString("PackageKey") + " '" + this.getXMLPackage().get("Id").toString() + "' - " + ResourceManager.getLanguageDependentString("PropertiesKey"));
        d.editXMLElement(p, false, true);
        this.getXMLPackage().setIDPrefixForCollections();
        ID.setReadOnly(true);
        this.isInitialized = true;
        JaWE.getInstance();
        JaWE.getXMLInterface().register(this.realXMLPackage);
        this.putPackageGraphMapping(ID.toString(), (PackageGraph)this.graph);
        this.getToolbarComponent("processActivityTool").setEnabled(true);
        this.getToolbarComponent("automaticStartEndTool").setEnabled(true);
        this.splitPane.remove((Component)((Object)this.packageTreePanel));
        this.packageTreePanel = new PackageTreePanel(this.getXMLPackage(), this, ResourceManager.getLanguageDependentString("PackageAndExternalPackagesKey"), false);
        this.splitPane.setLeftComponent((Component)((Object)this.packageTreePanel));
        this.displayPackage(this.realXMLPackage);
        this.update();
    }

    public void displayPackage(Package pkg) {
        this.graph.getSelectionModel().removeGraphSelectionListener((GraphSelectionListener)this);
        this.graph = this.getPackageGraph(pkg.get("Id").toString());
        if (this.graph == null || this.getXMLPackage() != pkg) {
            this.graph = this.realGraph;
        }
        this.graph.refreshGraphConfiguration();
        this.graph.getSelectionModel().addGraphSelectionListener((GraphSelectionListener)this);
        this.getAction(Utils.getUnqualifiedClassName(class$org$enhydra$jawe$actions$ImportExternalProcess == null ? (class$org$enhydra$jawe$actions$ImportExternalProcess = PackageEditor.class$("org.enhydra.jawe.actions.ImportExternalProcess")) : class$org$enhydra$jawe$actions$ImportExternalProcess)).setEnabled(this.graph == this.realGraph);
        this.getAction(Utils.getUnqualifiedClassName(class$org$enhydra$jawe$ldap$ImportExternalParticipants == null ? (class$org$enhydra$jawe$ldap$ImportExternalParticipants = PackageEditor.class$("org.enhydra.jawe.ldap.ImportExternalParticipants")) : class$org$enhydra$jawe$ldap$ImportExternalParticipants)).setEnabled(this.graph == this.realGraph);
        this.graphScrollPane.setViewportView((Component)((Object)this.graph));
        this.valueChanged(null);
        this.statusBar.updateMessage();
    }

    public boolean allowInvalidPackageSaving() {
        boolean allow = false;
        RedefinableHeader rh = (RedefinableHeader)this.getXMLPackage().get("RedefinableHeader");
        String pStatus = rh.get("PublicationStatus").toValue().toString();
        if (pStatus.equals("UNDER_TEST") || pStatus.equals("UNDER_REVISION")) {
            allow = true;
        }
        return allow;
    }

    public WorkflowProcess showProcess(Window parentWindow, WorkflowProcess wp, String processID) {
        if (wp == null) {
            Process pr = this.realGraph.getWorkflowManager().insertProcess(this.realGraph.getNextInsertionPoint(), true);
            wp = (WorkflowProcess)pr.getUserObject();
            wp.set("Id", (Object)processID);
            this.putProcessObjectMapping(wp, pr);
            pr.showProcess(parentWindow);
        } else {
            Process pr = this.getProcessObject(wp);
            ProcessEditor pe = pr.getImplementationEditor();
            pe.refreshEditorConfiguration();
            if (wp.getPackage() != this.realXMLPackage || wp.getPackage().isReadOnly()) {
                pe.setButtonsEnabled(false);
            }
            pr.showProcess(parentWindow);
        }
        return wp;
    }

    public String getTitle() {
        String title = "";
        title = this.realXMLPackage != null && this.realXMLPackage.get("Id").toString().trim().length() > 0 ? title + this.realXMLPackage.get("Id").toString().trim() : title + ResourceManager.getLanguageDependentString("UnnamedKey");
        title = title + " - JaWE";
        if (JaWE.getInstance().isModified()) {
            title = title + "*";
        }
        return title;
    }

    public String toolbarToLoad() {
        return "packageToolbars";
    }

    public String menubarToLoad() {
        return "packageMenubar";
    }

    public void setNewPackage(Package pkg, boolean clearOtherPackages) {
        if (clearOtherPackages) {
            this.clearPackageGraphMap();
            this.clearProcessObjectMap();
        }
        if (pkg != null) {
            this.putPackageGraphMapping(pkg.get("Id").toString(), (PackageGraph)this.graph);
        }
        this.graph.updateUI();
        this.realXMLPackage = pkg;
        this.graph.setPropertyObject((XMLComplexElement)pkg);
        this.graph.clearSelection();
        this.graph.paintImmediately(this.graph.getBounds());
        this.graph.getModel().removeGraphModelListener((GraphModelListener)this);
        this.graph.getModel().removeUndoableEditListener((UndoableEditListener)this.undoHandler);
        this.graph.setModel(new JaWEGraphModel());
        this.valueChanged(null);
        if (JaWE.getInstance().getFilename() != null && (new File(JaWE.getInstance().getFilename()).exists() || !clearOtherPackages)) {
            this.isInitialized = true;
            Window w = this.getWindow();
            this.graph.createWorkflowGraph(w);
            this.createGraphsForExternalPackages(this.realXMLPackage);
        } else {
            this.isInitialized = false;
        }
        if (this.splitPane != null) {
            this.splitPane.remove((Component)((Object)this.packageTreePanel));
            this.packageTreePanel = new PackageTreePanel(this.getXMLPackage(), this, ResourceManager.getLanguageDependentString("PackageAndExternalPackagesKey"), false);
            this.splitPane.setLeftComponent((Component)((Object)this.packageTreePanel));
        }
        try {
            this.displayPackage(this.realXMLPackage);
        }
        catch (Exception ex) {
            // empty catch block
        }
        JaWE.getInstance().setModified(false);
        this.graph.getModel().addGraphModelListener((GraphModelListener)this);
        this.graph.getModel().addUndoableEditListener((UndoableEditListener)this.undoHandler);
        this.resetUndoManager();
        try {
            this.getWindow().requestFocus();
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (!this.isInitialized) {
            this.getToolbarComponent("processActivityTool").setEnabled(false);
            this.getToolbarComponent("automaticStartEndTool").setEnabled(false);
        }
    }

    public void createGraphsForExternalPackages(Package pkg) {
        Set ems = pkg.getAllExternalPackages();
        Iterator it = ems.iterator();
        while (it.hasNext()) {
            Package ep = (Package)it.next();
            this.createGraphForPackage(ep, true);
        }
    }

    public void createGraphForPackage(Package pkg, boolean isReadOnly) {
        Window w = this.getWindow();
        if (!this.isPackageGraphCreated(pkg.get("Id").toString())) {
            pkg.setReadOnly(isReadOnly);
            PackageGraph peg = new PackageGraph((GraphModel)new JaWEGraphModel(), this);
            ToolTipManager.sharedInstance().registerComponent((JComponent)((Object)peg));
            peg.setPropertyObject((XMLComplexElement)pkg);
            peg.setAdditionalKeyboardShortcuts();
            peg.createWorkflowGraph(w);
            this.putPackageGraphMapping(pkg.get("Id").toString(), peg);
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

