/*
 * Decompiled with CFR 0.152.
 */
package org.enhydra.jawe;

import java.awt.BorderLayout;
import java.awt.Component;
import javax.swing.BorderFactory;
import javax.swing.JLabel;
import javax.swing.JPanel;
import org.enhydra.jawe.AbstractEditor;
import org.enhydra.jawe.JaWEConfig;
import org.enhydra.jawe.PackageEditor;
import org.enhydra.jawe.ResourceManager;
import org.enhydra.jawe.graph.BlockActivityEditor;

public class JaWEStatusBar
extends JPanel {
    private AbstractEditor editor;
    private JLabel message;

    public JaWEStatusBar(AbstractEditor editor) {
        this.editor = editor;
        this.setLayout(new BorderLayout());
        this.message = new JLabel("  ");
        this.message.setBorder(BorderFactory.createLoweredBevelBorder());
        this.add((Component)this.message, "Center");
    }

    public void updateMessage() {
        if (!JaWEConfig.getInstance().getStatusBarStatus()) {
            return;
        }
        if (!JaWEConfig.getInstance().getValidationStatus()) {
            this.message.setText(ResourceManager.getLanguageDependentString("MessageValidationIsTurnedOff"));
            return;
        }
        boolean isSchemaValidationError = !this.editor.getGraph().validateAgainsXPDLSchema();
        boolean isConnectionError = false;
        boolean isGraphConformanceError = false;
        boolean isLogicError = false;
        if (!isSchemaValidationError) {
            boolean bl = isConnectionError = !this.editor.getGraph().checkConnections(false);
        }
        if (!isConnectionError) {
            boolean bl = isGraphConformanceError = !this.editor.getGraph().checkGraphConformance(false);
        }
        if (!isConnectionError && !isGraphConformanceError) {
            isLogicError = !this.editor.getGraph().checkLogic(false);
        }
        boolean isModelOK = !isSchemaValidationError && !isConnectionError && !isGraphConformanceError && !isLogicError;
        String msg = "";
        if (this.editor instanceof PackageEditor) {
            if (isModelOK) {
                msg = ResourceManager.getLanguageDependentString("InformationPackageIsValid");
            } else if (isSchemaValidationError) {
                msg = this.editor.getGraph().getBasicXPDLSchemaValidationErrorMessage();
            } else if (isConnectionError) {
                msg = this.editor.getGraph().getBasicConnectionErrorMessage();
            } else if (isGraphConformanceError) {
                msg = this.editor.getGraph().getBasicGraphConformanceErrorMessages().get(0).toString();
                if (msg.length() == 0) {
                    msg = "SWR1";
                }
            } else {
                msg = this.editor.getGraph().getBasicLogicErrorMessage();
            }
        } else if (isModelOK) {
            msg = this.editor instanceof BlockActivityEditor ? ResourceManager.getLanguageDependentString("InformationBlockIsValid") : ResourceManager.getLanguageDependentString("InformationProcessIsValid");
        } else if (isSchemaValidationError) {
            msg = this.editor.getGraph().getBasicXPDLSchemaValidationErrorMessage();
        } else if (isConnectionError) {
            msg = this.editor.getGraph().getBasicConnectionErrorMessage();
        } else if (isGraphConformanceError) {
            msg = this.editor.getGraph().getBasicGraphConformanceErrorMessages().get(0).toString();
            if (msg.length() == 0) {
                msg = "SWR2";
            }
        } else {
            msg = this.editor.getGraph().getBasicLogicErrorMessage();
        }
        this.message.setText(msg);
    }

    public String getMessage() {
        return this.message.getText();
    }

    public void setMessage(String message) {
        this.message.setText(message);
    }
}

