/*
 * Decompiled with CFR 0.152.
 */
package org.enhydra.jawe;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Rectangle;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.util.Observable;
import java.util.Observer;
import javax.swing.BorderFactory;
import javax.swing.JPanel;
import org.enhydra.jawe.ProcessGraph;
import org.jgraph.JGraph;
import org.jgraph.event.GraphModelEvent;
import org.jgraph.event.GraphModelListener;
import org.jgraph.graph.AbstractCellView;
import org.jgraph.graph.CellView;
import org.jgraph.graph.GraphLayoutCache;

public class JaWEOverviewPanel
extends JPanel
implements ComponentListener,
GraphModelListener,
Observer {
    protected ProcessGraph graph;

    public JaWEOverviewPanel(JGraph g) {
        ViewRedirector view = new ViewRedirector(g, g.getGraphLayoutCache());
        this.graph = new ProcessGraph(g.getModel(), view);
        this.graph.setAntiAliased(true);
        this.setBorder(BorderFactory.createEtchedBorder());
        this.graph.getModel().addGraphModelListener((GraphModelListener)this);
        this.graph.setEnabled(false);
        g.addComponentListener((ComponentListener)this);
        g.getGraphLayoutCache().addObserver((Observer)this);
        this.setLayout(new BorderLayout());
        this.add((Component)((Object)this.graph), "Center");
    }

    public JGraph getGraph() {
        return this.graph;
    }

    public void update(Observable o, Object arg) {
        this.componentResized(null);
    }

    public void graphChanged(GraphModelEvent e) {
        this.componentResized(null);
    }

    public void componentResized(ComponentEvent e) {
        Rectangle r = null;
        if (AbstractCellView.getBounds((CellView[])this.graph.getGraphLayoutCache().getRoots()) != null) {
            r = AbstractCellView.getBounds((CellView[])this.graph.getGraphLayoutCache().getRoots()).getBounds();
        }
        double scale = 0.5;
        if (r != null) {
            Dimension d = new Dimension(r.x + r.width, r.y + r.height);
            Dimension s = this.getSize();
            double sx = s.getWidth() * 0.95 / d.getWidth();
            double sy = s.getHeight() * 0.95 / d.getHeight();
            scale = Math.min(Math.max(Math.min(sx, sy), 0.05), 0.5);
        }
        this.graph.setScale(scale);
        this.repaint();
    }

    public void componentShown(ComponentEvent e) {
        this.componentResized(e);
    }

    public void componentHidden(ComponentEvent e) {
    }

    public void componentMoved(ComponentEvent e) {
    }

    public class ViewRedirector
    extends GraphLayoutCache {
        protected GraphLayoutCache realView;

        public ViewRedirector(JGraph graph, GraphLayoutCache realView) {
            super(graph);
            this.realView = realView;
            this.setModel(graph.getModel());
        }

        public CellView[] getRoots() {
            return this.realView.getRoots();
        }

        public CellView getMapping(Object cell, boolean create) {
            if (this.realView != null) {
                return this.realView.getMapping(cell, create);
            }
            return null;
        }

        public void putMapping(Object cell, CellView view) {
            if (this.realView != null) {
                this.realView.putMapping(cell, view);
            }
        }
    }
}

