/*
 * Decompiled with CFR 0.152.
 */
package org.enhydra.jawe;

import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.geom.Rectangle2D;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import javax.swing.ButtonGroup;
import javax.swing.ImageIcon;
import javax.swing.JOptionPane;
import javax.swing.JPopupMenu;
import javax.swing.JToggleButton;
import javax.swing.SwingUtilities;
import javax.swing.tree.TreeNode;
import org.enhydra.jawe.AbstractEditor;
import org.enhydra.jawe.AbstractGraph;
import org.enhydra.jawe.BarFactory;
import org.enhydra.jawe.JaWE;
import org.enhydra.jawe.JaWEConfig;
import org.enhydra.jawe.JaWEGraphModel;
import org.enhydra.jawe.JaWEGraphUI;
import org.enhydra.jawe.JaWEPortView;
import org.enhydra.jawe.PackageEditor;
import org.enhydra.jawe.PackageGraph;
import org.enhydra.jawe.ProcessEditor;
import org.enhydra.jawe.ProcessGraph;
import org.enhydra.jawe.ResourceManager;
import org.enhydra.jawe.Utils;
import org.enhydra.jawe.WorkflowManager;
import org.enhydra.jawe.graph.Activity;
import org.enhydra.jawe.graph.BlockActivity;
import org.enhydra.jawe.graph.End;
import org.enhydra.jawe.graph.Linkable;
import org.enhydra.jawe.graph.Participant;
import org.enhydra.jawe.graph.ParticipantView;
import org.enhydra.jawe.graph.Process;
import org.enhydra.jawe.graph.Start;
import org.enhydra.jawe.graph.Subflow;
import org.enhydra.jawe.graph.Transition;
import org.enhydra.jawe.xml.elements.WorkflowProcess;
import org.jgraph.JGraph;
import org.jgraph.graph.AbstractCellView;
import org.jgraph.graph.BasicMarqueeHandler;
import org.jgraph.graph.CellView;
import org.jgraph.graph.DefaultPort;
import org.jgraph.graph.GraphConstants;
import org.jgraph.graph.PortView;

public class JaWEMarqueeHandler
extends BasicMarqueeHandler {
    private transient AbstractGraph graph = null;
    private transient AbstractEditor ED = null;
    private transient WorkflowManager workflowManager = null;
    private boolean persistent = false;
    private transient JToggleButton selectButton = new JToggleButton();
    private transient JToggleButton processButton = new JToggleButton();
    private transient JToggleButton participantButton = new JToggleButton();
    private transient JToggleButton subflowActivityButton = new JToggleButton();
    private transient JToggleButton blockActivityButton = new JToggleButton();
    private transient JToggleButton startButton = new JToggleButton();
    private transient JToggleButton endButton = new JToggleButton();
    private transient JToggleButton automaticStartEndButton = new JToggleButton();
    private transient JToggleButton genericActivityButton = new JToggleButton();
    private transient JToggleButton routeActivityButton = new JToggleButton();
    private transient JToggleButton transitionButton = new JToggleButton();
    private transient JToggleButton selfRoutedTransitionButton = new JToggleButton();
    private transient JToggleButton circularTransitionButton = new JToggleButton();
    private transient Cursor participantCursor;
    private transient Cursor processCursor;
    private transient Cursor subflowActivityCursor;
    private transient Cursor blockActivityCursor;
    private transient Cursor startCursor;
    private transient Cursor endCursor;
    private transient Cursor genericActivityCursor;
    private transient Cursor routeActivityCursor;
    private transient Cursor transitionCursor;
    private transient Cursor selfRoutedTransitionCursor;
    private transient Cursor circularTransitionCursor;
    private transient ML ml = new ML();
    private transient ASEML aseml = new ASEML();
    private transient AL al = new AL();
    protected Point start;
    protected Point current;
    protected PortView port;
    protected PortView firstPort;
    protected PortView lastPort;
    protected Point popupPoint;
    static /* synthetic */ Class class$org$enhydra$jawe$actions$Cut;
    static /* synthetic */ Class class$org$enhydra$jawe$actions$Copy;
    static /* synthetic */ Class class$org$enhydra$jawe$actions$PasteAt;
    static /* synthetic */ Class class$org$enhydra$jawe$actions$Delete;
    static /* synthetic */ Class class$org$enhydra$jawe$actions$SetSelfRouting;
    static /* synthetic */ Class class$org$enhydra$jawe$actions$SetNoRouting;
    static /* synthetic */ Class class$org$enhydra$jawe$actions$EditProperties;
    static /* synthetic */ Class class$org$enhydra$jawe$actions$AddPoint;
    static /* synthetic */ Class class$org$enhydra$jawe$actions$RemovePoint;
    static /* synthetic */ Class class$org$enhydra$jawe$actions$EditCell;
    static /* synthetic */ Class class$org$enhydra$jawe$actions$MakeCopyOfProcess;
    static /* synthetic */ Class class$org$enhydra$jawe$actions$MoveUpParticipant;
    static /* synthetic */ Class class$org$enhydra$jawe$actions$MoveDownParticipant;

    public JaWEMarqueeHandler(AbstractGraph graph) {
        Image curIm;
        Point hotSpot;
        ImageIcon curIc;
        this.graph = graph;
        this.ED = graph.getEditor();
        this.workflowManager = graph.getWorkflowManager();
        try {
            curIc = new ImageIcon(ResourceManager.getResource("participantToolImage"));
            hotSpot = new Point(curIc.getIconWidth() / 2, curIc.getIconHeight() / 2);
            curIm = curIc.getImage();
            this.participantCursor = graph.getToolkit().createCustomCursor(curIm, hotSpot, "participant20x20");
        }
        catch (Exception e) {
            System.err.println("Missing participant cursor in property file !");
        }
        try {
            curIc = new ImageIcon(ResourceManager.getResource("processActivityToolImage"));
            hotSpot = new Point(curIc.getIconWidth() / 2, curIc.getIconHeight() / 2);
            curIm = curIc.getImage();
            this.processCursor = graph.getToolkit().createCustomCursor(curIm, hotSpot, "process20x20");
        }
        catch (Exception e) {
            System.err.println("Missing process cursor in property file !");
        }
        try {
            curIc = new ImageIcon(ResourceManager.getResource("subflowActivityToolImage"));
            hotSpot = new Point(curIc.getIconWidth() / 2, curIc.getIconHeight() / 2);
            curIm = curIc.getImage();
            this.subflowActivityCursor = graph.getToolkit().createCustomCursor(curIm, hotSpot, "subflowActivity20x20");
        }
        catch (Exception e) {
            System.err.println("Missing subflow activity cursor in property file !");
        }
        try {
            curIc = new ImageIcon(ResourceManager.getResource("blockActivityToolImage"));
            hotSpot = new Point(curIc.getIconWidth() / 2, curIc.getIconHeight() / 2);
            curIm = curIc.getImage();
            this.blockActivityCursor = graph.getToolkit().createCustomCursor(curIm, hotSpot, "blockActivity20x20");
        }
        catch (Exception e) {
            System.err.println("Missing block activity cursor in property file !");
        }
        try {
            curIc = new ImageIcon(ResourceManager.getResource("startToolImage"));
            hotSpot = new Point(curIc.getIconWidth() / 2, curIc.getIconHeight() / 2);
            curIm = curIc.getImage();
            this.startCursor = graph.getToolkit().createCustomCursor(curIm, hotSpot, "start20x20");
        }
        catch (Exception e) {
            System.err.println("Missing start cursor in property file !");
        }
        try {
            curIc = new ImageIcon(ResourceManager.getResource("endToolImage"));
            hotSpot = new Point(curIc.getIconWidth() / 2, curIc.getIconHeight() / 2);
            curIm = curIc.getImage();
            this.endCursor = graph.getToolkit().createCustomCursor(curIm, hotSpot, "end20x20");
        }
        catch (Exception e) {
            System.err.println("Missing end cursor in property file !");
        }
        try {
            curIc = new ImageIcon(ResourceManager.getResource("genericActivityToolImage"));
            hotSpot = new Point(curIc.getIconWidth() / 2, curIc.getIconHeight() / 2);
            curIm = curIc.getImage();
            this.genericActivityCursor = graph.getToolkit().createCustomCursor(curIm, hotSpot, "genericActivity20x20");
        }
        catch (Exception e) {
            System.err.println("Missing generic activity cursor in property file !");
        }
        try {
            curIc = new ImageIcon(ResourceManager.getResource("routeActivityToolImage"));
            hotSpot = new Point(curIc.getIconWidth() / 2, curIc.getIconHeight() / 2);
            curIm = curIc.getImage();
            this.routeActivityCursor = graph.getToolkit().createCustomCursor(curIm, hotSpot, "routeActivity20x20");
        }
        catch (Exception e) {
            System.err.println("Missing route activity cursor in property file !");
        }
        try {
            curIc = new ImageIcon(ResourceManager.getResource("transitionToolImage"));
            hotSpot = new Point(curIc.getIconWidth() / 2, curIc.getIconHeight() / 2);
            curIm = curIc.getImage();
            this.transitionCursor = graph.getToolkit().createCustomCursor(curIm, hotSpot, "transition20x20");
        }
        catch (Exception e) {
            System.err.println("Missing transition cursor in property file !");
        }
        try {
            curIc = new ImageIcon(ResourceManager.getResource("selfRoutedTransitionToolImage"));
            hotSpot = new Point(curIc.getIconWidth() / 2, curIc.getIconHeight() / 2);
            curIm = curIc.getImage();
            this.selfRoutedTransitionCursor = graph.getToolkit().createCustomCursor(curIm, hotSpot, "selfRoutedTransition20x20");
        }
        catch (Exception e) {
            System.err.println("Missing self routed transition cursor in property file !");
        }
        try {
            curIc = new ImageIcon(ResourceManager.getResource("circularTransitionToolImage"));
            hotSpot = new Point(curIc.getIconWidth() / 2, curIc.getIconHeight() / 2);
            curIm = curIc.getImage();
            this.circularTransitionCursor = graph.getToolkit().createCustomCursor(curIm, hotSpot, "circularTransition20x20");
        }
        catch (Exception e) {
            System.err.println("Missing circular transition cursor in property file !");
        }
        this.selectButton.addMouseListener(this.ml);
        this.participantButton.addMouseListener(this.ml);
        this.processButton.addMouseListener(this.ml);
        this.subflowActivityButton.addMouseListener(this.ml);
        this.blockActivityButton.addMouseListener(this.ml);
        this.startButton.addMouseListener(this.ml);
        this.endButton.addMouseListener(this.ml);
        this.automaticStartEndButton.addMouseListener(this.aseml);
        this.genericActivityButton.addMouseListener(this.ml);
        this.routeActivityButton.addMouseListener(this.ml);
        this.transitionButton.addMouseListener(this.ml);
        this.selfRoutedTransitionButton.addMouseListener(this.ml);
        this.circularTransitionButton.addMouseListener(this.ml);
        this.selectButton.addActionListener(this.al);
        this.participantButton.addActionListener(this.al);
        this.processButton.addActionListener(this.al);
        this.subflowActivityButton.addActionListener(this.al);
        this.blockActivityButton.addActionListener(this.al);
        this.startButton.addActionListener(this.al);
        this.endButton.addActionListener(this.al);
        this.automaticStartEndButton.addActionListener(this.al);
        this.genericActivityButton.addActionListener(this.al);
        this.routeActivityButton.addActionListener(this.al);
        this.transitionButton.addActionListener(this.al);
        this.selfRoutedTransitionButton.addActionListener(this.al);
        this.circularTransitionButton.addActionListener(this.al);
        ButtonGroup group = new ButtonGroup();
        if (this.ED instanceof ProcessEditor) {
            group.add(this.selectButton);
            group.add(this.participantButton);
            group.add(this.subflowActivityButton);
            group.add(this.blockActivityButton);
            group.add(this.startButton);
            group.add(this.endButton);
            group.add(this.automaticStartEndButton);
            group.add(this.genericActivityButton);
            group.add(this.routeActivityButton);
            group.add(this.transitionButton);
            group.add(this.selfRoutedTransitionButton);
            group.add(this.circularTransitionButton);
        } else {
            group.add(this.selectButton);
            group.add(this.processButton);
            group.add(this.automaticStartEndButton);
        }
        if (!JaWEConfig.getInstance().getUseBubblesStatus()) {
            this.enableBubblesButtons(false);
        }
    }

    public boolean isForceMarqueeEvent(MouseEvent e) {
        return this.selectButton.isSelected() && SwingUtilities.isRightMouseButton(e) || !this.selectButton.isSelected() || super.isForceMarqueeEvent(e);
    }

    public void mousePressed(MouseEvent ev) {
        if (SwingUtilities.isRightMouseButton(ev)) {
            Object cell = this.graph.getFirstCellForLocation(ev.getX(), ev.getY());
            this.popupPoint = (Point)this.graph.fromScreen(new Point(ev.getPoint()));
            JPopupMenu menu = this.createPopupMenu(cell);
            menu.show((Component)((Object)this.graph), ev.getX(), ev.getY());
        } else if (!ev.isConsumed() && !this.selectButton.isSelected()) {
            this.start = (Point)this.graph.snap(ev.getPoint());
            this.firstPort = this.port;
            if ((this.transitionButton.isSelected() || this.selfRoutedTransitionButton.isSelected()) && this.firstPort != null) {
                double scale = this.graph.getScale();
                this.start = this.firstPort.getBounds().getBounds().getLocation();
                this.start.x += JaWEPortView.getPortSize() / 2;
                this.start.y += JaWEPortView.getPortSize() / 2;
                this.start = new Point((int)(this.start.getX() * scale), (int)(this.start.getY() * scale));
                if (this.acceptsSourceOrTarget(this.firstPort, true, null, false)) {
                    ev.consume();
                } else {
                    this.firstPort = null;
                    this.port = null;
                    this.start = null;
                    this.current = null;
                }
                return;
            }
            if (this.circularTransitionButton.isSelected() && this.firstPort != null) {
                boolean as = this.acceptsSourceOrTarget(this.firstPort, true, null, true);
                boolean at = this.acceptsSourceOrTarget(this.firstPort, false, this.firstPort, true);
                if (as && at) {
                    this.workflowManager.insertTransition(this.start, this.start, this.firstPort, this.firstPort, false, true);
                }
            }
            if (this.participantButton.isSelected()) {
                this.workflowManager.insertParticipantAndArrangeParticipants(this.start, null);
            }
            if (this.processButton.isSelected()) {
                Process pr = this.workflowManager.insertProcess(((PackageGraph)this.graph).getNextInsertionPoint(), true);
                ((PackageEditor)this.ED).putProcessObjectMapping((WorkflowProcess)pr.getUserObject(), pr);
            }
            if (this.subflowActivityButton.isSelected()) {
                this.workflowManager.insertSubflowAndArrangeParticipants(this.start);
            }
            if (this.blockActivityButton.isSelected()) {
                this.workflowManager.insertBlockActivityAndArrangeParticipants(this.start);
            }
            if (this.startButton.isSelected()) {
                this.workflowManager.insertStartAndArrangeParticipants(this.start);
            }
            if (this.endButton.isSelected()) {
                this.workflowManager.insertEndAndArrangeParticipants(this.start);
            }
            if (this.genericActivityButton.isSelected()) {
                this.workflowManager.insertActivityAndArrangeParticipants(this.start);
            }
            if (this.routeActivityButton.isSelected()) {
                this.workflowManager.insertRouteAndArrangeParticipants(this.start);
            }
            ev.consume();
            if (!this.persistent) {
                this.selectButton.doClick();
            }
            this.firstPort = null;
            this.port = null;
            this.start = null;
            this.current = null;
        }
        if (!SwingUtilities.isRightMouseButton(ev)) {
            super.mousePressed(ev);
        }
        this.setProperCursor();
    }

    public void mouseDragged(MouseEvent ev) {
        if (!ev.isConsumed() && (this.transitionButton.isSelected() || this.selfRoutedTransitionButton.isSelected()) && this.firstPort != null && !SwingUtilities.isRightMouseButton(ev)) {
            Graphics g = this.graph.getGraphics();
            Color bg = this.graph.getBackground();
            Color fg = Utils.getColor(JaWEConfig.getInstance().getTransitionColor());
            g.setColor(fg);
            g.setXORMode(bg);
            this.overlay(g);
            this.current = (Point)this.graph.snap(ev.getPoint());
            double scale = this.graph.getScale();
            this.port = this.graph.getPortViewAt((int)((double)ev.getX() / scale), (int)((double)ev.getY() / scale));
            if (this.port != null) {
                this.current = this.port.getBounds().getBounds().getLocation();
                this.current = new Point((int)((double)this.current.x * scale), (int)((double)this.current.y * scale));
                this.current.x += JaWEPortView.getPortSize() / 2;
                this.current.y += JaWEPortView.getPortSize() / 2;
            }
            g.setColor(bg);
            g.setXORMode(fg);
            this.overlay(g);
            ev.consume();
        }
        super.mouseDragged(ev);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void mouseReleased(MouseEvent ev) {
        if (ev != null && !ev.isConsumed() && (this.transitionButton.isSelected() || this.selfRoutedTransitionButton.isSelected()) && !SwingUtilities.isRightMouseButton(ev)) {
            if (this.acceptsSourceOrTarget(this.port, false, this.firstPort, false) && this.port != this.firstPort) {
                this.workflowManager.insertTransition(this.start, this.current, this.firstPort, this.port, this.selfRoutedTransitionButton.isSelected(), true);
            } else {
                Graphics g = this.graph.getGraphics();
                Color bg = this.graph.getBackground();
                Color fg = Utils.getColor(JaWEConfig.getInstance().getTransitionColor());
                g.setColor(fg);
                g.setXORMode(bg);
                this.port = this.firstPort;
                this.overlay(g);
            }
            ev.consume();
        }
        if (!this.persistent) {
            this.selectButton.doClick();
        }
        this.firstPort = null;
        this.port = null;
        this.start = null;
        this.current = null;
        try {
            if (ev != null && !ev.isConsumed() && this.marqueeBounds != null && !SwingUtilities.isRightMouseButton(ev)) {
                Rectangle2D bounds = this.graph.fromScreen(this.marqueeBounds);
                CellView[] rootViews = this.graph.getGraphLayoutCache().getRoots(bounds);
                CellView[] views = AbstractCellView.getDescendantViews((CellView[])rootViews);
                ArrayList<Object> wholeList = new ArrayList<Object>();
                ArrayList<Object> participantList = new ArrayList<Object>();
                ArrayList<Object> otherList = new ArrayList<Object>();
                for (int i = 0; i < views.length; ++i) {
                    if (!bounds.contains(views[i].getBounds())) continue;
                    if (!(views[i] instanceof ParticipantView)) {
                        otherList.add(views[i].getCell());
                    } else {
                        participantList.add(views[i].getCell());
                    }
                    wholeList.add(views[i].getCell());
                }
                Object[] cells = wholeList.toArray();
                this.graph.getUI().selectCellsForEvent((JGraph)this.graph, cells, ev);
                Rectangle dirty = this.marqueeBounds.getBounds();
                ++dirty.width;
                ++dirty.height;
                this.graph.repaint(dirty);
                ev.consume();
            }
            Object var11_11 = null;
            this.currentPoint = null;
            this.startPoint = null;
            this.marqueeBounds = null;
        }
        catch (Throwable throwable) {
            Object var11_12 = null;
            this.currentPoint = null;
            this.startPoint = null;
            this.marqueeBounds = null;
            throw throwable;
        }
        this.setProperCursor();
    }

    public void mouseMoved(MouseEvent ev) {
        if (!ev.isConsumed() && !this.selectButton.isSelected()) {
            ev.consume();
            if (this.transitionButton.isSelected() || this.selfRoutedTransitionButton.isSelected() || this.circularTransitionButton.isSelected()) {
                PortView oldPort = this.port;
                double scale = this.graph.getScale();
                PortView newPort = this.graph.getPortViewAt((int)((double)ev.getX() / scale), (int)((double)ev.getY() / scale));
                if (oldPort != newPort) {
                    Graphics g = this.graph.getGraphics();
                    Color bg = this.graph.getBackground();
                    Color fg = this.graph.getMarqueeColor();
                    g.setColor(fg);
                    g.setXORMode(bg);
                    this.overlay(g);
                    this.port = newPort;
                    g.setColor(bg);
                    g.setXORMode(fg);
                    this.overlay(g);
                }
            }
        }
        super.mouseMoved(ev);
    }

    public void overlay(Graphics g) {
        super.overlay(g);
        this.paintPort(this.graph.getGraphics());
        if (this.start != null && (this.transitionButton.isSelected() || this.selfRoutedTransitionButton.isSelected()) && this.current != null) {
            g.drawLine(this.start.x, this.start.y, this.current.x, this.current.y);
        }
    }

    protected void paintPort(Graphics g) {
        if (this.port != null) {
            boolean offset = GraphConstants.getOffset((Map)this.port.getAttributes()) != null;
            Rectangle r = offset ? this.port.getBounds().getBounds() : this.port.getParentView().getBounds().getBounds();
            r = (Rectangle)this.graph.toScreen(new Rectangle(r));
            int s = 3;
            r.translate(-s, -s);
            r.setSize(r.width + 2 * s, r.height + 2 * s);
            JaWEGraphUI ui = (JaWEGraphUI)this.graph.getUI();
            ui.paintCell(g, (CellView)this.port, r, true);
        }
    }

    protected JPopupMenu createPopupMenu(Object cell) {
        JPopupMenu menu = new JPopupMenu();
        BarFactory jbf = new BarFactory(this.ED);
        if (!(cell != null && (cell instanceof Participant || cell instanceof Process || cell instanceof BlockActivity || cell instanceof Transition || cell instanceof Start || cell instanceof End) || !(this.graph instanceof ProcessGraph))) {
            menu.add(jbf.createMenuItem(Utils.getUnqualifiedClassName(class$org$enhydra$jawe$actions$Cut == null ? (class$org$enhydra$jawe$actions$Cut = JaWEMarqueeHandler.class$("org.enhydra.jawe.actions.Cut")) : class$org$enhydra$jawe$actions$Cut), false));
            menu.add(jbf.createMenuItem(Utils.getUnqualifiedClassName(class$org$enhydra$jawe$actions$Copy == null ? (class$org$enhydra$jawe$actions$Copy = JaWEMarqueeHandler.class$("org.enhydra.jawe.actions.Copy")) : class$org$enhydra$jawe$actions$Copy), false));
            menu.add(jbf.createMenuItem(Utils.getUnqualifiedClassName(class$org$enhydra$jawe$actions$PasteAt == null ? (class$org$enhydra$jawe$actions$PasteAt = JaWEMarqueeHandler.class$("org.enhydra.jawe.actions.PasteAt")) : class$org$enhydra$jawe$actions$PasteAt), false));
            if (!this.graph.isSelectionEmpty() && cell != null) {
                menu.addSeparator();
            }
        }
        if (!this.graph.isSelectionEmpty() && cell != null) {
            menu.add(jbf.createMenuItem(Utils.getUnqualifiedClassName(class$org$enhydra$jawe$actions$Delete == null ? (class$org$enhydra$jawe$actions$Delete = JaWEMarqueeHandler.class$("org.enhydra.jawe.actions.Delete")) : class$org$enhydra$jawe$actions$Delete), false));
            menu.addSeparator();
        }
        if (cell != null && !(cell instanceof Start) && !(cell instanceof End)) {
            if (cell instanceof Transition && this.graph instanceof ProcessGraph) {
                Transition t = (Transition)cell;
                boolean isCircular = Utils.isCircularTransition(t.getAttributes());
                if (!isCircular) {
                    boolean isRouting = Utils.isRoutingTransition(t.getAttributes());
                    if (t.getSourceActivity() instanceof Start || t.getTargetActivity() instanceof End) {
                        if (!isRouting) {
                            menu.add(jbf.createMenuItem(Utils.getUnqualifiedClassName(class$org$enhydra$jawe$actions$SetSelfRouting == null ? (class$org$enhydra$jawe$actions$SetSelfRouting = JaWEMarqueeHandler.class$("org.enhydra.jawe.actions.SetSelfRouting")) : class$org$enhydra$jawe$actions$SetSelfRouting), false));
                        } else {
                            menu.add(jbf.createMenuItem(Utils.getUnqualifiedClassName(class$org$enhydra$jawe$actions$SetNoRouting == null ? (class$org$enhydra$jawe$actions$SetNoRouting = JaWEMarqueeHandler.class$("org.enhydra.jawe.actions.SetNoRouting")) : class$org$enhydra$jawe$actions$SetNoRouting), false));
                        }
                    } else {
                        menu.add(jbf.createMenuItem(Utils.getUnqualifiedClassName(class$org$enhydra$jawe$actions$EditProperties == null ? (class$org$enhydra$jawe$actions$EditProperties = JaWEMarqueeHandler.class$("org.enhydra.jawe.actions.EditProperties")) : class$org$enhydra$jawe$actions$EditProperties), false));
                        if (!isRouting) {
                            menu.add(jbf.createMenuItem(Utils.getUnqualifiedClassName(class$org$enhydra$jawe$actions$AddPoint == null ? (class$org$enhydra$jawe$actions$AddPoint = JaWEMarqueeHandler.class$("org.enhydra.jawe.actions.AddPoint")) : class$org$enhydra$jawe$actions$AddPoint), false));
                            menu.add(jbf.createMenuItem(Utils.getUnqualifiedClassName(class$org$enhydra$jawe$actions$RemovePoint == null ? (class$org$enhydra$jawe$actions$RemovePoint = JaWEMarqueeHandler.class$("org.enhydra.jawe.actions.RemovePoint")) : class$org$enhydra$jawe$actions$RemovePoint), false));
                            menu.add(jbf.createMenuItem(Utils.getUnqualifiedClassName(class$org$enhydra$jawe$actions$SetSelfRouting == null ? (class$org$enhydra$jawe$actions$SetSelfRouting = JaWEMarqueeHandler.class$("org.enhydra.jawe.actions.SetSelfRouting")) : class$org$enhydra$jawe$actions$SetSelfRouting), false));
                        } else {
                            menu.add(jbf.createMenuItem(Utils.getUnqualifiedClassName(class$org$enhydra$jawe$actions$SetNoRouting == null ? (class$org$enhydra$jawe$actions$SetNoRouting = JaWEMarqueeHandler.class$("org.enhydra.jawe.actions.SetNoRouting")) : class$org$enhydra$jawe$actions$SetNoRouting), false));
                        }
                    }
                } else {
                    menu.add(jbf.createMenuItem(Utils.getUnqualifiedClassName(class$org$enhydra$jawe$actions$EditProperties == null ? (class$org$enhydra$jawe$actions$EditProperties = JaWEMarqueeHandler.class$("org.enhydra.jawe.actions.EditProperties")) : class$org$enhydra$jawe$actions$EditProperties), false));
                }
            } else {
                menu.add(jbf.createMenuItem(Utils.getUnqualifiedClassName(class$org$enhydra$jawe$actions$EditProperties == null ? (class$org$enhydra$jawe$actions$EditProperties = JaWEMarqueeHandler.class$("org.enhydra.jawe.actions.EditProperties")) : class$org$enhydra$jawe$actions$EditProperties), false));
            }
            if (cell instanceof Process || cell instanceof Subflow || cell instanceof BlockActivity) {
                Subflow sbflw;
                WorkflowProcess wp;
                boolean toAdd = true;
                if (cell instanceof Subflow && (wp = (sbflw = (Subflow)cell).getReferencedWorkflowProcess(this.graph.getXMLPackage())) == null) {
                    toAdd = false;
                }
                if (toAdd) {
                    menu.add(jbf.createMenuItem(Utils.getUnqualifiedClassName(class$org$enhydra$jawe$actions$EditCell == null ? (class$org$enhydra$jawe$actions$EditCell = JaWEMarqueeHandler.class$("org.enhydra.jawe.actions.EditCell")) : class$org$enhydra$jawe$actions$EditCell), false));
                }
            }
            if (cell instanceof Process) {
                menu.add(jbf.createMenuItem(Utils.getUnqualifiedClassName(class$org$enhydra$jawe$actions$MakeCopyOfProcess == null ? (class$org$enhydra$jawe$actions$MakeCopyOfProcess = JaWEMarqueeHandler.class$("org.enhydra.jawe.actions.MakeCopyOfProcess")) : class$org$enhydra$jawe$actions$MakeCopyOfProcess), false));
            }
        }
        if (cell instanceof Activity && !(cell instanceof Process) && !(cell instanceof Start) && !(cell instanceof End)) {
            menu.add(jbf.createMenuItem("ReferredDocument", false));
        }
        if (cell instanceof Participant) {
            menu.addSeparator();
            menu.add(jbf.createMenuItem(Utils.getUnqualifiedClassName(class$org$enhydra$jawe$actions$MoveUpParticipant == null ? (class$org$enhydra$jawe$actions$MoveUpParticipant = JaWEMarqueeHandler.class$("org.enhydra.jawe.actions.MoveUpParticipant")) : class$org$enhydra$jawe$actions$MoveUpParticipant), false));
            menu.add(jbf.createMenuItem(Utils.getUnqualifiedClassName(class$org$enhydra$jawe$actions$MoveDownParticipant == null ? (class$org$enhydra$jawe$actions$MoveDownParticipant = JaWEMarqueeHandler.class$("org.enhydra.jawe.actions.MoveDownParticipant")) : class$org$enhydra$jawe$actions$MoveDownParticipant), false));
        }
        return menu;
    }

    public Point getPopupPoint() {
        return this.popupPoint;
    }

    public boolean acceptsSourceOrTarget(PortView port, boolean source, PortView firstPort, boolean circularTransition) {
        TreeNode p;
        if (port != null && port.getCell() != null && port.getCell() instanceof DefaultPort && (p = ((DefaultPort)port.getCell()).getParent()) instanceof Linkable) {
            boolean usingBubbles = JaWEConfig.getInstance().getUseBubblesStatus();
            if (source) {
                Activity act;
                if (!((Linkable)((Object)p)).acceptsSource()) {
                    return false;
                }
                if (usingBubbles && p instanceof Activity && Utils.hasConnectedEndBubble(act = (Activity)((Object)p)) && !circularTransition) {
                    JOptionPane.showMessageDialog(this.ED.getWindow(), ResourceManager.getLanguageDependentString("ErrorLastActivityCannotHaveOutgoingTransitions"), JaWE.getAppTitle(), 0);
                    return false;
                }
                return true;
            }
            if (!((Linkable)((Object)p)).acceptsTarget()) {
                return false;
            }
            TreeNode srcCell = ((DefaultPort)firstPort.getCell()).getParent();
            if (usingBubbles && p instanceof End && srcCell instanceof Start) {
                JOptionPane.showMessageDialog(this.ED.getWindow(), ResourceManager.getLanguageDependentString("ErrorCannotConnectStartAndEnd"), JaWE.getAppTitle(), 0);
                return false;
            }
            if (p instanceof Activity) {
                Activity act = (Activity)((Object)p);
                Set trns = act.getIncomingTransitions();
                if (usingBubbles) {
                    Set saNETrns;
                    Object[] trnsArr;
                    if ((trns.size() == 1 || trns.size() == 2) && (((Transition)(trnsArr = trns.toArray())[0]).getSourceActivity() instanceof Start || trns.size() == 2 && ((Transition)trnsArr[1]).getSourceActivity() instanceof Start) && !circularTransition) {
                        JOptionPane.showMessageDialog(this.ED.getWindow(), ResourceManager.getLanguageDependentString("ErrorFirstActivityCannotHaveIncomingTransitions"), JaWE.getAppTitle(), 0);
                        return false;
                    }
                    if (trns.size() > 0 && srcCell instanceof Start && (trns.size() > 1 || trns.size() == 1 && !Utils.hasCircularTransitions(trns))) {
                        JOptionPane.showMessageDialog(this.ED.getWindow(), ResourceManager.getLanguageDependentString("ErrorFirstActivityCannotHaveIncomingTransitions"), JaWE.getAppTitle(), 0);
                        return false;
                    }
                    if (act instanceof End && ((saNETrns = ((Activity)((Object)srcCell)).getNonExceptionalOutgoingTransitions()).size() > 1 || saNETrns.size() == 1 && !Utils.hasCircularTransitions(saNETrns))) {
                        JOptionPane.showMessageDialog(this.ED.getWindow(), ResourceManager.getLanguageDependentString("ErrorLastActivityCannotHaveOutgoingTransitions"), JaWE.getAppTitle(), 0);
                        return false;
                    }
                }
                if (trns.size() > 0) {
                    Iterator it = trns.iterator();
                    while (it.hasNext()) {
                        Activity src = ((Transition)it.next()).getSourceActivity();
                        if (!src.equals(srcCell)) continue;
                        JOptionPane.showMessageDialog(this.ED.getWindow(), ResourceManager.getLanguageDependentString("ErrorActivityCannotHaveMoreThenOneIncomingOutgoingTransitionFromToTheSameActivity"), JaWE.getAppTitle(), 0);
                        return false;
                    }
                }
            }
            return true;
        }
        return false;
    }

    public Hashtable getSpecialButtons() {
        Hashtable<String, JToggleButton> buttons = new Hashtable<String, JToggleButton>();
        ButtonGroup group = new ButtonGroup();
        if (this.ED instanceof ProcessEditor) {
            buttons.put("selectTool", this.selectButton);
            buttons.put("participantTool", this.participantButton);
            buttons.put("subflowActivityTool", this.subflowActivityButton);
            buttons.put("blockActivityTool", this.blockActivityButton);
            buttons.put("startTool", this.startButton);
            buttons.put("endTool", this.endButton);
            buttons.put("automaticStartEndTool", this.automaticStartEndButton);
            buttons.put("genericActivityTool", this.genericActivityButton);
            buttons.put("routeActivityTool", this.routeActivityButton);
            buttons.put("transitionTool", this.transitionButton);
            buttons.put("selfRoutedTransitionTool", this.selfRoutedTransitionButton);
            buttons.put("circularTransitionTool", this.circularTransitionButton);
        } else {
            group.add(this.selectButton);
            buttons.put("selectTool", this.selectButton);
            group.add(this.processButton);
            buttons.put("processActivityTool", this.processButton);
            group.add(this.automaticStartEndButton);
            buttons.put("automaticStartEndTool", this.automaticStartEndButton);
        }
        this.selectButton.doClick();
        return buttons;
    }

    public JToggleButton getSelectButton() {
        return this.selectButton;
    }

    public JToggleButton getProcessButton() {
        return this.processButton;
    }

    public JToggleButton getParticipantButton() {
        return this.participantButton;
    }

    public JToggleButton getSubflowActivityButton() {
        return this.subflowActivityButton;
    }

    public JToggleButton getBlockActivityButton() {
        return this.blockActivityButton;
    }

    public JToggleButton getStartButton() {
        return this.startButton;
    }

    public JToggleButton getEndButton() {
        return this.endButton;
    }

    public JToggleButton getGenericActivityButton() {
        return this.genericActivityButton;
    }

    public JToggleButton getRouteActivityButton() {
        return this.routeActivityButton;
    }

    public JToggleButton getTransitionButton() {
        return this.transitionButton;
    }

    public JToggleButton getSelfRoutedTransitionButton() {
        return this.selfRoutedTransitionButton;
    }

    public JToggleButton getCircularTransitionButton() {
        return this.circularTransitionButton;
    }

    public void enableBubblesButtons(boolean enable) {
        this.startButton.setEnabled(enable);
        this.endButton.setEnabled(enable);
        this.automaticStartEndButton.setEnabled(enable);
    }

    private void setProperCursor() {
        if (this.persistent) {
            Iterator it = this.ED.getSpecialButtons().values().iterator();
            while (it.hasNext()) {
                JToggleButton source = (JToggleButton)it.next();
                if (!source.isSelected()) continue;
                this.setProperCursor(source);
                return;
            }
        }
    }

    private void setProperCursor(JToggleButton source) {
        if (source.equals(this.participantButton)) {
            this.graph.setCursor(this.participantCursor);
        } else if (source.equals(this.processButton)) {
            this.graph.setCursor(this.processCursor);
        } else if (source.equals(this.subflowActivityButton)) {
            this.graph.setCursor(this.subflowActivityCursor);
        } else if (source.equals(this.blockActivityButton)) {
            this.graph.setCursor(this.blockActivityCursor);
        } else if (source.equals(this.startButton)) {
            this.graph.setCursor(this.startCursor);
        } else if (source.equals(this.endButton)) {
            this.graph.setCursor(this.endCursor);
        } else if (source.equals(this.automaticStartEndButton)) {
            this.automaticStartEndButton.setSelected(false);
            this.selectButton.setSelected(true);
        } else if (source.equals(this.genericActivityButton)) {
            this.graph.setCursor(this.genericActivityCursor);
        } else if (source.equals(this.routeActivityButton)) {
            this.graph.setCursor(this.routeActivityCursor);
        } else if (source.equals(this.transitionButton)) {
            this.graph.setCursor(this.transitionCursor);
        } else if (source.equals(this.selfRoutedTransitionButton)) {
            this.graph.setCursor(this.selfRoutedTransitionCursor);
        } else if (source.equals(this.circularTransitionButton)) {
            this.graph.setCursor(this.circularTransitionCursor);
        } else {
            this.graph.setCursor(Cursor.getDefaultCursor());
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    class AL
    implements ActionListener {
        AL() {
        }

        public void actionPerformed(ActionEvent ev) {
            JToggleButton source = (JToggleButton)ev.getSource();
            JaWEMarqueeHandler.this.setProperCursor(source);
        }
    }

    class ASEML
    extends MouseAdapter {
        ASEML() {
        }

        public void mousePressed(MouseEvent ev) {
            if (JaWEMarqueeHandler.this.ED instanceof PackageEditor) {
                Set activities = JaWEGraphModel.getAllActivitiesInModel(JaWEMarqueeHandler.this.graph.getModel());
                if (activities != null) {
                    Iterator it = activities.iterator();
                    while (it.hasNext()) {
                        Activity act = (Activity)it.next();
                        ProcessEditor pe = act.getImplementationEditor();
                        if (pe == null) continue;
                        ProcessGraph pg = (ProcessGraph)pe.getGraph();
                        pg.getWorkflowManager().createGraphStarts((WorkflowProcess)pg.getPropertyObject(), true, true);
                        pg.getWorkflowManager().createGraphEnds((WorkflowProcess)pg.getPropertyObject(), true, true);
                        Set blockActs = pg.getWorkflowManager().getBlockActivities(true);
                        Iterator itBas = blockActs.iterator();
                        while (itBas.hasNext()) {
                            BlockActivity ba = (BlockActivity)itBas.next();
                            ProcessEditor bwe = ba.getImplementationEditor();
                            if (bwe == null) continue;
                            ProcessGraph bag = (ProcessGraph)bwe.getGraph();
                            bag.getWorkflowManager().createGraphStarts((WorkflowProcess)pg.getPropertyObject(), true, true);
                            bag.getWorkflowManager().createGraphEnds((WorkflowProcess)pg.getPropertyObject(), true, true);
                        }
                    }
                }
            } else {
                JaWEMarqueeHandler.this.workflowManager.createGraphStarts((WorkflowProcess)JaWEMarqueeHandler.this.graph.getPropertyObject(), true, true);
                JaWEMarqueeHandler.this.workflowManager.createGraphEnds((WorkflowProcess)JaWEMarqueeHandler.this.graph.getPropertyObject(), true, true);
            }
            JaWEMarqueeHandler.this.ED.getStatusBar().updateMessage();
        }
    }

    class ML
    extends MouseAdapter {
        ML() {
        }

        public void mousePressed(MouseEvent ev) {
            if (ev.getClickCount() == 2) {
                JaWEMarqueeHandler.this.persistent = true;
            } else {
                JaWEMarqueeHandler.this.persistent = false;
            }
        }
    }
}

