/*
 * Decompiled with CFR 0.152.
 */
package org.enhydra.jawe;

import java.awt.Cursor;
import java.awt.Graphics;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Window;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Observable;
import java.util.Observer;
import javax.swing.JComponent;
import javax.swing.JOptionPane;
import javax.swing.SwingUtilities;
import javax.swing.TransferHandler;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.MutableTreeNode;
import org.enhydra.jawe.AbstractGraph;
import org.enhydra.jawe.JaWE;
import org.enhydra.jawe.JaWEConfig;
import org.enhydra.jawe.ResourceManager;
import org.enhydra.jawe.WorkflowElement;
import org.enhydra.jawe.WorkflowManager;
import org.enhydra.jawe.graph.Activity;
import org.enhydra.jawe.graph.ActivityView;
import org.enhydra.jawe.graph.BlockActivity;
import org.enhydra.jawe.graph.End;
import org.enhydra.jawe.graph.Participant;
import org.enhydra.jawe.graph.ParticipantView;
import org.enhydra.jawe.graph.Start;
import org.enhydra.jawe.xml.XMLElement;
import org.enhydra.jawe.xml.elements.Transition;
import org.jgraph.JGraph;
import org.jgraph.graph.CellHandle;
import org.jgraph.graph.CellMapper;
import org.jgraph.graph.CellView;
import org.jgraph.graph.ConnectionSet;
import org.jgraph.graph.DefaultPort;
import org.jgraph.graph.GraphConstants;
import org.jgraph.graph.GraphContext;
import org.jgraph.graph.GraphLayoutCache;
import org.jgraph.graph.GraphModel;
import org.jgraph.graph.GraphTransferable;
import org.jgraph.graph.ParentMap;
import org.jgraph.plaf.basic.BasicGraphUI;

public class JaWEGraphUI
extends BasicGraphUI {
    protected boolean canMouseReleaseSelectCell = true;
    protected Point insertionPoint = null;

    public AbstractGraph getGraph() {
        return (AbstractGraph)this.graph;
    }

    public void setInsertionPoint(Point p) {
        this.insertionPoint = p;
    }

    protected void paintBackground(Graphics g) {
        Rectangle pageBounds = new Rectangle(0, 0, this.graph.getWidth(), this.graph.getHeight());
        if (this.graph.isGridVisible()) {
            this.paintGrid(this.graph.getGridSize(), g, pageBounds);
        }
    }

    protected boolean startEditing(Object cell, MouseEvent event) {
        if (cell instanceof WorkflowElement) {
            Window parentW = this.getGraph().getEditor().getWindow();
            ((WorkflowElement)cell).showPropertyDialog(parentW, this.getGraph());
            return true;
        }
        return false;
    }

    public void startEditingAtCell(JGraph graph, Object cell) {
        if (cell != null) {
            this.startEditing(cell, null);
        }
    }

    protected MouseListener createMouseListener() {
        return new PEMouseHandler();
    }

    public CellHandle createHandle(GraphContext context) {
        if (context != null && !context.isEmpty() && this.graph.isEnabled()) {
            return new PERootHandle(context);
        }
        return null;
    }

    protected Observer createGraphViewObserver() {
        return new PEGraphViewObserver();
    }

    protected TransferHandler createTransferHandler() {
        return new PETransferHandler();
    }

    public void insertCells(Object[] cells, Map viewAttributeMap, ConnectionSet cs, boolean clone, int dx, int dy) {
        WorkflowManager wm = this.getGraph().getWorkflowManager();
        XMLElement wp = this.getGraph().getPropertyObject();
        String appTitle = JaWE.getAppTitle();
        HashSet<Object> cellsToCloneOrPaste = new HashSet<Object>();
        boolean dispMessage = false;
        for (int i = 0; i < cells.length; ++i) {
            if (!(cells[i] instanceof Participant || cells[i] instanceof Start || cells[i] instanceof End || cells[i] instanceof BlockActivity)) {
                if (cells[i] instanceof Activity && ((org.enhydra.jawe.xml.elements.Activity)((Activity)cells[i]).getUserObject()).getOwnerProcess() != wp) {
                    JOptionPane.showMessageDialog(this.getGraph().getEditor().getWindow(), ResourceManager.getLanguageDependentString("ErrorCrossGraphCopyIsForbidden"), appTitle, 0);
                    return;
                }
                cellsToCloneOrPaste.add(cells[i]);
                if (!(cells[i] instanceof Activity) || ((Activity)cells[i]).getChildren() != null && ((Activity)cells[i]).getPort() != null) continue;
                DefaultPort port = new DefaultPort((Object)"Center");
                ((Activity)cells[i]).add((MutableTreeNode)port);
                continue;
            }
            if (cells[i] instanceof org.enhydra.jawe.graph.Transition) continue;
            dispMessage = true;
        }
        if (cellsToCloneOrPaste.size() != cells.length) {
            if (dispMessage) {
                JOptionPane.showMessageDialog(this.getGraph().getEditor().getWindow(), ResourceManager.getLanguageDependentString("WarningOnlyGenericSubflowAndRouteActivitiesCanBePastedOrCloned"), appTitle, 2);
            }
            cells = cellsToCloneOrPaste.toArray();
        }
        if (cellsToCloneOrPaste.size() > 0) {
            Map cellMap = this.graph.cloneCells(cells);
            viewAttributeMap = GraphConstants.replaceKeys((Map)cellMap, (Map)viewAttributeMap);
            cs = new ConnectionSet();
            if (clone) {
                Iterator it = viewAttributeMap.entrySet().iterator();
                while (it.hasNext()) {
                    Map.Entry entry = it.next();
                    Object userObject = ((DefaultMutableTreeNode)entry.getKey()).getUserObject();
                    Map map = (Map)entry.getValue();
                    GraphConstants.setValue((Map)map, (Object)userObject);
                    if (!(entry.getKey() instanceof org.enhydra.jawe.graph.Transition)) continue;
                    org.enhydra.jawe.graph.Transition tr = (org.enhydra.jawe.graph.Transition)entry.getKey();
                    Transition trUo = (Transition)tr.getUserObject();
                    Activity source = null;
                    Activity target = null;
                    Iterator it1 = cellMap.entrySet().iterator();
                    while (it1.hasNext()) {
                        Map.Entry en1 = it1.next();
                        if (!(en1.getKey() instanceof Activity)) continue;
                        org.enhydra.jawe.xml.elements.Activity actUo = (org.enhydra.jawe.xml.elements.Activity)((Activity)en1.getKey()).getUserObject();
                        if (trUo.getFrom() == actUo) {
                            source = (Activity)en1.getValue();
                            tr.setSource(null);
                            trUo.setFrom((XMLElement)((org.enhydra.jawe.xml.elements.Activity)source.getUserObject()));
                        }
                        if (trUo.getTo() != actUo) continue;
                        target = (Activity)en1.getValue();
                        tr.setTarget(null);
                        trUo.setTo((XMLElement)((org.enhydra.jawe.xml.elements.Activity)target.getUserObject()));
                    }
                    if (source == null || target == null) continue;
                    cs.connect((Object)tr, (Object)source.getPort(), (Object)target.getPort());
                }
            }
            Object[] insert = new Object[cells.length];
            for (int i = 0; i < cells.length; ++i) {
                insert[i] = cellMap.get(cells[i]);
            }
            if (dx != 0 || dy != 0) {
                GraphConstants.translate(viewAttributeMap.values(), (double)dx, (double)dy);
            }
            wm.insertCellsAndArrangeParticipants(insert, viewAttributeMap, cs);
        }
    }

    public class PETransferHandler
    extends TransferHandler {
        protected boolean isCut = false;
        protected Object out;
        protected Object in;
        protected int inCount = 0;

        public boolean canImport(JComponent comp, DataFlavor[] flavors) {
            return true;
        }

        protected final Transferable createTransferable(JComponent c) {
            if (c instanceof JGraph) {
                JGraph graph = (JGraph)c;
                Object[] cells = JaWEGraphUI.this.graphLayoutCache.order(graph.getSelectionCells());
                if (cells != null && cells.length > 0) {
                    boolean dispMessage = false;
                    HashSet<Object> cellsToCopy = new HashSet<Object>();
                    for (int i = 0; i < cells.length; ++i) {
                        if (!(cells[i] instanceof Participant || cells[i] instanceof Start || cells[i] instanceof End || cells[i] instanceof BlockActivity)) {
                            cellsToCopy.add(cells[i]);
                            continue;
                        }
                        if (cells[i] instanceof org.enhydra.jawe.graph.Transition) continue;
                        dispMessage = true;
                    }
                    HashSet cellsToRemove = new HashSet();
                    Iterator it = cellsToCopy.iterator();
                    while (it.hasNext()) {
                        Object obj = it.next();
                        if (!(obj instanceof org.enhydra.jawe.graph.Transition)) continue;
                        boolean sourceOK = false;
                        boolean targetOK = false;
                        Iterator it2 = cellsToCopy.iterator();
                        while (it2.hasNext()) {
                            Object obj2 = it2.next();
                            if (!(obj2 instanceof Activity)) continue;
                            if (((org.enhydra.jawe.graph.Transition)obj).getSourceActivity() == obj2) {
                                sourceOK = true;
                            }
                            if (((org.enhydra.jawe.graph.Transition)obj).getTargetActivity() != obj2) continue;
                            targetOK = true;
                        }
                        if (sourceOK && targetOK) continue;
                        cellsToRemove.add(obj);
                    }
                    cellsToCopy.removeAll(cellsToRemove);
                    if (cellsToCopy.size() != cells.length) {
                        if (dispMessage) {
                            String appTitle = JaWE.getAppTitle();
                            JOptionPane.showMessageDialog(JaWEGraphUI.this.getGraph().getEditor().getWindow(), ResourceManager.getLanguageDependentString("WarningOnlyGenericSubflowAndRouteActivitiesCanBeCopied"), appTitle, 2);
                        }
                        if ((cells = cellsToCopy.toArray()).length == 0) {
                            return null;
                        }
                    }
                    this.out = cells;
                    ParentMap pm = ParentMap.create((GraphModel)JaWEGraphUI.this.graphModel, (Object[])cells, (boolean)false, (boolean)true);
                    ConnectionSet cs = ConnectionSet.create((GraphModel)JaWEGraphUI.this.graphModel, (Object[])cells, (boolean)false);
                    Map viewAttributes = GraphConstants.createAttributes((Object[])cells, (CellMapper)JaWEGraphUI.this.graphLayoutCache);
                    Rectangle2D bounds = graph.getCellBounds((Object[])this.out);
                    return this.create(graph, cells, viewAttributes, bounds, cs, pm);
                }
            }
            return null;
        }

        protected GraphTransferable create(JGraph graph, Object[] cells, Map viewAttributes, Rectangle2D bounds, ConnectionSet cs, ParentMap pm) {
            return new GraphTransferable(cells, viewAttributes, bounds, cs, pm);
        }

        protected void exportDone(JComponent comp, Transferable data, int action) {
            if (comp instanceof JGraph && data instanceof GraphTransferable && action == 2) {
                JGraph graph = (JGraph)comp;
                Object[] cells = ((GraphTransferable)data).getCells();
                this.removeCells(graph, cells);
            }
            JaWEGraphUI.this.updateHandle();
            JaWEGraphUI.this.setInsertionLocation(null);
        }

        public void exportToClipboard(JComponent compo, Clipboard clip, int action) {
            this.isCut = action == 2;
            super.exportToClipboard(compo, clip, action);
        }

        public int getSourceActions(JComponent c) {
            return 3;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public boolean importData(JComponent comp, Transferable t) {
            try {
                if (comp instanceof JGraph) {
                    JGraph graph = (JGraph)comp;
                    if (t.isDataFlavorSupported(GraphTransferable.dataFlavor)) {
                        Object obj = t.getTransferData(GraphTransferable.dataFlavor);
                        GraphTransferable gt = (GraphTransferable)obj;
                        if (this.out != gt.getCells() || JaWEGraphUI.this.insertionLocation == null) {
                            boolean bl = this.handleInsert(graph, gt);
                            return bl;
                        }
                        boolean bl = true;
                        return bl;
                    }
                }
            }
            catch (Exception exception) {
            }
            finally {
                this.isCut = false;
            }
            return false;
        }

        protected boolean handleInsert(JGraph graph, GraphTransferable t) {
            boolean c;
            Object[] cells = t.getCells();
            boolean bl = c = this.out != cells || !this.isCut;
            if (this.in != cells) {
                this.inCount = c ? 1 : 0;
            }
            this.in = cells;
            int dx = this.inCount * (int)graph.getGridSize();
            int dy = this.inCount * (int)graph.getGridSize();
            Map attributeMap = null;
            if (JaWEGraphUI.this.insertionLocation != null || JaWEGraphUI.this.insertionPoint != null) {
                Point p = t.getBounds().getBounds().getLocation();
                Point insPoint = JaWEGraphUI.this.insertionLocation;
                if (insPoint == null) {
                    insPoint = JaWEGraphUI.this.insertionPoint;
                }
                if (JaWEConfig.getInstance().getGridStatus()) {
                    int gridsize = JaWEConfig.getInstance().getGridSize();
                    int deltax = insPoint.x % gridsize;
                    int deltay = insPoint.y % gridsize;
                    int halfgrid = gridsize / 2;
                    insPoint.x = deltax > halfgrid ? (insPoint.x += gridsize - deltax) : (insPoint.x -= deltax);
                    insPoint.y = deltay > halfgrid ? (insPoint.y += gridsize - deltay) : (insPoint.y -= deltay);
                }
                dx = insPoint.x - p.x;
                dy = insPoint.y - p.y;
                if (JaWEGraphUI.this.insertionPoint != null) {
                    attributeMap = t.getAttributeMap();
                    GraphConstants.translate(attributeMap.values(), (double)dx, (double)dy);
                    Rectangle rect = t.getBounds().getBounds();
                    rect.translate(dx, dy);
                    t.getBounds().setRect(rect);
                    dx = 0;
                    dy = 0;
                    this.inCount = 0;
                }
            }
            ++this.inCount;
            if (cells == this.out || graph.isDropEnabled()) {
                if (attributeMap == null) {
                    attributeMap = t.getAttributeMap();
                }
                JaWEGraphUI.this.insertCells(cells, attributeMap, t.getConnectionSet(), c, dx, dy);
                return true;
            }
            return false;
        }

        protected void removeCells(JGraph graph, Object[] cells) {
            WorkflowManager dm = JaWEGraphUI.this.getGraph().getWorkflowManager();
            dm.removeCellsAndArrangeParticipants(cells);
        }
    }

    public class PEGraphViewObserver
    extends BasicGraphUI.GraphViewObserver {
        public PEGraphViewObserver() {
            super((BasicGraphUI)JaWEGraphUI.this);
        }

        public void update(Observable o, Object arg) {
            super.update(o, arg);
            JaWEGraphUI.this.canMouseReleaseSelectCell = false;
        }
    }

    public class PERootHandle
    extends BasicGraphUI.RootHandle {
        public PERootHandle(GraphContext ctx) {
            super((BasicGraphUI)JaWEGraphUI.this, ctx);
        }

        protected Point2D getInitialLocation(Object[] cells) {
            try {
                return super.getInitialLocation(cells);
            }
            catch (Throwable thr) {
                return null;
            }
        }

        public void mouseReleased(MouseEvent event) {
            if (event != null && !event.isConsumed()) {
                if (this.activeHandle != null) {
                    this.activeHandle.mouseReleased(event);
                    this.activeHandle = null;
                } else if (this.isMoving && !event.getPoint().equals(this.start)) {
                    if (this.cachedBounds != null) {
                        int dx = event.getX() - (int)this.start.getX();
                        int dy = event.getY() - (int)this.start.getY();
                        Point2D tmp = JaWEGraphUI.this.graph.fromScreen(GraphConstants.createPoint((double)dx, (double)dy));
                        GraphLayoutCache.translateViews((CellView[])this.views, (double)tmp.getX(), (double)tmp.getY());
                    }
                    if (JaWEConfig.getInstance().getGridStatus() && this.views[0] instanceof ActivityView) {
                        ActivityView view = (ActivityView)this.views[0];
                        Rectangle2D rect = view.getBounds();
                        int dx = 0;
                        int dy = 0;
                        int gridsize = JaWEConfig.getInstance().getGridSize();
                        int deltax = (int)rect.getX() % gridsize;
                        int deltay = (int)rect.getY() % gridsize;
                        int halfgrid = gridsize / 2;
                        dx = deltax > halfgrid ? (dx += gridsize - deltax) : (dx -= deltax);
                        dy = deltay > halfgrid ? (dy += gridsize - deltay) : (dy -= deltay);
                        Point2D tmp = JaWEGraphUI.this.graph.fromScreen(GraphConstants.createPoint((double)dx, (double)dy));
                        GraphLayoutCache.translateViews((CellView[])this.views, (double)tmp.getX(), (double)tmp.getY());
                    }
                    Object[] all = JaWEGraphUI.this.graphLayoutCache.getAllDescendants(this.views);
                    if (event.isControlDown() && JaWEGraphUI.this.graph.isCloneable()) {
                        Object[] cells = JaWEGraphUI.this.graph.getDescendants(this.context.getCells());
                        ConnectionSet cs = ConnectionSet.create((GraphModel)JaWEGraphUI.this.graphModel, (Object[])cells, (boolean)false);
                        cs.addConnections((CellView[])all);
                        Map propertyMap = GraphConstants.createAttributes((Object[])all, null);
                        JaWEGraphUI.this.insertCells(this.context.getCells(), propertyMap, cs, true, 0, 0);
                    } else if (JaWEGraphUI.this.graph.isMoveable()) {
                        Map propertyMap = GraphConstants.createAttributes((Object[])all, null);
                        WorkflowManager dm = JaWEGraphUI.this.getGraph().getWorkflowManager();
                        dm.moveCellsAndArrangeParticipants(propertyMap);
                    }
                    event.consume();
                }
            }
            this.start = null;
        }
    }

    public class PEMouseHandler
    extends BasicGraphUI.MouseHandler {
        public PEMouseHandler() {
            super((BasicGraphUI)JaWEGraphUI.this);
        }

        public void mousePressed(MouseEvent e) {
            this.handler = null;
            if (!e.isConsumed() && JaWEGraphUI.this.graph.isEnabled()) {
                DefaultMutableTreeNode child;
                DefaultMutableTreeNode parent;
                Object fcell;
                JaWEGraphUI.this.graph.requestFocus();
                int s = JaWEGraphUI.this.graph.getTolerance();
                Rectangle2D r = JaWEGraphUI.this.graph.fromScreen(GraphConstants.createRect((double)(e.getX() - s), (double)(e.getY() - s), (double)(2 * s), (double)(2 * s)));
                JaWEGraphUI.this.focus = JaWEGraphUI.this.focus != null && JaWEGraphUI.this.focus.intersects(JaWEGraphUI.this.graph.getGraphics(), r) ? JaWEGraphUI.this.focus : null;
                Point2D point = JaWEGraphUI.this.graph.fromScreen(GraphConstants.createPoint((Point2D)e.getPoint()));
                this.cell = JaWEGraphUI.this.graph.getNextViewAt(JaWEGraphUI.this.focus, point.getX(), point.getY());
                if (JaWEGraphUI.this.focus == null) {
                    this.cell = JaWEGraphUI.this.graph.getNextViewAt(JaWEGraphUI.this.focus, point.getX(), point.getY());
                    JaWEGraphUI.this.focus = this.cell;
                } else {
                    this.cell = JaWEGraphUI.this.focus;
                }
                if (JaWEGraphUI.this.focus != null && (fcell = JaWEGraphUI.this.focus.getCell()) instanceof Activity && (parent = (DefaultMutableTreeNode)(child = (DefaultMutableTreeNode)fcell).getParent()) != null) {
                    parent.insert(child, parent.getChildCount() - 1);
                    ((ParticipantView)JaWEGraphUI.this.focus.getParentView()).refreshChildViews();
                }
                JaWEGraphUI.this.cancelEditing(JaWEGraphUI.this.graph);
                if (this.cell != null && !JaWEGraphUI.this.graph.isCellSelected(this.cell.getCell())) {
                    JaWEGraphUI.this.selectCellForEvent(this.cell.getCell(), e);
                    JaWEGraphUI.this.canMouseReleaseSelectCell = false;
                }
                if (e.getClickCount() == JaWEGraphUI.this.graph.getEditClickCount() && JaWEGraphUI.this.focus != null && !SwingUtilities.isRightMouseButton(e)) {
                    JaWEGraphUI.this.graph.startEditingAtCell(JaWEGraphUI.this.focus.getCell());
                    e.consume();
                    this.cell = null;
                } else if (!JaWEGraphUI.this.isToggleSelectionEvent(e) && !JaWEGraphUI.this.isForceMarqueeEvent(e) && JaWEGraphUI.this.focus != null) {
                    if (JaWEGraphUI.this.handle != null) {
                        JaWEGraphUI.this.handle.mousePressed(e);
                        this.handler = JaWEGraphUI.this.handle;
                    }
                } else if (!(JaWEGraphUI.this.isToggleSelectionEvent(e) && JaWEGraphUI.this.focus != null || JaWEGraphUI.this.marquee == null)) {
                    JaWEGraphUI.this.marquee.mousePressed(e);
                    if (JaWEGraphUI.this.focus == null) {
                        Object[] cells = new ArrayList().toArray();
                        JaWEGraphUI.this.selectCellsForEvent(cells, e);
                    }
                    this.handler = JaWEGraphUI.this.marquee;
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void mouseDragged(MouseEvent e) {
            Object[] sc = JaWEGraphUI.this.graph.getSelectionCells();
            if (sc != null) {
                for (int i = 0; i < sc.length; ++i) {
                    if (!(sc[i] instanceof Participant)) continue;
                    e.consume();
                    return;
                }
            }
            BasicGraphUI.autoscroll((JGraph)JaWEGraphUI.this.graph, (Point)e.getPoint());
            if (this.handler == JaWEGraphUI.this.marquee) {
                JaWEGraphUI.this.marquee.mouseDragged(e);
            } else if (this.handler == null && !JaWEGraphUI.this.isEditing(JaWEGraphUI.this.graph) && JaWEGraphUI.this.focus != null) {
                if (!JaWEGraphUI.this.graph.isCellSelected(JaWEGraphUI.this.focus.getCell())) {
                    this.cell = null;
                }
                if (JaWEGraphUI.this.handle != null) {
                    JaWEGraphUI.this.handle.mousePressed(e);
                }
                this.handler = JaWEGraphUI.this.handle;
            }
            if (JaWEGraphUI.this.handle != null && this.handler == JaWEGraphUI.this.handle) {
                JaWEGraphUI.this.handle.mouseDragged(e);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void mouseReleased(MouseEvent e) {
            try {
                if (e != null && !e.isConsumed()) {
                    if (this.handler == JaWEGraphUI.this.marquee) {
                        JaWEGraphUI.this.marquee.mouseReleased(e);
                    } else if (this.handler == JaWEGraphUI.this.handle && JaWEGraphUI.this.handle != null) {
                        JaWEGraphUI.this.handle.mouseReleased(e);
                    }
                    if (!e.isConsumed() && JaWEGraphUI.this.focus != null && !SwingUtilities.isRightMouseButton(e) && JaWEGraphUI.this.canMouseReleaseSelectCell) {
                        JaWEGraphUI.this.selectCellForEvent(JaWEGraphUI.this.focus.getCell(), e);
                    }
                    JaWEGraphUI.this.canMouseReleaseSelectCell = true;
                }
                Object var3_2 = null;
            }
            catch (Throwable throwable) {
                Object var3_3 = null;
                JaWEGraphUI.this.insertionLocation = null;
                this.handler = null;
                this.cell = null;
                throw throwable;
            }
            JaWEGraphUI.this.insertionLocation = null;
            this.handler = null;
            this.cell = null;
        }

        public void mouseMoved(MouseEvent e) {
            if (JaWEGraphUI.this.graph != null && JaWEGraphUI.this.graph.isEnabled()) {
                if (JaWEGraphUI.this.marquee != null) {
                    JaWEGraphUI.this.marquee.mouseMoved(e);
                }
                if (JaWEGraphUI.this.handle != null) {
                    JaWEGraphUI.this.handle.mouseMoved(e);
                }
                if (!e.isConsumed()) {
                    JaWEGraphUI.this.graph.setCursor(Cursor.getDefaultCursor());
                }
            }
        }
    }
}

