/*
 * Decompiled with CFR 0.152.
 */
package org.enhydra.jawe;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.Stack;
import javax.swing.event.EventListenerList;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.MutableTreeNode;
import javax.swing.tree.TreeNode;
import javax.swing.undo.CannotRedoException;
import javax.swing.undo.CannotUndoException;
import javax.swing.undo.CompoundEdit;
import javax.swing.undo.UndoableEdit;
import javax.swing.undo.UndoableEditSupport;
import org.enhydra.jawe.ResourceManager;
import org.enhydra.jawe.graph.Activity;
import org.enhydra.jawe.graph.Participant;
import org.enhydra.jawe.graph.Transition;
import org.jgraph.event.GraphModelEvent;
import org.jgraph.event.GraphModelListener;
import org.jgraph.graph.CellView;
import org.jgraph.graph.ConnectionSet;
import org.jgraph.graph.DefaultGraphCell;
import org.jgraph.graph.Edge;
import org.jgraph.graph.GraphCell;
import org.jgraph.graph.GraphConstants;
import org.jgraph.graph.GraphLayoutCache;
import org.jgraph.graph.GraphModel;
import org.jgraph.graph.ParentMap;
import org.jgraph.graph.Port;

public class JaWEGraphModel
extends UndoableEditSupport
implements Serializable,
GraphModel {
    protected transient EventListenerList listenerList = new EventListenerList();
    protected transient Iterator emptyIterator = new EmptyIterator();
    protected List roots = new ArrayList();
    protected boolean asksAllowsChildren = false;
    static /* synthetic */ Class class$org$jgraph$event$GraphModelListener;

    public int getRootCount() {
        return this.roots.size();
    }

    public Object getRootAt(int index) {
        return this.roots.get(index);
    }

    public int getIndexOfRoot(Object root) {
        return this.roots.indexOf(root);
    }

    public boolean contains(Object node) {
        Object parentNode = null;
        while ((parentNode = this.getParent(node)) != null) {
            node = parentNode;
        }
        return this.roots.contains(node);
    }

    public Map getAttributes(Object node) {
        if (node instanceof GraphCell) {
            return ((GraphCell)node).getAttributes();
        }
        return null;
    }

    public Object getSource(Object edge) {
        if (edge instanceof Edge) {
            return ((Edge)edge).getSource();
        }
        return null;
    }

    public Object getTarget(Object edge) {
        if (edge instanceof Edge) {
            return ((Edge)edge).getTarget();
        }
        return null;
    }

    public boolean acceptsSource(Object edge, Object port) {
        return true;
    }

    public boolean acceptsTarget(Object edge, Object port) {
        return true;
    }

    public Iterator edges(Object port) {
        if (port instanceof Port) {
            return ((Port)port).edges();
        }
        return this.emptyIterator;
    }

    public boolean isEdge(Object edge) {
        return edge instanceof Edge;
    }

    public boolean isPort(Object port) {
        return port instanceof Port;
    }

    public Map cloneCells(Object[] cells) {
        Hashtable<DefaultGraphCell, DefaultGraphCell> map = new Hashtable<DefaultGraphCell, DefaultGraphCell>();
        ArrayList<Object> q = new ArrayList<Object>();
        for (int i = 0; i < cells.length; ++i) {
            q.add(cells[i]);
        }
        while (!q.isEmpty()) {
            DefaultMutableTreeNode p;
            Object node = q.remove(0);
            if (!(node instanceof DefaultGraphCell)) continue;
            for (int i = 0; i < this.getChildCount(node); ++i) {
                q.add(this.getChild(node, i));
            }
            DefaultGraphCell cell = (DefaultGraphCell)node;
            DefaultGraphCell clone = (DefaultGraphCell)cell.clone();
            Object par = this.getParent(cell);
            if (par != null && (p = (DefaultMutableTreeNode)map.get(par)) != null) {
                p.add((MutableTreeNode)clone);
            }
            map.put(cell, clone);
        }
        Iterator it = map.values().iterator();
        while (it.hasNext()) {
            Port anchor;
            Object obj = it.next();
            if (!(obj instanceof Port) || (anchor = ((Port)obj).getAnchor()) == null) continue;
            ((Port)obj).setAnchor((Port)map.get(anchor));
        }
        return map;
    }

    public Object getParent(Object child) {
        if (child != null && child instanceof TreeNode) {
            return ((TreeNode)child).getParent();
        }
        return null;
    }

    public int getIndexOfChild(Object parent, Object child) {
        if (parent == null || child == null) {
            return -1;
        }
        return ((TreeNode)parent).getIndex((TreeNode)child);
    }

    public Object getChild(Object parent, int index) {
        if (parent instanceof TreeNode) {
            return ((TreeNode)parent).getChildAt(index);
        }
        return null;
    }

    public int getChildCount(Object parent) {
        if (parent instanceof TreeNode) {
            return ((TreeNode)parent).getChildCount();
        }
        return 0;
    }

    public boolean isLeaf(Object node) {
        if (this.asksAllowsChildren && node instanceof TreeNode) {
            return !((TreeNode)node).getAllowsChildren();
        }
        return ((TreeNode)node).isLeaf();
    }

    public void insert(Object[] roots, Map attributes, ConnectionSet cs, ParentMap pm, UndoableEdit[] edits) {
        String undoMsg = ResourceManager.getLanguageDependentString("MessageInsertingObjects");
        GraphModelEdit edit = this.createInsertEdit(roots, attributes, cs, pm, edits, undoMsg);
        if (edit != null) {
            edit.execute();
            if (edits != null) {
                for (int i = 0; i < edits.length; ++i) {
                    if (!(edits[i] instanceof GraphModelEvent.ExecutableGraphChange)) continue;
                    ((GraphModelEvent.ExecutableGraphChange)edits[i]).execute();
                }
            }
            this.postEdit(edit);
        }
    }

    public void remove(Object[] roots) {
        String undoMsg = ResourceManager.getLanguageDependentString("MessageRemovingObjects");
        GraphModelEdit edit = this.createRemoveEdit(roots, undoMsg);
        if (edit != null) {
            edit.execute();
            this.postEdit(edit);
        }
    }

    public void edit(Map attributes, ConnectionSet cs, ParentMap pm, UndoableEdit[] edits) {
        if ((attributes == null || attributes.isEmpty()) && (cs == null || cs.isEmpty()) && pm == null && edits != null && edits.length == 1) {
            if (edits[0] instanceof GraphModelEvent.ExecutableGraphChange) {
                ((GraphModelEvent.ExecutableGraphChange)edits[0]).execute();
            }
            this.postEdit(edits[0]);
        } else {
            String undoMsg = ResourceManager.getLanguageDependentString("MessageEditingObject");
            GraphModelEdit edit = this.createCellEdit(attributes, cs, pm, edits, undoMsg);
            if (edit != null) {
                edit.execute();
                if (edits != null) {
                    for (int i = 0; i < edits.length; ++i) {
                        if (!(edits[i] instanceof GraphModelEvent.ExecutableGraphChange)) continue;
                        ((GraphModelEvent.ExecutableGraphChange)edits[i]).execute();
                    }
                }
                this.postEdit(edit);
            }
        }
    }

    public void editFonts(Map attributes) {
        GraphModelEdit edit = this.createCellEdit(attributes, null, null, null, null);
        if (edit != null) {
            edit.execute();
        }
    }

    public void removeBubbles(Object[] bubbles, GraphModelListener gml) {
        this.removeGraphModelListener(gml);
        GraphModelEdit edit = this.createRemoveEdit(bubbles, null);
        if (edit != null) {
            edit.execute();
        }
        this.addGraphModelListener(gml);
    }

    public void insertAndEdit(Object[] roots, Map attributes, ConnectionSet cs, ParentMap pm, UndoableEdit[] edits, String undoMsg) {
        GraphModelEdit edit = this.createInsertEdit(roots, attributes, cs, pm, edits, undoMsg);
        if (edit != null) {
            edit.execute();
            if (edits != null) {
                for (int i = 0; i < edits.length; ++i) {
                    if (!(edits[i] instanceof GraphModelEvent.ExecutableGraphChange)) continue;
                    ((GraphModelEvent.ExecutableGraphChange)edits[i]).execute();
                }
            }
            this.postEdit(edit);
        }
    }

    public void removeAndEdit(Object[] roots, Map attributes, String name) {
        GraphModelEdit edit = this.createRemoveAndCellEdit(roots, attributes, name);
        if (edit != null) {
            edit.execute();
            this.postEdit(edit);
        }
    }

    public void toBack(Object[] cells) {
        GraphModelLayerEdit edit = this.createLayerEdit(cells, -2);
        if (edit != null) {
            edit.execute();
            this.postEdit((UndoableEdit)((Object)edit));
        }
    }

    public void toFront(Object[] cells) {
        GraphModelLayerEdit edit = this.createLayerEdit(cells, -1);
        if (edit != null) {
            edit.execute();
            this.postEdit((UndoableEdit)((Object)edit));
        }
    }

    protected GraphModelLayerEdit createLayerEdit(Object[] cells, int layer) {
        return new GraphModelLayerEdit(cells, layer);
    }

    protected GraphModelEdit createInsertEdit(Object[] cells, Map attributeMap, ConnectionSet cs, ParentMap pm, UndoableEdit[] edits, String name) {
        GraphModelEdit edit = this.createEdit(cells, null, attributeMap, cs, pm, name);
        if (edit != null) {
            if (edits != null) {
                for (int i = 0; i < edits.length; ++i) {
                    edit.addEdit(edits[i]);
                }
            }
            edit.end();
        }
        return edit;
    }

    protected GraphModelEdit createRemoveEdit(Object[] cells, String name) {
        ParentMap pm;
        ConnectionSet cs = ConnectionSet.create((GraphModel)this, (Object[])cells, (boolean)true);
        GraphModelEdit edit = this.createEdit(null, cells, null, cs, pm = ParentMap.create((GraphModel)this, (Object[])cells, (boolean)true, (boolean)false), name);
        if (edit != null) {
            edit.end();
        }
        return edit;
    }

    protected GraphModelEdit createCellEdit(Map attributes, ConnectionSet cs, ParentMap pm, UndoableEdit[] edits, String name) {
        GraphModelEdit edit = this.createEdit(null, null, attributes, cs, pm, name);
        if (edit != null) {
            if (edits != null) {
                for (int i = 0; i < edits.length; ++i) {
                    edit.addEdit(edits[i]);
                }
            }
            edit.end();
        }
        return edit;
    }

    protected GraphModelEdit createEdit(Object[] inserted, Object[] removed, Map attributes, ConnectionSet cs, ParentMap pm, String name) {
        return new GraphModelEdit(inserted, removed, attributes, cs, pm, name);
    }

    protected GraphModelEdit createRemoveAndCellEdit(Object[] cells, Map attributes, String name) {
        ParentMap pm;
        ConnectionSet cs = ConnectionSet.create((GraphModel)this, (Object[])cells, (boolean)true);
        GraphModelEdit edit = this.createEdit(null, cells, attributes, cs, pm = ParentMap.create((GraphModel)this, (Object[])cells, (boolean)true, (boolean)false), name);
        if (edit != null) {
            edit.end();
        }
        return edit;
    }

    protected Object[] handleInsert(Object[] cells) {
        Object[] inserted = null;
        if (cells != null) {
            for (int i = 0; i < cells.length; ++i) {
                if (this.getParent(cells[i]) != null) continue;
                this.roots.add(cells[i]);
            }
            inserted = JaWEGraphModel.getDescendants(this, cells).toArray();
        }
        return inserted;
    }

    protected Object[] handleRemove(Object[] cells) {
        ArrayList<Object> removedRoots = new ArrayList<Object>();
        if (cells != null) {
            for (int i = 0; i < cells.length; ++i) {
                if (this.getParent(cells[i]) != null || !this.roots.remove(cells[i])) continue;
                removedRoots.add(cells[i]);
            }
        }
        return removedRoots.toArray();
    }

    protected ParentMap handleParentMap(ParentMap parentMap) {
        if (parentMap != null) {
            ParentMap undo = new ParentMap();
            Iterator it = parentMap.entries();
            while (it.hasNext()) {
                ParentMap.Entry entry = (ParentMap.Entry)it.next();
                Object child = entry.getChild();
                Object parent = entry.getParent();
                undo.addEntry(child, this.getParent(child));
                if (parent == null) {
                    if (child instanceof MutableTreeNode) {
                        ((MutableTreeNode)child).removeFromParent();
                    }
                } else if (parent instanceof DefaultMutableTreeNode && child instanceof MutableTreeNode) {
                    ((DefaultMutableTreeNode)parent).add((MutableTreeNode)child);
                }
                boolean isRoot = this.roots.contains(child);
                if (parent == null && !isRoot) {
                    this.roots.add(child);
                    continue;
                }
                if (parent == null || !isRoot) continue;
                this.roots.remove(child);
            }
            return undo;
        }
        return null;
    }

    protected Map handleAttributes(Map attributes) {
        if (attributes != null) {
            Hashtable undo = new Hashtable();
            Iterator it = attributes.entrySet().iterator();
            while (it.hasNext()) {
                Map.Entry entry = it.next();
                Object cell = entry.getKey();
                Map deltaNew = (Map)entry.getValue();
                if (cell instanceof GraphCell) {
                    Map deltaOld = ((GraphCell)cell).changeAttributes(deltaNew);
                    undo.put(cell, deltaOld);
                    continue;
                }
                Map attr = this.getAttributes(cell);
                if (attr == null) continue;
                Map deltaOld = GraphConstants.applyMap((Map)deltaNew, (Map)attr);
                undo.put(cell, deltaOld);
            }
            return undo;
        }
        return null;
    }

    protected ConnectionSet handleConnectionSet(ConnectionSet cs) {
        if (cs != null) {
            ConnectionSet csundo = new ConnectionSet();
            Iterator it = cs.connections();
            while (it.hasNext()) {
                ConnectionSet.Connection c = (ConnectionSet.Connection)it.next();
                Object edge = c.getEdge();
                if (c.isSource()) {
                    csundo.connect(edge, this.getSource(edge), true);
                } else {
                    csundo.connect(edge, this.getTarget(edge), false);
                }
                this.handleConnection(c);
            }
            return csundo;
        }
        return null;
    }

    protected void handleConnection(ConnectionSet.Connection c) {
        Object edge = c.getEdge();
        Object old = c.isSource() ? this.getSource(edge) : this.getTarget(edge);
        Object port = c.getPort();
        if (port != old) {
            this.connect(edge, old, c.isSource(), true);
            if (this.contains(port) && this.contains(edge)) {
                this.connect(edge, port, c.isSource(), false);
            }
        }
    }

    protected void connect(Object edge, Object port, boolean isSource, boolean remove) {
        if (port instanceof Port) {
            if (remove) {
                ((Port)port).removeEdge(edge);
            } else {
                ((Port)port).addEdge(edge);
            }
        }
        if (remove) {
            port = null;
        }
        if (edge instanceof Edge) {
            if (isSource) {
                ((Edge)edge).setSource(port);
            } else {
                ((Edge)edge).setTarget(port);
            }
        }
    }

    public void addGraphModelListener(GraphModelListener l) {
        this.listenerList.add(class$org$jgraph$event$GraphModelListener == null ? (class$org$jgraph$event$GraphModelListener = JaWEGraphModel.class$("org.jgraph.event.GraphModelListener")) : class$org$jgraph$event$GraphModelListener, l);
    }

    public void removeGraphModelListener(GraphModelListener l) {
        this.listenerList.remove(class$org$jgraph$event$GraphModelListener == null ? (class$org$jgraph$event$GraphModelListener = JaWEGraphModel.class$("org.jgraph.event.GraphModelListener")) : class$org$jgraph$event$GraphModelListener, l);
    }

    protected void fireGraphChanged(Object source, GraphModelEvent.GraphModelChange edit) {
        Object[] listeners = this.listenerList.getListenerList();
        GraphModelEvent e = null;
        for (int i = listeners.length - 2; i >= 0; i -= 2) {
            if (listeners[i] != (class$org$jgraph$event$GraphModelListener == null ? JaWEGraphModel.class$("org.jgraph.event.GraphModelListener") : class$org$jgraph$event$GraphModelListener)) continue;
            if (e == null) {
                e = new GraphModelEvent(source, edit);
            }
            ((GraphModelListener)listeners[i + 1]).graphChanged(e);
        }
    }

    public GraphModelListener[] getGraphModelListeners() {
        return (GraphModelListener[])this.listenerList.getListeners(class$org$jgraph$event$GraphModelListener == null ? (class$org$jgraph$event$GraphModelListener = JaWEGraphModel.class$("org.jgraph.event.GraphModelListener")) : class$org$jgraph$event$GraphModelListener);
    }

    public static Object getSourceVertex(GraphModel model, Object edge) {
        if (model != null) {
            return model.getParent(model.getSource(edge));
        }
        return null;
    }

    public static Object getTargetVertex(GraphModel model, Object edge) {
        if (model != null) {
            return model.getParent(model.getTarget(edge));
        }
        return null;
    }

    public static Object[] getRoots(GraphModel model) {
        if (model instanceof JaWEGraphModel) {
            return ((JaWEGraphModel)model).roots.toArray();
        }
        Object[] cells = null;
        if (model != null) {
            cells = new Object[model.getRootCount()];
            for (int i = 0; i < cells.length; ++i) {
                cells[i] = model.getRootAt(i);
            }
        }
        return cells;
    }

    public static Set getRootParticipants(GraphModel model) {
        Object[] roots = JaWEGraphModel.getRoots(model);
        if (roots == null || roots.length == 0) {
            return null;
        }
        HashSet<Object> rootDeps = new HashSet<Object>();
        for (int i = 0; i < roots.length; ++i) {
            if (!(roots[i] instanceof Participant)) continue;
            rootDeps.add(roots[i]);
        }
        return rootDeps;
    }

    public static Set getEdges(GraphModel model, Object[] cells) {
        HashSet result = new HashSet();
        Set allCells = JaWEGraphModel.getDescendants(model, cells);
        if (allCells != null) {
            Iterator it = allCells.iterator();
            while (it.hasNext()) {
                Iterator edges = model.edges(it.next());
                while (edges.hasNext()) {
                    result.add(edges.next());
                }
            }
            result.removeAll(allCells);
        }
        return result;
    }

    public static Set getDescendants(GraphModel model, Object[] cells) {
        if (cells != null) {
            Stack<Object> stack = new Stack<Object>();
            for (int i = 0; i < cells.length; ++i) {
                stack.add(cells[i]);
            }
            HashSet result = new HashSet();
            while (!stack.isEmpty()) {
                Object tmp = stack.pop();
                for (int i = 0; i < model.getChildCount(tmp); ++i) {
                    stack.add(model.getChild(tmp, i));
                }
                if (tmp == null) continue;
                result.add(tmp);
            }
            return result;
        }
        return null;
    }

    public static List getDescendantList(GraphModel model, Object[] cells) {
        if (cells != null) {
            Stack<Object> stack = new Stack<Object>();
            for (int i = cells.length - 1; i >= 0; --i) {
                stack.add(cells[i]);
            }
            LinkedList result = new LinkedList();
            while (!stack.isEmpty()) {
                Object tmp = stack.pop();
                for (int i = model.getChildCount(tmp) - 1; i >= 0; --i) {
                    stack.add(model.getChild(tmp, i));
                }
                if (tmp == null) continue;
                result.add(tmp);
            }
            return result;
        }
        return null;
    }

    public static Set getAllCellsInModel(GraphModel model) {
        Set allCellsInModel = JaWEGraphModel.getDescendants(model, JaWEGraphModel.getRoots(model));
        if (allCellsInModel == null || allCellsInModel.size() == 0) {
            return null;
        }
        return allCellsInModel;
    }

    public static Set getAllParticipantsInModel(GraphModel model) {
        if (!(model instanceof JaWEGraphModel)) {
            return null;
        }
        Set allCellsInModel = JaWEGraphModel.getAllCellsInModel(model);
        if (allCellsInModel == null) {
            return null;
        }
        HashSet participants = new HashSet();
        Iterator it = allCellsInModel.iterator();
        while (it.hasNext()) {
            Object cell = it.next();
            if (!(cell instanceof Participant)) continue;
            participants.add(cell);
        }
        if (participants.size() == 0) {
            return null;
        }
        return participants;
    }

    public static Set getAllActivitiesInModel(GraphModel model) {
        if (!(model instanceof JaWEGraphModel)) {
            return null;
        }
        Set allCellsInModel = JaWEGraphModel.getAllCellsInModel(model);
        if (allCellsInModel == null) {
            return null;
        }
        HashSet activities = new HashSet();
        Iterator it = allCellsInModel.iterator();
        while (it.hasNext()) {
            Object cell = it.next();
            if (!(cell instanceof Activity)) continue;
            activities.add(cell);
        }
        if (activities.size() == 0) {
            return null;
        }
        return activities;
    }

    public static Set getAllTransitionsInModel(GraphModel model) {
        if (!(model instanceof JaWEGraphModel)) {
            return null;
        }
        Object[] roots = JaWEGraphModel.getRoots(model);
        if (roots == null || roots.length == 0) {
            return null;
        }
        HashSet<Object> transitions = new HashSet<Object>();
        for (int i = 0; i < roots.length; ++i) {
            if (!(roots[i] instanceof Transition)) continue;
            transitions.add(roots[i]);
        }
        return transitions;
    }

    private void readObject(ObjectInputStream s) throws IOException, ClassNotFoundException {
        s.defaultReadObject();
        this.listenerList = new EventListenerList();
        this.emptyIterator = new EmptyIterator();
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    public static class EmptyIterator
    implements Iterator,
    Serializable {
        public boolean hasNext() {
            return false;
        }

        public Object next() {
            return null;
        }

        public void remove() {
        }
    }

    public class GraphModelLayerEdit
    extends GraphLayoutCache.GraphViewLayerEdit
    implements GraphModelEvent.GraphModelChange {
        protected Object[] parents;

        public GraphModelLayerEdit(Object[] cells, int layer) {
            super((Object)JaWEGraphModel.this, cells, layer);
            HashSet<TreeNode> par = new HashSet<TreeNode>();
            for (int i = 0; i < cells.length; ++i) {
                if (!(cells[i] instanceof TreeNode)) continue;
                par.add(((TreeNode)cells[i]).getParent());
            }
            this.parents = par.toArray();
        }

        public void execute() {
            super.execute();
        }

        public Object getSource() {
            return JaWEGraphModel.this;
        }

        public Object[] getChanged() {
            return this.parents;
        }

        public Object[] getInserted() {
            return null;
        }

        public Object[] getRemoved() {
            return null;
        }

        public Map getPreviousAttributes() {
            return null;
        }

        public ConnectionSet getPreviousConnectionSet() {
            return null;
        }

        public ParentMap getPreviousParentMap() {
            return null;
        }

        public void addImplicitEdit(UndoableEdit edit) {
        }

        public CellView[] getViews(GraphLayoutCache view) {
            return null;
        }

        public void putViews(GraphLayoutCache view, CellView[] cellViews) {
        }

        protected void updateListeners() {
            JaWEGraphModel.this.fireGraphChanged(JaWEGraphModel.this, this);
        }

        protected List getParentList(Object cell) {
            List list = null;
            if (cell instanceof DefaultMutableTreeNode) {
                TreeNode parent = ((DefaultMutableTreeNode)cell).getParent();
                list = parent instanceof DefaultGraphCell ? ((DefaultGraphCell)parent).getChildren() : JaWEGraphModel.this.roots;
            }
            return list;
        }
    }

    public class GraphModelEdit
    extends CompoundEdit
    implements GraphModelEvent.GraphModelChange,
    GraphModelEvent.ExecutableGraphChange {
        protected String name;
        protected Object[] insert;
        protected Object[] changed;
        protected Object[] remove;
        protected Object[] context;
        protected Object[] inserted;
        protected Object[] removed;
        protected Map attributes;
        protected Map previousAttributes;
        protected ParentMap parentMap;
        protected ParentMap previousParentMap;
        protected ConnectionSet connectionSet;
        protected ConnectionSet previousConnectionSet;
        protected Map cellViews = new Hashtable();

        public GraphModelEdit(Object[] inserted, Object[] removed, Map attributes, ConnectionSet connectionSet, ParentMap parentMap, String name) {
            this.insert = inserted;
            this.remove = removed;
            this.connectionSet = connectionSet;
            this.attributes = attributes;
            this.parentMap = parentMap;
            this.name = name;
            this.previousAttributes = attributes;
            this.previousConnectionSet = connectionSet;
            this.previousParentMap = parentMap;
            if (parentMap != null) {
                // empty if block
            }
        }

        public Object[] filterParents(Map childCount, int children) {
            ArrayList list = new ArrayList();
            Iterator it = childCount.entrySet().iterator();
            while (it.hasNext()) {
                Map.Entry entry = it.next();
                if (!(entry.getValue() instanceof Integer) || (Integer)entry.getValue() != children) continue;
                list.add(entry.getKey());
            }
            return list.toArray();
        }

        protected void changeChildCount(Map childCount, Object parent, int change) {
            if (parent != null) {
                Integer count = (Integer)childCount.get(parent);
                if (count == null) {
                    count = new Integer(JaWEGraphModel.this.getChildCount(parent));
                }
                int newValue = count + change;
                childCount.put(parent, new Integer(newValue));
            }
        }

        protected void handleEmptyGroups(Object[] groups) {
            if (groups != null && groups.length > 0) {
                if (this.remove == null) {
                    this.remove = new Object[0];
                }
                Object[] tmp = new Object[this.remove.length + groups.length];
                System.arraycopy(this.remove, 0, tmp, 0, this.remove.length);
                System.arraycopy(groups, 0, tmp, this.remove.length, groups.length);
                this.remove = tmp;
            }
        }

        public boolean isSignificant() {
            return true;
        }

        public String getPresentationName() {
            return this.name;
        }

        public Object getSource() {
            return JaWEGraphModel.this;
        }

        public Object[] getChanged() {
            return this.changed;
        }

        public Object[] getContext() {
            return this.context;
        }

        public Object[] getInserted() {
            return this.inserted;
        }

        public Object[] getRemoved() {
            return this.removed;
        }

        public Map getPreviousAttributes() {
            return this.previousAttributes;
        }

        public Map getAttributes() {
            return this.attributes;
        }

        public ConnectionSet getConnectionSet() {
            return this.connectionSet;
        }

        public ConnectionSet getPreviousConnectionSet() {
            return this.previousConnectionSet;
        }

        public ParentMap getParentMap() {
            return this.parentMap;
        }

        public ParentMap getPreviousParentMap() {
            return this.previousParentMap;
        }

        public void redo() throws CannotRedoException {
            super.redo();
            this.execute();
        }

        public void undo() throws CannotUndoException {
            super.undo();
            this.execute();
        }

        public void execute() {
            HashSet tmp = new HashSet();
            if (this.attributes != null) {
                tmp.addAll(this.attributes.keySet());
            }
            if (this.parentMap != null) {
                tmp.addAll(this.parentMap.getChangedNodes());
            }
            if (this.connectionSet != null) {
                tmp.addAll(this.connectionSet.getChangedEdges());
            }
            if (this.remove != null) {
                for (int i = 0; i < this.remove.length; ++i) {
                    tmp.remove(this.remove[i]);
                }
            }
            this.changed = tmp.toArray();
            Set ctx = JaWEGraphModel.getEdges(JaWEGraphModel.this, this.changed);
            this.context = ctx.toArray();
            this.inserted = this.insert;
            this.removed = this.remove;
            this.remove = JaWEGraphModel.this.handleInsert(this.inserted);
            this.previousParentMap = this.parentMap;
            this.parentMap = JaWEGraphModel.this.handleParentMap(this.parentMap);
            if (this.parentMap != null) {
                tmp.addAll(this.parentMap.getChangedNodes());
            }
            this.previousConnectionSet = this.connectionSet;
            this.connectionSet = JaWEGraphModel.this.handleConnectionSet(this.connectionSet);
            this.insert = JaWEGraphModel.this.handleRemove(this.removed);
            this.previousAttributes = this.attributes;
            this.attributes = JaWEGraphModel.this.handleAttributes(this.attributes);
            this.changed = tmp.toArray();
            JaWEGraphModel.this.fireGraphChanged(JaWEGraphModel.this, this);
        }

        public void putViews(GraphLayoutCache view, CellView[] views) {
            if (view != null && views != null) {
                this.cellViews.put(view, views);
            }
        }

        public CellView[] getViews(GraphLayoutCache view) {
            return (CellView[])this.cellViews.get(view);
        }

        public String toString() {
            int i;
            String s = new String();
            if (this.inserted != null) {
                s = s + "Inserted:\n";
                for (i = 0; i < this.inserted.length; ++i) {
                    s = s + "  " + this.inserted[i] + "\n";
                }
            } else {
                s = s + "None inserted\n";
            }
            if (this.removed != null) {
                s = s + "Removed:\n";
                for (i = 0; i < this.removed.length; ++i) {
                    s = s + "  " + this.removed[i] + "\n";
                }
            } else {
                s = s + "None removed\n";
            }
            if (this.changed != null && this.changed.length > 0) {
                s = s + "Changed:\n";
                for (i = 0; i < this.changed.length; ++i) {
                    s = s + "  " + this.changed[i] + "\n";
                }
            } else {
                s = s + "None changed\n";
            }
            s = this.parentMap != null ? s + this.parentMap.toString() : s + "No parent map\n";
            return s;
        }
    }
}

