/*
 * Decompiled with CFR 0.152.
 */
package org.enhydra.jawe;

import java.awt.Color;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Properties;
import javax.swing.ToolTipManager;
import javax.swing.UIManager;
import org.enhydra.jawe.JaWE;
import org.enhydra.jawe.JaWEConstants;
import org.enhydra.jawe.Utils;
import org.enhydra.jawe.xml.XML;
import org.enhydra.jawe.xml.XMLInterface;

public final class JaWEConfig {
    private static final int MIN_PROCESS_WIDTH = 75;
    private static final int MIN_PROCESS_HEIGHT = 45;
    private static final int MIN_MIN_PARTICIPANT_WIDTH = 150;
    private static final int MIN_MIN_PARTICIPANT_HEIGHT = 50;
    private static final int MIN_PARTICIPANT_NAME_WIDTH = 25;
    private static final int MIN_ACTIVITY_WIDTH = 50;
    private static final int MIN_ACTIVITY_HEIGHT = 30;
    private static final int MIN_GRID_SIZE = 4;
    private static final float MIN_FONT_SIZE = 4.0f;
    private static final float MAX_FONT_SIZE = 36.0f;
    public static final String ON_STATUS = "ON";
    public static final String OFF_STATUS = "OFF";
    public static final String CURRENT_VERSION = "1.2";
    public static final String DEFAULT_STARTING_LOCALE = "";
    public static final String DEFAULT_MANDATORY_CONFORMANCE_CLASS_SETTING_STATUS = "ON";
    public static final String DEFAULT_MANDATORY_CONFORMANCE_CLASS = "";
    public static final String DEFAULT_VALIDATION_STATUS = "ON";
    public static final String DEFAULT_USE_BUBBLES_STATUS = "ON";
    public static final String DEFAULT_ALLOW_UNDEFINED_START = "OFF";
    public static final String DEFAULT_ALLOW_UNDEFINED_END = "OFF";
    public static final String DEFAULT_LOOK_AND_FEEL_CLASS_NAME = "";
    public static final String DEFAULT_RECENT_FILE_LIST_SIZE = "10";
    public static final String DEFAULT_ENCODING = "UTF-8";
    public static final String DEFAULT_FILE_LOCKING_STATUS = "ON";
    public static final String DEFAULT_TOOLTIP_STATUS = "ON";
    public static final String DEFAULT_GRID_STATUS = "ON";
    public static final String DEFAULT_STATUS_BAR_STATUS = "ON";
    public static final String DEFAULT_NAME_WRAPPING_STATUS = "ON";
    public static final String DEFAULT_WRAPPING_STYLE_WORD_STATUS = "ON";
    public static final String DEFAULT_LDAP_COUNT_LIMIT = "0";
    public static final String DEFAULT_LDAP_TIME_LIMIT = "0";
    public static final String DEFAULT_GRID_SIZE = "10";
    public static final String DEFAULT_FONT_SIZE = "12";
    public static final String DEFAULT_PROCESS_WIDTH = "135";
    public static final String DEFAULT_PROCESS_HEIGHT = "65";
    public static final String DEFAULT_MIN_PARTICIPANT_WIDTH = "800";
    public static final String DEFAULT_MIN_PARTICIPANT_HEIGHT = "150";
    public static final String DEFAULT_PARTICIPANT_NAME_WIDTH = "50";
    public static final String DEFAULT_ACTIVITY_WIDTH = "75";
    public static final String DEFAULT_ACTIVITY_HEIGHT = "45";
    public static final String DEFAULT_BACKGROUND_COLOR = "SystemColor.menu";
    public static final String DEFAULT_HIGHLIGHT_COLOR = "SystemColor.inactiveCaptionText";
    public static final String DEFAULT_HANDLE_COLOR = "Color.pink";
    public static final String DEFAULT_MARQUEE_COLOR = "SystemColor.textHighlight";
    public static final String DEFAULT_GRID_COLOR = "SystemColor.textHighlight";
    public static final String DEFAULT_PROCESS_COLOR = "R=58,G=110,B=165";
    public static final String DEFAULT_TRANSITION_COLOR = "SystemColor.textHighlight";
    public static final String DEFAULT_OTHERWISE_TRANSITION_COLOR = "R=255,G=153,B=0";
    public static final String DEFAULT_EXCEPTION_TRANSITION_COLOR = "Color.pink";
    public static final String DEFAULT_DEFAULT_EXCEPTION_TRANSITION_COLOR = "R=204,G=0,B=0";
    public static final String DEFAULT_PARTICIPANT_TEXT_COLOR = "SystemColor.textText";
    public static final String DEFAULT_PARTICIPANT_BORDER_COLOR = "SystemColor.textText";
    public static final String DEFAULT_RESOURCE_SET_PARTICIPANT_COLOR = "R=146,G=146,B=180";
    public static final String DEFAULT_RESOURCE_PARTICIPANT_COLOR = "R=146,G=146,B=160";
    public static final String DEFAULT_ROLE_PARTICIPANT_COLOR = "R=146,G=180,B=146";
    public static final String DEFAULT_ORGANIZATIONAL_UNIT_PARTICIPANT_COLOR = "R=180,G=146,B=146";
    public static final String DEFAULT_HUMAN_PARTICIPANT_COLOR = "R=160,G=146,B=146";
    public static final String DEFAULT_SYSTEM_PARTICIPANT_COLOR = "R=146,G=160,B=146";
    public static final String DEFAULT_FREE_TEXT_EXPRESSION_PARTICIPANT_COLOR = "SystemColor.text";
    public static final String DEFAULT_SELECTED_ACTIVITY__COLOR = "Color.orange";
    public static final String DEFAULT_START_COLOR = "R=0,G=128,B=255";
    public static final String DEFAULT_END_COLOR = "Color.yellow";
    public static final String DEFAULT_START_END_COLOR = "Color.green";
    public static final String DEFAULT_GENERIC_ACTIVITY_COLOR = "SystemColor.textInactiveText";
    public static final String DEFAULT_ROUTE_ACTIVITY_COLOR = "R=216,G=230,B=216";
    public static final String DEFAULT_SUBFLOW_ACTIVITY_COLOR = "R=230,G=216,B=216";
    public static final String DEFAULT_BLOCK_ACTIVITY_COLOR = "R=216,G=216,B=230";
    private static JaWEConfig jaweConfig;
    private String cfn;
    private Properties properties = new Properties();

    public static JaWEConfig getInstance() {
        if (jaweConfig == null) {
            jaweConfig = new JaWEConfig();
        }
        return jaweConfig;
    }

    private JaWEConfig() {
        this.setDefaultValues();
        this.properties.remove("Version");
        this.cfn = JaWEConstants.JAWE_USER_HOME + "/JaWE.conf";
        try {
            FileInputStream is = new FileInputStream(this.cfn);
            this.properties.load(is);
            this.initialize();
            String ver = this.properties.getProperty("Version");
            if (ver == null || !ver.equals(CURRENT_VERSION)) {
                this.properties.setProperty("Version", CURRENT_VERSION);
                this.saveConf();
            }
        }
        catch (Exception ex) {
            this.properties.setProperty("Version", CURRENT_VERSION);
            this.initialize();
            this.saveConf();
        }
    }

    private void setDefaultValues() {
        this.properties.setProperty("Version", CURRENT_VERSION);
        this.properties.setProperty("StartingLocale", "");
        this.properties.setProperty("MandatoryConformanceClassSettingStatus", "ON");
        this.properties.setProperty("MandatoryConformanceClass", "");
        this.properties.setProperty("ValidationStatus", "ON");
        this.properties.setProperty("UseBubblesStatus", "ON");
        this.properties.setProperty("AllowUndefinedStartActivity", "OFF");
        this.properties.setProperty("AllowUndefinedEndActivity", "OFF");
        this.properties.setProperty("LookAndFeelClassName", "");
        this.properties.setProperty("RecentFileListSize", "10");
        this.properties.setProperty("Encoding", DEFAULT_ENCODING);
        this.properties.setProperty("FileLockingStatus", "ON");
        this.properties.setProperty("TooltipStatus", "ON");
        this.properties.setProperty("NameWrappingStatus", "ON");
        this.properties.setProperty("WrappingStyleWordStatus", "ON");
        this.properties.setProperty("GridStatus", "ON");
        this.properties.setProperty("StatusBarStatus", "ON");
        this.properties.setProperty("GridSize", "10");
        this.properties.setProperty("FontSize", DEFAULT_FONT_SIZE);
        this.properties.setProperty("LDAPCountLimit", "0");
        this.properties.setProperty("LDAPTimeLimit", "0");
        this.properties.setProperty("ProcessWidth", DEFAULT_PROCESS_WIDTH);
        this.properties.setProperty("ProcessHeight", DEFAULT_PROCESS_HEIGHT);
        this.properties.setProperty("MinParticipantWidth", DEFAULT_MIN_PARTICIPANT_WIDTH);
        this.properties.setProperty("MinParticipantHeight", DEFAULT_MIN_PARTICIPANT_HEIGHT);
        this.properties.setProperty("ParticipantNameWidth", DEFAULT_PARTICIPANT_NAME_WIDTH);
        this.properties.setProperty("ActivityWidth", DEFAULT_ACTIVITY_WIDTH);
        this.properties.setProperty("ActivityHeight", DEFAULT_ACTIVITY_HEIGHT);
        this.properties.setProperty("BackgroundColor", DEFAULT_BACKGROUND_COLOR);
        this.properties.setProperty("HighlightColor", DEFAULT_HIGHLIGHT_COLOR);
        this.properties.setProperty("HandleColor", "Color.pink");
        this.properties.setProperty("MarqueeColor", "SystemColor.textHighlight");
        this.properties.setProperty("GridColor", "SystemColor.textHighlight");
        this.properties.setProperty("ProcessColor", DEFAULT_PROCESS_COLOR);
        this.properties.setProperty("TransitionColor", "SystemColor.textHighlight");
        this.properties.setProperty("OtherwiseTransitionColor", DEFAULT_OTHERWISE_TRANSITION_COLOR);
        this.properties.setProperty("ExceptionTransitionColor", "Color.pink");
        this.properties.setProperty("DefaultExceptionTransitionColor", DEFAULT_DEFAULT_EXCEPTION_TRANSITION_COLOR);
        this.properties.setProperty("ParticipantTextColor", "SystemColor.textText");
        this.properties.setProperty("ParticipantBorderColor", "SystemColor.textText");
        this.properties.setProperty("ResourceSetParticipantColor", DEFAULT_RESOURCE_SET_PARTICIPANT_COLOR);
        this.properties.setProperty("ResourceParticipantColor", DEFAULT_RESOURCE_PARTICIPANT_COLOR);
        this.properties.setProperty("RoleParticipantColor", DEFAULT_ROLE_PARTICIPANT_COLOR);
        this.properties.setProperty("OrganizationalUnitParticipantColor", DEFAULT_ORGANIZATIONAL_UNIT_PARTICIPANT_COLOR);
        this.properties.setProperty("HumanParticipantColor", DEFAULT_HUMAN_PARTICIPANT_COLOR);
        this.properties.setProperty("SystemParticipantColor", DEFAULT_SYSTEM_PARTICIPANT_COLOR);
        this.properties.setProperty("FreeTextExpressionParticipantColor", DEFAULT_FREE_TEXT_EXPRESSION_PARTICIPANT_COLOR);
        this.properties.setProperty("StartColor", DEFAULT_START_COLOR);
        this.properties.setProperty("EndColor", DEFAULT_END_COLOR);
        this.properties.setProperty("StartEndColor", DEFAULT_START_END_COLOR);
        this.properties.setProperty("SelectedActivityColor", DEFAULT_SELECTED_ACTIVITY__COLOR);
        this.properties.setProperty("GenericActivityColor", DEFAULT_GENERIC_ACTIVITY_COLOR);
        this.properties.setProperty("RouteActivityColor", DEFAULT_ROUTE_ACTIVITY_COLOR);
        this.properties.setProperty("SubFlowActivityColor", DEFAULT_SUBFLOW_ACTIVITY_COLOR);
        this.properties.setProperty("BlockActivityColor", DEFAULT_BLOCK_ACTIVITY_COLOR);
    }

    private void initialize() {
        int aHeight;
        int aWidth;
        int pnWidth;
        int mpHeight;
        int mpWidth;
        int pHeight;
        int pWidth;
        float fs;
        int gs;
        int ltl;
        int lcl;
        boolean sbst;
        boolean gst;
        boolean wswst;
        boolean nmwst;
        boolean tst;
        boolean flst;
        int rfls;
        boolean aie;
        boolean ais;
        boolean ubst;
        boolean vst;
        boolean mccst;
        this.setStartingLocale(this.properties.getProperty("StartingLocale"));
        try {
            String mccsts = this.properties.getProperty("MandatoryConformanceClassSettingStatus");
            mccst = !mccsts.equalsIgnoreCase("OFF");
        }
        catch (Exception ex) {
            mccst = "ON".equalsIgnoreCase("ON");
        }
        this.setMandatoryConformanceClassSettingStatus(mccst);
        this.setMandatoryConformanceClass(this.properties.getProperty("MandatoryConformanceClass"));
        this.setEncoding(this.properties.getProperty("Encoding"));
        try {
            String vsts = this.properties.getProperty("ValidationStatus");
            vst = !vsts.equalsIgnoreCase("OFF");
        }
        catch (Exception ex) {
            vst = "ON".equalsIgnoreCase("ON");
        }
        this.setValidationStatus(vst);
        try {
            String ubsts = this.properties.getProperty("UseBubblesStatus");
            ubst = !ubsts.equalsIgnoreCase("OFF");
        }
        catch (Exception ex) {
            ubst = "ON".equalsIgnoreCase("ON");
        }
        this.setUseBubblesStatus(ubst);
        try {
            String aiss = this.properties.getProperty("AllowUndefinedStartActivity");
            ais = !aiss.equalsIgnoreCase("OFF");
        }
        catch (Exception ex) {
            ais = "OFF".equalsIgnoreCase("ON");
        }
        this.setAllowUndefinedStartActivity(ais);
        try {
            String aies = this.properties.getProperty("AllowUndefinedEndActivity");
            aie = !aies.equalsIgnoreCase("OFF");
        }
        catch (Exception ex) {
            aie = "OFF".equalsIgnoreCase("ON");
        }
        this.setAllowUndefinedStartActivity(aie);
        this.setLookAndFeelClassName(this.properties.getProperty("LookAndFeelClassName"));
        try {
            rfls = Integer.parseInt(this.properties.getProperty("RecentFileListSize"));
        }
        catch (Exception ex) {
            rfls = Integer.parseInt("10");
        }
        this.setRecentFileListSize(rfls);
        try {
            String flss = this.properties.getProperty("FileLockingStatus");
            flst = !flss.equalsIgnoreCase("OFF");
        }
        catch (Exception ex) {
            flst = "ON".equalsIgnoreCase("ON");
        }
        this.setFileLockingStatus(flst);
        try {
            String tss = this.properties.getProperty("TooltipStatus");
            tst = !tss.equalsIgnoreCase("OFF");
        }
        catch (Exception ex) {
            tst = "ON".equalsIgnoreCase("ON");
        }
        this.setTooltipStatus(tst);
        try {
            String nmwsst = this.properties.getProperty("NameWrappingStatus");
            nmwst = !nmwsst.equalsIgnoreCase("OFF");
        }
        catch (Exception ex) {
            nmwst = "ON".equalsIgnoreCase("ON");
        }
        this.setNameWrappingStatus(nmwst);
        try {
            String wswsts = this.properties.getProperty("WrappingStyleWordStatus");
            wswst = !wswsts.equalsIgnoreCase("OFF");
        }
        catch (Exception ex) {
            wswst = "ON".equalsIgnoreCase("ON");
        }
        this.setWrappingStyleWordStatus(wswst);
        try {
            String gss = this.properties.getProperty("GridStatus");
            gst = !gss.equalsIgnoreCase("OFF");
        }
        catch (Exception ex) {
            gst = "ON".equalsIgnoreCase("ON");
        }
        this.setGridStatus(gst);
        try {
            String sbss = this.properties.getProperty("StatusBarStatus");
            sbst = !sbss.equalsIgnoreCase("OFF");
        }
        catch (Exception ex) {
            sbst = "ON".equalsIgnoreCase("ON");
        }
        this.setStatusBarStatus(sbst);
        try {
            lcl = Integer.parseInt(this.properties.getProperty("LDAPCountLimit"));
        }
        catch (Exception ex) {
            lcl = Integer.parseInt("0");
        }
        this.setLDAPCountLimit(lcl);
        try {
            ltl = Integer.parseInt(this.properties.getProperty("LDAPTimeLimit"));
        }
        catch (Exception ex) {
            ltl = Integer.parseInt("0");
        }
        this.setLDAPTimeLimit(ltl);
        try {
            gs = Integer.parseInt(this.properties.getProperty("GridSize"));
        }
        catch (Exception ex) {
            gs = Integer.parseInt("10");
        }
        this.setGridSize(gs);
        try {
            fs = Float.parseFloat(this.properties.getProperty("FontSize"));
        }
        catch (Exception ex) {
            fs = Float.parseFloat(DEFAULT_FONT_SIZE);
        }
        this.setFontSize(fs);
        try {
            pWidth = Integer.parseInt(this.properties.getProperty("ProcessWidth"));
        }
        catch (Exception ex) {
            pWidth = Integer.parseInt(DEFAULT_PROCESS_WIDTH);
        }
        this.setProcessWidth(pWidth);
        try {
            pHeight = Integer.parseInt(this.properties.getProperty("ProcessHeight"));
        }
        catch (Exception ex) {
            pHeight = Integer.parseInt(DEFAULT_PROCESS_HEIGHT);
        }
        this.setProcessHeight(pHeight);
        try {
            mpWidth = Integer.parseInt(this.properties.getProperty("MinParticipantWidth"));
        }
        catch (Exception ex) {
            mpWidth = Integer.parseInt(DEFAULT_MIN_PARTICIPANT_WIDTH);
        }
        this.setMinParticipantWidth(mpWidth);
        try {
            mpHeight = Integer.parseInt(this.properties.getProperty("MinParticipantHeight"));
        }
        catch (Exception ex) {
            mpHeight = Integer.parseInt(DEFAULT_MIN_PARTICIPANT_HEIGHT);
        }
        this.setMinParticipantHeight(mpHeight);
        try {
            pnWidth = Integer.parseInt(this.properties.getProperty("ParticipantNameWidth"));
        }
        catch (Exception ex) {
            pnWidth = Integer.parseInt(DEFAULT_PARTICIPANT_NAME_WIDTH);
        }
        this.setParticipantNameWidth(pnWidth);
        try {
            aWidth = Integer.parseInt(this.properties.getProperty("ActivityWidth"));
        }
        catch (Exception ex) {
            aWidth = Integer.parseInt(DEFAULT_ACTIVITY_WIDTH);
        }
        this.setActivityWidth(aWidth);
        try {
            aHeight = Integer.parseInt(this.properties.getProperty("ActivityHeight"));
        }
        catch (Exception ex) {
            aHeight = Integer.parseInt(DEFAULT_ACTIVITY_HEIGHT);
        }
        this.setActivityHeight(aHeight);
        this.setBackgroundColor(this.properties.getProperty("BackgroundColor"));
        this.setHighlightColor(this.properties.getProperty("HighlightColor"));
        this.setHandleColor(this.properties.getProperty("HandleColor"));
        this.setMarqueeColor(this.properties.getProperty("MarqueeColor"));
        this.setGridColor(this.properties.getProperty("GridColor"));
        this.setProcessColor(this.properties.getProperty("ProcessColor"));
        this.setTransitionColor(this.properties.getProperty("TransitionColor"));
        this.setOtherwiseTransitionColor(this.properties.getProperty("OtherwiseTransitionColor"));
        this.setExceptionTransitionColor(this.properties.getProperty("ExceptionTransitionColor"));
        this.setDefaultExceptionTransitionColor(this.properties.getProperty("DefaultExceptionTransitionColor"));
        this.setParticipantTextColor(this.properties.getProperty("ParticipantTextColor"));
        this.setParticipantBorderColor(this.properties.getProperty("ParticipantBorderColor"));
        this.setResourceSetParticipantColor(this.properties.getProperty("ResourceSetParticipantColor"));
        this.setResourceParticipantColor(this.properties.getProperty("ResourceParticipantColor"));
        this.setRoleParticipantColor(this.properties.getProperty("RoleParticipantColor"));
        this.setOrganizationalUnitParticipantColor(this.properties.getProperty("OrganizationalUnitParticipantColor"));
        this.setHumanParticipantColor(this.properties.getProperty("HumanParticipantColor"));
        this.setSystemParticipantColor(this.properties.getProperty("SystemParticipantColor"));
        this.setFreeTextExpressionParticipantColor(this.properties.getProperty("FreeTextExpressionParticipantColor"));
        this.setStartColor(this.properties.getProperty("StartColor"));
        this.setEndColor(this.properties.getProperty("EndColor"));
        this.setStartEndColor(this.properties.getProperty("StartEndColor"));
        this.setSelectedActivityColor(this.properties.getProperty("SelectedActivityColor"));
        this.setGenericActivityColor(this.properties.getProperty("GenericActivityColor"));
        this.setRouteActivityColor(this.properties.getProperty("RouteActivityColor"));
        this.setSubFlowActivityColor(this.properties.getProperty("SubFlowActivityColor"));
        this.setBlockActivityColor(this.properties.getProperty("BlockActivityColor"));
    }

    public String getStartingLocale() {
        return this.properties.getProperty("StartingLocale");
    }

    public void setStartingLocale(String sl) {
        if (sl != null) {
            this.properties.setProperty("StartingLocale", sl);
        } else {
            this.properties.setProperty("StartingLocale", "");
        }
    }

    public boolean getMandatoryConformanceClassSettingStatus() {
        return this.properties.getProperty("MandatoryConformanceClassSettingStatus").equalsIgnoreCase("ON");
    }

    public void setMandatoryConformanceClassSettingStatus(boolean status) {
        if (status) {
            this.properties.setProperty("MandatoryConformanceClassSettingStatus", "ON");
        } else {
            this.properties.setProperty("MandatoryConformanceClassSettingStatus", "OFF");
        }
    }

    public String getMandatoryConformanceClass() {
        return this.properties.getProperty("MandatoryConformanceClass");
    }

    public void setMandatoryConformanceClass(String mcl) {
        if (mcl != null) {
            this.properties.setProperty("MandatoryConformanceClass", mcl);
        } else {
            this.properties.setProperty("MandatoryConformanceClass", "");
        }
    }

    public String getEncoding() {
        return this.properties.getProperty("Encoding");
    }

    public void setEncoding(String enc) {
        if (enc != null) {
            this.properties.setProperty("Encoding", enc);
        } else {
            this.properties.setProperty("Encoding", DEFAULT_ENCODING);
        }
    }

    public boolean getValidationStatus() {
        return this.properties.getProperty("ValidationStatus").equalsIgnoreCase("ON");
    }

    public void setValidationStatus(boolean status) {
        if (status) {
            this.properties.setProperty("ValidationStatus", "ON");
        } else {
            this.properties.setProperty("ValidationStatus", "OFF");
        }
        JaWE.getXMLInterface().setValidation(status);
    }

    public boolean getUseBubblesStatus() {
        return this.properties.getProperty("UseBubblesStatus").equalsIgnoreCase("ON");
    }

    public void setUseBubblesStatus(boolean status) {
        if (status) {
            this.properties.setProperty("UseBubblesStatus", "ON");
        } else {
            this.properties.setProperty("UseBubblesStatus", "OFF");
        }
    }

    public boolean getAllowUndefinedStartActivity() {
        return this.properties.getProperty("AllowUndefinedStartActivity").equalsIgnoreCase("ON");
    }

    public void setAllowUndefinedStartActivity(boolean allow) {
        if (allow) {
            this.properties.setProperty("AllowUndefinedStartActivity", "ON");
        } else {
            this.properties.setProperty("AllowUndefinedStartActivity", "OFF");
        }
    }

    public boolean getAllowUndefinedEndActivity() {
        return this.properties.getProperty("AllowUndefinedEndActivity").equalsIgnoreCase("ON");
    }

    public void setAllowUndefinedEndActivity(boolean allow) {
        if (allow) {
            this.properties.setProperty("AllowUndefinedEndActivity", "ON");
        } else {
            this.properties.setProperty("AllowUndefinedEndActivity", "OFF");
        }
    }

    public String getLookAndFeelClassName() {
        return this.properties.getProperty("LookAndFeelClassName");
    }

    public void setLookAndFeelClassName(String lafCN) {
        block7: {
            if (lafCN != null) {
                try {
                    if (lafCN.length() == 0) {
                        UIManager.setLookAndFeel(UIManager.getSystemLookAndFeelClassName());
                        this.properties.setProperty("LookAndFeelClassName", "");
                        break block7;
                    }
                    UIManager.setLookAndFeel(lafCN);
                    this.properties.setProperty("LookAndFeelClassName", lafCN);
                }
                catch (Exception ex) {}
            } else {
                this.properties.setProperty("LookAndFeelClassName", "");
                try {
                    UIManager.setLookAndFeel(UIManager.getSystemLookAndFeelClassName());
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }
    }

    public int getRecentFileListSize() {
        return Integer.valueOf(this.properties.getProperty("RecentFileListSize"));
    }

    public void setRecentFileListSize(int rfls) {
        if (rfls < 1) {
            rfls = 1;
        }
        if (rfls > 16) {
            rfls = 16;
        }
        this.properties.setProperty("RecentFileListSize", String.valueOf(rfls));
    }

    public boolean getFileLockingStatus() {
        return this.properties.getProperty("FileLockingStatus").equalsIgnoreCase("ON");
    }

    public void setFileLockingStatus(boolean status) {
        if (status) {
            this.properties.setProperty("FileLockingStatus", "ON");
        } else {
            this.properties.setProperty("FileLockingStatus", "OFF");
        }
        XMLInterface xmlI = JaWE.getXMLInterface();
        if (xmlI instanceof XML) {
            ((XML)xmlI).setFileLockingStatus(status);
            if (status) {
                ((XML)xmlI).lockAllFiles();
            } else {
                ((XML)xmlI).unlockAllFiles();
            }
        }
    }

    public boolean getTooltipStatus() {
        return this.properties.getProperty("TooltipStatus").equalsIgnoreCase("ON");
    }

    public void setTooltipStatus(boolean status) {
        if (status) {
            this.properties.setProperty("TooltipStatus", "ON");
        } else {
            this.properties.setProperty("TooltipStatus", "OFF");
        }
        ToolTipManager.sharedInstance().setEnabled(status);
    }

    public boolean getNameWrappingStatus() {
        return this.properties.getProperty("NameWrappingStatus").equalsIgnoreCase("ON");
    }

    public void setNameWrappingStatus(boolean status) {
        if (status) {
            this.properties.setProperty("NameWrappingStatus", "ON");
        } else {
            this.properties.setProperty("NameWrappingStatus", "OFF");
        }
    }

    public boolean getWrappingStyleWordStatus() {
        return this.properties.getProperty("WrappingStyleWordStatus").equalsIgnoreCase("ON");
    }

    public void setWrappingStyleWordStatus(boolean status) {
        if (status) {
            this.properties.setProperty("WrappingStyleWordStatus", "ON");
        } else {
            this.properties.setProperty("WrappingStyleWordStatus", "OFF");
        }
    }

    public boolean getGridStatus() {
        return this.properties.getProperty("GridStatus").equalsIgnoreCase("ON");
    }

    public void setGridStatus(boolean status) {
        if (status) {
            this.properties.setProperty("GridStatus", "ON");
        } else {
            this.properties.setProperty("GridStatus", "OFF");
        }
    }

    public boolean getStatusBarStatus() {
        return this.properties.getProperty("StatusBarStatus").equalsIgnoreCase("ON");
    }

    public void setStatusBarStatus(boolean status) {
        if (status) {
            this.properties.setProperty("StatusBarStatus", "ON");
        } else {
            this.properties.setProperty("StatusBarStatus", "OFF");
        }
    }

    public int getLDAPCountLimit() {
        return Integer.valueOf(this.properties.getProperty("LDAPCountLimit"));
    }

    public void setLDAPCountLimit(int lcl) {
        if (lcl < 0) {
            lcl = 0;
        }
        this.properties.setProperty("LDAPCountLimit", String.valueOf(lcl));
    }

    public int getLDAPTimeLimit() {
        return Integer.valueOf(this.properties.getProperty("LDAPTimeLimit"));
    }

    public void setLDAPTimeLimit(int ltl) {
        if (ltl < 0) {
            ltl = 0;
        }
        this.properties.setProperty("LDAPTimeLimit", String.valueOf(ltl));
    }

    public int getGridSize() {
        return Integer.valueOf(this.properties.getProperty("GridSize"));
    }

    public void setGridSize(int gs) {
        if (gs < 4) {
            gs = 4;
        }
        this.properties.setProperty("GridSize", String.valueOf(gs));
    }

    public float getFontSize() {
        return Float.valueOf(this.properties.getProperty("FontSize")).floatValue();
    }

    public void setFontSize(float fs) {
        if (fs < 4.0f) {
            fs = 4.0f;
        }
        if (fs > 36.0f) {
            fs = 36.0f;
        }
        this.properties.setProperty("FontSize", String.valueOf(fs));
    }

    public int getProcessWidth() {
        return Integer.valueOf(this.properties.getProperty("ProcessWidth"));
    }

    public void setProcessWidth(int pw) {
        if (pw < 75) {
            pw = 75;
        }
        this.properties.setProperty("ProcessWidth", String.valueOf(pw));
    }

    public int getProcessHeight() {
        return Integer.valueOf(this.properties.getProperty("ProcessHeight"));
    }

    public void setProcessHeight(int ph) {
        if (ph < 45) {
            ph = 45;
        }
        this.properties.setProperty("ProcessHeight", String.valueOf(ph));
    }

    public int getMinParticipantWidth() {
        return Integer.valueOf(this.properties.getProperty("MinParticipantWidth"));
    }

    public void setMinParticipantWidth(int mpw) {
        if (mpw < 150) {
            mpw = 150;
        }
        this.properties.setProperty("MinParticipantWidth", String.valueOf(mpw));
    }

    public int getMinParticipantHeight() {
        return Integer.valueOf(this.properties.getProperty("MinParticipantHeight"));
    }

    public void setMinParticipantHeight(int mph) {
        if (mph < 50) {
            mph = 50;
        }
        this.properties.setProperty("MinParticipantHeight", String.valueOf(mph));
    }

    public int getParticipantNameWidth() {
        return Integer.valueOf(this.properties.getProperty("ParticipantNameWidth"));
    }

    public void setParticipantNameWidth(int pnw) {
        if (pnw < 25) {
            pnw = 25;
        }
        this.properties.setProperty("ParticipantNameWidth", String.valueOf(pnw));
    }

    public int getActivityWidth() {
        return Integer.valueOf(this.properties.getProperty("ActivityWidth"));
    }

    public void setActivityWidth(int aw) {
        if (aw < 50) {
            aw = 50;
        }
        this.properties.setProperty("ActivityWidth", String.valueOf(aw));
    }

    public int getActivityHeight() {
        return Integer.valueOf(this.properties.getProperty("ActivityHeight"));
    }

    public void setActivityHeight(int ah) {
        if (ah < 30) {
            ah = 30;
        }
        this.properties.setProperty("ActivityHeight", String.valueOf(ah));
    }

    public int getInnerActivityWidth() {
        return (int)((double)this.getActivityWidth() * 0.8);
    }

    public int getInnerActivityHeight() {
        return (int)((double)this.getActivityHeight() * 0.8);
    }

    public String getBackgroundColor() {
        return this.properties.getProperty("BackgroundColor");
    }

    public void setBackgroundColor(String col) {
        this.properties.setProperty("BackgroundColor", this.createColorString(col, this.getBackgroundColor()));
    }

    public String getHighlightColor() {
        return this.properties.getProperty("HighlightColor");
    }

    public void setHighlightColor(String col) {
        this.properties.setProperty("HighlightColor", this.createColorString(col, this.getHighlightColor()));
    }

    public String getHandleColor() {
        return this.properties.getProperty("HandleColor");
    }

    public void setHandleColor(String col) {
        this.properties.setProperty("HandleColor", this.createColorString(col, this.getHandleColor()));
    }

    public String getMarqueeColor() {
        return this.properties.getProperty("MarqueeColor");
    }

    public void setMarqueeColor(String col) {
        this.properties.setProperty("MarqueeColor", this.createColorString(col, this.getMarqueeColor()));
    }

    public String getGridColor() {
        return this.properties.getProperty("GridColor");
    }

    public void setGridColor(String col) {
        this.properties.setProperty("GridColor", this.createColorString(col, this.getGridColor()));
    }

    public String getProcessColor() {
        return this.properties.getProperty("ProcessColor");
    }

    public void setProcessColor(String col) {
        this.properties.setProperty("ProcessColor", this.createColorString(col, this.getProcessColor()));
    }

    public String getTransitionColor() {
        return this.properties.getProperty("TransitionColor");
    }

    public void setTransitionColor(String col) {
        this.properties.setProperty("TransitionColor", this.createColorString(col, this.getTransitionColor()));
    }

    public String getOtherwiseTransitionColor() {
        return this.properties.getProperty("OtherwiseTransitionColor");
    }

    public void setOtherwiseTransitionColor(String col) {
        this.properties.setProperty("OtherwiseTransitionColor", this.createColorString(col, this.getOtherwiseTransitionColor()));
    }

    public String getExceptionTransitionColor() {
        return this.properties.getProperty("ExceptionTransitionColor");
    }

    public void setExceptionTransitionColor(String col) {
        this.properties.setProperty("ExceptionTransitionColor", this.createColorString(col, this.getExceptionTransitionColor()));
    }

    public String getDefaultExceptionTransitionColor() {
        return this.properties.getProperty("DefaultExceptionTransitionColor");
    }

    public void setDefaultExceptionTransitionColor(String col) {
        this.properties.setProperty("DefaultExceptionTransitionColor", this.createColorString(col, this.getDefaultExceptionTransitionColor()));
    }

    public String getParticipantTextColor() {
        return this.properties.getProperty("ParticipantTextColor");
    }

    public void setParticipantTextColor(String col) {
        this.properties.setProperty("ParticipantTextColor", this.createColorString(col, this.getParticipantTextColor()));
    }

    public String getParticipantBorderColor() {
        return this.properties.getProperty("ParticipantBorderColor");
    }

    public void setParticipantBorderColor(String col) {
        this.properties.setProperty("ParticipantBorderColor", this.createColorString(col, this.getParticipantBorderColor()));
    }

    public String getResourceSetParticipantColor() {
        return this.properties.getProperty("ResourceSetParticipantColor");
    }

    public void setResourceSetParticipantColor(String col) {
        this.properties.setProperty("ResourceSetParticipantColor", this.createColorString(col, this.getResourceSetParticipantColor()));
    }

    public String getResourceParticipantColor() {
        return this.properties.getProperty("ResourceParticipantColor");
    }

    public void setResourceParticipantColor(String col) {
        this.properties.setProperty("ResourceParticipantColor", this.createColorString(col, this.getResourceParticipantColor()));
    }

    public String getRoleParticipantColor() {
        return this.properties.getProperty("RoleParticipantColor");
    }

    public void setRoleParticipantColor(String col) {
        this.properties.setProperty("RoleParticipantColor", this.createColorString(col, this.getRoleParticipantColor()));
    }

    public String getOrganizationalUnitParticipantColor() {
        return this.properties.getProperty("OrganizationalUnitParticipantColor");
    }

    public void setOrganizationalUnitParticipantColor(String col) {
        this.properties.setProperty("OrganizationalUnitParticipantColor", this.createColorString(col, this.getOrganizationalUnitParticipantColor()));
    }

    public String getHumanParticipantColor() {
        return this.properties.getProperty("HumanParticipantColor");
    }

    public void setHumanParticipantColor(String col) {
        this.properties.setProperty("HumanParticipantColor", this.createColorString(col, this.getHumanParticipantColor()));
    }

    public String getSystemParticipantColor() {
        return this.properties.getProperty("SystemParticipantColor");
    }

    public void setSystemParticipantColor(String col) {
        this.properties.setProperty("SystemParticipantColor", this.createColorString(col, this.getSystemParticipantColor()));
    }

    public String getFreeTextExpressionParticipantColor() {
        return this.properties.getProperty("FreeTextExpressionParticipantColor");
    }

    public void setFreeTextExpressionParticipantColor(String col) {
        this.properties.setProperty("FreeTextExpressionParticipantColor", this.createColorString(col, this.getFreeTextExpressionParticipantColor()));
    }

    public String getStartColor() {
        return this.properties.getProperty("StartColor");
    }

    public void setStartColor(String col) {
        this.properties.setProperty("StartColor", this.createColorString(col, this.getStartColor()));
    }

    public String getEndColor() {
        return this.properties.getProperty("EndColor");
    }

    public void setEndColor(String col) {
        this.properties.setProperty("EndColor", this.createColorString(col, this.getEndColor()));
    }

    public String getStartEndColor() {
        return this.properties.getProperty("StartEndColor");
    }

    public void setStartEndColor(String col) {
        this.properties.setProperty("StartEndColor", this.createColorString(col, this.getStartEndColor()));
    }

    public String getSelectedActivityColor() {
        return this.properties.getProperty("SelectedActivityColor");
    }

    public void setSelectedActivityColor(String col) {
        this.properties.setProperty("SelectedActivityColor", this.createColorString(col, this.getSelectedActivityColor()));
    }

    public String getGenericActivityColor() {
        return this.properties.getProperty("GenericActivityColor");
    }

    public void setGenericActivityColor(String col) {
        this.properties.setProperty("GenericActivityColor", this.createColorString(col, this.getGenericActivityColor()));
    }

    public String getRouteActivityColor() {
        return this.properties.getProperty("RouteActivityColor");
    }

    public void setRouteActivityColor(String col) {
        this.properties.setProperty("RouteActivityColor", this.createColorString(col, this.getRouteActivityColor()));
    }

    public String getSubFlowActivityColor() {
        return this.properties.getProperty("SubFlowActivityColor");
    }

    public void setSubFlowActivityColor(String col) {
        this.properties.setProperty("SubFlowActivityColor", this.createColorString(col, this.getSubFlowActivityColor()));
    }

    public String getBlockActivityColor() {
        return this.properties.getProperty("BlockActivityColor");
    }

    public void setBlockActivityColor(String col) {
        this.properties.setProperty("BlockActivityColor", this.createColorString(col, this.getBlockActivityColor()));
    }

    private String createColorString(String col, String defaultColor) {
        if (col == null) {
            return defaultColor;
        }
        Color c = Utils.getColor(col);
        if (c == null) {
            return defaultColor;
        }
        return col;
    }

    public void restoreDefaultSettings() {
        this.setDefaultValues();
        this.initialize();
    }

    public void saveConf() {
        File ujdir = new File(JaWEConstants.JAWE_USER_HOME);
        if (!ujdir.exists()) {
            try {
                ujdir.mkdir();
            }
            catch (Exception exc) {
                // empty catch block
            }
        }
        try {
            FileOutputStream out = new FileOutputStream(this.cfn);
            this.properties.store(out, "#\n# JaWE configuration\n#\n");
            ((OutputStream)out).close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }
}

