/*
 * Decompiled with CFR 0.152.
 */
package org.enhydra.jawe;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRootPane;
import javax.swing.JTabbedPane;
import javax.swing.JTextArea;
import javax.swing.JToolBar;
import javax.swing.KeyStroke;
import org.enhydra.jawe.ResourceManager;
import org.enhydra.jawe.misc.Version;
import org.enhydra.jawe.xml.XMLButton;

public class JaWEAboutDialog
extends JDialog {
    private JButton okButton;
    private JPanel aboutPnl;
    private JPanel creditsPnl;
    private JPanel infoPnl;
    private JTabbedPane tabContainer;
    private JToolBar buttonToolbar;
    private JPanel txtPnl;
    private JLabel txtJaWE;
    private ActionListener actionHandler = new ActionHandler();

    public static void showAbout(Frame owner, String title, ImageIcon logo) {
        JaWEAboutDialog about = new JaWEAboutDialog(owner, title, logo);
        about.show();
        about = null;
    }

    private JaWEAboutDialog(Frame owner, String title, ImageIcon logo) {
        super(owner, title, true);
        this.createUI();
        this.setResizable(false);
        this.pack();
        Dimension screenSize = Toolkit.getDefaultToolkit().getScreenSize();
        Dimension winsize = this.getSize();
        this.setLocation(screenSize.width / 2 - winsize.width / 2, screenSize.height / 2 - winsize.height / 2);
        this.setLocationRelativeTo(owner);
    }

    private void createUI() {
        this.createButtonPane();
        this.createTabbedPane();
        this.getContentPane().add((Component)this.tabContainer, "Center");
        this.getContentPane().add((Component)this.buttonToolbar, "South");
        this.getRootPane().setDefaultButton(this.okButton);
    }

    private void createButtonPane() {
        Dimension dim = this.getDimension(new String[]{"OK", "Credits", "About"});
        this.okButton = new XMLButton("OK", "OK", dim);
        this.okButton.addActionListener(this.actionHandler);
        this.buttonToolbar = new JToolBar(0);
        this.buttonToolbar.setBorder(BorderFactory.createEmptyBorder(5, 10, 5, 10));
        this.buttonToolbar.setFloatable(false);
        this.buttonToolbar.add(Box.createHorizontalGlue());
        this.buttonToolbar.add(this.okButton);
        this.buttonToolbar.add(Box.createHorizontalGlue());
    }

    private void createTabbedPane() {
        this.createAboutPane();
        this.createCreditsPane();
        this.createInfoPane();
        this.tabContainer = new JTabbedPane();
        this.tabContainer.addTab("About", this.aboutPnl);
        this.tabContainer.addTab("Credits", this.creditsPnl);
        this.tabContainer.addTab("Info", this.infoPnl);
    }

    private void createAboutPane() {
        JLabel aboutLabel = new JLabel(new ImageIcon(ResourceManager.getResource("AboutPicture")), 0);
        aboutLabel.setBorder(BorderFactory.createEtchedBorder());
        this.aboutPnl = new JPanel(new BorderLayout());
        this.txtPnl = new JPanel(new BorderLayout());
        this.txtPnl.setFont(new Font("Serif", 0, 14));
        this.txtPnl.add("North", new JLabel("version: " + Version.getVersion(), 0));
        JLabel vendor = new JLabel("(c) TOGETHER - Teaml\u00f6sungen", 0);
        vendor.setFont(new Font("SansSerif", 1, 14));
        this.txtPnl.add("Center", vendor);
        this.txtPnl.add("South", new JLabel("http://jawe.objectweb.org      e-mail: JaWE@objectweb.org", 0));
        this.aboutPnl.add((Component)aboutLabel, "Center");
        this.aboutPnl.add((Component)this.txtPnl, "South");
    }

    private void createCreditsPane() {
        this.creditsPnl = new JPanel(new BorderLayout());
        JPanel contextPane = new JPanel(new GridBagLayout());
        Insets ins = new Insets(1, 1, 1, 1);
        this.txtJaWE = new JLabel("JaWE");
        this.txtJaWE.setFont(new Font(this.txtJaWE.getFont().getFontName(), 1, 14));
        contextPane.add((Component)this.txtJaWE, new GridBagConstraints(0, 0, 3, 1, 0.0, 0.0, 10, 0, new Insets(10, 1, 1, 1), 0, 0));
        contextPane.add((Component)new JLabel("Java Workflow Editor"), new GridBagConstraints(0, 1, 3, 1, 0.0, 0.0, 10, 0, ins, 0, 0));
        JLabel sponsoredLabel = new JLabel("Sponsored by:");
        sponsoredLabel.setFont(new Font(this.txtJaWE.getFont().getFontName(), 1, 12));
        contextPane.add((Component)sponsoredLabel, new GridBagConstraints(0, 2, 1, 1, 0.0, 0.0, 17, 0, new Insets(15, 1, 1, 1), 0, 0));
        JLabel sponsore1logo = new JLabel(new ImageIcon(ResourceManager.getResource("Sponsore1Logo")));
        sponsore1logo.setBorder(BorderFactory.createEtchedBorder());
        contextPane.add((Component)sponsore1logo, new GridBagConstraints(0, 3, 1, 5, 0.0, 0.0, 17, 2, new Insets(10, 1, 1, 30), 0, 0));
        contextPane.add((Component)new JLabel("(c) TOGETHER - Teaml\u00f6sungen"), new GridBagConstraints(1, 4, 2, 1, 0.0, 0.0, 10, 0, new Insets(25, 1, 1, 1), 0, 0));
        contextPane.add((Component)new JLabel("www.together.at"), new GridBagConstraints(1, 5, 2, 1, 0.0, 0.0, 10, 0, new Insets(5, 1, 1, 1), 0, 0));
        contextPane.add((Component)new JLabel("office@together.at"), new GridBagConstraints(1, 6, 2, 1, 0.0, 0.0, 10, 0, new Insets(2, 1, 1, 1), 0, 0));
        JLabel sponsore2logo = new JLabel(new ImageIcon(ResourceManager.getResource("Sponsore2Logo")));
        sponsore2logo.setBorder(BorderFactory.createEtchedBorder());
        contextPane.add((Component)sponsore2logo, new GridBagConstraints(0, 8, 4, 1, 0.0, 0.0, 17, 0, new Insets(15, 1, 1, 1), 0, 0));
        contextPane.add((Component)new JLabel("www.abacus.ch"), new GridBagConstraints(0, 9, 1, 1, 0.0, 0.0, 17, 0, new Insets(5, 1, 1, 1), 0, 0));
        this.creditsPnl.add((Component)contextPane, "North");
    }

    private void createInfoPane() {
        this.infoPnl = new JPanel(new BorderLayout());
        JPanel contextPane = new JPanel(new GridBagLayout());
        Insets ins = new Insets(1, 1, 1, 1);
        JLabel thanks = new JLabel("Many thanks to all who made this project available:");
        thanks.setFont(new Font(thanks.getFont().getFontName(), 1, thanks.getFont().getSize()));
        contextPane.add((Component)thanks, new GridBagConstraints(0, 0, 2, 1, 0.0, 0.0, 17, 2, ins, 0, 0));
        contextPane.add((Component)new JLabel("jgraph - "), new GridBagConstraints(0, 6, 1, 1, 0.0, 0.0, 13, 0, new Insets(8, 1, 1, 1), 0, 0));
        contextPane.add((Component)new JLabel("www.jgraph.com"), new GridBagConstraints(1, 6, 1, 1, 0.0, 0.0, 17, 0, new Insets(8, 1, 1, 1), 0, 0));
        contextPane.add((Component)new JLabel("javalobby - "), new GridBagConstraints(0, 7, 1, 1, 0.0, 0.0, 13, 0, ins, 0, 0));
        contextPane.add((Component)new JLabel("www.gallant.com/icons.htm"), new GridBagConstraints(1, 7, 1, 1, 0.0, 0.0, 17, 0, ins, 0, 0));
        contextPane.add((Component)new JLabel("WFMC - "), new GridBagConstraints(0, 8, 1, 1, 0.0, 0.0, 13, 0, ins, 0, 0));
        contextPane.add((Component)new JLabel("www.wfmc.org"), new GridBagConstraints(1, 8, 1, 1, 0.0, 0.0, 17, 0, ins, 0, 0));
        JTextArea txtProject = new JTextArea();
        txtProject.setText("Many thanks to:\n\nPilipovic Goran\nDjojic Predrag\nObradovic Vladan\nHarald Meister\nGilles Melon\nPedro Mor\u00f3n\nJakub Nadolny (IT Experts - www.ite.pl)\nIvan Chen\nLuiz Felipe M Ghelle");
        txtProject.setMinimumSize(new Dimension(200, 100));
        txtProject.setPreferredSize(new Dimension(250, 200));
        txtProject.setMaximumSize(new Dimension(350, 350));
        txtProject.setFont(new Font(this.txtJaWE.getFont().getFontName(), this.txtJaWE.getFont().getStyle(), 10));
        txtProject.setBackground(Color.LIGHT_GRAY);
        txtProject.setBorder(BorderFactory.createLoweredBevelBorder());
        txtProject.setEditable(false);
        contextPane.add((Component)txtProject, new GridBagConstraints(0, 9, 3, 1, 0.0, 0.0, 10, 0, new Insets(15, 1, 1, 1), 0, 0));
        this.infoPnl.add((Component)contextPane, "North");
    }

    private Dimension getDimension(String[] s) {
        String[] labels = s;
        int longest = 0;
        int w = 0;
        for (int i = 0; i < labels.length; ++i) {
            try {
                w = this.getFontMetrics(this.getFont()).stringWidth(labels[i]);
                if (w <= longest) continue;
                longest = w;
                continue;
            }
            catch (Exception e) {
                // empty catch block
            }
        }
        w = longest + 22;
        int h = this.getFontMetrics(this.getFont()).getHeight() + 2;
        Dimension dim = new Dimension(w, h);
        return dim;
    }

    protected JRootPane createRootPane() {
        KeyStroke stroke = KeyStroke.getKeyStroke(27, 0);
        JRootPane rootPane = new JRootPane();
        rootPane.registerKeyboardAction(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                JaWEAboutDialog.this.setVisible(false);
            }
        }, stroke, 2);
        return rootPane;
    }

    private class ActionHandler
    implements ActionListener {
        private ActionHandler() {
        }

        public void actionPerformed(ActionEvent e) {
            if (e.getSource() == JaWEAboutDialog.this.okButton) {
                JaWEAboutDialog.this.dispose();
            }
        }
    }
}

