/*
 * Decompiled with CFR 0.152.
 */
package org.enhydra.jawe;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GraphicsEnvironment;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.File;
import java.net.URL;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.StringTokenizer;
import javax.swing.Action;
import javax.swing.ImageIcon;
import javax.swing.JFrame;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.ToolTipManager;
import org.enhydra.jawe.BarFactory;
import org.enhydra.jawe.JaWEConfig;
import org.enhydra.jawe.JaWEConstants;
import org.enhydra.jawe.JaWEPortView;
import org.enhydra.jawe.JaWESplash;
import org.enhydra.jawe.PackageEditor;
import org.enhydra.jawe.ProcessEditor;
import org.enhydra.jawe.ResourceManager;
import org.enhydra.jawe.actions.New;
import org.enhydra.jawe.graph.BlockActivity;
import org.enhydra.jawe.graph.Process;
import org.enhydra.jawe.ldap.ExternalParticipants;
import org.enhydra.jawe.misc.ExternalProcesses;
import org.enhydra.jawe.misc.PFLocale;
import org.enhydra.jawe.misc.ValidationErrorDisplay;
import org.enhydra.jawe.xml.PackageValidator;
import org.enhydra.jawe.xml.XML;
import org.enhydra.jawe.xml.XMLCollection;
import org.enhydra.jawe.xml.XMLCollectionElement;
import org.enhydra.jawe.xml.XMLComplexElement;
import org.enhydra.jawe.xml.XMLElement;
import org.enhydra.jawe.xml.XMLElementChangeListener;
import org.enhydra.jawe.xml.XMLElementDialog;
import org.enhydra.jawe.xml.XMLInterface;
import org.enhydra.jawe.xml.XMLUtil;
import org.enhydra.jawe.xml.elements.Activity;
import org.enhydra.jawe.xml.elements.ActivitySet;
import org.enhydra.jawe.xml.elements.ActualParameter;
import org.enhydra.jawe.xml.elements.ConformanceClass;
import org.enhydra.jawe.xml.elements.DataTypes;
import org.enhydra.jawe.xml.elements.Deadline;
import org.enhydra.jawe.xml.elements.EnumerationValue;
import org.enhydra.jawe.xml.elements.ExtendedAttribute;
import org.enhydra.jawe.xml.elements.ExternalPackages;
import org.enhydra.jawe.xml.elements.Package;
import org.enhydra.jawe.xml.elements.Responsible;
import org.enhydra.jawe.xml.elements.Tool;
import org.enhydra.jawe.xml.elements.Transition;
import org.enhydra.jawe.xml.elements.WorkflowProcess;

public final class JaWE
implements XMLElementChangeListener {
    private static JaWE jawe;
    public static ImageIcon appIcon;
    private static ImageIcon logoIcon;
    private static String appTitle;
    private static XMLInterface xmlInterface;
    private static String mandatoryConformanceClass;
    private static final int recentFileListSize;
    private JFrame mainFrame = new JFrame();
    private PackageEditor packageEditor;
    private String filename;
    private boolean modified = false;
    private Action save;
    private Action exit;
    private JMenu recentFilesMenu;

    public static XMLInterface getXMLInterface() {
        return xmlInterface;
    }

    public static JaWE getInstance() {
        if (jawe == null) {
            jawe = new JaWE();
            jawe.init(null);
        }
        return jawe;
    }

    public static String getAppTitle() {
        return appTitle;
    }

    public static ImageIcon getLogoIcon() {
        return logoIcon;
    }

    public static ImageIcon getAppIcon() {
        return appIcon;
    }

    private JaWE() {
        this.mainFrame.setBackground(Color.lightGray);
        this.mainFrame.getContentPane().setLayout(new BorderLayout());
        this.mainFrame.setDefaultCloseOperation(0);
        if (appIcon != null) {
            this.mainFrame.setIconImage(appIcon.getImage());
        }
        XMLUtil.setApplicationWindow((Window)this.mainFrame);
        XMLElementDialog.addXMLElementChangedListener((XMLElementChangeListener)this);
    }

    private void init(String filename) {
        Package pkg = this.openDocument(filename, true, false);
        this.packageEditor = new PackageEditor((XMLComplexElement)pkg);
        this.mainFrame.getContentPane().add((Component)this.packageEditor, "Center");
        if (filename != null && new File(filename).exists()) {
            boolean validationStatus = JaWEConfig.getInstance().getValidationStatus();
            PackageValidator pv = new PackageValidator(pkg, false, true, true, true, JaWEConfig.getInstance().getAllowUndefinedStartActivity(), JaWEConfig.getInstance().getAllowUndefinedEndActivity(), JaWEConfig.getInstance().getEncoding());
            ValidationErrorDisplay ved = null;
            if (validationStatus && !pv.validateAll(true)) {
                try {
                    JaWESplash.getSplash().hideSplash();
                }
                catch (Exception ex) {
                    // empty catch block
                }
                Map xpdlSchemaValidationErrors = pv.getXPDLSchemaValidationErrors();
                Map connectionErrors = pv.getGraphsConnectionErrors((XMLComplexElement)pkg);
                List basicGraphConformanceErrors = pv.getBasicGraphConformanceErrors((XMLComplexElement)pkg);
                Map graphConformanceErrors = pv.getGraphConformanceErrors((XMLComplexElement)pkg);
                Map logicErrors = pv.getLogicErrors((XMLComplexElement)pkg);
                String title = ResourceManager.getLanguageDependentString("DialogValidationReport");
                ved = new ValidationErrorDisplay(xpdlSchemaValidationErrors, connectionErrors, basicGraphConformanceErrors, graphConformanceErrors, logicErrors, this.mainFrame, title, true);
            }
            if (ved == null || !ved.hasBeenStoped()) {
                this.packageEditor.setNewPackage(pkg, true);
                if (!this.packageEditor.isInitialized() || pkg.get("Id").toString().trim().length() == 0) {
                    if (ved != null && !ved.hasBeenStoped()) {
                        this.message(ResourceManager.getLanguageDependentString("InformationErrorWhileOpeningFile"), 1);
                    }
                    this.filename = null;
                    this.packageEditor.update();
                    this.packageEditor.enterPackageID();
                } else {
                    try {
                        JaWESplash.getSplash().hideSplash();
                    }
                    catch (Exception ex) {
                        // empty catch block
                    }
                    this.processConformanceClassAttribute(pkg);
                }
            } else {
                New.openNewPackage();
            }
            this.packageEditor.update();
        } else {
            this.filename = null;
            this.packageEditor.setNewPackage(pkg, true);
        }
        this.save = this.packageEditor.getAction("Save");
        this.exit = this.packageEditor.getAction("Exit");
        this.recentFilesMenu = (JMenu)this.packageEditor.getMenuItem("RecentFiles");
        this.initRecentFileMenu();
        if (this.filename != null && new File(this.filename).exists()) {
            this.addToRecentFiles(this.filename);
        }
        this.mainFrame.addWindowListener(this.createAppCloser());
        this.mainFrame.pack();
        Dimension screenSize = GraphicsEnvironment.getLocalGraphicsEnvironment().getDefaultScreenDevice().getDefaultConfiguration().getBounds().getSize();
        int xMinus = 50;
        int yMinus = 100;
        this.mainFrame.setBounds(xMinus / 2, yMinus / 2, screenSize.width - xMinus, screenSize.height - yMinus);
        ToolTipManager.sharedInstance().setEnabled(JaWEConfig.getInstance().getTooltipStatus());
    }

    public String getFilename() {
        return this.filename;
    }

    public void setFilename(String filename) {
        this.filename = filename;
    }

    protected WindowAdapter createAppCloser() {
        return new AppCloser();
    }

    public JMenu getRecentFilesMenu() {
        return this.recentFilesMenu;
    }

    private void initRecentFileMenu() {
        String rfl = XMLUtil.fileToString((String)(JaWEConstants.JAWE_USER_HOME + "/.rfl"));
        if (rfl != null) {
            StringTokenizer st = new StringTokenizer(rfl, "\n");
            while (st.hasMoreTokens()) {
                this.addToRecentFiles(st.nextToken());
            }
        }
    }

    public void addToRecentFiles(String filename) {
        JMenuItem mItem;
        int i;
        for (i = 0; i < this.recentFilesMenu.getItemCount(); ++i) {
            mItem = (JMenuItem)this.recentFilesMenu.getMenuComponent(i);
            if (!filename.equals(mItem.getText().substring(2))) continue;
            this.recentFilesMenu.remove(i);
        }
        if (this.recentFilesMenu.getItemCount() == recentFileListSize) {
            this.recentFilesMenu.remove(recentFileListSize - 1);
        }
        mItem = new JMenuItem("1 " + filename);
        mItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                String filename = e.getActionCommand().substring(2);
                if (JaWE.getInstance().close()) {
                    JaWE.this.checkNameAndOpenDocumentIfPossible(filename);
                }
            }
        });
        this.recentFilesMenu.insert(mItem, 0);
        for (i = 0; i < this.recentFilesMenu.getItemCount(); ++i) {
            mItem = (JMenuItem)this.recentFilesMenu.getMenuComponent(i);
            String oldText = mItem.getText();
            String ordNo = String.valueOf(i + 1);
            String mnemonic = ordNo.substring(ordNo.length() - 1, ordNo.length());
            mItem.setText(mnemonic + " " + oldText.substring(2));
            BarFactory.setMnemonic(mItem, mnemonic);
        }
    }

    public boolean close() {
        int r = 1;
        if (this.isModified()) {
            r = JOptionPane.showConfirmDialog(this.mainFrame, ResourceManager.getLanguageDependentString("SaveChangesDialog"), appTitle, 1);
        }
        if (r == 0) {
            this.save.actionPerformed(null);
            if (this.isModified()) {
                r = 2;
            }
        }
        return r != 2;
    }

    public PackageEditor getPackageEditor() {
        return this.packageEditor;
    }

    public Package getRealXMLPackage() {
        return this.packageEditor.getRealXMLPackage();
    }

    public WorkflowProcess showProcess(Window parentWindow, WorkflowProcess wp, String processID) {
        return this.packageEditor.showProcess(parentWindow, wp, processID);
    }

    public void setModified(boolean modified) {
        if (this.modified != modified) {
            this.modified = modified;
            this.getPackageEditor().update();
        }
    }

    public boolean isModified() {
        return this.modified;
    }

    public void checkNameAndOpenDocumentIfPossible(String name) {
        if (name != null && new File(name).exists()) {
            this.packageEditor.displayPackage(this.packageEditor.getRealXMLPackage());
            Package pkg = this.openDocument(name, true, false);
            boolean validationStatus = JaWEConfig.getInstance().getValidationStatus();
            PackageValidator pv = new PackageValidator(pkg, false, true, true, true, JaWEConfig.getInstance().getAllowUndefinedStartActivity(), JaWEConfig.getInstance().getAllowUndefinedEndActivity(), JaWEConfig.getInstance().getEncoding());
            ValidationErrorDisplay ved = null;
            if (validationStatus && !pv.validateAll(true)) {
                Map xpdlSchemaValidationErrors = pv.getXPDLSchemaValidationErrors();
                Map connectionErrors = pv.getGraphsConnectionErrors((XMLComplexElement)pkg);
                List basicGraphConformanceErrors = pv.getBasicGraphConformanceErrors((XMLComplexElement)pkg);
                Map graphConformanceErrors = pv.getGraphConformanceErrors((XMLComplexElement)pkg);
                Map logicErrors = pv.getLogicErrors((XMLComplexElement)pkg);
                String title = ResourceManager.getLanguageDependentString("DialogValidationReport");
                ved = new ValidationErrorDisplay(xpdlSchemaValidationErrors, connectionErrors, basicGraphConformanceErrors, graphConformanceErrors, logicErrors, this.mainFrame, title, true);
            }
            if (ved == null || !ved.hasBeenStoped()) {
                this.packageEditor.setNewPackage(pkg, true);
                if (!this.packageEditor.isInitialized() || pkg.get("Id").toString().trim().length() == 0) {
                    if (ved != null && !ved.hasBeenStoped()) {
                        this.message(ResourceManager.getLanguageDependentString("InformationErrorWhileOpeningFile"), 1);
                    }
                    this.filename = null;
                    this.packageEditor.update();
                    this.packageEditor.enterPackageID();
                } else {
                    this.addToRecentFiles(this.filename);
                    this.processConformanceClassAttribute(pkg);
                }
            } else {
                New.openNewPackage();
            }
            this.packageEditor.update();
        } else {
            this.message(ResourceManager.getLanguageDependentString("InformationErrorWhileOpeningFile"), 1);
        }
    }

    public void openPackageFromStream(String name, String pkgCnt) {
        if (name != null && pkgCnt != null) {
            this.filename = name;
            this.packageEditor.displayPackage(this.packageEditor.getRealXMLPackage());
            xmlInterface.closeAllPackages();
            xmlInterface.putPkgIdToFileContentMapping(name, pkgCnt);
            Package pkg = null;
            pkg = xmlInterface.openPackage(name, true);
            System.out.println("pkg=" + pkg);
            if (pkg == null) {
                pkg = new Package(xmlInterface);
            }
            boolean validationStatus = JaWEConfig.getInstance().getValidationStatus();
            PackageValidator pv = new PackageValidator(pkg, false, true, true, false, JaWEConfig.getInstance().getAllowUndefinedStartActivity(), JaWEConfig.getInstance().getAllowUndefinedEndActivity(), JaWEConfig.getInstance().getEncoding());
            ValidationErrorDisplay ved = null;
            if (validationStatus && !pv.validateAll(true)) {
                Map xpdlSchemaValidationErrors = pv.getXPDLSchemaValidationErrors();
                Map connectionErrors = pv.getGraphsConnectionErrors((XMLComplexElement)pkg);
                List basicGraphConformanceErrors = pv.getBasicGraphConformanceErrors((XMLComplexElement)pkg);
                Map graphConformanceErrors = pv.getGraphConformanceErrors((XMLComplexElement)pkg);
                Map logicErrors = pv.getLogicErrors((XMLComplexElement)pkg);
                String title = ResourceManager.getLanguageDependentString("DialogValidationReport");
                ved = new ValidationErrorDisplay(xpdlSchemaValidationErrors, connectionErrors, basicGraphConformanceErrors, graphConformanceErrors, logicErrors, this.mainFrame, title, true);
            }
            if (ved == null || !ved.hasBeenStoped()) {
                this.packageEditor.setNewPackage(pkg, false);
                if (!this.packageEditor.isInitialized() || pkg.get("Id").toString().trim().length() == 0) {
                    if (ved != null && !ved.hasBeenStoped()) {
                        this.message(ResourceManager.getLanguageDependentString("InformationErrorWhileOpeningFile"), 1);
                    }
                    this.filename = null;
                    this.packageEditor.update();
                    this.packageEditor.enterPackageID();
                } else {
                    this.filename = null;
                    this.processConformanceClassAttribute(pkg);
                }
            } else {
                New.openNewPackage();
            }
            this.packageEditor.update();
        } else {
            this.message(ResourceManager.getLanguageDependentString("InformationErrorWhileOpeningFile"), 1);
        }
    }

    public Package openDocument(String filename, boolean clearOtherPackages, boolean openFromStream) {
        this.filename = filename;
        Package pkg = null;
        if (clearOtherPackages) {
            xmlInterface.closeAllPackages();
        }
        if (filename != null) {
            pkg = xmlInterface.openPackage(filename, openFromStream);
        }
        if (pkg == null) {
            pkg = new Package(xmlInterface);
        }
        return pkg;
    }

    public String openDialog(String message) {
        return XMLUtil.dialog((Component)this.mainFrame, (String)message, (int)0, (int)0, null);
    }

    public String saveDialog(String message, int filteringMode, String initialName) {
        return XMLUtil.dialog((Component)this.mainFrame, (String)message, (int)1, (int)filteringMode, (String)initialName);
    }

    public void message(String message, int type) {
        JOptionPane.showMessageDialog(this.mainFrame, message, JaWE.getAppTitle(), type);
    }

    public void setRecentFilesMenu(JMenu rfm) {
        this.recentFilesMenu = rfm;
    }

    public JFrame getMainFrame() {
        return this.mainFrame;
    }

    public void xmlElementChanged(XMLElement el) {
        if (!(el instanceof XMLCollection && !(el instanceof ExternalPackages) && !el.getClass().getName().startsWith("org.enhydra.jawe.xml.elements.Activity$") || el instanceof Responsible || el instanceof ExtendedAttribute || el instanceof DataTypes || el instanceof EnumerationValue || el instanceof Tool || el instanceof ActualParameter || el instanceof ExternalProcesses || el instanceof ExternalParticipants || el instanceof Deadline || el.getClass().getName().startsWith("org.enhydra.jawe.xml.panels.XMLListChoiceControlPanel$"))) {
            this.setModified(true);
        }
        if (!JaWEConfig.getInstance().getStatusBarStatus()) {
            return;
        }
        if (el instanceof Activity || el instanceof Transition) {
            this.packageEditor.getStatusBar().updateMessage();
            XMLCollectionElement actOrTrans = (XMLCollectionElement)el;
            Process pr = null;
            if (actOrTrans.getCollection().getOwner() instanceof WorkflowProcess) {
                pr = this.packageEditor.getProcessObject((WorkflowProcess)actOrTrans.getCollection().getOwner());
                pr.getImplementationEditor().getStatusBar().updateMessage();
            } else {
                ActivitySet actSet = (ActivitySet)actOrTrans.getCollection().getOwner();
                pr = this.packageEditor.getProcessObject((WorkflowProcess)actSet.getCollection().getOwner());
                Set baObjects = pr.getImplementationEditor().getGraph().getWorkflowManager().getBlockActivities(true);
                Iterator baObjs = baObjects.iterator();
                while (baObjs.hasNext()) {
                    XMLElement xpdlObj;
                    BlockActivity ba = (BlockActivity)baObjs.next();
                    ProcessEditor bae = ba.getImplementationEditor();
                    if (bae == null || !(xpdlObj = bae.getGraph().getXPDLObject()).equals(actSet)) continue;
                    bae.getStatusBar().updateMessage();
                }
            }
        }
        if (el instanceof Package) {
            this.packageEditor.getStatusBar().updateMessage();
        }
    }

    private void processConformanceClassAttribute(Package pkg) {
        ConformanceClass cc = (ConformanceClass)pkg.get("ConformanceClass");
        String gct = cc.get("GraphConformance").toValue().toString();
        int mct = XMLUtil.getConformanceClassNo((String)mandatoryConformanceClass);
        int ct = XMLUtil.getConformanceClassNo((String)gct);
        if (mct > 0) {
            if (mct != ct) {
                this.message(ResourceManager.getLanguageDependentString("WarningYouHaveOpenedPackageWithConformanceClassDiferentThenMandatoryOne"), 2);
            } else {
                cc.setReadOnly(true);
            }
        }
    }

    public String getMandatoryConformanceClass() {
        return mandatoryConformanceClass;
    }

    public static void main(String[] args) {
        jawe = new JaWE();
        JaWESplash splash = new JaWESplash("SplashImage", null, 9000);
        String fn = null;
        String sl = null;
        String mcc = null;
        if (args != null && args.length > 0) {
            for (int i = 0; i < args.length; ++i) {
                if (args[i].compareTo("-mcc") == 0) {
                    if (++i == args.length) {
                        System.err.println("error: Missing argument to -mcc option.");
                        continue;
                    }
                    mcc = args[i];
                    String oldMCC = JaWEConfig.getInstance().getMandatoryConformanceClass();
                    JaWEConfig.getInstance().setMandatoryConformanceClass(mcc);
                    mandatoryConformanceClass = JaWEConfig.getInstance().getMandatoryConformanceClass();
                    JaWEConfig.getInstance().setMandatoryConformanceClass(oldMCC);
                }
                if (args[i].compareTo("-sl") != 0) continue;
                if (++i == args.length) {
                    System.err.println("error: Missing argument to -sl option.");
                    continue;
                }
                sl = args[i];
                try {
                    PFLocale pfl = PFLocale.createPFLocale(sl);
                    if (pfl == null) {
                        pfl = new PFLocale(Locale.getDefault());
                    }
                    ResourceManager.setChoosen(pfl.getLocale());
                    continue;
                }
                catch (Exception ex) {
                    System.err.println("warning: Can't start with locale " + sl);
                }
            }
            if ((double)(args.length / 2) != (double)args.length / 2.0) {
                fn = args[args.length - 1];
            }
        }
        jawe.init(fn);
        splash.dispose();
        splash = null;
        jawe.getPackageEditor().showWindow(null, jawe.getPackageEditor().getTitle());
    }

    static {
        xmlInterface = new XML();
        mandatoryConformanceClass = JaWEConfig.getInstance().getMandatoryConformanceClass();
        recentFileListSize = JaWEConfig.getInstance().getRecentFileListSize();
        try {
            String vers = System.getProperty("java.version");
            if (vers.compareTo("1.4") < 0) {
                System.out.println("!!!WARNING: JaWE must be run with a 1.4 or higher version VM!!!");
                System.exit(1);
            }
            appTitle = ResourceManager.getLanguageDependentString("Title");
            URL url = ResourceManager.getResource("Logo");
            if (url != null) {
                logoIcon = new ImageIcon(url);
            }
            if ((url = ResourceManager.getResource("Icon")) != null) {
                appIcon = new ImageIcon(url);
            }
            JaWEPortView.setPortSize(Math.min(JaWEConfig.getInstance().getActivityWidth(), JaWEConfig.getInstance().getActivityHeight()) - 10);
            File ujdir = new File(JaWEConstants.JAWE_USER_HOME);
            if (!ujdir.exists()) {
                try {
                    ujdir.mkdir();
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            ((XML)xmlInterface).setFileLockingStatus(JaWEConfig.getInstance().getFileLockingStatus());
        }
        catch (Throwable t) {
            System.err.println("uncaught exception: " + t);
            t.printStackTrace();
        }
    }

    private final class AppCloser
    extends WindowAdapter {
        private AppCloser() {
        }

        public void windowClosing(WindowEvent e) {
            JaWE.this.exit.actionPerformed(null);
        }
    }
}

