/*
 * Decompiled with CFR 0.152.
 */
package org.enhydra.jawe;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.net.URL;
import java.util.Hashtable;
import javax.swing.AbstractButton;
import javax.swing.Action;
import javax.swing.Box;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JTabbedPane;
import javax.swing.JToolBar;
import javax.swing.KeyStroke;
import javax.swing.text.JTextComponent;
import org.enhydra.jawe.AbstractEditor;
import org.enhydra.jawe.ResourceManager;
import org.enhydra.jawe.Utils;
import org.enhydra.jawe.actions.TextPrint;
import org.enhydra.jawe.actions.TextSaveAs;

public class BarFactory {
    protected AbstractEditor editor;
    Hashtable commands = new Hashtable();
    static /* synthetic */ Class class$java$awt$event$KeyEvent;

    public BarFactory(AbstractEditor editor) {
        this.editor = editor;
    }

    public Component createToolBars(JTabbedPane tabbedPane) {
        int i;
        String[] toolBars = Utils.tokenize(ResourceManager.getResourceString(this.editor.toolbarToLoad()), " ");
        JPanel lastPanel = new JPanel();
        lastPanel.setLayout(new BorderLayout());
        for (i = 0; i < toolBars.length && !toolBars[i].equals("-"); ++i) {
            String label = ResourceManager.getLanguageDependentString(toolBars[i] + "Label");
            JPanel panel = new JPanel();
            panel.setLayout(new BorderLayout());
            Component c = this.createToolbar(toolBars[i], label);
            panel.add("West", c);
            ImageIcon icon = null;
            URL url = ResourceManager.getResource(toolBars[i] + "Image");
            if (url != null) {
                icon = new ImageIcon(url);
            }
            tabbedPane.addTab(label, icon, panel, label);
        }
        tabbedPane.setPreferredSize(new Dimension(500, 60));
        tabbedPane.setSelectedIndex(i - 1);
        lastPanel.add("West", tabbedPane);
        if (i < toolBars.length - 1) {
            Component c = this.createTool(toolBars[i + 1]);
            lastPanel.add("East", c);
        }
        return lastPanel;
    }

    protected Component createToolbar(String key, String label) {
        JToolBar toolbar = new JToolBar(label);
        toolbar.putClientProperty("JToolBar.isRollover", Boolean.TRUE);
        String[] toolKeys = Utils.tokenize(ResourceManager.getResourceString(key), " ");
        for (int i = 0; i < toolKeys.length; ++i) {
            if (toolKeys[i].equals("-")) {
                toolbar.addSeparator();
                continue;
            }
            toolbar.add(this.createTool(toolKeys[i]));
        }
        toolbar.add(Box.createHorizontalGlue());
        return toolbar;
    }

    protected Component createTool(String key) {
        return this.createToolbarButton(key);
    }

    protected Component createToolbarButton(String key) {
        String tip;
        Object specialButton = this.editor.getSpecialButton(key);
        if (specialButton instanceof JComponent && !(specialButton instanceof AbstractButton)) {
            return (JComponent)specialButton;
        }
        AbstractButton b = null;
        URL url = ResourceManager.getResource(key + "Image");
        if (specialButton instanceof AbstractButton) {
            b = (AbstractButton)specialButton;
            b.setIcon(new ImageIcon(url));
        } else {
            b = url != null ? new JButton((Icon)new ImageIcon(url)){

                public float getAlignmentY() {
                    return 0.5f;
                }
            } : new JButton(ResourceManager.getLanguageDependentString(key + "Label")){

                public float getAlignmentY() {
                    return 0.5f;
                }
            };
        }
        b.setMargin(new Insets(1, 1, 1, 1));
        b.setRequestFocusEnabled(false);
        if (specialButton == null) {
            Action a;
            String astr = ResourceManager.getResourceString(key + "Action");
            if (astr == null) {
                astr = key;
            }
            if ((a = this.editor.getAction(astr)) != null) {
                b.setActionCommand(astr);
                b.addActionListener(new EventRedirector(a));
                b.setEnabled(a.isEnabled());
                a.addPropertyChangeListener(new ActionChangedListener(b));
            } else {
                b.setEnabled(false);
            }
        }
        if ((tip = ResourceManager.getLanguageDependentString(key + "Tooltip")) != null) {
            b.setToolTipText(tip);
        }
        this.editor.putToolbarComponent(key, b);
        return b;
    }

    public JMenuBar createMenubar() {
        JMenuBar mb = new JMenuBar();
        String[] menuKeys = Utils.tokenize(ResourceManager.getResourceString(this.editor.menubarToLoad()), " ");
        for (int i = 0; i < menuKeys.length; ++i) {
            String[] itemKeys = Utils.tokenize(ResourceManager.getResourceString(menuKeys[i]), " ");
            JMenu m = this.createMenu(menuKeys[i], itemKeys);
            if (m == null) continue;
            mb.add(m);
        }
        return mb;
    }

    public JMenuBar createTextViewMenubar(String key) {
        JMenuBar mb = new JMenuBar();
        String[] menuKeys = Utils.tokenize(ResourceManager.getResourceString(key), " ");
        for (int i = 0; i < menuKeys.length; ++i) {
            String[] itemKeys = Utils.tokenize(ResourceManager.getResourceString(menuKeys[i]), " ");
            JMenu m = this.createTextViewMenu(menuKeys[i], itemKeys);
            if (m == null) continue;
            mb.add(m);
        }
        return mb;
    }

    public JMenu createTextViewMenu(String key, String[] itemKeys) {
        JMenu menu = new JMenu(ResourceManager.getLanguageDependentString(key + "Label"));
        for (int i = 0; i < itemKeys.length; ++i) {
            if (itemKeys[i].equals("-")) {
                menu.addSeparator();
                continue;
            }
            JMenuItem mi = this.createTextVeiwMenuItem(itemKeys[i]);
            menu.add(mi);
        }
        URL url = ResourceManager.getResource(key + "Image");
        if (url != null) {
            menu.setHorizontalTextPosition(4);
            menu.setIcon(new ImageIcon(url));
        }
        BarFactory.setMnemonic(menu, ResourceManager.getLanguageDependentString(key + "Mnemonic"));
        menu.setActionCommand(key);
        return menu;
    }

    public JMenuItem createTextVeiwMenuItem(String cmd) {
        String subMenu = ResourceManager.getResourceString(cmd + "Menu");
        if (subMenu != null) {
            String[] itemKeys = Utils.tokenize(subMenu, " ");
            JMenu mn = this.createTextViewMenu(cmd, itemKeys);
            return mn;
        }
        JMenuItem mi = new JMenuItem(ResourceManager.getLanguageDependentString(cmd + "Label"));
        URL url = ResourceManager.getResource(cmd + "Image");
        if (url != null) {
            mi.setHorizontalTextPosition(4);
            mi.setIcon(new ImageIcon(url));
        }
        BarFactory.setAccelerator(mi, ResourceManager.getLanguageDependentString(cmd + "Accel"));
        BarFactory.setMnemonic(mi, ResourceManager.getLanguageDependentString(cmd + "Mnemonic"));
        String astr = ResourceManager.getResourceString(cmd + "Action");
        if (astr == null) {
            astr = cmd;
        }
        mi.setActionCommand(astr);
        Action a = this.getTextViewAction(astr);
        if (a != null) {
            mi.addActionListener(a);
            mi.setEnabled(a.isEnabled());
        } else {
            mi.setEnabled(false);
        }
        return mi;
    }

    public Action getTextViewAction(String key) {
        return (Action)this.commands.get(key);
    }

    public void createViewActions(JTextComponent textComponent) {
        Action[] actions = new Action[]{new TextSaveAs(textComponent), new TextPrint()};
        for (int i = 0; i < actions.length; ++i) {
            Action a = actions[i];
            this.commands.put(a.getValue("Name"), a);
        }
    }

    protected JMenu createMenu(String key, String[] itemKeys) {
        JMenu menu = new JMenu(ResourceManager.getLanguageDependentString(key + "Label"));
        for (int i = 0; i < itemKeys.length; ++i) {
            if (itemKeys[i].equals("-")) {
                menu.addSeparator();
                continue;
            }
            JMenuItem mi = this.createMenuItem(itemKeys[i], true);
            menu.add(mi);
        }
        URL url = ResourceManager.getResource(key + "Image");
        if (url != null) {
            menu.setHorizontalTextPosition(4);
            menu.setIcon(new ImageIcon(url));
        }
        BarFactory.setMnemonic(menu, ResourceManager.getLanguageDependentString(key + "Mnemonic"));
        menu.setActionCommand(key);
        return menu;
    }

    public JMenuItem createMenuItem(String cmd, boolean putIntoTable) {
        JMenuItem mi;
        String subMenu = ResourceManager.getResourceString(cmd + "Menu");
        if (subMenu != null) {
            String[] itemKeys = Utils.tokenize(subMenu, " ");
            JMenu mn = this.createMenu(cmd, itemKeys);
            if (putIntoTable) {
                this.editor.putMenuItem(cmd, mn);
            }
            return mn;
        }
        Object specialItem = this.editor.getSpecialItem(cmd);
        if (specialItem instanceof JMenuItem) {
            mi = (JMenuItem)specialItem;
            mi.setText(ResourceManager.getLanguageDependentString(cmd + "Label"));
        } else {
            mi = new JMenuItem(ResourceManager.getLanguageDependentString(cmd + "Label"));
        }
        URL url = ResourceManager.getResource(cmd + "Image");
        if (url != null) {
            mi.setHorizontalTextPosition(4);
            mi.setIcon(new ImageIcon(url));
        }
        BarFactory.setAccelerator(mi, ResourceManager.getLanguageDependentString(cmd + "Accel"));
        BarFactory.setMnemonic(mi, ResourceManager.getLanguageDependentString(cmd + "Mnemonic"));
        if (specialItem == null) {
            String astr = ResourceManager.getResourceString(cmd + "Action");
            if (astr == null) {
                astr = cmd;
            }
            mi.setActionCommand(astr);
            Action a = this.editor.getAction(astr);
            if (a != null) {
                mi.addActionListener(new EventRedirector(a));
                a.addPropertyChangeListener(new ActionChangedListener(mi));
                mi.setEnabled(a.isEnabled());
            } else {
                mi.setEnabled(false);
            }
        }
        if (putIntoTable) {
            this.editor.putMenuItem(cmd, mi);
        }
        return mi;
    }

    public static JMenuItem createMenuItem(String cmd) {
        JMenuItem mi = new JMenuItem(ResourceManager.getLanguageDependentString(cmd + "Label"));
        URL url = ResourceManager.getResource(cmd + "Image");
        if (url != null) {
            mi.setHorizontalTextPosition(4);
            mi.setIcon(new ImageIcon(url));
        }
        return mi;
    }

    public static void setMnemonic(JMenuItem mi, String mnemonic) {
        if (mnemonic != null && mnemonic.length() > 0) {
            mi.setMnemonic(mnemonic.toCharArray()[0]);
        }
    }

    public static void setAccelerator(JMenuItem mi, String accel) {
        if (accel != null) {
            try {
                int mask = 0;
                if (accel.startsWith("CTRL")) {
                    mask += 2;
                    accel = accel.substring(5);
                }
                if (accel.startsWith("SHIFT")) {
                    ++mask;
                    accel = accel.substring(6);
                }
                if (accel.startsWith("ALT")) {
                    mask += 8;
                    accel = accel.substring(4);
                }
                int key = (class$java$awt$event$KeyEvent == null ? (class$java$awt$event$KeyEvent = BarFactory.class$("java.awt.event.KeyEvent")) : class$java$awt$event$KeyEvent).getField("VK_" + accel).getInt(null);
                mi.setAccelerator(KeyStroke.getKeyStroke(key, mask));
            }
            catch (Exception e) {
                System.err.println("Error while assigning accelerator !!!");
            }
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    private class ActionChangedListener
    implements PropertyChangeListener {
        AbstractButton button;

        ActionChangedListener(AbstractButton b) {
            this.button = b;
        }

        public void propertyChange(PropertyChangeEvent e) {
            String propertyName = e.getPropertyName();
            if (e.getPropertyName().equals("Name") && this.button instanceof JMenuItem) {
                String text = (String)e.getNewValue();
                this.button.setText(text);
            } else if (propertyName.equals("enabled")) {
                Boolean enabledState = (Boolean)e.getNewValue();
                this.button.setEnabled(enabledState);
            }
        }
    }

    private class EventRedirector
    implements ActionListener {
        protected Action action;

        public EventRedirector(Action a) {
            this.action = a;
        }

        public void actionPerformed(ActionEvent e) {
            e = new ActionEvent(BarFactory.this.editor.getGraph(), e.getID(), e.getActionCommand(), e.getModifiers());
            this.action.actionPerformed(e);
        }
    }
}

