/*
 * Decompiled with CFR 0.152.
 */
package org.enhydra.jawe;

import java.awt.Font;
import java.awt.Window;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.swing.JComponent;
import javax.swing.KeyStroke;
import org.enhydra.jawe.AbstractEditor;
import org.enhydra.jawe.JaWE;
import org.enhydra.jawe.JaWEConfig;
import org.enhydra.jawe.JaWEGraphModel;
import org.enhydra.jawe.JaWEGraphSelectionModel;
import org.enhydra.jawe.JaWEGraphUI;
import org.enhydra.jawe.JaWEMarqueeHandler;
import org.enhydra.jawe.Utils;
import org.enhydra.jawe.WorkflowElement;
import org.enhydra.jawe.WorkflowManager;
import org.enhydra.jawe.graph.End;
import org.enhydra.jawe.graph.Start;
import org.enhydra.jawe.xml.XMLComplexElement;
import org.enhydra.jawe.xml.XMLElement;
import org.enhydra.jawe.xml.elements.Package;
import org.jgraph.JGraph;
import org.jgraph.graph.CellView;
import org.jgraph.graph.GraphConstants;
import org.jgraph.graph.GraphLayoutCache;
import org.jgraph.graph.GraphModel;
import org.jgraph.graph.Port;
import org.jgraph.plaf.GraphUI;

public abstract class AbstractGraph
extends JGraph
implements WorkflowElement {
    protected XMLComplexElement xmlObject = null;
    protected transient WorkflowManager workflowManager;
    protected transient AbstractEditor editor;
    protected Map xpdlSchemaValidationErrors = null;
    protected String basicXpdlSchemaValidationError = null;
    protected Map graphConnectionErrors = null;
    protected String basicGraphConnectionError = null;
    protected Map graphConformanceErrors = null;
    protected List basicGraphConformanceErrors = null;
    protected Map logicErrors = null;
    protected String basicLogicError = null;
    static /* synthetic */ Class class$org$enhydra$jawe$actions$EditProperties;

    public AbstractGraph(GraphModel model, AbstractEditor editor) {
        this.selectionModel = new JaWEGraphSelectionModel(this);
        this.setLayout(null);
        GraphLayoutCache view = new GraphLayoutCache((JGraph)this);
        this.setGraphLayoutCache(view);
        this.updateUI();
        if (model == null) {
            model = new JaWEGraphModel();
        }
        this.setModel(model);
        this.editor = editor;
        this.workflowManager = new WorkflowManager(this);
        this.setMarqueeHandler(new JaWEMarqueeHandler(this));
        this.initGraphBehavior();
    }

    public AbstractGraph(GraphModel model, GraphLayoutCache view) {
        super(model, view);
    }

    public abstract Package getXMLPackage();

    public abstract void setPropertyObject(XMLComplexElement var1);

    public abstract void createWorkflowGraph(Window var1);

    public abstract String getToolTipText(MouseEvent var1);

    protected void initGraphBehavior() {
        this.setHandleSize(4);
        this.setTolerance(4);
        this.setSelectNewCells(true);
        this.setSizeable(false);
        this.setMoveable(false);
        this.selectionModel.setSelectionMode(1);
        this.refreshGraphConfiguration();
    }

    public void refreshGraphConfiguration() {
        JaWEConfig jcfg = JaWEConfig.getInstance();
        boolean gs = jcfg.getGridStatus();
        this.setGridEnabled(gs);
        this.setGridVisible(gs);
        this.setGridSize(jcfg.getGridSize());
        this.setBackground(Utils.getColor(jcfg.getBackgroundColor()));
        this.setHighlightColor(Utils.getColor(jcfg.getHighlightColor()));
        this.setGridColor(Utils.getColor(jcfg.getGridColor()));
        this.setHandleColor(Utils.getColor(jcfg.getHandleColor()));
        this.setMarqueeColor(Utils.getColor(jcfg.getMarqueeColor()));
        this.setFontSize();
        ((JaWEMarqueeHandler)this.getMarqueeHandler()).enableBubblesButtons(JaWEConfig.getInstance().getUseBubblesStatus());
        this.updateStartEndBubbles();
    }

    protected void setFontSize() {
        boolean isModified = JaWE.getInstance().isModified();
        Set cellSet = JaWEGraphModel.getAllCellsInModel(this.getModel());
        if (cellSet == null) {
            return;
        }
        ArrayList list = new ArrayList();
        Iterator i = cellSet.iterator();
        while (i.hasNext()) {
            Object cell = i.next();
            if (cell instanceof Port) continue;
            list.add(cell);
        }
        Object[] cells = list.toArray();
        Hashtable<Object, Map> nested = new Hashtable<Object, Map>();
        for (int i2 = 0; i2 < cells.length; ++i2) {
            CellView view = this.getGraphLayoutCache().getMapping(cells[i2], false);
            if (view == null) continue;
            Font font = GraphConstants.getFont((Map)view.getAllAttributes());
            if ((float)font.getSize() == JaWEConfig.getInstance().getFontSize()) {
                return;
            }
            Map attr = GraphConstants.createMap();
            GraphConstants.setFont((Map)attr, (Font)font.deriveFont(JaWEConfig.getInstance().getFontSize()));
            nested.put(cells[i2], attr);
        }
        ((JaWEGraphModel)this.graphModel).editFonts(nested);
        if (!isModified) {
            JaWE.getInstance().setModified(false);
        }
    }

    protected void updateStartEndBubbles() {
        if (!JaWEConfig.getInstance().getUseBubblesStatus()) {
            HashSet objectsToRemove = new HashSet();
            Set starts = this.workflowManager.getStarts();
            objectsToRemove.addAll(starts);
            Iterator it = starts.iterator();
            while (it.hasNext()) {
                Start s = (Start)it.next();
                objectsToRemove.addAll(s.getOutgoingTransitions());
            }
            Set ends = this.workflowManager.getEnds();
            objectsToRemove.addAll(ends);
            it = ends.iterator();
            while (it.hasNext()) {
                End e = (End)it.next();
                objectsToRemove.addAll(e.getIncomingTransitions());
            }
            if (objectsToRemove.size() > 0) {
                ((JaWEGraphModel)this.graphModel).removeBubbles(objectsToRemove.toArray(), this.getEditor());
            }
        }
    }

    public static void addSampleData(GraphModel model) {
    }

    public void showPropertyDialog(Window parentWindow, AbstractGraph graph) {
    }

    public XMLElement getPropertyObject() {
        return this.xmlObject;
    }

    public XMLElement getXPDLObject() {
        return this.xmlObject;
    }

    public XMLElement get(String what) {
        return ((XMLComplexElement)this.getPropertyObject()).get(what);
    }

    public void set(String what, Object value) {
        ((XMLComplexElement)this.getPropertyObject()).set(what, value);
    }

    public String getTooltip() {
        return "";
    }

    public AbstractEditor getEditor() {
        return this.editor;
    }

    public WorkflowManager getWorkflowManager() {
        return this.workflowManager;
    }

    public Map getXPDLSchemaValidationErrorMessages() {
        return this.xpdlSchemaValidationErrors;
    }

    public String getBasicXPDLSchemaValidationErrorMessage() {
        return this.basicXpdlSchemaValidationError;
    }

    public Map getConnectionErrorMessages() {
        return this.graphConnectionErrors;
    }

    public String getBasicConnectionErrorMessage() {
        return this.basicGraphConnectionError;
    }

    public abstract boolean validateAgainsXPDLSchema();

    public abstract boolean checkConnections(boolean var1);

    protected abstract boolean checkStartAndEndsConnections(boolean var1);

    protected abstract void updateXMLObjectsBeforeChecking();

    public Map getGraphConformanceErrorMessages() {
        return this.graphConformanceErrors;
    }

    public List getBasicGraphConformanceErrorMessages() {
        return this.basicGraphConformanceErrors;
    }

    public abstract boolean checkGraphConformance(boolean var1);

    public Map getLogicErrorMessages() {
        return this.logicErrors;
    }

    public String getBasicLogicErrorMessage() {
        return this.basicLogicError;
    }

    public abstract boolean checkLogic(boolean var1);

    public void updateUI() {
        this.setUI((GraphUI)new JaWEGraphUI());
        this.invalidate();
    }

    public void setAdditionalKeyboardShortcuts() {
        this.getInputMap(2).put(KeyStroke.getKeyStroke(10, 512, false), Utils.getUnqualifiedClassName(class$org$enhydra$jawe$actions$EditProperties == null ? (class$org$enhydra$jawe$actions$EditProperties = AbstractGraph.class$("org.enhydra.jawe.actions.EditProperties")) : class$org$enhydra$jawe$actions$EditProperties));
        this.getActionMap().put(Utils.getUnqualifiedClassName(class$org$enhydra$jawe$actions$EditProperties == null ? (class$org$enhydra$jawe$actions$EditProperties = AbstractGraph.class$("org.enhydra.jawe.actions.EditProperties")) : class$org$enhydra$jawe$actions$EditProperties), this.editor.getAction(Utils.getUnqualifiedClassName(class$org$enhydra$jawe$actions$EditProperties == null ? (class$org$enhydra$jawe$actions$EditProperties = AbstractGraph.class$("org.enhydra.jawe.actions.EditProperties")) : class$org$enhydra$jawe$actions$EditProperties)));
        this.editor.setALTCursorKeyboardShortcuts((JComponent)((Object)this));
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

