/*
 * Decompiled with CFR 0.152.
 */
package org.enhydra.jawe;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Rectangle;
import java.awt.Window;
import java.util.Collections;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Map;
import java.util.Observable;
import java.util.Observer;
import java.util.Set;
import javax.swing.Action;
import javax.swing.BorderFactory;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.JToolBar;
import javax.swing.JViewport;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import javax.swing.ToolTipManager;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.UndoableEditListener;
import org.enhydra.jawe.AbstractGraph;
import org.enhydra.jawe.BarFactory;
import org.enhydra.jawe.JaWE;
import org.enhydra.jawe.JaWEConfig;
import org.enhydra.jawe.JaWEMarqueeHandler;
import org.enhydra.jawe.JaWEStatusBar;
import org.enhydra.jawe.ResourceManager;
import org.enhydra.jawe.TextPreview;
import org.enhydra.jawe.UndoHandler;
import org.enhydra.jawe.XPDLPreview;
import org.enhydra.jawe.actions.FocusNearestCell;
import org.enhydra.jawe.actions.Redo;
import org.enhydra.jawe.actions.Undo;
import org.enhydra.jawe.graph.Transition;
import org.enhydra.jawe.xml.XMLComplexElement;
import org.jgraph.JGraph;
import org.jgraph.event.GraphModelEvent;
import org.jgraph.event.GraphModelListener;
import org.jgraph.event.GraphSelectionEvent;
import org.jgraph.event.GraphSelectionListener;
import org.jgraph.graph.GraphUndoManager;

public abstract class AbstractEditor
extends JPanel
implements GraphModelListener,
GraphSelectionListener,
Observer {
    protected BarFactory barFactory = new BarFactory(this);
    protected AbstractGraph graph;
    protected Hashtable commands;
    protected Hashtable menuItems;
    protected Hashtable specialItems;
    protected Hashtable toolbarComponents;
    protected Hashtable specialButtons;
    protected JMenuBar menubar;
    protected JToolBar toolbar;
    protected JTabbedPane tabbedPane;
    protected JScrollPane graphScrollPane;
    protected JaWEStatusBar statusBar;
    protected GraphUndoManager undo;
    protected UndoHandler undoHandler;
    protected JTabbedPane contentTabbedPane;
    protected XPDLPreview xpdlPreview;
    protected TextPreview textPreview;
    protected Undo undoAction = new Undo(this);
    protected Redo redoAction = new Redo(this);
    protected Action[] defaultActions;
    protected AbstractEditor parentEditor;

    public AbstractEditor(XMLComplexElement pkgOrProcess) {
        super(true);
        this.setBorder(BorderFactory.createEtchedBorder());
        this.setLayout(new BorderLayout());
        this.undoHandler = new UndoHandler(this, true);
        this.undo = new GraphUndoManager();
        this.graph = this.createGraph();
        ToolTipManager.sharedInstance().registerComponent((JComponent)((Object)this.graph));
        this.registerListeners(this.graph);
        this.graph.getModel().addUndoableEditListener((UndoableEditListener)this.undoHandler);
        this.commands = new Hashtable();
        this.createActions();
        Action[] actions = this.getActions();
        for (int i = 0; i < actions.length; ++i) {
            Action a = actions[i];
            this.commands.put(a.getValue("Name"), a);
        }
        this.graph.setAdditionalKeyboardShortcuts();
        JPanel panel = new JPanel();
        panel.setLayout(new BorderLayout());
        this.specialItems = this.createSpecialItems();
        JaWEMarqueeHandler pemh = (JaWEMarqueeHandler)this.graph.getMarqueeHandler();
        this.specialButtons = pemh.getSpecialButtons();
        this.toolbarComponents = new Hashtable();
        this.tabbedPane = new JTabbedPane();
        Component toolBarComponent = this.barFactory.createToolBars(this.tabbedPane);
        this.menuItems = new Hashtable();
        this.menubar = this.barFactory.createMenubar();
        panel.add(toolBarComponent, "North");
        this.add((Component)this.menubar, "North");
        this.graph.setPropertyObject(pkgOrProcess);
        panel.add(this.createCenterComponent(), "Center");
        JPanel mainPanel = new JPanel();
        mainPanel.setLayout(new BorderLayout());
        mainPanel.add((Component)this.menubar, "North");
        mainPanel.add((Component)panel, "Center");
        mainPanel.add(this.createStatusBar(), "South");
        this.add(this.createContentTabbedPane(mainPanel), "Center");
        this.valueChanged(null);
    }

    protected Component createCenterComponent() {
        this.graphScrollPane = new JScrollPane((Component)((Object)this.graph));
        JViewport port = this.graphScrollPane.getViewport();
        port.setScrollMode(1);
        this.graphScrollPane.getVerticalScrollBar().setUnitIncrement(20);
        this.graphScrollPane.getHorizontalScrollBar().setUnitIncrement(40);
        return this.graphScrollPane;
    }

    public TextPreview getTextPreview() {
        return this.textPreview;
    }

    public XPDLPreview getXPDLPreview() {
        return this.xpdlPreview;
    }

    protected Component createContentTabbedPane(Component graphPanel) {
        this.xpdlPreview = new XPDLPreview(this);
        this.textPreview = new TextPreview(this);
        this.contentTabbedPane = new JTabbedPane(3);
        this.contentTabbedPane.addTab(ResourceManager.getLanguageDependentString("GraphViewKey"), graphPanel);
        this.contentTabbedPane.addTab(ResourceManager.getLanguageDependentString("TextViewKey"), (Component)((Object)this.textPreview));
        this.contentTabbedPane.addTab(ResourceManager.getLanguageDependentString("XPDLViewKey"), this.xpdlPreview);
        this.contentTabbedPane.addChangeListener(new ChangeListener(){

            public void stateChanged(ChangeEvent ce) {
                if (AbstractEditor.this.contentTabbedPane.getSelectedIndex() == 1) {
                    AbstractEditor.this.textPreview.refreshView();
                } else if (AbstractEditor.this.contentTabbedPane.getSelectedIndex() == 2) {
                    AbstractEditor.this.xpdlPreview.refreshView();
                }
            }
        });
        return this.contentTabbedPane;
    }

    protected Component createStatusBar() {
        this.statusBar = new JaWEStatusBar(this);
        if (!JaWEConfig.getInstance().getStatusBarStatus()) {
            this.statusBar.setVisible(false);
        }
        return this.statusBar;
    }

    public JaWEStatusBar getStatusBar() {
        return this.statusBar;
    }

    protected abstract AbstractGraph createGraph();

    public abstract String getTitle();

    public abstract String toolbarToLoad();

    public abstract String menubarToLoad();

    protected abstract void createActions();

    public AbstractEditor getParentEditor() {
        return this.parentEditor;
    }

    protected void doEditorSpecificStuff() {
    }

    public Object getSpecialButton(String key) {
        return this.specialButtons.get(key);
    }

    public Map getSpecialButtons() {
        return Collections.unmodifiableMap(this.specialButtons);
    }

    public Object getSpecialItem(String key) {
        return this.specialItems.get(key);
    }

    public Map getSpecialItems() {
        return Collections.unmodifiableMap(this.specialItems);
    }

    public void putMenuItem(String key, Object item) {
        this.menuItems.put(key, item);
    }

    public void putToolbarComponent(String key, Object item) {
        this.toolbarComponents.put(key, item);
    }

    public Map getToolbarComponents() {
        return Collections.unmodifiableMap(this.toolbarComponents);
    }

    public BarFactory getBarFactory() {
        return this.barFactory;
    }

    public JTabbedPane getContentTabbedPane() {
        return this.contentTabbedPane;
    }

    public JTabbedPane getTabbedPane() {
        return this.tabbedPane;
    }

    public JMenuBar getMenubar() {
        return this.menubar;
    }

    public Map getMenuItems() {
        return Collections.unmodifiableMap(this.menuItems);
    }

    public JMenuItem getMenuItem(String cmd) {
        return (JMenuItem)this.menuItems.get(cmd);
    }

    public JComponent getToolbarComponent(String cmd) {
        return (JComponent)this.toolbarComponents.get(cmd);
    }

    public Redo getRedo() {
        return this.redoAction;
    }

    public Undo getUndo() {
        return this.undoAction;
    }

    public JScrollPane getGraphScrollPane() {
        return this.graphScrollPane;
    }

    protected Hashtable createSpecialItems() {
        return new Hashtable();
    }

    public Window getWindow() {
        for (Container p = this.getParent(); p != null; p = p.getParent()) {
            if (!(p instanceof Window)) continue;
            return (Window)p;
        }
        return null;
    }

    public void update() {
        this.undoAction.update();
        this.redoAction.update();
        try {
            this.setTitle(this.getWindow(), this.getTitle());
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void showWindow(Window parentWindow, String name) {
        Window w = this.getWindow();
        if (w != null) {
            this.setBounds(w, parentWindow);
            this.setTitle(w, name);
            this.tabbedPane.requestFocus();
            w.show();
        }
    }

    public void setTitle(Window w, String name) {
        if (w == null) {
            return;
        }
        if (w instanceof JFrame) {
            ((JFrame)w).setTitle(name);
        } else {
            ((JDialog)w).setTitle(name);
        }
    }

    protected void setBounds(Window w, Window parentWindow) {
        Rectangle wBounds = w.getBounds();
        if (parentWindow != null) {
            wBounds = new Rectangle(parentWindow.getBounds());
            wBounds.grow(-20, -20);
        }
        w.setBounds(wBounds);
    }

    public void resetUndoManager() {
        this.undo.discardAllEdits();
        this.undoAction.update();
        this.redoAction.update();
    }

    public GraphUndoManager getUndoManager() {
        return this.undo;
    }

    public AbstractGraph getGraph() {
        return this.graph;
    }

    public void setScale(double scale) {
        scale = Math.max(Math.min(scale, 2.0), 0.1);
        this.graph.setScale(scale);
    }

    protected void setALTCursorKeyboardShortcuts(JComponent jc) {
        String focusUp = "focusUp";
        String focusDown = "focusDown";
        String focusLeft = "focusLeft";
        String focusRight = "focusRight";
        jc.getInputMap(2).put(KeyStroke.getKeyStroke(38, 512, false), focusUp);
        jc.getActionMap().put(focusUp, new FocusNearestCell(this, 0));
        jc.getInputMap(2).put(KeyStroke.getKeyStroke(40, 512, false), focusDown);
        jc.getActionMap().put(focusDown, new FocusNearestCell(this, 1));
        jc.getInputMap(2).put(KeyStroke.getKeyStroke(37, 512, false), focusLeft);
        jc.getActionMap().put(focusLeft, new FocusNearestCell(this, 2));
        jc.getInputMap(2).put(KeyStroke.getKeyStroke(39, 512, false), focusRight);
        jc.getActionMap().put(focusRight, new FocusNearestCell(this, 3));
    }

    public void refreshCollections(Set s1, Set s2) {
        HashSet toAdd = new HashSet();
        HashSet toRemove = new HashSet();
        if (s1 != null) {
            toRemove.addAll(s1);
            if (s2 != null) {
                toRemove.removeAll(s2);
            }
        }
        if (s2 != null) {
            toAdd.addAll(s2);
            if (s1 != null) {
                toAdd.removeAll(s1);
            }
        }
        HashSet transToManage = new HashSet();
        if (s1 != null) {
            transToManage.addAll(s1);
            if (s2 != null) {
                transToManage.removeAll(toRemove);
                transToManage.addAll(toAdd);
            }
            Iterator it = transToManage.iterator();
            while (it.hasNext()) {
                Object o = it.next();
                if (!(o instanceof Transition)) continue;
                this.graph.getWorkflowManager().correctXMLTransition((Transition)o);
            }
        }
        this.graph.getWorkflowManager().refreshCollections(toAdd.toArray(), true);
        this.graph.getWorkflowManager().refreshCollections(toRemove.toArray(), false);
    }

    public Action[] getActions() {
        return this.defaultActions;
    }

    public Action getAction(String cmd) {
        return (Action)this.commands.get(cmd);
    }

    protected void registerListeners(JGraph graph) {
        graph.getSelectionModel().addGraphSelectionListener((GraphSelectionListener)this);
        graph.getModel().addGraphModelListener((GraphModelListener)this);
        graph.getGraphLayoutCache().addObserver((Observer)this);
    }

    protected void unregisterListeners(JGraph graph) {
        graph.getSelectionModel().removeGraphSelectionListener((GraphSelectionListener)this);
        graph.getModel().removeGraphModelListener((GraphModelListener)this);
    }

    public void valueChanged(GraphSelectionEvent e) {
    }

    public void update(Observable obs, Object arg) {
        JaWE.getInstance().setModified(true);
        this.update();
    }

    public void graphChanged(GraphModelEvent e) {
        JaWE.getInstance().setModified(true);
        this.update();
    }

    public void refreshEditorConfiguration() {
        SwingUtilities.updateComponentTreeUI(this);
        for (int i = 0; i < this.tabbedPane.getComponentCount(); ++i) {
            try {
                JPanel p = (JPanel)this.tabbedPane.getComponent(i);
                JToolBar toolbar = (JToolBar)p.getComponent(0);
                toolbar.putClientProperty("JToolBar.isRollover", Boolean.TRUE);
                toolbar.updateUI();
                continue;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        this.statusBar.setVisible(JaWEConfig.getInstance().getStatusBarStatus());
        this.statusBar.updateMessage();
        this.getGraph().refreshGraphConfiguration();
    }
}

