/*
 * Decompiled with CFR 0.152.
 */
package com.lutris.appserver.server.sql.oracle;

import com.lutris.appserver.server.sql.DBConnection;
import com.lutris.dods.builder.generator.query.RDBColumn;
import java.io.BufferedInputStream;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import oracle.jdbc.OracleResultSet;
import oracle.sql.BLOB;
import org.enhydra.dods.DriverDependencies;

public class OracleDriverDependencies
implements DriverDependencies {
    public boolean isBlobAccessSpecial() {
        return true;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void insertBlob(DBConnection conn, byte[] cont, RDBColumn primary, RDBColumn column, String handle) throws SQLException {
        if (null == cont) {
            return;
        }
        Statement qb = null;
        Statement pp = null;
        ResultSet rs = null;
        BLOB blob = null;
        InputStream in = null;
        OutputStream out = null;
        try {
            try {
                qb = conn.getConnection().prepareStatement("select " + column.getColumnName() + " from " + column.getTableName() + " where " + primary.getColumnName() + " = " + handle + " FOR UPDATE");
                rs = qb.executeQuery();
                rs.next();
                blob = ((OracleResultSet)rs).getBLOB(1);
                in = new BufferedInputStream(new ByteArrayInputStream(cont));
                out = blob.getBinaryOutputStream();
                int chunk = blob.getChunkSize();
                byte[] buffer = new byte[chunk];
                int length = -1;
                while ((length = in.read(buffer)) != -1) {
                    out.write(buffer, 0, length);
                }
                if (blob.length() != (long)cont.length) {
                    out.flush();
                }
            }
            catch (IOException e) {
                throw new SQLException("tweak failure", e.getMessage());
            }
            Object var16_16 = null;
        }
        catch (Throwable throwable) {
            Object var16_17 = null;
            try {
                if (out != null) {
                    out.close();
                }
                if (in != null) {
                    in.close();
                }
                if (rs != null) {
                    rs.close();
                }
                if (qb != null) {
                    qb.close();
                }
                if (pp == null) throw throwable;
                pp.close();
                throw throwable;
            }
            catch (Exception e2) {
                // empty catch block
            }
            throw throwable;
        }
        try {}
        catch (Exception e2) {}
        if (out != null) {
            out.close();
        }
        if (in != null) {
            in.close();
        }
        if (rs != null) {
            rs.close();
        }
        if (qb != null) {
            qb.close();
        }
        if (pp == null) return;
        pp.close();
        return;
    }

    public byte[] readBlob(ResultSet rs, String colName) throws SQLException {
        BLOB blob = ((OracleResultSet)rs).getBLOB(colName);
        if (null == blob) {
            return null;
        }
        return blob.getBytes(1L, (int)blob.length());
    }
}

