/*
 * Decompiled with CFR 0.152.
 */
package com.plusmpm.parser.translation.wrapper.general;

import com.plusmpm.parser.translation.utils.XpdlKeyResolver;
import com.plusmpm.parser.translation.wrapper.ElementWrapper;
import com.plusmpm.parser.translation.wrapper.general.PackageParticipantWrapper;
import com.plusmpm.parser.translation.wrapper.general.ProcessWrapper;
import java.beans.ConstructorProperties;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.enhydra.shark.xpdl.elements.Package;
import org.enhydra.shark.xpdl.elements.Participant;
import org.enhydra.shark.xpdl.elements.WorkflowProcess;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PackageWrapper
extends ElementWrapper {
    private static final Logger log = LoggerFactory.getLogger(PackageWrapper.class);
    private Package pack;

    @Override
    public String getKey() {
        return XpdlKeyResolver.extract(this.pack).getKey();
    }

    @Override
    public String getRawName() {
        return this.pack.getName();
    }

    @Override
    public Map<String, String> getProperties() {
        Map<String, String> map = super.getProperties();
        for (PackageParticipantWrapper participant : this.findParticipants()) {
            map.putAll(participant.getProperties());
        }
        for (ProcessWrapper process : this.findProcesses()) {
            map.putAll(process.getProperties());
        }
        return map;
    }

    private List<ProcessWrapper> findProcesses() {
        ArrayList processes = this.pack.getWorkflowProcesses().toElements();
        return processes.stream().map(process -> new ProcessWrapper((WorkflowProcess)process)).collect(Collectors.toList());
    }

    private List<PackageParticipantWrapper> findParticipants() {
        ArrayList packageParticipants = this.pack.getParticipants().toElements();
        return packageParticipants.stream().map(participant -> new PackageParticipantWrapper((Participant)participant)).collect(Collectors.toList());
    }

    @ConstructorProperties(value={"pack"})
    public PackageWrapper(Package pack) {
        this.pack = pack;
    }
}

