/*
 * Decompiled with CFR 0.152.
 */
package com.plusmpm.parser.translation.wrapper.general;

import com.plusmpm.parser.translation.utils.PackageElementsExtractor;
import com.plusmpm.parser.translation.utils.XpdlKeyResolver;
import com.plusmpm.parser.translation.wrapper.ElementWrapper;
import com.plusmpm.parser.translation.wrapper.form.HttpLinkWrapper;
import com.plusmpm.parser.translation.wrapper.form.VariableSetWrapper;
import com.plusmpm.parser.translation.wrapper.form.button.ActionButtonWrapper;
import com.plusmpm.parser.translation.wrapper.form.button.AddFileButtonWrapper;
import com.plusmpm.parser.translation.wrapper.form.button.PdfButtonWrapper;
import java.beans.ConstructorProperties;
import java.util.List;
import java.util.Map;
import org.enhydra.shark.xpdl.elements.Activity;
import org.enhydra.shark.xpdl.elements.ExtendedAttribute;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ActivityWrapper
extends ElementWrapper {
    private static final Logger log = LoggerFactory.getLogger(ActivityWrapper.class);
    private Activity activity;

    @Override
    public String getKey() {
        return XpdlKeyResolver.extract(this.activity).getKey();
    }

    @Override
    public String getRawName() {
        return this.activity.getName();
    }

    @Override
    public Map<String, String> getProperties() {
        Map<String, String> map = super.getProperties();
        map.put(XpdlKeyResolver.extract(this.activity).getKeyDesc(), this.activity.getDescription().replaceAll("\n", "<br>"));
        for (ActionButtonWrapper actionButton : this.getActionButtons()) {
            map.putAll(actionButton.getProperties());
        }
        for (PdfButtonWrapper pdfButton : this.getPdfButtons()) {
            map.putAll(pdfButton.getProperties());
        }
        for (AddFileButtonWrapper addFileButton : this.getAddFileButtons()) {
            map.putAll(addFileButton.getProperties());
        }
        for (HttpLinkWrapper httpLink : this.getHttpLinks()) {
            map.putAll(httpLink.getProperties());
        }
        for (VariableSetWrapper variableSet : this.getVariableSets()) {
            map.putAll(variableSet.getProperties());
        }
        return map;
    }

    private List<ActionButtonWrapper> getActionButtons() {
        return PackageElementsExtractor.getActionAcceptButtons(this.findExtendedAttributes());
    }

    private List<PdfButtonWrapper> getPdfButtons() {
        return PackageElementsExtractor.getPdfButtons(this.findExtendedAttributes());
    }

    private List<AddFileButtonWrapper> getAddFileButtons() {
        return PackageElementsExtractor.getAddFileButtons(this.findExtendedAttributes());
    }

    private List<HttpLinkWrapper> getHttpLinks() {
        return PackageElementsExtractor.getHttpLinks(this.findExtendedAttributes());
    }

    private List<VariableSetWrapper> getVariableSets() {
        return PackageElementsExtractor.getVariableSets(this.findExtendedAttributes());
    }

    private List<ExtendedAttribute> findExtendedAttributes() {
        return PackageElementsExtractor.getExtendedAttributes(this.activity);
    }

    @ConstructorProperties(value={"activity"})
    public ActivityWrapper(Activity activity) {
        this.activity = activity;
    }
}

