/*
 * Decompiled with CFR 0.152.
 */
package com.plusmpm.parser.translation.wrapper.form.datachooser;

import com.google.common.collect.HashMultimap;
import com.google.common.collect.Iterables;
import com.google.common.collect.Multimap;
import com.plusmpm.parser.translation.utils.PackageElementsExtractor;
import com.plusmpm.parser.translation.utils.XpdlKeyResolver;
import com.plusmpm.parser.translation.wrapper.ElementWrapper;
import com.plusmpm.parser.translation.wrapper.form.datachooser.exception.DataChooserSettingDoesNotExist;
import com.plusmpm.parser.wrapper.DataChooser;
import java.beans.ConstructorProperties;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Stream;
import org.enhydra.shark.xpdl.elements.DataField;
import org.enhydra.shark.xpdl.elements.ExtendedAttribute;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractDataChooserWrapper
extends ElementWrapper {
    private static final Logger log = LoggerFactory.getLogger(AbstractDataChooserWrapper.class);
    protected DataField field;

    @Override
    public Map<String, String> getProperties() {
        LinkedHashMap<String, String> map = new LinkedHashMap<String, String>();
        try {
            DataChooser dataChooserXpdlKey = XpdlKeyResolver.extractDataChooser(this.field);
            this.getTranslatedMappings().forEach((mappingName, mappingTranslation) -> map.put(dataChooserXpdlKey.getMapping((String)mappingName), (String)mappingTranslation));
        }
        catch (Exception ex) {
            log.error(ex.getMessage(), (Throwable)ex);
        }
        return map;
    }

    protected abstract Map<String, String> getTranslatedMappings();

    protected static Multimap<String, String> findDataChooserSettings(DataField field) {
        Optional<ExtendedAttribute> optionalAttribute = PackageElementsExtractor.getExtendedAttribute(field, "DATA_CHOOSER");
        if (optionalAttribute.isPresent()) {
            String attrValue = optionalAttribute.get().getVValue();
            HashMultimap result = HashMultimap.create();
            Stream.of(attrValue.split("\n")).map(dcOption -> dcOption.split("=")).forEach(arg_0 -> AbstractDataChooserWrapper.lambda$findDataChooserSettings$2((Multimap)result, arg_0));
            return result;
        }
        return HashMultimap.create();
    }

    protected static String findDataChooserSetting(DataField field, String name) throws DataChooserSettingDoesNotExist {
        Multimap<String, String> settings = AbstractDataChooserWrapper.findDataChooserSettings(field);
        if (settings.containsKey((Object)name)) {
            return (String)Iterables.get((Iterable)settings.get((Object)name), (int)0);
        }
        throw new DataChooserSettingDoesNotExist();
    }

    @Override
    public String getKey() {
        return null;
    }

    @Override
    public String getRawName() {
        return null;
    }

    static boolean isDataChooser(DataField field) {
        return PackageElementsExtractor.getExtendedAttribute(field, "DATA_CHOOSER").isPresent();
    }

    @ConstructorProperties(value={"field"})
    public AbstractDataChooserWrapper(DataField field) {
        this.field = field;
    }

    private static /* synthetic */ void lambda$findDataChooserSettings$2(Multimap result, String[] split) {
        String key = split[0].trim();
        String value = "";
        if (split.length > 1) {
            value = split[1].trim();
        }
        result.put((Object)key, (Object)value);
    }
}

