/*
 * Decompiled with CFR 0.152.
 */
package com.plusmpm.parser.translation.utils;

import com.plusmpm.parser.translation.wrapper.form.HttpLinkWrapper;
import com.plusmpm.parser.translation.wrapper.form.LabelWrapper;
import com.plusmpm.parser.translation.wrapper.form.VariableSetWrapper;
import com.plusmpm.parser.translation.wrapper.form.button.ActionButtonWrapper;
import com.plusmpm.parser.translation.wrapper.form.button.AddFileButtonWrapper;
import com.plusmpm.parser.translation.wrapper.form.button.DtButtonWrapper;
import com.plusmpm.parser.translation.wrapper.form.button.PdfButtonWrapper;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import org.enhydra.shark.xpdl.elements.Activity;
import org.enhydra.shark.xpdl.elements.DataField;
import org.enhydra.shark.xpdl.elements.ExtendedAttribute;
import org.enhydra.shark.xpdl.elements.Participant;
import org.enhydra.shark.xpdl.elements.WorkflowProcess;

public class PackageElementsExtractor {
    public static List<Participant> getParticipants(WorkflowProcess process) {
        LinkedList<Participant> participants = new LinkedList<Participant>();
        for (Participant participant : process.getParticipants().toElements()) {
            participants.add(participant);
        }
        return participants;
    }

    public static List<ExtendedAttribute> getExtendedAttributes(WorkflowProcess process) {
        LinkedList<ExtendedAttribute> extendedAttributes = new LinkedList<ExtendedAttribute>();
        for (ExtendedAttribute extendedAttribute : process.getExtendedAttributes().toElements()) {
            extendedAttributes.add(extendedAttribute);
        }
        return extendedAttributes;
    }

    public static Optional<ExtendedAttribute> getProcessNameMask(List<ExtendedAttribute> extendedAttributes) {
        return extendedAttributes.stream().filter(extendedAttribute -> extendedAttribute.getName().equals("PROCESS_NAME_MASK")).findFirst();
    }

    public static List<DataField> getDataFields(WorkflowProcess process) {
        LinkedList<DataField> dataFields = new LinkedList<DataField>();
        for (DataField dataField : process.getDataFields().toElements()) {
            dataFields.add(dataField);
        }
        return dataFields;
    }

    public static Optional<ExtendedAttribute> getExtendedAttribute(DataField field, String name) {
        List<ExtendedAttribute> extendedAttributes = PackageElementsExtractor.getExtendedAttributes(field);
        List<ExtendedAttribute> extAttrs = PackageElementsExtractor.getByName(extendedAttributes, name);
        if (extAttrs.size() > 0) {
            return Optional.ofNullable(extAttrs.get(0));
        }
        return Optional.empty();
    }

    public static List<ExtendedAttribute> getExtendedAttributes(DataField dataField) {
        LinkedList<ExtendedAttribute> extendedAttributes = new LinkedList<ExtendedAttribute>();
        for (ExtendedAttribute extendedAttribute : dataField.getExtendedAttributes().toElements()) {
            extendedAttributes.add(extendedAttribute);
        }
        return extendedAttributes;
    }

    public static List<Activity> getActivities(WorkflowProcess process) {
        LinkedList<Activity> activities = new LinkedList<Activity>();
        for (Activity activity : process.getActivities().toElements()) {
            activities.add(activity);
        }
        return activities;
    }

    public static List<ExtendedAttribute> getExtendedAttributes(Activity activity) {
        LinkedList<ExtendedAttribute> extendedAttributes = new LinkedList<ExtendedAttribute>();
        for (ExtendedAttribute extendedAttribute : activity.getExtendedAttributes().toElements()) {
            extendedAttributes.add(extendedAttribute);
        }
        return extendedAttributes;
    }

    public static List<ActionButtonWrapper> getActionAcceptButtons(List<ExtendedAttribute> extendedAttributes) {
        return PackageElementsExtractor.getByName(extendedAttributes, "ACTION_ACCEPT_BUTTON").stream().map(attribute -> new ActionButtonWrapper((ExtendedAttribute)attribute)).collect(Collectors.toList());
    }

    public static List<PdfButtonWrapper> getPdfButtons(List<ExtendedAttribute> extendedAttributes) {
        return PackageElementsExtractor.getByName(extendedAttributes, "GENERATE_PDF_BUTTON").stream().map(attribute -> new PdfButtonWrapper((ExtendedAttribute)attribute)).collect(Collectors.toList());
    }

    public static List<AddFileButtonWrapper> getAddFileButtons(List<ExtendedAttribute> extendedAttributes) {
        return PackageElementsExtractor.getByName(extendedAttributes, "ADD_FILE_BUTTON").stream().map(attribute -> new AddFileButtonWrapper((ExtendedAttribute)attribute)).collect(Collectors.toList());
    }

    public static List<HttpLinkWrapper> getHttpLinks(List<ExtendedAttribute> extendedAttributes) {
        return PackageElementsExtractor.getByName(extendedAttributes, "HTTP_LINK").stream().map(attribute -> new HttpLinkWrapper((ExtendedAttribute)attribute)).collect(Collectors.toList());
    }

    private static Map<String, List<DtButtonWrapper>> getDtButtons(List<ExtendedAttribute> extendedAttributes) {
        LinkedHashMap<String, List<DtButtonWrapper>> map = new LinkedHashMap<String, List<DtButtonWrapper>>();
        PackageElementsExtractor.getByName(extendedAttributes, "DT_BUTTON").forEach(dtButton -> {
            DtButtonWrapper buttonWrapper = new DtButtonWrapper((ExtendedAttribute)dtButton);
            String variableSetId = buttonWrapper.getVariableSetId();
            if (!map.containsKey(variableSetId)) {
                map.put(variableSetId, new LinkedList());
            }
            ((List)map.get(variableSetId)).add(buttonWrapper);
        });
        return map;
    }

    public static List<VariableSetWrapper> getVariableSets(List<ExtendedAttribute> extendedAttributes) {
        List<ExtendedAttribute> filteredAttributes = PackageElementsExtractor.filterBy(extendedAttributes, extendedAttribute -> extendedAttribute.getName().matches("VARIABLE_SET(|_VIEW)"));
        LinkedList<VariableSetWrapper> variableSets = new LinkedList<VariableSetWrapper>();
        for (int i = 0; i < filteredAttributes.size(); ++i) {
            Map<String, List<DtButtonWrapper>> dtButtons = PackageElementsExtractor.getDtButtons(extendedAttributes);
            VariableSetWrapper variableSetWrapper = new VariableSetWrapper(filteredAttributes.get(i), i);
            String tableId = variableSetWrapper.getTableId();
            LinkedList<DtButtonWrapper> buttons = new LinkedList();
            if (dtButtons.containsKey(tableId)) {
                buttons = dtButtons.get(tableId);
            }
            buttons.forEach(button -> button.setVariableSet(variableSetWrapper));
            variableSetWrapper.setDtButtons(buttons);
            variableSets.add(variableSetWrapper);
        }
        return variableSets;
    }

    public static List<LabelWrapper> getLabels(List<ExtendedAttribute> extendedAttributes) {
        return PackageElementsExtractor.getByName(extendedAttributes, "LABEL").stream().map(attribute -> new LabelWrapper((ExtendedAttribute)attribute)).collect(Collectors.toList());
    }

    private static List<ExtendedAttribute> getByName(List<ExtendedAttribute> extendedAttributes, String name) {
        return PackageElementsExtractor.filterBy(extendedAttributes, extendedAttribute -> extendedAttribute.getName().equals(name));
    }

    private static <T> List<T> filterBy(Collection<T> collection, Predicate<T> predicate) {
        return collection.stream().filter(predicate).collect(Collectors.toList());
    }
}

