/*
 * Decompiled with CFR 0.152.
 */
package com.plusmpm.parser.translation.wrapper.general;

import com.plusmpm.parser.translation.utils.PackageElementsExtractor;
import com.plusmpm.parser.translation.utils.XpdlKeyResolver;
import com.plusmpm.parser.translation.wrapper.ElementWrapper;
import com.plusmpm.parser.translation.wrapper.form.DataFieldWrapper;
import com.plusmpm.parser.translation.wrapper.form.LabelWrapper;
import com.plusmpm.parser.translation.wrapper.form.datachooser.AbstractDataChooserWrapper;
import com.plusmpm.parser.translation.wrapper.form.datachooser.ClassDataChooserWrapper;
import com.plusmpm.parser.translation.wrapper.form.datachooser.ComponentDataChooserWrapper;
import com.plusmpm.parser.translation.wrapper.general.ActivityWrapper;
import com.plusmpm.parser.translation.wrapper.general.ParticipantWrapper;
import java.beans.ConstructorProperties;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.enhydra.shark.xpdl.elements.ExtendedAttribute;
import org.enhydra.shark.xpdl.elements.WorkflowProcess;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ProcessWrapper
extends ElementWrapper {
    private static final Logger log = LoggerFactory.getLogger(ProcessWrapper.class);
    private WorkflowProcess process;

    @Override
    public String getKey() {
        return XpdlKeyResolver.extract(this.process).getKey();
    }

    @Override
    public String getRawName() {
        return this.process.getName();
    }

    @Override
    public Map<String, String> getProperties() {
        Map<String, String> map = super.getProperties();
        map.put(XpdlKeyResolver.extract(this.process).getKeyDesc(), this.getDescription());
        this.resolveProcessNameMask(map);
        for (ParticipantWrapper participant : this.findParticipants()) {
            map.putAll(participant.getProperties());
        }
        for (DataFieldWrapper dataField : this.findDataFields()) {
            map.putAll(dataField.getProperties());
        }
        for (AbstractDataChooserWrapper dataChooser : this.findDataChoosers()) {
            map.putAll(dataChooser.getProperties());
        }
        for (LabelWrapper label : this.getLabels()) {
            map.putAll(label.getProperties());
        }
        for (ActivityWrapper activity : this.findActivities()) {
            map.putAll(activity.getProperties());
        }
        return map;
    }

    private void resolveProcessNameMask(Map<String, String> map) {
        List<ExtendedAttribute> extendedAttributes = PackageElementsExtractor.getExtendedAttributes(this.process);
        String nameMaskTranslation = this.getProcessNameMaskValue(extendedAttributes);
        String processNameMask = XpdlKeyResolver.extract(this.process).forProcessNameMask().getKey();
        map.put(processNameMask, nameMaskTranslation);
    }

    private String getProcessNameMaskValue(List<ExtendedAttribute> extendedAttributes) {
        Optional<ExtendedAttribute> optionalProcessNameMask = PackageElementsExtractor.getProcessNameMask(extendedAttributes);
        return optionalProcessNameMask.map(extendedAttribute -> extendedAttribute.getVValue().split("_")[0].trim()).orElseGet(this::getName);
    }

    private String getDescription() {
        String description = this.process.getProcessHeader().getDescription();
        description = description.replace("\n", "</br>");
        description = description.replace("\r\n", "</br>");
        return description;
    }

    private List<DataFieldWrapper> findDataFields() {
        return PackageElementsExtractor.getDataFields(this.process).stream().map(DataFieldWrapper::new).collect(Collectors.toList());
    }

    private List<ParticipantWrapper> findParticipants() {
        return PackageElementsExtractor.getParticipants(this.process).stream().map(ParticipantWrapper::new).collect(Collectors.toList());
    }

    private List<ActivityWrapper> findActivities() {
        return PackageElementsExtractor.getActivities(this.process).stream().map(ActivityWrapper::new).collect(Collectors.toList());
    }

    private List<AbstractDataChooserWrapper> findDataChoosers() {
        return Stream.concat(this.findComponentDataChoosers(), this.findClassDataChoosers()).collect(Collectors.toList());
    }

    private Stream<ComponentDataChooserWrapper> findComponentDataChoosers() {
        return PackageElementsExtractor.getDataFields(this.process).stream().filter(ComponentDataChooserWrapper::isTypeOf).map(ComponentDataChooserWrapper::new);
    }

    private Stream<ClassDataChooserWrapper> findClassDataChoosers() {
        return PackageElementsExtractor.getDataFields(this.process).stream().filter(ClassDataChooserWrapper::isTypeOf).map(ClassDataChooserWrapper::new);
    }

    private List<LabelWrapper> getLabels() {
        return PackageElementsExtractor.getLabels(this.findExtendedAttributes());
    }

    private List<ExtendedAttribute> findExtendedAttributes() {
        return PackageElementsExtractor.getExtendedAttributes(this.process);
    }

    @ConstructorProperties(value={"process"})
    public ProcessWrapper(WorkflowProcess process) {
        this.process = process;
    }
}

