/**
 *
 */
package com.plusmpm.parser.xpdlelements;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;

import org.apache.log4j.Logger;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

/**
 * @author Michał Bocian 16-08-2011
 */
@Deprecated
public class Process
    extends XpdlNode
{
    private static Logger log = Logger.getLogger( Process.class );

    public Process( Node el, XpdlNode parentNode )
    {
        super( el, parentNode );
    }

    public String getId()
    {
        return this.parentNode.getId() + "_PROC(" + this.id + ")";
    }

    private List<Activity> findActivities()
    {
        List<Activity> activities = new ArrayList<Activity>();

        NodeList childrenNodes = node.getChildNodes();

        for ( int i = 0; i < childrenNodes.getLength(); i++ )
        {
            Node child = childrenNodes.item( i );
			if ("Activities".equals(child.getLocalName()))
            {
                NodeList participantNodes = child.getChildNodes();

                for ( int j = 0; j < participantNodes.getLength(); j++ )
                {
                    Node participantNode = participantNodes.item( j );
					if ("Activity".equals(participantNode.getLocalName()))
                        activities.add( new Activity( participantNode, this ) );
                }
            }
        }
        if ( activities.isEmpty() )
        {
			log.warn("Brak zadań dla: '" + getId() + "");
        }

        return activities;
    }

    private String getDescription()
    {
        NodeList activityChildren = node.getChildNodes();
        for ( int i = 0; i < activityChildren.getLength(); i++ )
        {
            Node child = activityChildren.item( i );
			if ("ProcessHeader".equals(child.getLocalName()))
            {
                NodeList processHeader = child.getChildNodes();
                for ( int j = 0; j < processHeader.getLength(); j++ )
                {
                    Node header = processHeader.item( j );
					if ("Description".equals(header.getLocalName()))
                    {
                        return header.getFirstChild().getNodeValue();
                    }
                }
            }
        }
		log.trace("Proces: " + this.id + " nie posiada opisu!");
        return "";
    }

    /**
     * {@link Parsable#getProperties()}
     */
    public Map<String, String> getProperties()
    {
		Map<String, String> map = super.getProperties();

        ExtendedAttribute ea = getProcessNameMask();
        if ( ea != null )
        {
            map.putAll( ea.getProperties() );
        }

        for ( Participant participant : findParticipants() )
        {
            map.putAll( participant.getProperties() );
        }

        for ( DataField dataField : findDataFields() )
        {
            map.putAll( dataField.getProperties() );
        }

        for ( Activity activity : findActivities() )
        {
            map.putAll( activity.getProperties() );
        }

        map.put( this.parentNode.getId() + "_PROC(" + this.id + ")_DESC", getDescription() );

        return map;
    }

    private List<DataField> findDataFields()
    {
        return DataField.findDataFields( node, this );
    }

    private List<Participant> findParticipants()
    {
        return Participant.findParticipants( node, this );
    }

    private ProcessNameMaskAttr getProcessNameMask()
    {
        NodeList extendedAttrs = getExtendedAttributes();

        for ( int j = 0; j < extendedAttrs.getLength(); j++ )
        {
            Node extendedAttr = extendedAttrs.item( j );
            try
            {
                String name = extendedAttr.getAttributes().getNamedItem( "Name" ).toString();
                name = splitValue( name );
                if ( name.equals( "PROCESS_NAME_MASK" ) )
                {
                    return new ProcessNameMaskAttr( extendedAttr, this );
                }
            }
            catch ( NullPointerException npe )
            {

            }
        }
        return null;
    }

}
