package com.plusmpm.parser.xpdlelements;

import java.util.Map;

import org.apache.log4j.Logger;
import org.w3c.dom.Node;

/**
 * @author Rafał Nowacki 2017-03-22
 */
@Deprecated
public class DtButtonAttr
    extends ExtendedAttribute
{
    private static Logger log = Logger.getLogger( DtButtonAttr.class );

    private String[] rows;

    private String buttonId;

    private String variableSetId;

    public DtButtonAttr( Node el, XpdlNode parentNode )
    {
        super();

        String valueAttr = el.getAttributes().getNamedItem( "Value" ).getNodeValue();
        this.rows = valueAttr.split( "\n" );
        this.parentNode = parentNode;
        this.node = el;
        this.buttonId = getButtonId();
        this.name = getName();
        this.variableSetId = resolveVariableSetId();
        this.id = getId();
    }

    public Map<String, String> getProperties()
    {
        Map<String, String> map = super.getProperties();
        map.put( this.getId() + "_DESC", getTooltip() );

        return map;
    }

    private String getTooltip()
    {
        for ( String row : rows )
        {
            if ( row.startsWith( "tooltip" ) )
            {
                return row.split( "=" )[1];
            }
        }
        return "";
    }

    public String getVariableSetId()
    {
        return variableSetId;
    }

    private String getButtonId()
    {
        for ( String row : rows )
        {
            if ( row.startsWith( "id" ) )
            {
                return row.split( "=" )[1].replaceAll( " ", "_" );
            }
        }

        log.error( "DtButton nie posiada id!" );
        throw new IllegalArgumentException();
    }

    private String resolveVariableSetId()
    {
        for ( String row : rows )
        {
            if ( row.startsWith( "variableSetId" ) )
            {
                return row.split( "=" )[1];
            }
        }
        log.warn( "DtButton w zadaniu: " + getId() + " nie jest przypisany do żadnej tabeli!" );
        return "";
    }

    public String getId()
    {
        return parentNode.getId() + "_DTBUTTON(" + this.buttonId + ")";
    }

    public String getName()
    {
        for ( String row : rows )
        {
            if ( row.startsWith( "text" ) )
            {
                return row.split( "=" )[1];
            }
        }
        log.warn( "DtButton w zadaniu: " + getId() + " nie ma zdefiniowanej nazwy!" );
        return "";
    }

    public void setParentNode( XpdlNode parentNode )
    {
        this.parentNode = parentNode;
    }
}
