package com.plusmpm.parser.translation.wrapper.general;

import com.plusmpm.parser.translation.utils.XpdlKeyResolver;
import com.plusmpm.parser.translation.wrapper.ElementWrapper;
import lombok.AllArgsConstructor;
import org.enhydra.shark.xpdl.elements.Participant;

@AllArgsConstructor
public class PackageParticipantWrapper
                extends ElementWrapper
{
    private Participant participant;

    @Override
    public String getKey()
    {
        return XpdlKeyResolver.extractParticipantForPackage( participant );
    }

    @Override
    public String getRawName()
    {
        return participant.getName();
    }
}
