package com.plusmpm.parser.translation.wrapper.general;

import com.plusmpm.parser.translation.utils.PackageElementsExtractor;
import com.plusmpm.parser.translation.utils.XpdlKeyResolver;
import com.plusmpm.parser.translation.wrapper.*;
import com.plusmpm.parser.translation.wrapper.form.HttpLinkWrapper;
import com.plusmpm.parser.translation.wrapper.form.VariableSetWrapper;
import com.plusmpm.parser.translation.wrapper.form.button.ActionButtonWrapper;
import com.plusmpm.parser.translation.wrapper.form.button.AddFileButtonWrapper;
import com.plusmpm.parser.translation.wrapper.form.button.PdfButtonWrapper;
import lombok.AllArgsConstructor;
import lombok.extern.slf4j.Slf4j;
import org.enhydra.shark.xpdl.elements.Activity;
import org.enhydra.shark.xpdl.elements.ExtendedAttribute;

import java.util.List;
import java.util.Map;

@Slf4j
@AllArgsConstructor
public class ActivityWrapper
                extends ElementWrapper
{
    private Activity activity;

    @Override
    public String getKey()
    {
        return XpdlKeyResolver.extract( activity ).getKey();
    }

    @Override
    public String getRawName()
    {
        return activity.getName();
    }

    @Override
    public Map<String, String> getProperties()
    {
        Map<String, String> map = super.getProperties();
        map.put( XpdlKeyResolver.extract( activity ).getKeyDesc(),
                 activity.getDescription().replaceAll( "\n", "<br>" ) );

        for ( ActionButtonWrapper actionButton : getActionButtons() )
        {
            map.putAll( actionButton.getProperties() );
        }

        for ( PdfButtonWrapper pdfButton : getPdfButtons() )
        {
            map.putAll( pdfButton.getProperties() );
        }

        for ( AddFileButtonWrapper addFileButton : getAddFileButtons() )
        {
            map.putAll( addFileButton.getProperties() );
        }

        for ( HttpLinkWrapper httpLink : getHttpLinks() )
        {
            map.putAll( httpLink.getProperties() );
        }

        for ( VariableSetWrapper variableSet : getVariableSets() )
        {
            map.putAll( variableSet.getProperties() );
        }

        return map;
    }

    private List<ActionButtonWrapper> getActionButtons()
    {
        return PackageElementsExtractor.getActionAcceptButtons( findExtendedAttributes() );
    }

    public List<PdfButtonWrapper> getPdfButtons()
    {
        return PackageElementsExtractor.getPdfButtons( findExtendedAttributes() );
    }

    public List<AddFileButtonWrapper> getAddFileButtons()
    {
        return PackageElementsExtractor.getAddFileButtons( findExtendedAttributes() );
    }

    public List<HttpLinkWrapper> getHttpLinks()
    {
        return PackageElementsExtractor.getHttpLinks( findExtendedAttributes() );
    }

    public List<VariableSetWrapper> getVariableSets()
    {
        return PackageElementsExtractor.getVariableSets( findExtendedAttributes() );
    }

    private List<ExtendedAttribute> findExtendedAttributes()
    {
        return PackageElementsExtractor.getExtendedAttributes( activity );
    }
}
