package com.plusmpm.parser.translation.wrapper.form;

import com.plusmpm.parser.translation.utils.XpdlKeyResolver;
import com.plusmpm.parser.translation.wrapper.ExtendedAttributeWrapper;
import com.plusmpm.parser.translation.wrapper.form.button.DtButtonWrapper;
import lombok.Data;
import org.enhydra.shark.xpdl.elements.ExtendedAttribute;

import java.util.List;
import java.util.Map;

@Data
public class VariableSetWrapper
                extends ExtendedAttributeWrapper
{
    private static String TABLE_ID_ATTRIBUTE = "DT_TABLE_ID";

    private static String TABLE_NAME_ATTRIBUTE = "DT_TABLE_NAME";

    private List<DtButtonWrapper> dtButtons;

    private Integer variableSetNumber;

    public VariableSetWrapper( ExtendedAttribute attribute, Integer variableSetNumber )
    {
        super( attribute );
        this.variableSetNumber = variableSetNumber;
    }

    @Override
    public String getKey()
    {
        return XpdlKeyResolver.extract( this ).getKey();
    }

    @Override
    public String getRawName()
    {
        return getName();
    }

    public String getTableId()
    {
        return getAttribute( TABLE_ID_ATTRIBUTE );
    }

    public String getName()
    {
        return getAttribute( TABLE_NAME_ATTRIBUTE );
    }

    @Override public Map<String, String> getProperties()
    {
        Map<String, String> map = super.getProperties();

        dtButtons.forEach( button -> {
            map.putAll( button.getProperties() );
        } );

        return map;
    }
}
