package com.plusmpm.parser.translation.wrapper.form;

import com.plusmpm.parser.translation.utils.XpdlKeyResolver;
import com.plusmpm.parser.translation.wrapper.ElementWrapper;
import lombok.AllArgsConstructor;
import lombok.extern.slf4j.Slf4j;
import org.enhydra.shark.xpdl.elements.DataField;

import java.util.Map;

@Slf4j
@AllArgsConstructor
public class DataFieldWrapper
                extends ElementWrapper
{
    private DataField dataField;

    @Override
    public Map<String, String> getProperties()
    {
        Map<String, String> map = super.getProperties();
        map.put( XpdlKeyResolver.extract( dataField ).getKeyDesc(), dataField.getDescription().replaceAll( "\n", "<br>" ) );

        return map;
    }

    @Override
    public String getKey()
    {
        return XpdlKeyResolver.extract( dataField ).getKey();
    }

    @Override
    public String getRawName()
    {
        return dataField.getName();
    }
}
