/**
 *
 */
package com.plusmpm.parser.printer;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.util.Map;
import java.util.Properties;

import org.apache.log4j.Logger;

/**
 * @author Michał Bocian 17-08-2011
 */
public class FilePrinter
{
    private static Logger log = Logger.getLogger( FilePrinter.class );

    private File output;

    public FilePrinter( File file )
    {
        this.output = file;
    }

    public void printProperties( Map<String, String> propertiesMap )
    {
        Properties properties = new Properties();
        properties.putAll( propertiesMap );

        Writer writer = null;
        try
        {
            writer = new OutputStreamWriter( new FileOutputStream( output ), "UTF-8" );
            properties.store( writer, null );
        }
        catch ( IOException e )
        {
            log.error( "Wystąpił błąd przy zapisywaniu do pliku:" );
            return;
        }
        finally
        {
            try
            {
                writer.close();
            }
            catch ( IOException e )
            {
                // ignore
                log.error( "Wystąpił błąd przy próbie zamknięcia pliku." );
            }
        }
    }
}
