/*
 * Decompiled with CFR 0.152.
 */
package com.plusmpm.parser.translation;

import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;

public class TranslationDiff {
    private Map<String, String> translationsToUpdate = new LinkedHashMap<String, String>();
    private Set<String> translationsToRemove = new HashSet<String>();

    public static TranslationDiff resolveTranslationDiff(Map<String, String> newerTranslations, Map<String, String> olderTranslations) {
        TranslationDiff diff = new TranslationDiff();
        olderTranslations.forEach((oldKey, oldValue) -> {
            if (newerTranslations.containsKey(oldKey)) {
                String newValue = (String)newerTranslations.get(oldKey);
                if (!newValue.equals(oldValue)) {
                    diff.getTranslationsToUpdate().put((String)oldKey, newValue);
                }
            } else {
                diff.getTranslationsToRemove().add((String)oldKey);
            }
        });
        newerTranslations.forEach((newKey, newValue) -> {
            if (!olderTranslations.containsKey(newKey)) {
                diff.getTranslationsToUpdate().put((String)newKey, (String)newValue);
            }
        });
        return diff;
    }

    public Map<String, String> getTranslationsToUpdate() {
        return this.translationsToUpdate;
    }

    public Set<String> getTranslationsToRemove() {
        return this.translationsToRemove;
    }

    public void setTranslationsToUpdate(Map<String, String> translationsToUpdate) {
        this.translationsToUpdate = translationsToUpdate;
    }

    public void setTranslationsToRemove(Set<String> translationsToRemove) {
        this.translationsToRemove = translationsToRemove;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof TranslationDiff)) {
            return false;
        }
        TranslationDiff other = (TranslationDiff)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Map<String, String> this$translationsToUpdate = this.getTranslationsToUpdate();
        Map<String, String> other$translationsToUpdate = other.getTranslationsToUpdate();
        if (this$translationsToUpdate == null ? other$translationsToUpdate != null : !((Object)this$translationsToUpdate).equals(other$translationsToUpdate)) {
            return false;
        }
        Set<String> this$translationsToRemove = this.getTranslationsToRemove();
        Set<String> other$translationsToRemove = other.getTranslationsToRemove();
        return !(this$translationsToRemove == null ? other$translationsToRemove != null : !((Object)this$translationsToRemove).equals(other$translationsToRemove));
    }

    protected boolean canEqual(Object other) {
        return other instanceof TranslationDiff;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Map<String, String> $translationsToUpdate = this.getTranslationsToUpdate();
        result = result * 59 + ($translationsToUpdate == null ? 43 : ((Object)$translationsToUpdate).hashCode());
        Set<String> $translationsToRemove = this.getTranslationsToRemove();
        result = result * 59 + ($translationsToRemove == null ? 43 : ((Object)$translationsToRemove).hashCode());
        return result;
    }

    public String toString() {
        return "TranslationDiff(translationsToUpdate=" + this.getTranslationsToUpdate() + ", translationsToRemove=" + this.getTranslationsToRemove() + ")";
    }
}

