/**
 *
 */
package com.plusmpm.parser.xpdlelements;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;

import org.apache.log4j.Logger;
import org.w3c.dom.Node;

/**
 * @author Michał Bocian 17-08-2011
 */
@Deprecated
public class VariableSetAttr
    extends ExtendedAttribute
{
    private static Logger log = Logger.getLogger( VariableSetAttr.class );

    public static final String DT_TABLE_ID = "DT_TABLE_ID";

    public static final String DT_TABLE_NAME = "DT_TABLE_NAME";

    /**
     * Numer w danym węźle
     */
    private int number;

    private String tableId;

    /**
     * Tablica łańcuchów zawierająca definicję tabelki
     */
    private String[] rows;

    private List<DtButtonAttr> dtButtons = new ArrayList<DtButtonAttr>();

    /**
     * Konstruktor stawawiający podstawowe informacje o tabelce dynamicznej
     * 
     * @param el Element XPDL odpowiadający danemu węzłowi
     * @param parentNode Obiekt XpdlNode rodzica danego elementu
     * @param nr Numer tabelki dynamicznej w danym węźle
     * @author Michał Bocian 25-08-2011
     */
    public VariableSetAttr( Node el, XpdlNode parentNode, int nr )
    {
        super();

        String valueAttr = el.getAttributes().getNamedItem( "Value" ).getNodeValue();
        this.rows = valueAttr.split( "\n" );

        this.number = nr;
        this.parentNode = parentNode;
        this.tableId = getTableId();
        this.id = getId();
        this.name = getName();
        this.node = el;
    }

    /**
     * {@link XpdlNode#getId()}
     */
    public String getId()
    {
        return parentNode.getId() + "_VARIABLESET(" + ( ( tableId == null || tableId.isEmpty() ) ? number : tableId )
            + ")";
    }

    /**
     * {@link XpdlNode#getName()}
     */
    public String getName()
    {
        return getAttributeValue( DT_TABLE_NAME );
    }

    public String getTableId()
    {
        return getAttributeValue( DT_TABLE_ID );
    }

    public Map<String, String> getProperties()
    {
        Map<String, String> map = super.getProperties();
        for ( DtButtonAttr button : dtButtons )
        {
            button.setParentNode( this );
            map.putAll( button.getProperties() );
        }

        return map;
    }

    private String getAttributeValue( String attributeName )
    {
        for ( String row : rows )
        {
            if ( row.startsWith( attributeName ) )
            {
                return row.split( "=", -1 )[1];
            }
        }
        log.trace( "Tabela dynamiczna: ".concat( getId() )
            .concat( " nie ma podanego atrybutu \"" + attributeName + "\"" ) );
        return "";
    }

    public void setDtButtons( List<DtButtonAttr> dtButtons )
    {
        if ( dtButtons != null )
        {
            this.dtButtons = dtButtons;
        }
    }
}
