package com.plusmpm.parser.xpdlelements;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;

import org.apache.log4j.Logger;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

/**
 * @author Michał Bocian 16-08-2011
 */
@Deprecated
public class DataField
    extends XpdlNode
{
    private static Logger log = Logger.getLogger( DataField.class );

    /**
     * @author Michał Bocian 16-08-2011
     */
    public DataField( Node el, XpdlNode parentNode )
    {
        super( el, parentNode );
    }

    @Override
    public String getId()
    {
        return parentNode.getId() + "_DATAFIELD(" + this.id + ")";
    }

    public static List<DataField> findDataFields( Node el, XpdlNode node )
    {
        List<DataField> dataFields = new ArrayList<DataField>();

        NodeList childrenNodes = el.getChildNodes();

        for ( int i = 0; i < childrenNodes.getLength(); i++ )
        {
            Node child = childrenNodes.item( i );
            if ( "DataFields".equals( child.getLocalName() ) )
            {
                NodeList dataFieldsNodes = child.getChildNodes();

                for ( int j = 0; j < dataFieldsNodes.getLength(); j++ )
                {
                    Node dataFieldNode = dataFieldsNodes.item( j );
                    if ( "DataField".equals( dataFieldNode.getLocalName() ) )
                        dataFields.add( new DataField( dataFieldNode, node ) );
                }
            }
        }
        if ( dataFields.isEmpty() )
        {
            log.warn( "Brak zmiennych dla: '" + node.getId() + "" );
        }

        return dataFields;
    }

    public Map<String, String> getProperties()
    {
        Map<String, String> map = super.getProperties();
        map.put( parentNode.getId() + "_DATAFIELD(" + this.id + ")_DESC", getDescription() );

        return map;
    }

    private String getDescription()
    {
        NodeList dateFieldChildren = node.getChildNodes();
        for ( int i = 0; i < dateFieldChildren.getLength(); i++ )
        {
            Node child = dateFieldChildren.item( i );
            if ( "Description".equals( child.getLocalName() ) )
            {
                return child.getFirstChild().getNodeValue().replaceAll( "\n", "<br>" );
            }
        }
        log.trace( "Zmienna: " + this.id + " nie posiada opisu!" );
        return "";
    }

}
