package com.plusmpm.parser.translation.wrapper.form.button;

import com.plusmpm.parser.translation.utils.XpdlKeyResolver;
import org.enhydra.shark.xpdl.elements.ExtendedAttribute;

public class PdfButtonWrapper
                extends ActionButtonWrapper
{
    private static String ID_ATTRIBUTE = "Template";

    public PdfButtonWrapper( ExtendedAttribute attribute )
    {
        super( attribute );
    }

    @Override
    public String getKey()
    {
        return XpdlKeyResolver.extractPdfButton( this ).getKey();
    }

    @Override
    public String getId()
    {
        for ( String row : getRows() )
        {
            if ( row.startsWith( ID_ATTRIBUTE ) )
            {
                return row.split( "=" )[1].replaceAll( " ", "_" );
            }
        }

        throw new IllegalArgumentException( "Cannot find id for action button " + attribute.getVValue() );
    }
}
