package com.plusmpm.parser.translation.wrapper.form;

import com.plusmpm.parser.translation.utils.Utils;
import com.plusmpm.parser.translation.utils.XpdlKeyResolver;
import com.plusmpm.parser.translation.wrapper.ExtendedAttributeWrapper;
import org.apache.commons.lang.StringUtils;
import org.enhydra.shark.xpdl.elements.ExtendedAttribute;

public class HttpLinkWrapper
                extends ExtendedAttributeWrapper
{
    private static String NAME_ATTRIBUTE = "Name";

    public HttpLinkWrapper( ExtendedAttribute attribute )
    {
        super( attribute );
    }

    @Override
    public String getKey()
    {
        return XpdlKeyResolver.extractHttpLink( this ).getKey();
    }

    @Override
    public String getRawName()
    {
        return getName();
    }

    public String getId()
    {
        return Utils.generateId( getName() );
    }

    public String getName()
    {
        String name = getAttribute( NAME_ATTRIBUTE );

        if ( StringUtils.isEmpty( name ) )
        {
            throw new IllegalArgumentException();
        }
        else
        {
            return name;
        }
    }

}
