package com.plusmpm.parser.translation.wrapper;

import lombok.extern.slf4j.Slf4j;

import java.util.LinkedHashMap;
import java.util.Map;

@Slf4j
public abstract class ElementWrapper
{
    public Map<String, String> getProperties()
    {
        Map<String, String> map = new LinkedHashMap<>();
        map.put( this.getKey(), this.getName() );

        return map;
    }

    public String splitValue( String value )
    {
        if ( value.contains( "=" ) )
        {
            String result = value.split( "=" )[0];
            return result.substring( 0, result.length() - 1 );
        }
        else
        {
            return value;
        }
    }

    public String getName()
    {
        return splitValue( getRawName() );
    }

    public abstract String getKey();

    public abstract String getRawName();
}