package com.plusmpm.parser.translation;

import lombok.Data;

import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;

@Data
public class TranslationDiff
{
    private Map<String, String> translationsToUpdate;

    private Set<String> translationsToRemove;

    public TranslationDiff()
    {
        translationsToUpdate = new LinkedHashMap<>();
        translationsToRemove = new HashSet<>();
    }

    public static TranslationDiff resolveTranslationDiff( Map<String, String> newerTranslations,
                                                          Map<String, String> olderTranslations )
    {
        TranslationDiff diff = new TranslationDiff();

        olderTranslations.forEach( ( oldKey, oldValue ) -> {
            if ( newerTranslations.containsKey( oldKey ) )
            {
                String newValue = newerTranslations.get( oldKey );
                if ( !newValue.equals( oldValue ) )
                {
                    diff.getTranslationsToUpdate().put( oldKey, newValue );
                }
            }
            else
            {
                diff.getTranslationsToRemove().add( oldKey );
            }
        } );

        newerTranslations.forEach( ( newKey, newValue ) -> {
            if ( !olderTranslations.containsKey( newKey ) )
            {
                diff.getTranslationsToUpdate().put( newKey, newValue );
            }
        } );

        return diff;
    }
}
